<?php
	
include_once( get_template_directory() . '/theme/liquid-vc-page-templates.php' );

add_filter( 'vc_load_default_templates', 'liquid_reset_default_templates' ); // Hook in
function liquid_reset_default_templates( $data ) {
    return array(); // This will remove all default templates. Basically you should use native PHP functions to modify existing array and then return it.
}

function liquid_add_default_templates() {

	$templates = liquid_vc_templates();
	$page_templates = liquid_vc_page_templates();
	
	$templates = array_merge( $templates, $page_templates );
	
	return array_map( 'vc_add_default_templates', $templates );

}

liquid_add_default_templates();

function liquid_vc_templates(){
	
	$sections_uri = get_template_directory_uri() . '/liquid/assets/img/liquid-templates/sections/';
	$pages_uri = get_template_directory_uri() . '/liquid/assets/img/liquid-templates/pages/';
	$templates = array();

	/*###################
		SECTION TEMPLATES
	###################*/

	//Category Accordions
	//Accordion 1
	$data = array();
	$data['name'] = esc_html__( 'Accordion 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-1.jpg' );
	$data['sort_name'] = 'Accordion, Fancy Box';
	$data['custom_class'] = 'general accordion fancybox';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1602154964430{padding-top: 65px !important;}" responsive_css="border_top_medium:200px|padding_top_medium:100px|padding_bottom_medium:50px|padding_top_small:65px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1577271701433{margin-bottom: 60px !important;}" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h2"]global experts[/ld_fancy_heading][ld_fancy_heading tag="p"]As a partner of corporates, Liquid has more than 9,000 partners of all sizes and all potential of session.[/ld_fancy_heading][/vc_column][vc_column responsive_css="margin_bottom_medium:80px|margin_bottom_small:45px" css=".vc_custom_1602155570185{margin-bottom: 45px !important;}"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="bottom" gap="20" animation_preset="Fade In" ca_delay="80"][vc_column_inner enable_link="enable_column_link" enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1595423449007{margin-bottom: 30px !important;padding-top: 215px !important;padding-right: 50px !important;padding-bottom: 30px !important;padding-left: 50px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/Image@2x.jpg?id=8661) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" offset="vc_col-md-4" overlay_bg="linear-gradient(0deg, rgba(24, 27, 49, 0.6) 0%, rgba(0, 0, 0, 0) 100%)" hover_overlay_bg="rgba(24, 27, 49, 0.65)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" link="url:%23|||"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="13px" fw="700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]finance[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:28px" lh="text_small:1em" padding="right_all:20%25|right_large:16%25"]banking and business partnership[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_link="enable_column_link" enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1595423440522{margin-bottom: 30px !important;padding-top: 215px !important;padding-right: 50px !important;padding-bottom: 30px !important;padding-left: 50px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/Image-2@2x.jpg?id=8659) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" offset="vc_col-md-4" overlay_bg="linear-gradient(0deg, rgba(24, 27, 49, 0.6) 0%, rgba(0, 0, 0, 0) 100%)" hover_overlay_bg="rgba(24, 27, 49, 0.65)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" link="url:%23|||"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="13px" fw="700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]analytics[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="28px" lh="1em" padding="right_all:20%25|right_large:16%25"]big data integration for startups[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_link="enable_column_link" enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1595423456095{margin-bottom: 30px !important;padding-top: 215px !important;padding-right: 50px !important;padding-bottom: 30px !important;padding-left: 50px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/Image-1@2x.jpg?id=8660) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" offset="vc_col-md-4" overlay_bg="linear-gradient(0deg, rgba(24, 27, 49, 0.6) 0%, rgba(0, 0, 0, 0) 100%)" hover_overlay_bg="rgba(24, 27, 49, 0.65)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" link="url:%23|||"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="13px" fw="700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]consulting[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:28px" lh="text_small:1em" padding="right_all:20%25|right_large:16%25"]analyzing company reports[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1606898355338{margin-bottom: 65px !important;}" responsive_css="padding_right_medium:8%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h2"]leading the best marketing team.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2.25em"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly, achieve marketing.[/ld_fancy_heading][ld_button style="btn-solid" title="learn more" shape="round" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" fs="16px" css=".vc_custom_1595351930590{padding-right: 0.75em !important;padding-left: 0.75em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_size="20px" hover_color="rgb(24, 67, 65)"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1577272089640{margin-bottom: 30px !important;}" ca_duration="1800" ca_start_delay="350" ca_delay="180" ca_init_translate_y="35"][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="30px" fs="16px" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(248, 245, 243)" active_bg_color="rgb(24, 67, 65)" heading_color="rgb(24, 67, 65)" active_heading_color="rgb(255, 255, 255)" exp_color="rgb(24, 67, 65)" active_exp_color="rgb(255, 255, 255)" lh="1.5em" border_color="rgb(255, 250, 247)" active_border_color="rgb(24, 67, 65)"][vc_accordion_tab title="First-class investment solutions" tab_id="ld-1576843306949-c9811b96-fe6b"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Building the idea of future" tab_id="ld-1576843455029-57b05fca-b401"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Business consultation for startups" tab_id="ld-1576843473475-7ad9f679-ee46"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Hub IT allows your business and technology<br /> computers to store, transmit, analyze,<br /> and manipulate big data.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	
	$templates[] = $data;
	
	//Accordion 2
	$data = array();
	$data['name'] = esc_html__( 'Accordion 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-2.jpg' );
	$data['sort_name'] = 'Accordion, Icon';
	$data['custom_class'] = 'general accordion icon';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1576240570995{padding-top: 120px !important;padding-bottom: 100px !important;background-color: #f4f4f4 !important;}" responsive_css="border_right_medium:200px"][vc_column offset="vc_col-lg-6 vc_col-md-7" css=".vc_custom_1607931989373{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:40px|text_small:36px"]Inspiration, innovation, and countless opportunities.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="30px" margin="bottom_small:2em"]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-round" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="20px" fs="16px" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" heading_color="rgb(57, 55, 77)" active_heading_color="rgb(255, 255, 255)" bg_color="rgb(255, 255, 255)" border_color="rgb(255, 255, 255)" fw="700" active_bg_color="rgb(24, 67, 65)"][vc_accordion_tab title="Hub Business' Vision" tab_id="lqd-1575466271794-292b803f-ecd6"][vc_column_text]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Our mission for Sustainability" tab_id="ld-1575466481374-e9a15b23-39d2"][vc_column_text]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="Qualified Team" tab_id="ld-1575466494877-1af59567-b066"][vc_column_text]Take advantage of the experiential-learning opportunities built into many programs. You can work in labs on and off[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-md-5"][ld_images_group_element parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="8" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="8658" margin="right_large:-12%25" translate_from_y="60" translate_to_y="-75"][/ld_images_group_element][/vc_column][vc_column][ld_spacer height="72px"][vc_row_inner enable_content_animation="yes" equal_height="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1800" ca_delay="180" ca_init_translate_x="0"][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246569369{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-presentation" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246647927{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-target" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246618793{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-path" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3"][ld_icon_box i_type="linea" heading_size="custom" toggleable="yes" i_size="xl" fill="yes" border_radius="iconbox-round" shadow="iconbox-shadow" title="Diversity and Inclusion" title_mb="1" custom_heading_size="16px" icon_mb="25" fill_color="rgb(255, 255, 255)" css=".vc_custom_1611246601414{padding-top: 55px !important;padding-bottom: 50px !important;}" link="|||" i_icon_linea="lqd-icn-ess icon-lqd-mobile" icon_size="49px" i_color="rgb(24, 67, 65)"]International Partners[/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 3 - startuphub
	$data = array();
	$data['name'] = esc_html__( 'Accordion 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-3.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion process';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1596109247090{padding-top: 20px !important;padding-bottom: 10px !important;}"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1605832601085{margin-bottom: 40px !important;}"][ld_images_group_element img_size="80%" enable_hover3d="yes" enable_float_effect="yes" image="4380"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(51, 59, 65)" fs="text_small:11px" ls="text_small:0.1em" padding="top_small:7px|right_small:20px|bottom_small:7px|left_small:20px" fh_bg="rgb(237, 243, 247)" margin="bottom_small:1.5em"]Workflow Integration[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" use_custom_fonts_title="true" fs="text_large:48px|text_small:45px" lh="text_small:1.02em" margin="bottom_large:30px" highlight_color="rgba(157, 95, 255, 0.16)"]Platform [ld_highlight]Integration[/ld_highlight][/ld_fancy_heading][vc_accordion size="lg" borders="accordion-title-bordered" border_round="accordion-title-circle" active_style="yes" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="18px" lh="1.55em" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" heading_color="rgb(21, 21, 23)" active_heading_color="rgb(21, 21, 23)" exp_color="rgb(131, 131, 131)" active_exp_color="rgb(77, 102, 255)" active_tab="1" border_color="rgb(255, 255, 255)" bottom_margin="0px"][vc_accordion_tab title="Track and analyze business reports" tab_id="lqd-1587034043819-84b84fd6-594f"][ld_fancy_heading tag="p" color="rgb(47, 47, 47)"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Increase your conversion rate" tab_id="lqd-1596289116665-e12466c4-780e"][ld_fancy_heading tag="p" color="rgb(47, 47, 47)"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="End-to-end encryption for messages" tab_id="lqd-1587034043874-e9d0bbcd-65a3"][ld_fancy_heading tag="p" color="rgb(47, 47, 47)"]Hub is the all-in-one builder with ultra high performance, intuitive editor, exclusive features and award-winning design collection.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row][vc_row css=".vc_custom_1605833009940{padding-top: 40px !important;padding-bottom: 80px !important;}" row_hide="hidden-xs hidden-sm"][vc_column custom_border_radius="50em" responsive_css="border_top_medium:1px|border_right_medium:1px|border_bottom_medium:1px|border_left_medium:1px|padding_top_medium:32px|padding_right_medium:60px|padding_bottom_medium:32px|padding_left_medium:60px" css=".vc_custom_1605833063145{border-top-width: 0px !important;border-right-width: 0px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;border-left-color: rgba(212,214,219,0.35) !important;border-left-style: solid !important;border-right-color: rgba(212,214,219,0.35) !important;border-right-style: solid !important;border-top-color: rgba(212,214,219,0.35) !important;border-top-style: solid !important;border-bottom-color: rgba(212,214,219,0.35) !important;border-bottom-style: solid !important;}" responsive_align="text-center text-md-left"][ld_process_box_container template="style05"][ld_process_box use_custom_fonts_title="true" title="Register your email" fs="16px" ls="0px" title_color="rgb(17, 36, 70)" count="01" image="800"][/ld_process_box][ld_process_box use_custom_fonts_title="true" title="Accept Invitations" fs="16px" ls="0px" title_color="rgb(17, 36, 70)"][/ld_process_box][ld_process_box use_custom_fonts_title="true" title="Start using your email" fs="16px" ls="0px" title_color="rgb(17, 36, 70)"][/ld_process_box][/ld_process_box_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 4 - gridportfolio
	$data = array();
	$data['name'] = esc_html__( 'Accordion 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-4.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" equal_height="yes" content_placement="top" css=".vc_custom_1588772707964{padding-top: 30px !important;padding-bottom: 30px !important;}" responsive_css="margin_top_medium:50px|margin_bottom_medium:50px"][vc_column offset="vc_col-lg-6 vc_col-md-7" responsive_css="padding_right_medium:50px" css=".vc_custom_1588757803815{padding-right: 15px !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h6" color="rgb(0, 0, 0)" margin="top_small:1em|bottom_small:2em"]— I build designs systems for companies[/ld_fancy_heading][ld_fancy_heading tag="h3" highlight_type="lqd-highlight-custom-underline" highlight_height="50%" duration="1400" delay="150" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" margin="bottom_small:1.2em" lh="text_small:1.35em"]I am an award-winning digital designer from London, in the business of creating unforgettable interactive experiences.[/ld_fancy_heading][/vc_column][vc_column responsive_css="margin_top_medium:0px|padding_left_medium:5%25|margin_top_small:0px|padding_right_small:30px|padding_left_small:30px" offset="vc_col-lg-offset-0 vc_col-md-6" css=".vc_custom_1605879852432{padding-right: 15px !important;padding-left: 15px !important;}"][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="0px" fs="20px" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(20, 20, 20)" border_color="rgb(0, 0, 0)" exp_color="rgb(20, 20, 20)" active_exp_color="rgb(0, 0, 0)" ls="0px" active_heading_color="rgb(0, 0, 0)" active_border_color="rgb(0, 0, 0)"][vc_accordion_tab title="Understand the whole customer story" tab_id="lqd-1587831664813-aeecfaeb-451a"][ld_fancy_heading tag="p"]Hub gives you incomparable insight into what your customers are perusing, clicking, and craving.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Build trust and loyalty programs" tab_id="lqd-1587831664920-2b73c907-de32"][ld_fancy_heading tag="p"]Easily segment the clients, build loyalty programs with cross-selling automation.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Analyze and optimize with data at your fingertips" tab_id="lqd-1587831665033-9829583b-1af9"][ld_fancy_heading tag="p"]Our design services starts and ends with a best-in-class experience strategy that builds brands.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Accordion 5 - newsletterhub
	$data = array();
	$data['name'] = esc_html__( 'Accordion 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-5.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
[vc_row bg_position="custom" css=".vc_custom_1606474718115{padding-top: 85px !important;padding-bottom: 15px !important;background-image: url(https://mainhub.liquid-themes.com/staging/wp-content/uploads/2019/11/dots-bg-1.png?id=4186) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50%" bg_pos_v="-20%"][vc_column][ld_images_group_container parallax="yes" move_to_parent_row="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" translate_from_y="48" translate_to_y="-175" position="top_small:-45px|left_small:10%25"][ld_images_group_element image="380"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="200" ca_init_translate_y="35"][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" fs="18px" border_color="rgb(240, 242, 250)" exp_color="rgb(0, 109, 255)" bottom_margin="15px" heading_color="rgb(0, 35, 82)" fw="600"][vc_accordion_tab title="1. Problems sending or receiving messages" tab_id="ld-1573557703923-2b536dc1-8433"][vc_column_text]<span style="font-size: 17px; line-height: 29px;">Passionate about solving problems through creative communications. Offering affordable goods.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="2. End-to-end encryption for messages" tab_id="ld-1573557848857-fe47078b-be98"][vc_column_text]<span style="font-size: 17px; line-height: 29px;">Passionate about solving problems through creative communications. Offering affordable goods.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="3. Restore your chat history?" tab_id="ld-1573557855085-a110d9e8-dd5b"][vc_column_text]<span style="font-size: 17px; line-height: 29px;">Passionate about solving problems through creative communications. Offering affordable goods.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="4. Deleting and clearing chats in the application" tab_id="ld-1573557971281-cb873053-3190"][vc_column_text]<span style="font-size: 17px; line-height: 29px;">Passionate about solving problems through creative communications. Offering affordable goods.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="5. Getting messages from businesses" tab_id="ld-1573557979674-b9d6884a-b21e"][vc_column_text]<span style="font-size: 17px; line-height: 29px;">Passionate about solving problems through creative communications. Offering affordable goods.</span>[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="6. Calling unavailable in some countries" tab_id="ld-1573557986530-b01574dd-230b"][vc_column_text]<span style="font-size: 17px; line-height: 29px;">Passionate about solving problems through creative communications. Offering affordable goods.</span>[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Accordion 6 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-6.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1605606348218{padding-top: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column offset="vc_col-lg-4 vc_col-md-5"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:24px" lh="text_small:1.5em"]Hi, I’m Daniel.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.46em" color="rgba(255, 255, 255, 0.6)"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-5"][vc_accordion size="md" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="19px" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgba(255, 255, 255, 0.56)" active_heading_color="rgb(255, 255, 255)" border_color="rgb(185, 185, 185)"][vc_accordion_tab title="Developing core applications" tab_id="lqd-1588404458746-15ba10e7-18eb"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em" color="rgba(255, 255, 255, 0.6)"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Digital business consultation" tab_id="lqd-1596793559971-4fb7d693-bff9"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Tailor-made digital products" tab_id="lqd-1588404722047-49fc3c81-db7f"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 7 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-7.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" bg_position="custom" css=".vc_custom_1610879009876{padding-top: 60px !important;padding-bottom: 60px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="104%" bg_pos_v="10%" responsive_css="margin_left_medium:100px|padding_top_medium:70px|padding_bottom_medium:70px|padding_bottom_small:40px"][vc_column offset="vc_col-md-4" css=".vc_custom_1610836127832{margin-bottom: 20px !important;}" responsive_css="padding_top_medium:70px"][ld_images_group_container][ld_images_group_element img_size="55%" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" absolute_pos="yes" image="49" position="top_large:-15%25|left_large:-7vw|left_medium:10vw|top_small:-15%25|left_small:0px"][/ld_images_group_element][ld_images_group_element img_size="55%" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" absolute_pos="yes" image="48" position="right_large:-30%25|right_medium:9vw|top_small:-26%25|right_small:0px"][/ld_images_group_element][ld_images_group_element img_size="55%" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" image="47" margin="top_large:90px" position="left_large:0px|left_medium:25vw|left_small:18vw"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-offset-1 vc_col-md-6"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]La solution a vos mobile online payments[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:1.5em"]We create brand identities, digital experiences, and print materials look fantastic.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-bordered" border_round="accordion-title-round" heading_shadow="yes" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="25px" fs="18px" lh="1.75em" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(255, 255, 255)" active_bg_color="rgb(255, 255, 255)" heading_color="rgb(21, 21, 23)" active_heading_color="rgb(21, 21, 23)" exp_color="rgb(77, 102, 255)" active_exp_color="rgb(77, 102, 255)" border_color="rgb(255, 255, 255)" active_border_color="rgb(255, 255, 255)"][vc_accordion_tab title="increase your conversion rate" tab_id="lqd-1587034043819-84b84fd6-594f"][ld_fancy_heading tag="p"]Helping innovators and brands through cultural insight, strategic vision, and innovation.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="End-to-end encryption for messages" tab_id="lqd-1587034043874-e9d0bbcd-65a3"][ld_fancy_heading tag="p"]Helping innovators and brands through cultural insight, strategic vision, and innovation.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 8 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-8.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1605606348218{padding-top: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column offset="vc_col-lg-4 vc_col-md-5"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:24px" lh="text_small:1.5em"]Hi, I’m Daniel.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.46em" color="rgba(255, 255, 255, 0.6)"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-5"][vc_accordion size="md" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="19px" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgba(255, 255, 255, 0.56)" active_heading_color="rgb(255, 255, 255)" border_color="rgb(185, 185, 185)"][vc_accordion_tab title="Developing core applications" tab_id="lqd-1588404458746-15ba10e7-18eb"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em" color="rgba(255, 255, 255, 0.6)"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Digital business consultation" tab_id="lqd-1596793559971-4fb7d693-bff9"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Tailor-made digital products" tab_id="lqd-1588404722047-49fc3c81-db7f"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" lh="text_small:1.5em"]Creating brand identities, digital experiences, that communicate clearly to the client. My name is Eugenia, I’m a freelance Branding and Digital Designer.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 9 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-9.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:70px|padding_bottom_medium:70px" css=".vc_custom_1602652556487{padding-top: 30px !important;}"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h6" margin="bottom_small:1.5em"]Increase Values[/ld_fancy_heading][ld_fancy_heading tag="h2"]Social marketing made easy.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:1.5em" color="rgb(49, 63, 88)" margin="bottom_small:1.25em"]We craft premium digital work for web, mobile and experiential with creative agencies and global brands alike – putting passion.[/ld_fancy_heading][ld_button style="btn-naked" title="Learn more" transformation="text-uppercase" hover_txt_effect="btn-hover-txt-liquid-x" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="12px" ls="0.1em" i_size="1.25em"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1620722318109{background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="19px" lh="1.75em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(0, 0, 0)" active_heading_color="rgb(0, 0, 0)" border_color="rgba(185, 185, 185, 0.7)" active_border_color="rgb(185, 185, 185)" fw="600"][vc_accordion_tab title="Developing core applications" tab_id="lqd-1588594296702-fdd94918-81f9"][ld_fancy_heading tag="p"]Through a deep understanding of our audience’s makeup and motivations, we design digital experiences that connect with people.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Unique brand identity and strategy" tab_id="lqd-1588594383516-68391adc-4eea"][ld_fancy_heading tag="p"]Through a deep understanding of our audience’s makeup and motivations, we design digital experiences that connect with people.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Tailor-made digital products" tab_id="lqd-1588594394127-bf7b723e-2841"][ld_fancy_heading tag="p"]Through a deep understanding of our audience’s makeup and motivations, we design digital experiences that connect with people.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 10 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-10.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1605616186759{padding-top: 40px !important;padding-bottom: 60px !important;}"][vc_column offset="vc_col-md-5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1605616127527{margin-bottom: 40px !important;}"][ld_images_group_element image="4310"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6" responsive_css="padding_right_large:7%25|padding_right_medium:5%25|padding_left_medium:8%25"][ld_fancy_heading tag="h6" margin="bottom_small:1.25em"]— Arch Philosophy[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:1.5em"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="18px" lh="1.8em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(0, 0, 0)" active_heading_color="rgb(0, 0, 0)" fw="400" border_color="rgb(185, 185, 185)"][vc_accordion_tab title="01. Building the future cities" tab_id="lqd-1584631046124-4d7a24d6-c841"][vc_column_text css=".vc_custom_1584946903012{margin-bottom: 15px !important;}"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="02. Unique and influential design" tab_id="lqd-1584631246270-3f120044-72ac"][vc_column_text css=".vc_custom_1584946910333{margin-bottom: 15px !important;}"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="03. Award-winning Architecture" tab_id="lqd-1584631247309-5c26887d-1aeb"][vc_column_text css=".vc_custom_1584946916841{margin-bottom: 15px !important;}"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 11 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-11.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle"][vc_column row_scale_bg_onhover="yes" width="1/2" bg_position="center center" css=".vc_custom_1611007077105{padding-top: 50vw !important;padding-bottom: 50vw !important;background-image: url(https://architecturepro.liquid-themes.com/wp-content/uploads/2021/01/bg@2x-1.jpg?id=4573) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_small:0px|padding_bottom_small:0px"][/vc_column][vc_column width="1/2" css=".vc_custom_1611573024379{padding-top: 60px !important;padding-right: 5vw !important;padding-bottom: 60px !important;padding-left: 5vw !important;}" responsive_css="padding_top_medium:15vh|padding_right_medium:7vw|padding_bottom_medium:15vh|padding_left_medium:7vw|padding_top_small:10vh|padding_bottom_small:10vh"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" margin="bottom_small:2em"]— Arch Philosophy[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:43px" fw="text_small:500" margin="bottom_small:0.8em"]Innovative <em class="h3">design</em>[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" fs="18px" lh="1.5em"][vc_accordion_tab title="Building the future cities" tab_id="lqd-1610034274098-5324ce09-d98a"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.6em"]Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Unique and influential design" tab_id="lqd-1610034392114-11835d46-6615"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.6em"]Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Award-winning Architecture" tab_id="lqd-1610034405942-f5a3b918-932c"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.6em"]Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 12 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-12.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" responsive_css="padding_top_medium:50px|padding_bottom_medium:165px" css=".vc_custom_1617787581517{padding-bottom: 60px !important;}"][vc_column align="text-center" offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs" responsive_align="text-center"][ld_images_group_container][ld_images_group_element img_size="65%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_reveal="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="137" translate_from_y="35" rotate_from_y="0" translate_to_y="-45" position="top_small:-15%25|left_small:0%25"][/ld_images_group_element][ld_images_group_element img_size="40%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="4" enable_shadow="yes" enable_reveal="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="136" translate_from_y="90" translate_to_y="-70" margin="top_large:100px"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" responsive_css="padding_left_medium:10%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]Who we are[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" duration="1000" delay="120" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" minfontsize="40" fs="text_large:48px|text_small:40px" ca_init_translate_y="70"]Hub connects creative people.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" margin="bottom_small:3.35em"]With over 25 years of experience, we have crafted thousands of strategic discovery process.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-bordered" border_round="accordion-title-circle" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="25px" fs="17px" lh="1.35em" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(247, 248, 249)" heading_color="rgb(0, 0, 0)" active_heading_color="rgb(255, 255, 255)" border_color="rgb(247, 248, 249)"][vc_accordion_tab title="Global search engine optimization" tab_id="lqd-1579175585568-fabb85cc-3af9"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.73em" margin="bottom_small:0.25em"]A startup or start-up is started by individual founders or entrepreneurs to search for a repeatable and scalable business model.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Complete Social Media Integration" tab_id="ld-1579175796106-906f8cfc-cbda"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.73em" margin="bottom_small:0.25em"]A startup or start-up is started by individual founders or entrepreneurs to search for a repeatable and scalable business model. A startup or start-up is started by individual founders or[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Branding Strategy for startups" tab_id="ld-1579175803325-17b3ad82-140a"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.73em" margin="bottom_small:0.25em"]A startup or start-up is started by individual founders or entrepreneurs to search for a repeatable and scalable business model. A startup or start-up is started by individual founders or[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 13 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-13.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row][vc_column][ld_gdpr_box]<span class="d-flex" style="font-size: 11px; line-height: 16px;">This website uses cookies to improve your web experience.[ld_br]See our Privacy Policy to learn more.</span>[/ld_gdpr_box][/vc_column][/vc_row][vc_row content_placement="middle" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px" css=".vc_custom_1621609863490{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column offset="vc_col-md-5" responsive_css="margin_right_medium:-55px|margin_left_medium:-70px"][vc_single_image image="3541" css=".vc_custom_1621610157644{margin-bottom: -10% !important;}"][/vc_column][vc_column offset="vc_col-md-7"][ld_fancy_heading tag="h2" use_inheritance="true"]Have questions?[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="18px" fw="500" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" active_tab="-1"][vc_accordion_tab title="End-to-end encryption for business messages for iOS Devices" tab_id="lqd-1621609909807-7c8e442a-b7d2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:0px"]We embrace holistic development and support for employees the aim of being a first-choice employer[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Sending media, documents, location and contacts" tab_id="lqd-1621610030115-79744a97-73cc"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:0px"]We embrace holistic development and support for employees the aim of being a first-choice employer[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Get insights on key metrics like response time and issue volume" tab_id="lqd-1621610043743-cf0472eb-37bd"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:0px"]We embrace holistic development and support for employees the aim of being a first-choice employer[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Problems sending or receiving messages" tab_id="lqd-1621610057760-774f53da-141d"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:0px"]We embrace holistic development and support for employees the aim of being a first-choice employer[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Calling unavailable in some countries" tab_id="lqd-1621610073214-89ff4f0f-20b5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:0px"]We embrace holistic development and support for employees the aim of being a first-choice employer[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 14 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-14.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" equal_height="yes" content_placement="top" css=".vc_custom_1605830781335{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #d1f0fc !important;}" responsive_css="padding_top_medium:120px|padding_bottom_medium:120px"][vc_column enable_pin="enable_pin" offset="vc_col-lg-6 vc_col-md-7" responsive_css="padding_right_medium:50px" css=".vc_custom_1620293176118{padding-right: 15px !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h6" color="rgb(0, 0, 0)" margin="top_small:1em|bottom_small:2em"]— I build designs systems for companies[/ld_fancy_heading][ld_fancy_heading tag="h3" highlight_type="lqd-highlight-custom-underline" highlight_height="50%" duration="1400" delay="150" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" margin="bottom_small:1.2em" lh="text_small:1.35em"]I am an award-winning digital designer from London, in the business of creating unforgettable interactive experiences.[/ld_fancy_heading][/vc_column][vc_column responsive_css="margin_top_medium:0px|padding_left_medium:5%25|margin_top_small:0px|padding_right_small:30px|padding_left_small:30px" offset="vc_col-lg-6 vc_col-md-5" css=".vc_custom_1603283491133{margin-top: 50px !important;padding-right: 15px !important;padding-left: 15px !important;}"][vc_accordion show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="0px" fs="20px" lh="1.5em" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(20, 20, 20)" border_color="rgb(0, 0, 0)" exp_color="rgb(0, 0, 0)" active_exp_color="rgb(0, 0, 0)" ls="0px" active_heading_color="rgb(0, 0, 0)" active_border_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-ion-ios-add"][vc_accordion_tab title="Digital Branding" tab_id="lqd-1587831664813-aeecfaeb-451a"][ld_fancy_heading tag="p"]Hub gives you incomparable insight into what your customers are perusing, clicking, and craving.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Development" tab_id="lqd-1587831664920-2b73c907-de32"][ld_fancy_heading tag="p"]Easily segment the clients, build loyalty programs with cross-selling automation.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="UX Analyze" tab_id="lqd-1587831665033-9829583b-1af9"][ld_fancy_heading tag="p"]Our design services starts and ends with a best-in-class experience strategy that builds brands.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Consulting" tab_id="lqd-1588936464398-e3a365d2-2231"][ld_fancy_heading tag="p"]Our design services starts and ends with a best-in-class experience strategy that builds brands.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Branding Strategy" tab_id="lqd-1588936465753-4eba7f77-46fa"][ld_fancy_heading tag="p"]Our design services starts and ends with a best-in-class experience strategy that builds brands.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Mobile App Design" tab_id="lqd-1588953058595-670a06ef-3fd0"][ld_fancy_heading tag="p"]Our design services starts and ends with a best-in-class experience strategy that builds brands.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 15 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-15.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1614669941565{background-color: #fafafa !important;}" el_id="howitworks"][vc_column row_scale_bg_onhover="yes" bg_position="center center" align="text-center" offset="vc_col-md-6" css=".vc_custom_1620719918371{padding-top: 30vw !important;padding-bottom: 30vw !important;background-image: url(https://itbusinesspro.liquid-themes.com/wp-content/uploads/2020/01/bg-3@2x.jpg?id=52) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_align="text-center" responsive_css="padding_top_medium:15vw|padding_bottom_medium:15vw|padding_top_small:25vw|padding_bottom_small:25vw"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-xlg" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="icon-ion-ios-play" i_size="24px" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DcVEemOmHw9Y|||" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" responsive_css="padding_top_medium:90px|padding_right_medium:12%25|padding_bottom_medium:90px|padding_left_medium:12%25" css=".vc_custom_1607346561233{padding-top: 60px !important;padding-right: 15px !important;padding-left: 15px !important;}" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="35"][ld_fancy_heading tag="h2"]The Creative Process[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.64em" margin="bottom_small:2.6em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][vc_accordion size="lg" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="25px" fs="18px" lh="1.5em" i_icon_linea="icon-ion-ios-arrow-down" active_icon_linea="icon-ion-ios-arrow-up" bg_color="rgb(255, 255, 255)" heading_color="rgb(21, 21, 23)" active_tab="-1"][vc_accordion_tab title="increase your conversion rate" tab_id="ld-1578911887679-d3801bcc-f354"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.64em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="End-to-end encryption for messages" tab_id="ld-1578911887956-3fb39dcc-5ffb"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.64em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Getting messages from businesses" tab_id="ld-1578911888239-a4e132ad-1dd9"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.64em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 16 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-16.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1614343884838{padding-top: 70px !important;}" el_id="help"][vc_column width="2/3"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:45px|text_small:10vw" lh="text_small:1.1em" margin="bottom_small:0.35em"]Frequently Asked Questions.[/ld_fancy_heading][/vc_column][vc_column width="1/3" responsive_align="text-md-right"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" color="rgb(0, 0, 0)"]Support Team  <img class="alignnone size-full wp-image-985" src="https://saaspro.liquid-themes.com/wp-content/uploads/2021/01/Images@2x.jpg" alt="" width="93" height="44" />[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1587634210152{margin-top: 50px !important;}"][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" bottom_margin="10px" fs="19px" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(0, 0, 0)" active_heading_color="rgb(0, 0, 0)" exp_color="rgb(101, 31, 222)" active_exp_color="rgb(101, 31, 222)"][vc_accordion_tab title="End-to-end encryption for business messages for iOS Devices" tab_id="lqd-1587633968163-3eddfcbd-9bd6"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Ultimate shop experience. Effortlessly build high-converting online shops and start selling in a few minutes.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Sending media, documents, location and contacts" tab_id="lqd-1587634212758-10ff1f99-248a"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Ultimate shop experience. Effortlessly build high-converting online shops and start selling in a few minutes.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Get insights on key metrics like response time and issue volume" tab_id="lqd-1587634220162-d4df9acf-2261"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Ultimate shop experience. Effortlessly build high-converting online shops and start selling in a few minutes.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Calling unavailable in some countries" tab_id="lqd-1587634230666-40e488b0-0149"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Ultimate shop experience. Effortlessly build high-converting online shops and start selling in a few minutes.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Problems sending or receiving messages" tab_id="lqd-1587634239018-7a00bd0a-306a"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Ultimate shop experience. Effortlessly build high-converting online shops and start selling in a few minutes.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="How to restore your chat history?" tab_id="lqd-1587634247253-380ad72d-09c1"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Ultimate shop experience. Effortlessly build high-converting online shops and start selling in a few minutes.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][ld_images_group_container][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="987" position="right_small:-80px|bottom_small:250px" translate_from_y="65" rotate_from_z="-30" translate_to_y="-106" rotate_to_z="23"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="931" position="bottom_small:400px|left_small:-80px" translate_from_y="-54" rotate_from_z="26" translate_to_y="95" rotate_to_z="-19"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 17 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-17.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="center center" responsive_css="padding_top_medium:30px|padding_bottom_medium:30px" css=".vc_custom_1610701098486{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column offset="vc_col-md-5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1610700906404{margin-bottom: 40px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" margin="bottom_small:0.75em" color="rgb(86, 154, 204)" fs="text_small:16px"]Industry Experiences[/ld_fancy_heading][ld_fancy_heading tag="h2" color="rgb(31, 42, 88)"]Digital solutions for your business.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:1.5em" margin="bottom_small:1.5em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][ld_button style="btn-naked" title="Learn more" hover_txt_effect="btn-hover-txt-liquid-x" i_type="linea" i_add_icon="true" color="rgb(38, 139, 225)" fs="18px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-md-offset-2 vc_col-md-5"][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="18px" lh="1.5em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(6, 14, 98)" active_tab="-1" exp_color="rgb(0, 109, 255)"][vc_accordion_tab title="Google mobile can monetize your app" tab_id="lqd-1588064599041-461442b0-64e9"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.5em" margin="bottom_small:0px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.<br />[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Track the location of your cars" tab_id="lqd-1588064792424-c7f59e69-a015"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.5em" margin="bottom_small:0px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.<br />[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Google mobile can monetize your app" tab_id="lqd-1610699873300-fb5273ca-8730"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.5em" margin="bottom_small:0px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.<br />[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 18 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-18.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row enable_gradient="yes" enable_row_dividers="yes" css=".vc_custom_1614781167031{padding-top: 70px !important;padding-bottom: 70px !important;}" gradient_bg="linear-gradient(125deg, rgb(47, 52, 66) 3.1847133757961785%, rgb(52, 61, 82) 100%)" row_svg_divider="top_shape_type:6|top_shape_color:%23ffffff|top_shape_height:26|bottom_shape_type:5|bottom_shape_color:%23ffffff|bottom_shape_height:142"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" margin="bottom_small:60px" fs="text_medium:43px|text_small:35px"]Frequently Asked Questions[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][vc_accordion size="lg" borders="accordion-body-underlined" show_icon="yes" i_add_icon="true" expander_position="accordion-expander-left" expander_size="accordion-expander-lg" i_type="fontawesome" active_add_icon="true" active_type="fontawesome" use_custom_fonts_title="true" fs="22px" lh="1.15em" fw="500" i_icon_fontawesome="fa fa-caret-right" active_icon_fontawesome="fa fa-caret-down" heading_color="rgb(255, 255, 255)" active_heading_color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.15)" exp_color="rgb(41, 128, 185)" bottom_margin="8px"][vc_accordion_tab title="1. Problems sending or receiving messages" tab_id="ld-1573803431648-7cf3a11b-5d1e"][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.65)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut pretium pretium tempor. Ut eget imperdiet neque. In volutpat ante semper diam molestie, et aliquam erat laoreet.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="3. Restore your chat history?" tab_id="ld-1573803546811-4677b40e-217e"][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.65)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut pretium pretium tempor. Ut eget imperdiet neque. In volutpat ante semper diam molestie, et aliquam erat laoreet.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="4. Deleting and clearing chats in the application" tab_id="ld-1573803589737-d409622f-8e88"][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.65)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut pretium pretium tempor. Ut eget imperdiet neque. In volutpat ante semper diam molestie, et aliquam erat laoreet.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="5. Getting messages from businesses" tab_id="ld-1573803612994-83c41c11-b476"][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.65)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut pretium pretium tempor. Ut eget imperdiet neque. In volutpat ante semper diam molestie, et aliquam erat laoreet.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="6. Calling unavailable in some countries" tab_id="ld-1573803620387-6e5cf80e-5706"][ld_fancy_heading tag="p" color="rgba(255, 255, 255, 0.65)"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut pretium pretium tempor. Ut eget imperdiet neque. In volutpat ante semper diam molestie, et aliquam erat laoreet.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 19 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-19.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row enable_gradient="yes" css=".vc_custom_1611421914720{margin-top: 90px !important;padding-top: 70px !important;padding-bottom: 30px !important;}" gradient_bg="linear-gradient(115deg, rgb(243, 248, 248) 0.3184713375796178%, rgb(255, 255, 255) 55.4140127388535%)"][vc_column width="1/2"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:45px" lh="text_small:1.1em" margin="bottom_small:0.35em"]Have a question?[/ld_fancy_heading][/vc_column][vc_column width="1/2" responsive_align="text-md-right"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px"]Alex Martinez   <img class="alignnone size-full wp-image-82" src="https://asymmetric-landing.liquid-themes.com/staging/wp-content/uploads/2020/04/imgs@2x.png" alt="" width="93" height="44" />[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1587634210152{margin-top: 50px !important;}"][vc_accordion size="lg" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="-1" bottom_margin="18px" fs="19px" lh="1.4em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(0, 0, 0)" active_heading_color="rgb(0, 0, 0)" exp_color="rgb(101, 31, 222)" active_exp_color="rgb(101, 31, 222)"][vc_accordion_tab title="End-to-end encryption for business messages for iOS Devices" tab_id="lqd-1587633968163-3eddfcbd-9bd6"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Sending media, documents, location and contacts" tab_id="lqd-1587634212758-10ff1f99-248a"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Get insights on key metrics like response time and issue volume" tab_id="lqd-1587634220162-d4df9acf-2261"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Calling unavailable in some countries" tab_id="lqd-1587634230666-40e488b0-0149"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Problems sending or receiving messages" tab_id="lqd-1587634239018-7a00bd0a-306a"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="How to restore your chat history?" tab_id="lqd-1587634247253-380ad72d-09c1"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 20 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 20', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-20.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Accordion 21 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 21', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-21.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Accordion 22 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 22', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-22.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Accordion 23 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 23', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-23.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:130px|padding_bottom_medium:130px" css=".vc_custom_1621849312172{padding-top: 70px !important;padding-bottom: 70px !important;}"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px|margin_bottom_small:160px" css=".vc_custom_1621864061246{margin-bottom: 70px !important;}"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_roudness="yes" image_roudness="8" enable_shadow="yes" image="83"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_roudness="yes" image_roudness="8" enable_shadow="yes" absolute_pos="yes" image="84" position="top_small:25%25|left_small:25%25" shadow_delay="250"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h2" margin="bottom_small:0.35em"]Smart and effective business solutions.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" margin="bottom_small:1.25em"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives[/ld_fancy_heading][ld_button style="btn-underlined" title="Learn more" link_type="scroll_to_section" border="border-thick" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="text_small:17px" css=".vc_custom_1621865280408{margin-right: 40px !important;}"][ld_button style="btn-naked" title="Play Video" link_type="lightbox" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" fs="text_small:17px" i_size="14px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWaSvMAl4zPw||target:%20_blank|"][ld_spacer height="30px"][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="1" fs="19px" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" fw="500"][vc_accordion_tab title="Business Consultation" tab_id="lqd-1621849870257-a6c90671-f7f1"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Strategetic Vision and Insight" tab_id="lqd-1621850133313-fcc50966-e093"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Private Property and Business" tab_id="lqd-1621850376284-61924f49-73ec"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Accordion 24 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Accordion 24', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'accordion-24.jpg' );
	$data['sort_name'] = 'Accordion';
	$data['custom_class'] = 'general accordion';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:75px|padding_bottom_medium:75px" css=".vc_custom_1622033294126{padding-top: 35px !important;padding-bottom: 35px !important;}"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px|margin_bottom_small:240px" css=".vc_custom_1622100886801{margin-bottom: 220px !important;}"][ld_images_group_container][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="27" translate_from_y="40" translate_to_y="-45"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="28" position="right_large:0px|right_medium:20%25|top_small:20px|right_small:0px" translate_from_y="50" translate_to_y="-55" shadow_delay="240"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="26" position="left_medium:90px|top_small:80px|right_small:8%25|left_small:10%25" translate_from_y="75" translate_to_y="-105" shadow_delay="120"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]Legal disciplines.[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:45px"]Legal <u>aid</u> from professionals.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="1" fs="19px" fw="500" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Anti-money Laundering" tab_id="lqd-1622033590191-308418da-a55b"][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:0px" fs="text_small:14px" lh="text_small:1.64em"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Immigration and Citizenship" tab_id="lqd-1622033689521-14822213-718e"][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:0px" fs="text_small:14px" lh="text_small:1.64em"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Private Property and Business" tab_id="lqd-1622033685660-808da547-f3b8"][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:0px" fs="text_small:14px" lh="text_small:1.64em"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Banners
	//Banner 1
	$data = array();
	$data['name'] = esc_html__( 'Banner 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-1.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px|padding_top_small:60px|padding_bottom_small:60px" css=".vc_custom_1607342656970{padding-top: 70px !important;padding-bottom: 30px !important;}"][vc_column width="7/12" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_x="0%" ca_an_opacity="1" ca_duration="2000" ca_delay="180" ca_init_translate_y="100" ca_init_rotate_y="15" ca_init_rotate_x="0" ca_init_translate_x="0" responsive_align="text-center text-sm-left"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" margin="bottom_small:1.15em" color="rgba(255, 255, 255, 0.75)"]<img class="alignnone size-full wp-image-31" src="https://darkapp.liquid-themes.com/wp-content/uploads/2020/10/Group-28148.svg" alt="Image" />  Introducing Reminder Tools[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" fs="text_large:86px|text_medium:7vw|text_small:13vw" lh="text_small:1em" margin="right_all:5%25|bottom_small:0.3em" padding="right_large:0px|left_large:0px|right_medium:1vw|left_medium:1vw"]E-wallet in your pocket 🤑[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:20px|text_medium:22px|text_small:18px" lh="text_small:1.5em"]Preferred stock may be hybrid by having the qualities of bonds of fixed returns and common stock voting rightson.[/ld_fancy_heading][vc_row_inner content_placement="middle" css=".vc_custom_1602597013022{padding-top: 22px !important;}"][vc_column_inner offset="vc_col-md-5" css=".vc_custom_1607342265389{margin-bottom: 15px !important;}"][ld_button style="btn-default" title="Get the app" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" border="border-thick" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="fontawesome" i_position="left" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" fw="700" ls="0.05em" i_icon_fontawesome="fab fa-apple" i_size="23px" i_margin_right="0.85em" css=".vc_custom_1605283164168{padding-right: 0.75em !important;padding-left: 0.75em !important;}" lh="2.5em"][/vc_column_inner][vc_column_inner css=".vc_custom_1607342274637{margin-bottom: 15px !important;}" offset="vc_col-md-6"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" lh="text_small:1em"]Get your tools for free. [ld_br]<br /> For a limited time.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="5/12" column_top_onmobile="yes" align="text-center" offset="vc_col-sm-offset-0 vc_col-xs-offset-1 vc_col-xs-10" css=".vc_custom_1607342664586{padding-top: 120px !important;}" responsive_css="padding_top_medium:20%25" responsive_align="text-center text-md-left"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1800" pf_start_delay="1250" pf_delay="180" pf_init_translate_y="35" pf_init_rotate_x="-12"][ld_images_group_element img_size="50%" absolute_pos="yes" image="84" position="top_small:-20%25|right_small:0px|left_small:12px"][/ld_images_group_element][ld_images_group_element img_size="55%" image="85" margin="bottom_large:-10%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column][ld_particles as_bg="yes" absolute_pos="yes" color_type="multi_color" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1605275107996-f48f08c1-2ce5" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="8" multi_color_values="%5B%7B%22scolor%22%3A%22%234cfd89%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%23fdc14c%22%7D%5D" size="4"][/vc_column][/vc_row]</p>
CONTENT;
	$templates[] = $data;

	//Banner 2
	$data = array();
	$data['name'] = esc_html__( 'Banner 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-2.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="center top" css=".vc_custom_1605278322098{padding-top: 65px !important;padding-bottom: 35px !important;background-image: url(https://darkapp.liquid-themes.com/wp-content/uploads/2020/11/bg-circles.svg?id=120) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="download"][vc_column offset="vc_col-lg-5 vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1605283182083{margin-bottom: 35px !important;}"][ld_images_group_element image="121" margin="bottom_small:20px"][/ld_images_group_element][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22easy%20%F0%9F%A4%91%22%7D%2C%7B%22word%22%3A%22secure%20%F0%9F%92%B6%22%7D%2C%7B%22word%22%3A%22public%20%F0%9F%8F%A6%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:61px|text_small:12vw" lh="text_small:1em" margin="bottom_small:0.25em"]E-Stock trading made[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.5em"]All in one  and startup solutions. Endless use-cases that make it highly[/ld_fancy_heading][vc_row_inner content_placement="middle" css=".vc_custom_1602597013022{padding-top: 22px !important;}"][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1605278083336{margin-bottom: 15px !important;}"][ld_button style="btn-default" title="Get the app" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" border="border-thick" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="fontawesome" i_position="left" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="13px" fw="700" ls="0.05em" i_icon_fontawesome="fab fa-apple" i_size="23px" i_margin_right="0.85em" css=".vc_custom_1605283164168{padding-right: 0.75em !important;padding-left: 0.75em !important;}" lh="2.5em"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1602594290870{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:13px" lh="text_small:1em"]Get your tools for free. [ld_br]<br /> For a limited time.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="2/3" offset="vc_col-md-offset-1 vc_col-md-5 vc_col-xs-10"][ld_images_group_element enable_hover3d="yes" image="124"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 3
	$data = array();
	$data['name'] = esc_html__( 'Banner 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-3.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" enable_slideshow_bg="yes" slideshow_images="155,156" bg_attachment="fixed" enable_overlay="yes" enable_row_dividers="yes" enable_loading_bg="yes" css=".vc_custom_1610355277015{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(https://barber.liquid-themes.com/staging/wp-content/uploads/2020/03/barber-slide-1_2x-scaled_b590a2c2e8ef2da9b9d2f62b8155a2a0.jpg?id=155) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" row_svg_divider="top_shape_height:0|bottom_shape_type:11|bottom_shape_color:%23fffdf8|bottom_shape_height:86" overlay_bg="rgba(0, 0, 0, 0.31)" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px|padding_top_small:60px|padding_bottom_small:60px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" ca_start_delay="250" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="11px" margin="bottom_small:2em" fw="700" ls="0.2em"]Enjoy Your Haircut[/ld_fancy_heading][ld_spacer height="12px"][ld_fancy_heading transform="text-uppercase" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="44" fs="text_medium:53px|text_small:9vw" lh="text_small:1.33em" fw="text_small:900" ca_init_translate_y="71"]NYC’s Favourite Barber Shop.[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="14px" fw="700" ls="2px"]14th St, SOHO, NYC. APPOINTMENT: +123 456 789[/ld_fancy_heading][ld_spacer height="25px"][ld_button style="btn-solid" title="Book Appointment" transformation="text-uppercase" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="11px" ls="0.15em"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" el_id="scroll-down-link-container" ca_duration="1800" ca_start_delay="1000" ca_delay="180" ca_init_translate_y="40" responsive_align="text-center"][ld_button style="btn-naked" link_type="scroll_to_section" i_type="linea" i_position="bottom" i_shape="btn-icon-round" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-md" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" i_size="18px" i_color="rgb(0, 0, 0)" i_fill_color="rgb(255, 255, 255)" i_hcolor="rgb(255, 255, 255)" i_fill_hcolor="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 4
	$data = array();
	$data['name'] = esc_html__( 'Banner 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-4.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="bottom" fade_scroll="yes" enable_slideshow_bg="yes" slideshow_images="4595,4520,4524" enable_overlay="yes" css=".vc_custom_1603704921801{padding-top: 110px !important;padding-bottom: 110px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="linear-gradient(0deg, rgb(15,15,20) 2.8662420382165603%, rgba(15, 15, 20, 0.38) 29.006369426751593%, rgba(20,19,26,0) 54.77707006369427%)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1596021144870{margin-bottom: 10vh !important;}" ca_init_rotate_y="64" ca_duration="1400" ca_delay="80" ca_init_translate_y="52" responsive_align="text-center"][ld_fancy_heading transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="68" fs="text_medium:120px|text_small:26vw" compressor="0.6" ls="text_small:0.035em" lh="text_small:1.4em" ca_init_translate_y="0" ca_init_rotate_y="0"]Daniel[ld_br]Mcbride[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-8"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1.2" ca_init_scale_y="1.2" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="800" ca_delay="180" ca_init_translate_y="50" ca_init_rotate_x="-25"][vc_column_inner width="1/3" align="text-center" offset="vc_col-xs-4" responsive_align="text-center"][ld_button style="btn-naked" title="Apple Music" transformation="text-uppercase" hover_txt_effect="btn-hover-txt-liquid-y-alt" i_type="fontawesome" i_position="top" i_add_icon="true" i_size="44px" i_margin_bottom="20px" i_color="rgb(255, 255, 255)" text_color="rgba(255, 255, 255, 0.7)" fs="14px" i_icon_fontawesome="fab fa-apple" link="url:%23|||" i_hcolor="rgb(165, 116, 80)"][/vc_column_inner][vc_column_inner width="1/3" align="text-center" offset="vc_col-xs-4" responsive_align="text-center"][ld_button style="btn-naked" title="Spotify" transformation="text-uppercase" hover_txt_effect="btn-hover-txt-liquid-y-alt" i_type="fontawesome" i_position="top" i_add_icon="true" i_size="44px" i_margin_bottom="20px" i_color="rgb(255, 255, 255)" text_color="rgba(255, 255, 255, 0.7)" fs="14px" i_icon_fontawesome="fab fa-spotify" i_hcolor="rgb(165, 116, 80)"][/vc_column_inner][vc_column_inner width="1/3" align="text-center" offset="vc_col-xs-4" responsive_align="text-center"][ld_button style="btn-naked" title="Youtube" transformation="text-uppercase" hover_txt_effect="btn-hover-txt-liquid-y-alt" i_type="fontawesome" i_position="top" i_add_icon="true" i_size="44px" i_margin_bottom="20px" i_color="rgb(255, 255, 255)" text_color="rgba(255, 255, 255, 0.7)" fs="14px" i_icon_fontawesome="fab fa-youtube" i_hcolor="rgb(165, 116, 80)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 5
	$data = array();
	$data['name'] = esc_html__( 'Banner 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-5.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1605626634888{padding-bottom: 60px !important;}" responsive_css="margin_top_medium:100px|padding_top_medium:70px|padding_bottom_medium:70px"][vc_column][ld_bananas_banner use_custom_fonts_heading="true" use_custom_fonts_heading2="true" image="4569" heading="Available on Spotify." heading2="New album is out!" fs="clamp(32px, 7vw, 110px)" fs2="clamp(32px, 7vw, 110px)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 6
	$data = array();
	$data['name'] = esc_html__( 'Banner 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-6.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" equal_height="yes" bg_attachment="fixed" enable_overlay="yes" enable_loading_bg="yes" css=".vc_custom_1603104694188{padding-top: 180px !important;padding-bottom: 120px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2020/07/banner-company-optimized@2x-scaled.jpg?id=8821) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 34, 44, 0.43)" responsive_css="padding_top_medium:135px|padding_bottom_medium:35px|padding_top_small:80px|padding_bottom_small:80px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-7" ca_duration="1600" ca_start_delay="600" ca_delay="160" ca_init_translate_y="50"][ld_fancy_heading split_type="chars, words" highlight_type="lqd-highlight-custom-underline" highlight_height="0.2em" highlight_offset="0em" duration="1000" delay="45" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_all:88px|text_large:84px|text_small:13.5vw" lh="text_small:0.9em" margin="bottom_small:0.1em" ca_init_translate_y="0" ls="text_small:-0.02em"][ld_highlight]first[/ld_highlight]class investments[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.7)" fs="text_medium:23px|text_small:20px" lh="text_medium:1.7em|text_small:1.5em" padding="right_large:20%25" ca_init_translate_y="0"]Take your business to the next level Hub’s built-in risk and profit management tools.[/ld_fancy_heading][vc_row_inner css=".vc_custom_1612086109115{padding-top: 25px !important;}"][vc_column_inner width="1/2" offset="vc_col-md-5" css=".vc_custom_1576834675024{margin-bottom: 15px !important;}"][ld_button style="btn-solid" title="Get a quote" link_type="scroll_to_section" shape="round" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" fs="16px" css=".vc_custom_1609755564039{padding-right: 0.75em !important;padding-left: 0.75em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_size="20px" hover_color="rgb(24, 67, 65)"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1576834683574{margin-bottom: 15px !important;}"][vc_column_text]</p> <h6><span style="font-size: 13px; color: #ffffff;">call us now</span><br /> <span style="font-size: 19px; color: var(--color-primary);">+1 114 7788</span></h6> <p>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="2.05" ca_init_scale_y="2.05" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-3" responsive_align="text-md-right" ca_duration="1800" ca_start_delay="1200"][ld_spacer height="15px" md_height="120px" sm_height="30px"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="24px" i_shape_custom_size="96px" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.8)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DQxdxYr6CRN4%26ab_channel%3DIntapp|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 7
	$data = array();
	$data['name'] = esc_html__( 'Banner 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-7.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" data_tooltip="Find your music" responsive_css="padding_top_medium:6vh|padding_right_medium:10vw|padding_bottom_medium:0px|padding_left_medium:10vw|padding_bottom_small:100px" css=".vc_custom_1612169239907{padding-top: 160px !important;padding-bottom: 60px !important;background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/lines-5.svg?id=204) !important;background-position: 0 0 !important;background-repeat: repeat !important;}" el_id="home"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1612169489054{margin-bottom: 35px !important;}" responsive_align="text-center text-sm-left" ca_duration="1600" ca_delay="160" ca_init_translate_y="45"][ld_fancy_heading use_custom_fonts_title="true" lh="text_small:1em" fs="text_large:5vw|text_medium:77px|text_small:17vw" color="rgb(0, 0, 0)" margin="bottom_small:0px" ls="text_small:-0.02em"]Experience[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" lh="text_small:1.1em" fs="text_large:5vw|text_medium:77px|text_small:23.5vw" gradient="linear-gradient(90deg, rgb(245, 58, 139) 15.923566878980886%, rgb(238, 112, 74) 50.63694267515923%, rgb(107,133,255) 99.68152866242038%)" ls="text_small:-0.02em" margin="bottom_small:0.35em"]magical sound.[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" padding="right_large:15%25" ca_init_translate_y="0"]Listen to playlists curated for every occasion. Get daily podcasts and music recommendations.[/ld_fancy_heading][vc_row_inner][vc_column_inner][ld_button style="btn-solid" title="App store `{`ld_span`}`Get it for free`{`/ld_span`}`" transformation="text-uppercase" shape="round" size="btn-lg" border="border-none" i_type="fontawesome" i_separator="btn-icon-sep" enable_row_shadowbox="yes" i_add_icon="true" i_icon_fontawesome="fab fa-apple" i_size="22px" color="rgb(44, 46, 49)" text_color="rgb(255, 255, 255)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.5em" fw="700" ls="0.05em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2240px%22%2C%22shadow_color%22%3A%22rgba(73%2C76%2C137%2C0.13)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611745315515{margin-bottom: 25px !important;padding-top: 0.5em !important;padding-bottom: 0.5em !important;}"][vc_column_text]    Try for free. No credit card required.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_top_onmobile="yes" align="text-center" offset="vc_col-md-6" css=".vc_custom_1606982949576{margin-bottom: 30px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" responsive_align="text-center" responsive_css="margin_bottom_small:0px"][ld_images_group_element img_size="100%" image="189" margin="left_large:-18%25"][/ld_images_group_element][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_random_opacity="yes" enable_anim_opacity="yes" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1595673746671-a27c94f3-ba8e" number="7" multi_color_values="%5B%7B%22scolor%22%3A%22%2340f292%22%7D%2C%7B%22scolor%22%3A%22%2397dff4%22%7D%2C%7B%22scolor%22%3A%22%23ffefd2%22%7D%2C%7B%22scolor%22%3A%22%23ffe3d1%22%7D%5D" anim_opacity_speed="0.2" anim_opacity_min="0.5" size="4" move_speed="1.5" anim_size_speed="1" anim_size_min="70"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 8
	$data = array();
	$data['name'] = esc_html__( 'Banner 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-8.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" css=".vc_custom_1612169257837{padding-top: 100px !important;background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/lines-5.svg?id=204) !important;background-position: 0 0 !important;background-repeat: repeat !important;}" data_tooltip="Better Sound" responsive_css="padding_bottom_medium:150px|padding_top_small:150px" el_id="features"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_css="padding_top_medium:35px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" ls="text_small:0.05em" margin="bottom_small:1em"]Daily Podcasts[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:60px|text_small:12vw" lh="text_large:1.1em"]Enjoy live podcasts.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" ca_init_translate_y="0" start_delay="1150"]All in one  and startup solutions. Endless cases that make it highly flexible and adaptable in the app.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="High performance gaming mode" title_mb="1" custom_heading_size="18px" icon_size="21px" icon_mb="16" css=".vc_custom_1595835474587{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Smart and affordable mobility solutions" title_mb="1" custom_heading_size="18px" icon_size="21px" icon_mb="16" css=".vc_custom_1595835458681{margin-bottom: 15px !important;}"][/ld_icon_box][ld_spacer][ld_button style="btn-solid" title="See Live Podcasts" shape="round" i_type="fontawesome" i_add_icon="true" fs="18px" lh="1.15em" i_icon_fontawesome="fas fa-play" i_size="10px" i_margin_left="20px" color="rgb(44, 46, 49)" text_color="rgb(255, 255, 255)"][/vc_column][vc_column align="text-center" offset="vc_col-md-6" responsive_align="text-center"][ld_hotspots image="107" identities="%5B%7B%22title%22%3A%22Gaming%20Headphones%22%2C%22description%22%3A%22Focus%20and%20target%20your%20audience%20through%20the%20right%20channels.%22%2C%22position%22%3A%22lqd-hotspot-t%22%2C%22top%22%3A%2235%25%22%2C%22left%22%3A%2235%25%22%7D%2C%7B%22title%22%3A%22Smartphone%20Integration%22%2C%22description%22%3A%22Focus%20and%20target%20your%20audience%20through%20the%20right%20channels.%22%2C%22position%22%3A%22lqd-hotspot-t%22%2C%22top%22%3A%2220%25%22%2C%22right%22%3A%2227%25%22%7D%5D"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 9
	$data = array();
	$data['name'] = esc_html__( 'Banner 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-9.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" luminosity="dark" css=".vc_custom_1612169328782{padding-top: 80px !important;padding-bottom: 80px !important;background-color: #000000 !important;background-position: 0 0 !important;background-repeat: repeat !important;}" data_tooltip="Better Sound" responsive_css="padding_top_medium:150px|padding_bottom_medium:150px|padding_top_small:100px|padding_bottom_small:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" ls="text_small:0.05em" margin="bottom_small:1em" color="rgba(255, 255, 255, 0.57)"]Live Composition Mode[/ld_fancy_heading][ld_fancy_heading tag="h2" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" ca_init_translate_x="0" ca_init_translate_y="0" ca_init_translate_z="0" ca_init_rotate_x="0" lh="text_small:1.1em" padding="right_large:35%25" color="rgb(255, 255, 255)" fs="text_medium:65px|text_small:12vw"]Record and share.[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" ca_init_translate_y="0" color="rgba(255, 255, 255, 0.57)"]All in one  and startup solutions. Endless use-cases that make it highly flexible, adaptable, and scalable for everyone in the community.[/ld_fancy_heading][ld_button style="btn-solid" title="Explore Daily Mix" shape="round" i_type="fontawesome" i_add_icon="true" fs="18px" lh="1.15em" i_icon_fontawesome="fas fa-music" i_size="13px" i_margin_left="20px" color="rgb(44, 46, 49)"][/vc_column][vc_column column_top_onmobile="yes" align="text-center" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|margin_bottom_small:0px|padding_top_small:60px" css=".vc_custom_1606983223802{margin-bottom: 20px !important;}" responsive_align="text-center"][ld_images_group_element img_size="60%" image="228"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 10
	$data = array();
	$data['name'] = esc_html__( 'Banner 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-10.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" css=".vc_custom_1612169289087{padding-top: 150px !important;padding-bottom: 150px !important;background-image: url(https://appblocks.liquid-themes.com/staging/wp-content/uploads/2020/07/lines-5.svg?id=204) !important;background-position: 0 0 !important;background-repeat: repeat !important;}" data_tooltip="Available for all devices" el_id="download"][vc_column width="5/6" offset="vc_hidden-lg vc_hidden-md vc_col-xs-offset-1 vc_col-xs-10"][vc_single_image image="222" alignment="center"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_align="text-center text-md-left" ca_duration="1600" ca_delay="160" ca_init_translate_y="65"][ld_fancy_heading tag="h2" split_type="words" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" ca_init_translate_x="0" ca_init_translate_y="0" ca_init_translate_z="0" ca_init_rotate_x="0" lh="text_small:1.1em" compressor="0.7" minfontsize="50" fs="text_medium:60px|text_small:12vw" padding="right_large:25%25"]Available for all devices.[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:21px" lh="text_small:33px" margin="bottom_small:1.67em" padding="right_large:15%25" ca_init_translate_y="0"]All in one  and startup solutions. Endless use-cases that make it highly adaptable.[/ld_fancy_heading][vc_row_inner][vc_column_inner][ld_button style="btn-solid" title="App store `{`ld_span`}`Get it for free`{`/ld_span`}`" transformation="text-uppercase" shape="round" size="btn-lg" border="border-none" i_type="fontawesome" i_separator="btn-icon-sep" enable_row_shadowbox="yes" i_add_icon="true" i_icon_fontawesome="fab fa-apple" i_size="22px" color="rgb(44, 46, 49)" text_color="rgb(255, 255, 255)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.5em" fw="700" ls="0.05em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2240px%22%2C%22shadow_color%22%3A%22rgba(73%2C76%2C137%2C0.13)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611745327563{margin-bottom: 25px !important;padding-top: 0.5em !important;padding-bottom: 0.5em !important;}"][vc_column_text]    Try for free. No credit card required.[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs"][ld_images_group_element image="222" margin="bottom_large:-5vw"][/ld_images_group_element][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_random_opacity="yes" enable_anim_opacity="yes" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-ld-1572606562223-6c86d24f-61ae" number="7" multi_color_values="%5B%7B%22scolor%22%3A%22%2340f292%22%7D%2C%7B%22scolor%22%3A%22%2397dff4%22%7D%2C%7B%22scolor%22%3A%22%23ffefd2%22%7D%2C%7B%22scolor%22%3A%22%23ffe3d1%22%7D%5D" anim_opacity_speed="0.2" anim_opacity_min="0.5" size="4" move_speed="1.5" anim_size_speed="1" anim_size_min="70"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 11
	$data = array();
	$data['name'] = esc_html__( 'Banner 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-11.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" bg_position="center center" enable_overlay="yes" enable_row_dividers="yes" enable_loading_bg="yes" css=".vc_custom_1603179531850{padding-top: 160px !important;padding-bottom: 200px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/marketing-bg@2x-scaled.jpg?id=5865) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(12, 13, 14, 0.34)" responsive_css="padding_bottom_medium:100px|padding_top_small:100px" row_svg_divider="bottom_shape_type:12|bottom_shape_color:%23ffffff|bottom_shape_height:153"][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1595576723011{background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:13px" ls="text_small:0.1em" margin="bottom_small:1.8em"]Digital Marketing Agency[/ld_fancy_heading][ld_fancy_heading split_type="chars, words" highlight_type="lqd-highlight-custom-underline" duration="1300" delay="70" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" enable_fit="true" color="rgb(255, 255, 255)" compressor="0.8" minfontsize="57" fs="text_large:100px|text_medium:90px|text_small:65px" lh="text_small:1.1em" ls="text_small:-0.02em" margin="bottom_small:0.3em" ca_init_translate_y="0" ca_init_translate_x="0" ca_init_rotate_z="3"]Unique digital ideas.[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-10" responsive_css="padding_right_medium:7%25|padding_left_medium:7%25" css=".vc_custom_1572887826278{margin-bottom: 30px !important;}"][ld_fancy_heading tag="p" delay="200" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.8)" fs="text_medium:21px|text_small:18px" start_delay="900" ca_init_translate_y="70" lh="text_small:1.62em"]We help our clients succeed by creating brand identities, digital experiences, and print materials.[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="1200" ca_delay="200" ca_init_translate_y="35"][ld_button style="btn-solid" title="Let's Talk" shape="circle" size="btn-lg" border="border-none" hover_txt_effect="btn-hover-txt-liquid-x" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1603179547119{margin-bottom: 10px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" color="rgb(0, 127, 255)" color2="rgb(255, 77, 84)" hover_color="rgb(255, 0, 0)" fs="18px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color2="rgb(0, 127, 255)"][ld_button style="btn-default" title="Explore Hub" link_type="scroll_to_section" shape="circle" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1603179559060{margin-right: 12px !important;margin-bottom: 10px !important;margin-left: 12px !important;}" color="rgba(255, 255, 255, 0.25)" text_color="rgb(255, 255, 255)" lh="1.3em" fs="18px" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 12
	$data = array();
	$data['name'] = esc_html__( 'Banner 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-12.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" row_scale_bg_onhover="yes"][vc_column row_scale_bg_onhover="yes" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_column_shadowbox="yes" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2250px%22%2C%22blur_radius%22%3A%2280px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" css=".vc_custom_1606722264142{border-radius: 10px !important;}" translate_from_y="20" translate_to_y="-70"][vc_row_inner row_scale_bg_onhover="yes" bg_position="left center" enable_overlay="yes" responsive_css="padding_top_medium:300px|padding_bottom_medium:75px|padding_left_medium:50px" css=".vc_custom_1606722443480{padding-top: 70px !important;padding-right: 20px !important;padding-bottom: 70px !important;padding-left: 20px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2019/11/bg-2@2x.jpg?id=5820) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 10px !important;}" hover_overlay_bg="rgba(0, 0, 0, 0.19)"][vc_column_inner offset="vc_col-md-8" responsive_align="text-left"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" color="rgb(255, 255, 255)" fs="text_large:35px|text_small:30px" lh="text_small:1.26em" margin="bottom_small:0.75em" compressor="0.7" minfontsize="38"]Watch the creative process behind the digital marketing.[/ld_fancy_heading][ld_button style="btn-naked" title="`{`ld_small`}`Click to Watch`{`/ld_small`}`See how it works" link_type="lightbox" i_type="linea" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" enable_icon_shadowbox="yes" i_add_icon="true" i_size="16px" i_shape_custom_size="62px" i_color="rgb(255, 255, 255)" i_fill_color2="rgba(255, 255, 255, 0.35)" i_fill_hcolor2="rgb(255, 255, 255)" fs="18px" icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22rgba(255%2C255%2C255%2C0.35)%22%7D%5D" h_icon_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%23ffffff%22%7D%5D" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DIC9urbiVp4M|||" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_hcolor="rgb(0, 0, 0)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 13
	$data = array();
	$data['name'] = esc_html__( 'Banner 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-13.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row enable_gradient="yes" enable_row_dividers="yes" css=".vc_custom_1612870817541{margin-top: 40px !important;padding-top: 160px !important;padding-bottom: 85px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/marketing-bg@2x-1-scaled.jpg?id=5958) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" gradient_bg="linear-gradient(90deg, rgb(52, 122, 255) 0.3184713375796178%, rgb(250, 65, 94) 100%)" row_svg_divider="top_shape_type:12|top_shape_color:%23ffffff|top_shape_height:65" responsive_css="margin_top_small:75px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" ca_duration="1600" ca_delay="200" ca_init_translate_y="65"][ld_fancy_heading tag="h2" split_type="words" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" color="rgb(255, 255, 255)" fs="text_large:45px|text_small:32px" lh="text_small:1.26em" margin="bottom_small:0.75em" compressor="0.75" minfontsize="38"]Any questions à Projects? Let’s get started.[/ld_fancy_heading][ld_button style="btn-solid" title="Send a Message" shape="circle" size="btn-lg" i_type="linea" i_add_icon="true" css=".vc_custom_1595584965098{margin-right: 12px !important;margin-bottom: 15px !important;margin-left: 12px !important;padding-right: 1em !important;padding-left: 1em !important;}" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" lh="1.3em" fs="16px" hover_color="rgb(32, 35, 41)" htext_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-lqd-pen"][ld_button style="btn-default" title="Get started" shape="circle" size="btn-lg" css=".vc_custom_1573385436113{margin-right: 12px !important;margin-bottom: 15px !important;margin-left: 12px !important;padding-right: 1em !important;padding-left: 1em !important;}" color="rgba(255, 255, 255, 0.25)" text_color="rgb(255, 255, 255)" lh="1.3em" fs="16px" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 14 - startuphub
	$data = array();
	$data['name'] = esc_html__( 'Banner 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-14.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" css=".vc_custom_1607065376522{padding-top: 160px !important;}" responsive_css="padding_top_medium:0px|padding_right_medium:10vw|padding_left_medium:10vw"][vc_column][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" position="top_all:0px|top_large:-20%25|right_large:0px|top_medium:-15%25|top_small:-10%25|right_small:-10%25"][ld_images_group_element image="4409"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-5 vc_col-md-7"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22payments.%22%7D%2C%7B%22word%22%3A%22tax%20forms.%22%7D%2C%7B%22word%22%3A%22contracts.%22%7D%5D" use_custom_fonts_title="true" gradient="linear-gradient(156deg, #3d00c6 0%, rgb(241,77,255) 70.06369426751593%)" fs="text_large:6.5vw|text_small:17vw" lh="text_small:0.85em" ls="text_small:-0.02em" margin="bottom_small:0.35em" fw="text_small:700"]Online[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(49, 63, 88)" fs="text_small:20px" lh="text_small:1.45em" margin="bottom_small:1.25em"]The ultimate one-click collection crafted by world-class designers. Give it a try![/ld_fancy_heading][ld_spacer height="15px"][ld_newsletter use_opt_in="Yes" style="solid" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--round" inputs_border="ld-sf--border-none" inputs_shadow="ld-sf--input-shadow" btn_style="solid" btn_display="label_icon" btn_label="Get started" btn_position="ld-sf--button-inline" enable_btn_shadowbox="yes" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" placeholder_text="Enter your email address" fs="16px" label_fs="17px" btn_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%227px%22%2C%22blur_radius%22%3A%2220px%22%2C%22shadow_color%22%3A%22rgba(132%2C92%2C255%2C0.2)%22%7D%5D" txt_color="rgb(49, 63, 88)" bg_color="rgb(255, 255, 255)" txt_f_color="rgb(0, 0, 0)" btn_txt_color="rgb(255, 255, 255)" btn_bg_color="rgb(132, 92, 255)" hover_btn_txt_color="rgb(255, 255, 255)" hover_btn_bg_color="rgb(132, 92, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_size="15px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:12px" color="rgb(0, 0, 0)"]   Try for free. No credit card required.[/ld_fancy_heading][/vc_column][vc_column width="5/6" offset="vc_col-lg-offset-1 vc_col-lg-6 vc_col-md-offset-0 vc_col-md-5 vc_col-sm-offset-1"][ld_images_group_element enable_float_effect="yes" float_easing="ease-in-out" image="792"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 15 - newsletter
	$data = array();
	$data['name'] = esc_html__( 'Banner 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-15.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner newsletter';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" bg_position="center bottom" sticky_row="yes" css=".vc_custom_1610357228901{padding-top: 150px !important;padding-bottom: 380px !important;background: #f7f8fb url(https://newsletterhub.liquid-themes.com/staging/wp-content/uploads/2019/11/people-2.svg?id=36) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px|padding_top_small:80px|padding_bottom_small:180px"][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_images_group_container enable_item_animation="yes" move_to_parent_row="yes" pf_init_scale_x="0.75" pf_init_scale_y="0.75" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" absolute_pos="yes" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" pf_duration="1800" pf_delay="220" pf_init_translate_y="117"][ld_images_group_element parallax="yes" scale_from_x="1.1" scale_from_y="1.1" scale_from_z="1" from_opacity="1" scale_to_x="1.4" scale_to_y="1.4" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="28" translate_from_y="16" translate_to_y="-129" position="right_small:0px|bottom_small:0px"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_trigger="number" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" responsive_css="padding_right_medium:7%25|padding_left_medium:7%25" ca_duration="1800" ca_delay="200" ca_init_translate_y="70" ca_init_rotate_x="0" translate_from_y="1" translate_to_y="-125" parallax_trigger_number="0.3" responsive_align="text-center"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22online%20forms%22%7D%2C%7B%22word%22%3A%22offline%20forms%22%7D%2C%7B%22word%22%3A%22any%20forms%22%7D%5D" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" fs="text_large:65px|text_medium:55px|text_small:13vw" lh="text_small:1em" word_colors="rgb(43, 189, 204)" padding="right_large:4%25|left_large:4%25" compressor="0.7" minfontsize="44"]Generate more innovative leads and[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:20px" margin="bottom_small:2.5em"]Beautiful layouts, super customizable, blazing fast, customer first approach.[/ld_fancy_heading][ld_newsletter enable_name_field="yes" show_inline="ld-sf--inputs-inline" style="bordered" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--round" inputs_border="ld-sf--border-none" inputs_shadow="ld-sf--input-shadow" btn_style="solid" btn_display="label_icon" btn_label="Sign up" btn_position="ld-sf--button-inline" btn_padding="0px" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" fs="16px" label_fs="16px" margin="bottom_small:0px" bg_color="rgb(255, 255, 255)" placeholder_text="Email address" placeholder_nametext="Your Name" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" label_fw="700" txt_color="rgb(110, 121, 130)"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1607064674952{padding-top: 25px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" ca_start_delay="650" responsive_css="padding_top_small:5px"][vc_column_inner width="1/4" offset="vc_col-lg-offset-3 vc_col-lg-2 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="30 Day Free Trial" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="No Hidden Fees" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Cancel Anytime" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" shape_type="triangle" opacity="1" enable_move="yes" move_direction="top" modes_grab_opacity="1" particle_id="ld-1579791733747-f28cf823-c73d" number="10" multi_color_values="%5B%7B%22scolor%22%3A%22%23ff7cac%22%7D%2C%7B%22scolor%22%3A%22%237ef3d6%22%7D%2C%7B%22scolor%22%3A%22%23ffe798%22%7D%5D" size="5" move_speed="1.75"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 16 - gridportfolio
	$data = array();
	$data['name'] = esc_html__( 'Banner 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-16.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:150px|padding_bottom_medium:150px|padding_top_small:160px" css=".vc_custom_1603117181334{padding-top: 140px !important;padding-bottom: 100px !important;}" el_id="works"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" ca_init_translate_y="-20" ca_init_rotate_y="-46" ca_duration="1800" ca_delay="140" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]Digital Designer based in London.[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" fs="text_large:81px|text_medium:68px|text_small:13.5vw" margin="bottom_small:0px"]Hi, I’m David. I create[/ld_fancy_heading][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22designs%22%7D%2C%7B%22word%22%3A%22illustrations%22%7D%2C%7B%22word%22%3A%22websites%22%7D%5D" use_custom_fonts_title="true" fs="text_large:81px|text_medium:68px|text_small:13.5vw" margin="bottom_small:0.35em"]beautiful[/ld_fancy_heading][ld_button style="btn-naked" title="— Would you like to work with me?" link_type="modal_window" hover_txt_effect="btn-hover-txt-liquid-y" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)" css=".vc_custom_1615372919780{margin-top: 0.5em !important;}" anchor_id="#header-contact-modal"][ld_particles as_bg="yes" color_type="random_color" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1588757654892-fd309525-a54e" number="7" size="3"][/vc_column][vc_column][ld_modal_window modal_type="fullscreen" el_id="header-contact-modal"][vc_row_inner full_width="" equal_height="yes" content_placement="middle" bg_position="center center" responsive_css="padding_top_medium:80px|padding_bottom_medium:80px" css=".vc_custom_1615372857273{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(https://gridportfolio.liquid-themes.com/staging/wp-content/uploads/2021/03/bg-2@2x-scaled-1.jpeg?id=4893) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="h-vh-100 align-items-center"][vc_column_inner width="1/2" css=".vc_custom_1615219219533{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:10%25"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:122px|text_medium:48px|text_small:34px" fw="text_small:500" color="rgb(0, 0, 0)" lh="text_medium:0.75em|text_small:1em" margin="bottom_small:0.5em"]Send a message.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2.5em"]We’re here to answer any question you may have.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_css="padding_top_medium:45px|padding_right_medium:65px|padding_bottom_medium:45px|padding_left_medium:65px" css=".vc_custom_1615219159553{margin-bottom: -130px !important;background-color: #ffffff !important;border-radius: 10px !important;}"][ld_cf7 id="4892" shape="lqd-contact-form-inputs-underlined" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="13px" submit_fs="17px" color="rgb(0, 0, 0)" h_color="rgb(0, 0, 0)" css=".vc_custom_1615372838390{margin-bottom: 0px !important;}" submit_fw="500" border_color="rgba(0, 0, 0, 0.12)" hover_border_color="rgb(0, 0, 0)" submit_lh="1.5em" bm="13px"][/vc_column_inner][vc_column_inner width="1/4"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:13px" fw="text_small:700" ls="text_small:0.1em" margin="bottom_small:1.25em" color="rgb(0, 0, 0)"]careers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" margin="bottom_small:0.75em" color="rgb(0, 0, 0)"]Would you like to join our growing team?[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" fw="text_small:700" color="rgb(0, 0, 0)"]careers@hub.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/4"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:13px" fw="text_small:700" ls="text_small:0.1em" margin="bottom_small:1.25em" color="rgb(0, 0, 0)"]Feedbacks[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" margin="bottom_small:0.75em" color="rgb(0, 0, 0)"]Have a project in mind? Send a message.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.18em" fw="text_small:700" color="rgb(0, 0, 0)"]info@hub.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_modal_window][/vc_column][/vc_row][vc_row][vc_column][ld_portfolio_listing style="style02" grid_columns="2" columns_gap="27" bottom_gap="90" post_type="liquid-portfolio" posts_per_page="6" show_filter="yes" custom_cursor_style="lqd-cc-icon-trigger" filter_lbl_all="All" filter_mb="50" show_button="yes" ib_style="btn-naked" ib_title="See more" ib_i_type="linea" color_type="lqd-pf-color-custom" ib_i_add_icon="true" filter_id="lqd-1588770546136-5772c7db-b381" filter_cats="branding, custom-print, digital-design" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" filter_normal_color="rgb(77, 77, 77)" filter_hover_color="rgb(0, 0, 0)" filter_title="Filter by" ib_color="rgb(77, 77, 77)" color_primary="linear-gradient(0deg, rgb(91, 25, 183) 0.3184713375796178%, rgba(255, 255, 255, 0.36) 100%)" title_size="17px" overlay_arrow_color="rgba(255, 255, 255, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 17 - verticalportfolio
	$data = array();
	$data['name'] = esc_html__( 'Banner 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-17.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" enable_cc_circle="yes" cc_circle_color="rgb(255, 255, 255)"][vc_column][ld_slideshow_2 height="100vh"][ld_slideshow_section title="ScottBank" image="121"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:140px|text_small:18vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|title:Nexa%20Mobile||"]Nexa Mobile[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][ld_slideshow_section title="Kontrast" image="66"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:140px|text_small:20vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|title:Nike%20Shopping||"]Kontrast[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][ld_slideshow_section title="S-Klasse" image="120"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:140px|text_medium:15vw|text_small:20vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|||"]S-Klasse[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][ld_slideshow_section title="Insider" image="123"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1611322379049{margin-bottom: 30px !important;}" offset="vc_col-md-10"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_all:140px|text_large:130px|text_small:20vw" margin="top_large:0px|top_medium:120px|top_small:160px|bottom_small:0px" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Finspiration-board%2F|||"]Insider[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:20px|text_small:18px" color="rgb(255, 255, 255)" lh="text_small:1.3em" margin="bottom_small:2em"]We build digital experiences that communicate clearly and look fantastic on any device.[/ld_fancy_heading][ld_button style="btn-naked" title="See case details" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.85)" link="url:http%3A%2F%2Fverticalportfolio.liquid-themes.com%2Fportfolio%2Finspiration-board%2F|||"][/vc_column_inner][vc_column_inner responsive_align="text-md-center" css=".vc_custom_1611322407282{margin-bottom: 30px !important;}" offset="vc_col-md-2"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="152px" i_fill_color2="rgba(255, 255, 255, 0.25)" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column_inner][/vc_row_inner][/ld_slideshow_section][/ld_slideshow_2][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 18 - split
	$data = array();
	$data['name'] = esc_html__( 'Banner 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-18.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" luminosity="dark" bg_position="left center" css=".vc_custom_1596194795190{background-color: #161616 !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" data_tooltip="Mobile Connection" el_id="about"][vc_column offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:0px|padding_left_medium:10vmax" css=".vc_custom_1611748325327{padding-top: 160px !important;padding-right: 15px !important;padding-bottom: 5vh !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h2" transform="text-uppercase" enable_txt_rotator="yes" rotator_type="basic" items="%5B%7B%22word%22%3A%22experiences%22%7D%2C%7B%22word%22%3A%22illustrations%22%7D%2C%7B%22word%22%3A%22products%22%7D%2C%7B%22word%22%3A%22videos%22%7D%5D" highlight_type="lqd-highlight-custom-underline" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" maxfontsize="65" minfontsize="50" margin="bottom_small:0.35em" compressor="0.7" color="rgb(255, 255, 255)" start_delay="500" highlight_color_brush="rgb(255, 255, 255)" word_colors="rgb(255, 255, 255)" fs="text_large:7vmin|text_medium:8vw|text_small:11vw"]Hi, I'm David. [ld_br] I create[/ld_fancy_heading][ld_spacer height="22px"][ld_fancy_heading tag="p" split_type="words" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgba(255, 255, 255, 0.55)" fs="23px" lh="1.52em" margin="bottom_small:1.75em" start_delay="850" ca_init_translate_x="0" ca_init_translate_y="-1"]App Design / UX Research / Wireframing / Motion Design / Front-End Development[/ld_fancy_heading][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="1100" ca_delay="180" ca_init_translate_y="35"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_start_delay="1000"][ld_spacer height="15px"][ld_social_icons style="" size="social-icon-lg" identities="%5B%7B%22network%22%3A%22fa-pinterest%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-behance-square%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="27px" primary_color="rgba(255,255,255,0.43)" hover_color="#ffffff"][/vc_column_inner][/vc_row_inner][ld_gdpr_box]We use cookies to provide the best web experience possible . [/ld_gdpr_box][/vc_column][vc_column bg_position="center top" offset="vc_col-md-6" css=".vc_custom_1606209488800{padding-top: 20vh !important;padding-bottom: 20vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2020/07/split1@2x.jpg?id=1137) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 19 - split
	$data = array();
	$data['name'] = esc_html__( 'Banner 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-19.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610725640932{background-color: #f6dbb8 !important;}" data_tooltip="Pull and Bear" el_id="pull-and-bear"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(118, 56, 56)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(0, 0, 0)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(118, 56, 56)" lh="text_small:1em" ls="text_small:-0.02em"]Pull and Bear[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(118, 56, 56)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(118, 56, 56)" hover_color="rgb(0, 0, 0)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|title:Inspiration%20Board||"][/vc_column][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-6" css=".vc_custom_1612357592538{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-1@2x.jpg?id=4754) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Faliens-do-3d-automobile%2F|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 20 - split
	$data = array();
	$data['name'] = esc_html__( 'Banner 20', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-20.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610726102949{background-color: #002b3b !important;}" data_tooltip="Coast Drone" el_id="coast-drone"][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-6" css=".vc_custom_1612357648338{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-2@2x.jpg?id=4755) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fthe-portraits%2F|||"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_fancy_heading tag="h6" color="rgb(198, 229, 195)"]2021 - case study[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(198, 229, 195)" lh="text_small:1em" ls="text_small:-0.02em"]Coast Drone[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(198, 229, 195)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(198, 229, 195)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fthe-portraits%2F|title:The%20Portraits||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 21 - split
	$data = array();
	$data['name'] = esc_html__( 'Banner 21', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-21.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" bg_position="center center" css=".vc_custom_1610726560646{background: #502e23 url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-4@2x.jpg?id=4756) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" data_tooltip="Mercedes S-klasse" el_id="mercedes-s-klasse"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(242, 235, 225)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(242, 235, 225)" lh="text_small:1em" ls="text_small:-0.02em" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fmercedez-benz-coupe%2F|||"]Mercedes S-klasse[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(242, 235, 225)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(242, 235, 225)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fmercedez-benz-coupe%2F|title:Mercedez-Benz%20Coupe||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 22 - split
	$data = array();
	$data['name'] = esc_html__( 'Banner 22', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-22.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610726708653{background-color: #16161d !important;}" data_tooltip="Nexa mobile" el_id="nexa-mobile"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610725391311{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(255, 255, 255)" lh="text_small:1em" ls="text_small:-0.02em"]Nexa mobile[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(255, 255, 255)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|title:Nexa%20Mobile||"][/vc_column][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-6" css=".vc_custom_1612357735534{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-5@2x.jpg?id=4757) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 23 - split
	$data = array();
	$data['name'] = esc_html__( 'Banner 23', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-23.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="bottom" css=".vc_custom_1610726881702{background-color: #002B3B !important;}" data_tooltip="Insider Magazine" el_id="insider-magazine"][vc_column enable_link="enable_column_link" column_top_onmobile="yes" bg_position="center center" offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1612357676542{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/img-7@2x.jpg?id=4758) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fphoto-retouching%2F|||"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" responsive_css="margin_left_medium:-15%25|padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:120px|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1610726927822{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" ca_init_translate_y="55" ca_init_rotate_y="50" ca_duration="1600" ca_delay="180"][ld_button style="btn-naked" title="Play" link_type="lightbox" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" hover_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" color="rgb(255, 255, 255)" lh="text_small:1em" ls="text_small:-0.02em"]Insider Magazine[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(255, 255, 255)" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fphoto-retouching%2F|title:Photo%20Retouching||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 24 - split
	$data = array();
	$data['name'] = esc_html__( 'Banner 24', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-24.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" css=".vc_custom_1578567359580{background-color: #ffffff !important;}" data_tooltip="Social Connection"][vc_column row_scale_bg_onhover="yes" enable_link="enable_column_link" bg_position="center center" align="text-center" offset="vc_col-md-6" css=".vc_custom_1612358796277{padding-top: 20vh !important;padding-bottom: 20vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2020/07/split-pf-3@2x.jpg?id=1154) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_align="text-center" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|||"][ld_button style="btn-naked" title="Play Video" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thick" i_shape_size="btn-icon-xlg" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" i_size="22px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DTCMnrssX1NE%26ab_channel%3DApple|||" hover_color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)"][/vc_column][vc_column offset="vc_col-md-6" responsive_css="padding_top_medium:0px|padding_right_medium:10vmax|padding_bottom_medium:0px|padding_left_medium:10vmax|padding_top_small:150px|padding_bottom_small:150px" css=".vc_custom_1605618568268{padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h6"]2021 - case study[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" enable_fit="true" maxfontsize="80" minfontsize="68" margin="top_small:0.15em|bottom_small:0.2em" compressor="0.6" fs="text_large:6.5vw|text_medium:70px|text_small:60px" lh="text_small:1em" ls="text_small:-0.02em"]Android Cast [/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.75em"]I built digital experiences, and print materials that communicate clearly and look fantastic.[/ld_fancy_heading][ld_button style="btn-naked" title="⸺ See case study" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)" link="url:https%3A%2F%2Fsplit.liquid-themes.com%2Fportfolio%2Fnike-shopping%2F|title:Nike%20Shopping||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 25 - newsletterhub
	$data = array();
	$data['name'] = esc_html__( 'Banner 25', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-25.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" bg_position="center bottom" sticky_row="yes" css=".vc_custom_1610357228901{padding-top: 150px !important;padding-bottom: 380px !important;background: #f7f8fb url(https://newsletterhub.liquid-themes.com/staging/wp-content/uploads/2019/11/people-2.svg?id=36) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:0px|padding_bottom_medium:0px|padding_top_small:80px|padding_bottom_small:180px"][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_images_group_container enable_item_animation="yes" move_to_parent_row="yes" pf_init_scale_x="0.75" pf_init_scale_y="0.75" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" absolute_pos="yes" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" pf_duration="1800" pf_delay="220" pf_init_translate_y="117"][ld_images_group_element parallax="yes" scale_from_x="1.1" scale_from_y="1.1" scale_from_z="1" from_opacity="1" scale_to_x="1.4" scale_to_y="1.4" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="28" translate_from_y="16" translate_to_y="-129" position="right_small:0px|bottom_small:0px"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" parallax_trigger="number" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" responsive_css="padding_right_medium:7%25|padding_left_medium:7%25" ca_duration="1800" ca_delay="200" ca_init_translate_y="70" ca_init_rotate_x="0" translate_from_y="1" translate_to_y="-125" parallax_trigger_number="0.3" responsive_align="text-center"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22online%20forms%22%7D%2C%7B%22word%22%3A%22offline%20forms%22%7D%2C%7B%22word%22%3A%22any%20forms%22%7D%5D" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" fs="text_large:65px|text_medium:55px|text_small:13vw" lh="text_small:1em" word_colors="rgb(43, 189, 204)" padding="right_large:4%25|left_large:4%25" compressor="0.7" minfontsize="44"]Generate more innovative leads and[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:20px" margin="bottom_small:2.5em"]Beautiful layouts, super customizable, blazing fast, customer first approach.[/ld_fancy_heading][ld_newsletter enable_name_field="yes" show_inline="ld-sf--inputs-inline" style="bordered" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--round" inputs_border="ld-sf--border-none" inputs_shadow="ld-sf--input-shadow" btn_style="solid" btn_display="label_icon" btn_label="Sign up" btn_position="ld-sf--button-inline" btn_padding="0px" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" fs="16px" label_fs="16px" margin="bottom_small:0px" bg_color="rgb(255, 255, 255)" placeholder_text="Email address" placeholder_nametext="Your Name" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" label_fw="700" txt_color="rgb(110, 121, 130)"][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1607064674952{padding-top: 25px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" ca_start_delay="650" responsive_css="padding_top_small:5px"][vc_column_inner width="1/4" offset="vc_col-lg-offset-3 vc_col-lg-2 vc_col-sm-offset-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="30 Day Free Trial" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="No Hidden Fees" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/4" offset="vc_col-lg-2"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Cancel Anytime" icon_size="14px" custom_heading_size="16px"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" shape_type="triangle" opacity="1" enable_move="yes" move_direction="top" modes_grab_opacity="1" particle_id="ld-1579791733747-f28cf823-c73d" number="10" multi_color_values="%5B%7B%22scolor%22%3A%22%23ff7cac%22%7D%2C%7B%22scolor%22%3A%22%237ef3d6%22%7D%2C%7B%22scolor%22%3A%22%23ffe798%22%7D%5D" size="5" move_speed="1.75"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 26 - newsletterhub
	$data = array();
	$data['name'] = esc_html__( 'Banner 26', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-26.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
[vc_row content_placement="middle" responsive_css="padding_top_medium:135px" css=".vc_custom_1608904295031{padding-top: 90px !important;padding-bottom: 30px !important;}"][vc_column width="1/2"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1600" pf_delay="160" pf_init_translate_x="-35" pf_init_translate_y="0" pf_init_rotate_y="0"][ld_images_group_element img_size="50%" enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" enable_reveal="yes" image="273" reveal_delay="150"][/ld_images_group_element][ld_images_group_element absolute_pos="yes" image="274" position="bottom_small:0px|left_small:0px"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="45" ca_init_rotate_z="0" responsive_css="padding_left_large:7%25|margin_bottom_small:0px" css=".vc_custom_1608905281532{margin-bottom: 55px !important;}" ca_start_delay="500"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:70px" fw="text_small:700" ls="text_small:-0.015em" lh="text_small:1em" margin="bottom_small:0px"]We don’t sell[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_height="0.15em" highlight_offset="0.325em" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" color="rgb(15, 90, 100)" fs="text_large:78px" ls="text_small:-0.015em" lh="text_small:1em" margin="bottom_small:0px" hover_text_outline_color="rgb(0, 0, 0)" highlight_color="rgba(255, 126, 126, 0.65)" hover_text_outline_width="1px" fw="text_small:700"][ld_highlight]user data[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_height="0.15em" highlight_offset="0.325em" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" color="rgb(15, 90, 100)" fs="text_all:78px|text_large:70px" ls="text_small:-0.015em" lh="text_small:1em" margin="bottom_small:0px" hover_text_outline_color="rgb(0, 0, 0)" highlight_color="rgba(255, 126, 126, 0.65)" hover_text_outline_width="1px" fw="text_small:700"][ld_highlight]sensitive info[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_height="0.15em" highlight_offset="0.325em" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" color="rgb(15, 90, 100)" fs="text_large:78px" ls="text_small:-0.015em" lh="text_small:1em" margin="bottom_small:0px" hover_text_outline_color="rgb(0, 0, 0)" highlight_color="rgba(255, 126, 126, 0.65)" hover_text_outline_width="1px" fw="text_small:700"][ld_highlight]information[/ld_highlight][/ld_fancy_heading][ld_spacer height="10px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(70, 77, 101, 0.8)" fs="text_small:18px" lh="text_small:1.44em" margin="right_all:22%25|bottom_small:1em"]Hub allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][ld_button style="btn-naked" title="Learn more" link_type="lightbox" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="18px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 27 - classic
	$data = array();
	$data['name'] = esc_html__( 'Banner 27', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-27.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row enable_loading_bg="yes" css=".vc_custom_1595415099940{padding-top: 140px !important;padding-bottom: 140px !important;background-image: url(https://classichub.liquid-themes.com/staging/wp-content/uploads/2020/03/bg-11@2x-scaled.jpg?id=59) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}" responsive_css="padding_right_large:140px|padding_left_large:140px|padding_right_medium:100px|padding_left_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" ca_init_rotate_z="0"][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" ca_init_translate_y="0" ca_init_rotate_z="0" margin="bottom_small:0.35em"]Take your business to the next level.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:17px" lh="text_small:30px" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner width="1/3" offset="vc_col-md-6"][ld_button style="btn-solid" title="Explore hub" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1595490224601{padding-right: 0.6em !important;padding-left: 0.6em !important;}" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fw="700" hover_color="rgb(22, 22, 22)"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-6"][vc_column_text css=".vc_custom_1583768679211{margin-bottom: 0px !important;}"]Hotline: (733) 860-2906[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 28 - photography
	$data = array();
	$data['name'] = esc_html__( 'Banner 28', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-28.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" responsive_css="padding_top_medium:220px|padding_right_medium:35px|padding_left_medium:35px" css=".vc_custom_1611750213101{padding-top: 120px !important;}"][vc_column offset="vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:0.5em" ls="text_small:-0.02em" fs="text_small:17px"]Hi, I’m Tom.[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" margin="bottom_small:0.5em" ls="text_small:-0.02em"]I’m a freelance Branding and Digital Designer based in NYC.[/ld_fancy_heading][ld_button style="btn-naked" title="— Would you like to work with me?" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 29 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Banner 29', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-29.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" bg_position="center top" css=".vc_custom_1602670018904{padding-top: 80px !important;padding-bottom: 80px !important;background: #bcb1cf url(https://productshop.liquid-themes.com/staging/wp-content/uploads/2020/10/Banner@2x.jpg?id=165) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column width="1/2" offset="vc_col-lg-5" responsive_css="padding_right_medium:18%25" css=".vc_custom_1603288619112{padding-bottom: 70px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:10px" ls="text_small:0.08em" fw="text_small:700" margin="bottom_small:1.5em"]<img class="alignnone size-full wp-image-167" src="https://productshop.liquid-themes.com/staging/wp-content/uploads/2020/10/intro.svg" alt="Image" />  Hub Wired Collection[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" fs="text_small:59px" lh="text_small:1em" color="rgb(0, 0, 0)" ls="text_small:-0.01em" margin="bottom_small:0.25em"]Easy skin care routine.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:19px" padding="right_all:7%25" margin="bottom_small:1.85em"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_fancy_heading][ld_button style="btn-solid" title="Shop Products" shape="circle" size="btn-sm" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" lh="1.35em" color="rgb(35, 38, 27)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" css=".vc_custom_1610714720297{padding-right: 0.65em !important;padding-left: 0.65em !important;}" fw="500"][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1602671540471{margin-top: -75px !important;padding-top: 25px !important;padding-bottom: 25px !important;background-color: #ffd78b !important;}"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288497441-8bf20fef-4083"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670644137-e38675d2-149a"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I feel amazing when I use Hub Cosmetics.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288409283-989c28c2-d697"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288483752{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602671192095-46abc435-ec95"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670963432-11920b84-244e"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670954055-fa8296fb-8b7e"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288526674-65d262fc-eff4"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670975168-2be5953e-7120"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288521994-c8c46d08-1455"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602671209218-19459e63-0fea"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 30 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 30', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-30.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" bg_position="custom" css=".vc_custom_1603434252834{padding-top: 160px !important;padding-bottom: 50px !important;background-image: url(https://shadow.liquid-themes.com/staging/wp-content/uploads/2020/05/bg-1.png?id=29) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50%" bg_pos_v="-145px" responsive_css="padding_top_medium:200px|padding_right_medium:7vw|padding_left_medium:7vw"][vc_column][ld_images_group_element img_size="50%" absolute_pos="yes" image="36" position="top_small:8%25|right_small:5vw" el_class="z-index-3"][/ld_images_group_element][vc_row_inner el_class="z-index-2"][vc_column_inner][ld_fancy_heading transform="text-uppercase" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22UX%20Designer%22%7D%2C%7B%22word%22%3A%22Illustrator%22%7D%2C%7B%22word%22%3A%22Developer%22%7D%5D" use_custom_fonts_title="true" fs="text_large:11vw|text_small:13vw" lh="text_small:0.9em" margin="left_large:2vw|bottom_small:0px"][/ld_fancy_heading][ld_fancy_heading tag="h2" alignment="text-right" transform="text-uppercase" split_type="chars, words" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" gradient="linear-gradient(180deg, rgba(19, 17, 23, 0.65) 0%, rgb(255, 255, 255) 100%)" fs="text_large:11vw|text_small:13vw" lh="text_small:0.9em" margin="bottom_small:0px"]In London[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_small:11vw" lh="text_small:0.9em" margin="bottom_small:0px" el_class="z-index-1" hover_text_outline_color="rgba(255, 255, 255, 0.33)" hover_text_outline_width="1px"]See my works[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Banner 31 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 31', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-31.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="bottom" content_placement="middle" parallax="enable_parallax" bg_position="center center" enable_overlay="yes" css=".vc_custom_1608027163774{padding-bottom: 50px !important;background-image: url(https://shadow.liquid-themes.com/staging/wp-content/uploads/2020/12/bg-image@2x.jpg?id=247) !important;background-position: center;background-repeat: no-repeat;background-size:cover !important;}" overlay_bg="linear-gradient(180deg, rgba(0, 0, 0, 0) 70%, rgb(23, 25, 26) 99.68152866242038%)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1608020287127{margin-bottom: 35px !important;}" responsive_css="margin_bottom_medium:0px" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_start_delay="650"][ld_fancy_heading split_type="chars, words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_all:160px|text_large:120px|text_medium:16vw|text_small:25vw" lh="text_small:0.85em" ls="text_small:-0.05em" margin="bottom_small:0.1em" ca_init_translate_y="0" ca_init_rotate_z="3" ca_init_translate_x="60" ca_init_rotate_x="0" ca_init_rotate_y="12"]Zack[ld_br]Cherry[/ld_fancy_heading][ld_button style="btn-naked" title="Interaction. Design. .Strategy. `{`ld_br`}` Mobile App. Development" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgba(255, 255, 255, 0.9)" i_margin_left="1em"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs" responsive_css="margin_bottom_medium:0px|padding_top_medium:75px|padding_right_medium:15px|padding_left_medium:15px" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_start_delay="650" css=".vc_custom_1612016898745{margin-bottom: 15px !important;}"][vc_separator color="custom" border_width="10" accent_color="#ffffff" css=".vc_custom_1608019633241{margin-bottom: 0px !important;}"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_start_delay="900"][ld_fancy_heading tag="h2" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_all:138px|text_large:100px|text_medium:11vw|text_small:20vw" margin="bottom_large:-0.5em|bottom_small:0px" ls="text_small:-0.05em" hover_text_outline_color="rgb(255, 255, 255)"]About[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 32 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 32', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-32.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" css=".vc_custom_1603704684299{background-color: #ffc1c5 !important;}"][vc_column][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:1em"]Digital Designer based in Los Angeles[/ld_fancy_heading][ld_fancy_heading mask_bg_size="cover" mask_bg_repeat="no-repeat" mask_bg_position="center center" use_custom_fonts_title="true" use_bg_mask="true" fs="text_large:80px|text_medium:8vw|text_small:10vw" lh="text_small:1.1em" ls="text_small:-0.02em" gradient="linear-gradient(111deg, #0bccee 0%, rgb(235, 173, 105) 41.082802547770704%, rgb(194, 80, 80) 79.29936305732484%, #ac1de1 100%)"]Hi, I'm Alix. I work at <i class="fa fa-apple"></i>. I craft original effective brand experiences. My aim is to build your website so that it is functional and user friendly.[/ld_fancy_heading][ld_button style="btn-naked" title="— See my works" link_type="scroll_to_section" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(0, 0, 0)" hover_color="rgba(0, 0, 0, 0.75)" fs="19px" i_icon_linea="lqd-icn-ess icon-md-arrow-down"][ld_particles as_bg="yes" color_type="random_color" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1596101585154-567d0b79-a330" number="12" size="2px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 33 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 33', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-33.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" columns_placement="bottom" equal_height="yes" bg_position="center center" data_tooltip="Hub Data" css=".vc_custom_1614606040346{padding-top: 110px !important;padding-bottom: 40px !important;background: #0a0a0a url(https://businessblocks.liquid-themes.com/staging/wp-content/uploads/2021/03/businessblocksBG@2x.jpg?id=4326) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_right_medium:10vw|padding_bottom_medium:80px|padding_left_medium:10vw|padding_top_small:80px" el_id="home"][vc_column offset="vc_col-lg-7 vc_col-md-9"][ld_fancy_heading tag="h6" transform="text-uppercase" highlight_animation="lqd-highlight-fadein" highlight_height="150%" highlight_offset="-25%" color="rgb(255, 255, 255)" highlight_color="rgb(255, 255, 255)" highlight_roudness="50em" margin="bottom_small:2em"][ld_highlight color="#000"]  Introducing  [/ld_highlight]   Hub data science[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:55px" lh="text_large:1em"]Helping innovators and brands through cultural insight.[/ld_fancy_heading][/vc_column][vc_column][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_right_medium:2vw"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_icon_linea="lqd-icn-ess icon-lqd-atom" title="Innovation" custom_heading_size="19px" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" icon_size="32px"]Hub IT allows your to store, transmit and analyze data.[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_right_medium:2vw"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_icon_linea="lqd-icn-ess icon-lqd-atom" title="Innovation" custom_heading_size="19px" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" icon_size="32px"]Hub IT allows your to store, transmit and analyze data.[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_right_medium:2vw"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_icon_linea="lqd-icn-ess icon-lqd-check" title="Consulting" custom_heading_size="19px" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" icon_size="32px"]Hub IT allows your to store, transmit and analyze data.[/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_right_medium:2vw"][ld_icon_box i_type="linea" heading_size="custom" alignment="text-left" i_icon_linea="lqd-icn-ess icon-lqd-compass" title="Strategy" custom_heading_size="19px" i_color="rgb(255, 255, 255)" h_color="rgb(255, 255, 255)" icon_size="32px"]Hub IT allows your to store, transmit and analyze data.[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 34 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 34', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-34.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" enable_overlay="yes" enable_row_dividers="yes" enable_loading_bg="yes" css=".vc_custom_1615495996267{padding-top: 160px !important;padding-bottom: 100px !important;background-image: url(https://servicepro.liquid-themes.com/wp-content/uploads/2021/03/bannerbg-1-min.jpg?id=8808) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" row_svg_divider="bottom_shape_type:3|bottom_shape_color:%23ffffff|bottom_shape_height:105" overlay_bg="rgba(0, 0, 0, 0.2)" responsive_css="padding_top_medium:140px|padding_top_small:120px"][vc_column enable_content_animation="yes" animation_preset="Fade In" offset="vc_col-lg-7" ca_delay="120" responsive_css="margin_bottom_large:0px" css=".vc_custom_1603368113564{margin-bottom: 60px !important;}"][ld_fancy_heading split_type="words" highlight_type="lqd-highlight-custom-underline" duration="1600" delay="280" easing="expo.inOut" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_medium:110px|text_small:22vw" lh="text_small:1em" ca_init_translate_x="90" margin="bottom_small:0px" highlight_color_brush="rgba(255, 255, 255, 0.76)"]Send money. [ld_highlight]No fees.[/ld_highlight][/ld_fancy_heading][vc_row_inner css=".vc_custom_1595256612980{padding-top: 45px !important;}"][vc_column_inner enable_overlay="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_start_delay="1750" ca_init_translate_y="30"][ld_button style="btn-naked" title="New to Hub? See how it works." link_type="lightbox" i_type="linea" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thicker" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="20px" i_margin_right="28px" i_color="rgb(255, 227, 209)" i_hcolor="rgb(255, 255, 255)" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DHAZiE9NtRfs|||" i_shape_custom_size="70px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_column_shadowbox="yes" offset="vc_col-lg-5 vc_col-md-offset-0" css=".vc_custom_1603368293347{padding-top: 40px !important;padding-right: 25px !important;padding-bottom: 30px !important;padding-left: 25px !important;background-color: #ffffff !important;border-radius: 10px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.24)%22%7D%5D" responsive_css="padding_right_small:50px|padding_left_small:50px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" padding="right_large:14%25" margin="bottom_small:0px" fs="30px"]Transfer money[/ld_fancy_heading][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]Already have an account? Log in.[/ld_fancy_heading][ld_spacer height="12px"][ld_cf7 id="3986" shape="lqd-contact-form-inputs-filled" size="lqd-contact-form-inputs-lg" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" fw="400" submit_fs="16px" submit_fw="700" lqd_bg_color="rgb(236, 241, 245)" color="rgb(0, 0, 0)" css=".vc_custom_1593506218247{margin-bottom: 0px !important;}" submit_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 35 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 35', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-35.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" luminosity="dark" bg_position="center center" enable_loading_bg="yes" css=".vc_custom_1611404061825{border-top-width: 10px !important;border-right-width: 10px !important;border-bottom-width: 10px !important;border-left-width: 10px !important;padding-top: 100px !important;padding-bottom: 40px !important;background-image: url(https://modernbusiness.liquid-themes.com/staging/wp-content/uploads/2020/02/bg-11@2x-min-scaled.jpg?id=27) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-left-color: #ffffff !important;border-left-style: solid !important;border-right-color: #ffffff !important;border-right-style: solid !important;border-top-color: #ffffff !important;border-top-style: solid !important;border-bottom-color: #ffffff !important;border-bottom-style: solid !important;}" responsive_css="border_top_medium:10px|border_right_medium:10px|border_bottom_medium:10px|border_left_medium:10px|padding_top_medium:0px|padding_bottom_medium:0px" data_tooltip="Home"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-1 vc_col-lg-10" ca_duration="1800" ca_start_delay="850" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_spacer height="" sm_height="100px" md_height="200px" lg_height="210px"][ld_fancy_heading split_type="chars, words" highlight_type="lqd-highlight-custom-underline" duration="" delay="50" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="100%" ca_init_origin_y="100%" ca_init_origin_z="100px" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-100px" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" ca_init_translate_y="0" ca_init_translate_z="0" ca_init_rotate_y="0" margin="bottom_small:0px" highlight_color_brush="rgb(255, 255, 255)" ca_init_rotate_x="0" fs="text_large:84px|text_medium:66px|text_small:45px"]We build [ld_highlight]immersive[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="chars, words" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22digital%20products.%22%7D%2C%7B%22word%22%3A%22business%20solutions%22%7D%2C%7B%22word%22%3A%22digital%20startups%22%7D%5D" highlight_type="lqd-highlight-custom-underline" duration="" delay="50" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="100%" ca_init_origin_y="100%" ca_init_origin_z="100px" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-100px" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" ca_init_translate_y="0" ca_init_translate_z="0" ca_init_rotate_y="0" margin="bottom_small:0px" highlight_color_brush="rgb(255, 255, 255)" ca_init_rotate_x="0" fs="text_large:84px|text_medium:66px|text_small:40px" start_delay="600"][/ld_fancy_heading][ld_spacer height="55px"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-lg" i_ripple="btn-icon-ripple" i_add_icon="true" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="25px" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)"][ld_spacer height="" sm_height="70px" md_height="110px" lg_height="110px"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:10px" fw="text_small:700" ls="text_small:0.1em" padding="top_small:5px|right_small:10px|bottom_small:5px|left_small:10px" margin="bottom_small:1.5em"]Trusted Partners[/ld_fancy_heading][/vc_column][vc_column width="1/6" offset="vc_col-md-2 vc_col-xs-4"][vc_single_image image="71" alignment="center"][/vc_column][vc_column width="1/6" offset="vc_col-md-2 vc_col-xs-4"][vc_single_image image="4195" alignment="center"][/vc_column][vc_column width="1/6" offset="vc_col-md-2 vc_col-xs-4"][vc_single_image image="4193" alignment="center"][/vc_column][vc_column width="1/6" offset="vc_col-md-2 vc_col-xs-4"][vc_single_image image="4199" alignment="center"][/vc_column][vc_column width="1/6" offset="vc_col-md-2 vc_col-xs-4"][vc_single_image image="4194" alignment="center"][/vc_column][vc_column width="1/6" offset="vc_col-md-2 vc_col-xs-4"][vc_single_image image="4197" alignment="center"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 36 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 36', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-36.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" equal_height="yes" content_placement="middle" bg_position="right top" css=".vc_custom_1602588719073{padding-top: 150px !important;padding-bottom: 20px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:50px|padding_bottom_medium:0px"][vc_column][ld_images_group_container enable_item_animation="yes" move_to_parent_row="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" absolute_pos="yes" position="top_large:-2%25|top_medium:-12%25|top_small:0px|right_small:-5%25" pf_duration="1800" pf_init_translate_x="55" pf_init_translate_y="-45"][ld_images_group_element img_size="50%" image="173"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1600" ca_delay="160" ca_init_translate_y="45"][ld_fancy_heading tag="p" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(0, 0, 0)" margin="bottom_small:1.85em" padding="top_small:0.3em|right_small:1em|bottom_small:0.3em|left_small:1em" fh_bg="rgb(245, 245, 245)" fs="text_small:14px"]On sale for a limited time[/ld_fancy_heading][ld_fancy_heading highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="5px" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" fs="text_large:65px|text_medium:11vw|text_small:13vw" lh="text_small:1.1em" compressor="0.7" minfontsize="60" margin="bottom_small:0.2em" ca_init_translate_y="0" highlight_color="rgba(98, 73, 201, 0.21)"]Plan your next trip on [ld_highlight]budget[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:20px" lh="text_small:30px" margin="bottom_small:1.35em" padding="right_large:18%25" ca_init_translate_y="0"]No coding required to make customizations. The live customizer has everything you need.[/ld_fancy_heading][vc_row_inner content_placement="middle"][vc_column_inner offset="vc_col-md-5"][ld_button style="btn-solid" title="App store `{`ld_span`}`Get it for free`{`/ld_span`}`" transformation="text-uppercase" shape="round" size="btn-lg" border="border-none" i_type="fontawesome" i_separator="btn-icon-sep" enable_row_shadowbox="yes" i_add_icon="true" css=".vc_custom_1602587253742{margin-bottom: 30px !important;}" hover_color="rgb(239, 75, 121)" i_icon_fontawesome="fab fa-apple" color="rgb(255, 255, 255)" text_color="rgb(21, 86, 108)" htext_color="rgb(255, 255, 255)" i_size="22px" fs="12px" lh="1.8em" fw="700" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(73%2C76%2C137%2C0.12)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" ls="0.05em" hover_color2="rgb(198, 123, 255)"][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-6"][vc_single_image image="38" css=".vc_custom_1599036499811{margin-bottom: 30px !important;padding-left: 10px !important;}"][/vc_column_inner][vc_column_inner][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.65)" fs="15px"]Available for all platforms.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-right" offset="vc_col-md-6" ca_duration="1800" ca_start_delay="1100" ca_init_translate_x="100" ca_init_rotate_z="7" responsive_align="text-right"][ld_images_group_element enable_float_effect="yes" image="231" margin="right_large:-45%25|left_large:-15%25"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 37 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 37', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-37.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" css=".vc_custom_1602676934910{background-color: #f9fbfe !important;}"][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_particles as_bg="yes" opacity="1" enable_random_size="yes" modes_grab_opacity="1" particle_id="lqd-1602677587125-1b0404bc-e681" number="3" color="#fda44c" size="6"][/vc_column][vc_column offset="vc_col-md-5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1602677924943{margin-bottom: 35px !important;}"][ld_images_group_element image="22" margin="bottom_small:15px"][/ld_images_group_element][ld_fancy_heading use_custom_fonts_title="true" fs="text_medium:64px|text_small:48px" lh="text_small:1em" margin="bottom_small:0.1em"]Share your ride at <img class="alignnone size-full wp-image-24" style="height: 0.525em; vertical-align: baseline;" src="https://mobilemodernpro.liquid-themes.com/wp-content/uploads/2020/10/Mask-Group-2.svg" alt="zero" /> cost.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(49, 63, 88)" fs="text_small:18px" lh="text_small:1.35em" margin="bottom_small:2em"]Earn money leading people on activities you love. designed and led by locals.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.6)" fs="text_small:15px" margin="bottom_small:0.8em"]<img class="alignnone size-full wp-image-25" src="https://mobilemodernpro.liquid-themes.com/wp-content/uploads/2020/10/btn@2x.png" alt="" width="149" height="50" />    Latest version 3.7[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.5)" fs="text_small:13px"]<a href="https://mobilemodernpro.liquid-themes.com/wp-content/uploads/2020/10/stars.svg"><img class="alignnone size-full wp-image-26" src="https://mobilemodernpro.liquid-themes.com/wp-content/uploads/2020/10/stars.svg" alt="" /></a>   3.98 Best Rated App Based on Reviews[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-7" responsive_css="padding_left_large:5%25|margin_right_medium:-25%25"][ld_images_group_element absolute_pos="yes" image="31" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px"][/ld_images_group_element][ld_masked_image image="27"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 38 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 38', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-38.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" bg_position="right top" css=".vc_custom_1609871210232{padding-top: 38vh !important;padding-bottom: 38vh !important;background-color: #ffda01 !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1603353492576{padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}" responsive_css="padding_right_medium:0px|padding_left_medium:0px"][vc_column offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1611568479247{margin-top: -60vh !important;}"][ld_asymmetric_slider show_button="yes" ib_style="btn-solid" ib_title="See latest projects" ib_size="btn-lg" ib_i_type="linea" ib_i_hover_reveal="btn-hover-swp" ib_i_separator="btn-icon-sep" ib_i_add_icon="true" identities="%5B%7B%22title%22%3A%22Building%20villas%22%2C%22subtitle%22%3A%22Villa%22%2C%22description%22%3A%2201.%20Private%20properties%20%3Cbr%3E%20in%20Rome%2C%20Italy.%22%2C%22image%22%3A%224255%22%2C%22btn_label%22%3A%22See%20latest%20projects%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22title%22%3A%22Interior%20Design%22%2C%22subtitle%22%3A%22Architecture%22%2C%22description%22%3A%2202.%20Private%20properties%20%3Cbr%3E%20in%20Lazio%2C%20Italy.%22%2C%22image%22%3A%224306%22%2C%22btn_label%22%3A%22See%20latest%20projects%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22title%22%3A%22Urban%20City%22%2C%22subtitle%22%3A%22Urban%20City%22%2C%22description%22%3A%2201.%20Private%20properties%20%3Cbr%3E%20in%20Nice%2C%20France.%22%2C%22image%22%3A%224582%22%2C%22btn_label%22%3A%22See%20latest%20projects%22%2C%22url%22%3A%22%23%22%7D%5D" stroke_width="2px" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_text_color="rgb(255, 255, 255)" ib_fs="16px" ib_i_separator_color="rgba(0, 0, 0, 0.1)" ib_htext_color="rgb(255, 255, 255)" ib_color="rgb(31, 31, 31)" ib_hover_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 39 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 39', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-39.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" luminosity="dark" responsive_css="margin_right_large:16%25|margin_right_medium:8%25|margin_bottom_medium:80px"][vc_column][ld_slideshow_2 height="700px" overlay_bg="rgba(0, 0, 0, 0.3)"][ld_slideshow_section title="Interior Design" image="4306"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:81px|text_small:40px" lh="text_small:1.15em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][ld_slideshow_section title="Construction" image="4263"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:81px|text_small:40px" lh="text_small:0.96em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][ld_slideshow_section title="Residential" image="4445"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:80px|text_small:40px" lh="text_small:0.96em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][ld_slideshow_section title="City planning" image="4260"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:80px|text_small:40px" lh="text_small:0.96em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][/ld_slideshow_2][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 40 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 40', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-40.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" bg_position="right top" css=".vc_custom_1612078152307{padding-top: 130px !important;padding-bottom: 90px !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_large:130px|padding_right_medium:6vw|padding_left_medium:6vw|padding_top_small:90px"][vc_column][ld_particles as_bg="yes" enable_density="yes" opacity="1" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1574947035246-eebb4f98-33c1" number="17" size="4" move_speed="1" color="#d8d8d8" density="170"][/vc_column][vc_column width="7/12" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1000" ca_init_translate_x="-25" ca_init_translate_y="70" responsive_css="padding_right_large:6vw"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" padding="top_small:15px|right_small:22px|bottom_small:15px|left_small:22px" fh_bg="rgba(16, 114, 250, 0.09)" margin="bottom_small:2em" fs="text_small:11px" color="rgb(16, 114, 250)"]50% Off for your first purchase[/ld_fancy_heading][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_all:47px|text_medium:40px|text_small:9vw" lh="text_small:1.15em"]Browse the internet securely. No Proxy needed.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:31px" margin="bottom_small:1.75em" padding="right_large:12%25"]Forget about design limits! Build and customize your site visually. It’s fun, fast and super-easy![/ld_fancy_heading][ld_newsletter style="bordered" inputs_size="ld-sf--size-lg" inputs_radius="ld-sf--round" btn_style="solid" btn_label="GET STARTED" btn_position="ld-sf--button-inline" btn_padding="7px" use_custom_fonts_input="true" use_custom_fonts_label="true" placeholder_text="Enter your email address" fs="14px" label_fs="13px" label_ls="0.065em" margin="bottom_small:20px" brd_color="rgb(219, 219, 219)" brd_f_color="rgb(54, 54, 54)" btn_txt_color="rgb(255, 255, 255)" hover_btn_txt_color="rgb(255, 255, 255)" label_fw="700" txt_color="rgb(87, 87, 87)"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(167, 167, 167)" fs="12px"]Try for free. No credit card required.[/ld_fancy_heading][/vc_column][vc_column width="5/12" column_top_onmobile="yes" offset="vc_col-md-6" responsive_css="margin_bottom_small:0px" css=".vc_custom_1607343177591{margin-bottom: 30px !important;}"][ld_images_group_element img_size="50%" image="116" margin="right_large:0px|right_medium:-50%25"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 41 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 41', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-41.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes"][vc_column][ld_carousel_tab columns="xs:1|spacing_xs:0px" inactiv_opacity="1" cellalign="center" prevnextbuttons="yes" wraparound="yes" navarrow="6" navappend="parent_row" navsize="carousel-nav-xl" navfill="carousel-nav-solid" navshape="carousel-nav-square" navshadow="carousel-nav-shadowed-onhover" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" nav_arrow_color="rgb(0, 0, 0)" nav_bg_color="rgb(255, 255, 255)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1611317854415-f0a8c8d2-a3d0"][vc_row_inner content_placement="middle" css=".vc_custom_1614076909624{background-image: url(https://fashionstorepro.liquid-themes.com/wp-content/uploads/2020/10/fashionstore@2x.jpg?id=4562) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="h-vh-100" responsive_css="padding_right_medium:5vw|padding_left_medium:5vw"][vc_column_inner width="1/2" css=".vc_custom_1611318102646{padding-right: 5vw !important;padding-left: 5vw !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:78px|text_medium:48px|text_small:15vw" lh="text_small:1em" margin="bottom_small:0.35em" fw="text_small:900"]Hub SS-21 Editorial.[/ld_fancy_heading][ld_button style="btn-naked" title="Shop Women" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" fs="text_small:12px" ls="text_small:0.1em" hover_color="rgb(255, 255, 255)" link="url:https%3A%2F%2Ffashionstorepro.liquid-themes.com%2Fproduct-category%2Fparty-collection%2F|||"][/vc_column_inner][vc_column_inner enable_link="enable_column_link" width="1/2" css=".vc_custom_1614065254631{padding-right: 5vw !important;padding-left: 5vw !important;}" link="url:%23|||"][ld_button style="btn-naked" title="Knit Sweater `{`ld_span`}`£39.90`{`/ld_span`}`" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" css=".vc_custom_1591010928148{border-left-width: 2px !important;padding-left: 18px !important;border-left-color: #ffffff !important;border-left-style: solid !important;}" color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(255, 255, 255)"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1611318332923-0548805a-f76d"][vc_row_inner content_placement="middle" bg_position="center bottom" css=".vc_custom_1614076665745{background-image: url(https://fashionstorepro.liquid-themes.com/wp-content/uploads/2021/02/fashionstore3@2x.jpg?id=4777) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_class="h-vh-100" responsive_css="padding_right_medium:5vw|padding_left_medium:5vw"][vc_column_inner width="1/2" css=".vc_custom_1611318102646{padding-right: 5vw !important;padding-left: 5vw !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:78px|text_medium:48px|text_small:15vw" lh="text_small:1em" margin="bottom_small:0.35em" fw="text_small:900"]#stayhome essentials.[/ld_fancy_heading][ld_button style="btn-naked" title="Shop Women" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 255, 255)" fs="12px" ls="0.1em" hover_color="rgb(255, 255, 255)"][/vc_column_inner][vc_column_inner enable_link="enable_column_link" width="1/2" css=".vc_custom_1614065240562{padding-right: 5vw !important;padding-left: 5vw !important;}" link="url:%23|||"][ld_button style="btn-naked" title="Blue Hoodie `{`ld_span`}`£19.90`{`/ld_span`}`" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" css=".vc_custom_1614064371866{border-left-width: 2px !important;padding-left: 18px !important;border-left-color: #ffffff !important;border-left-style: solid !important;}" color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(255, 255, 255)"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 42 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 42', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-42.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" equal_height="yes" content_placement="middle" responsive_css="padding_right_large:5vw|padding_left_large:5vw|padding_right_medium:30px|padding_bottom_medium:60px|padding_left_medium:30px" css=".vc_custom_1605399378146{padding-top: 125px !important;padding-bottom: 60px !important;}"][vc_column width="7/12" offset="vc_col-lg-5 vc_col-md-6" responsive_css="padding_right_medium:3vw"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" absolute_pos="yes" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" pf_duration="1800" pf_delay="180" pf_init_translate_y="0"][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="50" position="top_small:80px|left_small:5%25" translate_from_y="90" translate_to_y="-130" rotate_from_z="25" rotate_to_z="-25"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="51" position="right_small:3%25|bottom_small:-20%25" translate_from_y="15" translate_to_y="-130" translate_from_x="10" translate_to_x="120"][/ld_images_group_element][/ld_images_group_container][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:15px" ls="text_small:0.1em" margin="bottom_small:1em|left_small:10px" color="rgb(0, 0, 0)"]Global Experience[/ld_fancy_heading][ld_fancy_heading highlight_type="lqd-highlight-custom-underline" highlight_height="0.325em" highlight_offset="-0.05em" use_custom_fonts_title="true" enable_fit="true" minfontsize="50" fs="text_large:clamp(47px%2C%203.5vw%2C%2060px)|text_medium:6vw|text_small:10vw" lh="text_small:1.1em" margin="right_all:0px|right_large:-12%25|bottom_small:0.6em"][ld_highlight]Immersive[/ld_highlight] digital experience.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:21px|text_medium:18px|text_small:17px" lh="text_small:1.61em" color="rgb(29, 41, 63)" margin="bottom_large:1.15em|bottom_medium:0.75em|bottom_small:1.15em"]We merge imagination and technology to help thousands of brands grow in an age of digital transformation.[/ld_fancy_heading][vc_row_inner content_placement="middle" gap="0" css=".vc_custom_1618491590503{margin-top: 30px !important;}"][vc_column_inner offset="vc_col-lg-6"][ld_button style="btn-solid" title="See how we work" transformation="text-uppercase" shape="circle" enable_row_shadowbox="yes" fs="14px" lh="1.75em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C207%2C50%2C0.2)%22%7D%5D" hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2225px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(10%2C0%2C0%2C0.16)%22%7D%5D" hover_color="rgb(27, 27, 27)" css=".vc_custom_1602667824194{margin-bottom: 30px !important;padding-right: 1em !important;padding-left: 1em !important;}"][/vc_column_inner][/vc_row_inner][ld_spacer height="20px" sm_height="30px" md_height="90px"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_medium:45px|bottom_small:30px" fs="text_small:15px" ls="text_small:0.1em" color="rgb(0, 0, 0)"]Trusted by[/ld_fancy_heading][ld_carousel_tab columns="xs:3|spacing_sm:6%25|spacing_xs:15px" inactiv_opacity="1" groupcells="no" wraparound="yes" equalheightcells="yes" middlealigncontent="yes" autoplay="yes"][ld_carousel_section title="Tab" tab_id="lqd-1595668354598-ceef2cee-b183"][vc_single_image image="23" css=".vc_custom_1579169149743{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668354789-68171aa6-413b"][vc_single_image image="21" css=".vc_custom_1579169160676{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668354978-a9095e5d-30de"][vc_single_image image="22" css=".vc_custom_1579169168550{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668433282-eca54d7d-4496"][vc_single_image image="21" css=".vc_custom_1579169160676{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column width="5/12" column_top_onmobile="yes" align="text-right" offset="vc_col-lg-offset-1 vc_col-md-6" responsive_align="text-right" responsive_css="margin_bottom_small:0px" css=".vc_custom_1607345108348{margin-bottom: 30px !important;}"][ld_images_group_container margin="right_large:0px|right_medium:-20%25"][ld_images_group_element img_size="50%" image="170"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_particles as_bg="yes" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-579174300002-14637266-1f34" number="2" color="#32a703" size="3"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 43 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 43', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-43.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle"][vc_column align="text-center" responsive_align="text-center"][ld_d_depth_banner height="100vh" target=".ld-container" image="119" second_image="118" vth="40" hth="70"][ld_fancy_heading split_type="chars, words" duration="2000" delay="45" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(242, 240, 226)" fs="text_large:8vw|text_small:17vw" fw="text_small:700" margin="bottom_small:0px" ls="text_small:-0.015em" lh="text_small:0.9em" ca_init_translate_x="20"]Just another creative Designer in London[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 44 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 44', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-44.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="stretch" equal_height="yes" content_placement="middle" bg_position="center top" css=".vc_custom_1603443617279{background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_large:6vh"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="right top" css=".vc_custom_1603443442209{padding-top: 150px !important;background-image: url(https://sidefoliopro.liquid-themes.com/wp-content/uploads/2020/08/memphis.svg?id=4437) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" offset="vc_col-lg-5 vc_col-md-6" ca_delay="180" el_class="z-index-2" ca_duration="1600" responsive_css="padding_bottom_medium:150px"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="17px" margin="bottom_small:1.75em"]Hi, I’m Daniel Mcbride.[/ld_fancy_heading][ld_fancy_heading duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_all:6.5vw|text_large:10vw|text_medium:15vw|text_small:17vw" lh="text_small:0.9em" fw="text_small:700" margin="bottom_small:0.2em|left_small:-0.07em" ls="text_small:-0.05em"].freelancer .stratégie .concept .grafik .design[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-lg-7 vc_col-md-6" css=".vc_custom_1603443825768{background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="margin_top_medium:0px|margin_left_medium:0px|margin_top_small:-40vh|margin_left_small:35vw"][ld_particles as_bg="yes" enable_density="yes" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="ld-1579696659771-5fc42be0-c0f3" number="10" density="200" size="3" height="100vh" color="#232323"][ld_images_group_element img_size="50%" enable_hover3d="yes" enable_roudness="yes" image_roudness="6" image="4686"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 45 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 45', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-45.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="middle" bg_position="custom" bg_attachment="fixed" css=".vc_custom_1621616572533{background-image: url(https://insurance.liquid-themes.com/wp-content/uploads/2020/10/bnnr-img@2x.jpg?id=18) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bg_pos_h="60%" bg_pos_v="50%"][vc_column offset="vc_col-lg-6 vc_col-md-8" responsive_css="padding_top_medium:150px"][ld_fancy_heading use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:70px|text_medium:80px" margin="bottom_small:0.3em"]Private medical insurance plans.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:20px" lh="text_small:1.4em"]Holistic development and support for employees the aim of being a first-choice employer within our sectors.[/ld_fancy_heading][vc_row_inner content_placement="middle" css=".vc_custom_1621518999565{padding-top: 35px !important;}"][vc_column_inner width="1/3" offset="vc_col-md-5"][ld_button style="btn-solid" title="Request a Quote" link_type="scroll_to_section" shape="circle" border="border-none" color="rgb(255, 255, 255)" hover_color="rgb(15, 90, 100)" text_color="rgb(15, 90, 100)" htext_color="rgb(255, 255, 255)" lh="text_small:1.25em" css=".vc_custom_1621617177690{margin-bottom: 15px !important;}"][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:16px" margin="bottom_small:15px"]<strong>0123 267 8901</strong>[ld_br]<span style="font-size: 14px;">Free Consultation</span>[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row content_placement="middle" css=".vc_custom_1621519714114{border-bottom-width: 1px !important;padding-top: 15px !important;padding-bottom: 15px !important;border-bottom-color: #e5e5e5 !important;border-bottom-style: solid !important;}"][vc_column width="1/2" css=".vc_custom_1621616870150{margin-bottom: 15px !important;}" responsive_align="text-center text-sm-left" responsive_css="margin_bottom_medium:0px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(50, 54, 67)" fs="text_small:14px" margin="bottom_small:0px"]<img class="alignnone size-full wp-image-3472" src="https://insurance.liquid-themes.com/wp-content/uploads/2021/05/img@2x.png" alt="Ageny" width="47" height="47" />  Looking for an agent? <a href="#">Talk to our finance agent</a>[/ld_fancy_heading][/vc_column][vc_column width="1/2" responsive_align="text-center text-sm-right"][ld_button style="btn-naked" title="Our design services starts and ends with a best-in-class." i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgb(115, 116, 127)" fs="text_small:15px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 46 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 46', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-46.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" equal_height="yes"][vc_column bg_position="left center" offset="vc_col-md-8 vc_hidden-sm vc_hidden-xs"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" equalheightcells="yes" navarrow="6" navsize="carousel-nav-xl" navfill="carousel-nav-solid" navshape="carousel-nav-circle" navshadow="carousel-nav-shadowed-onhover" navfloated="carousel-nav-floated" navvalign="carousel-nav-bottom" mobile_dots_position="carousel-dots-mobile-inside" mobile_align_dots="carousel-dots-mobile-left" nav_arrow_color="rgb(0, 0, 0)" nav_arrow_color_hover="rgb(255, 255, 255)" nav_bg_color="rgb(226, 229, 237)" nav_bg_hcolor="rgb(0, 0, 0)" navoffset="bottom: 5vmin, left: 75px"][ld_carousel_section title="Tab" tab_id="lqd-1601018635800-01c6a68e-2755"][vc_row_inner bg_position="right top" css=".vc_custom_1601017881351{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 25vh !important;padding-left: 15px !important;background-image: url(https://marketplacepro.liquid-themes.com/wp-content/uploads/2020/06/market-carousel-1@2x.jpg?id=257) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:60px|padding_right_medium:60px|padding_bottom_medium:52.5vh|padding_left_medium:60px"][vc_column_inner][ld_fancy_heading]Samsung
Galaxy Z Flip[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Subscribe and get 20% off your first purchase.[/ld_fancy_heading][ld_button style="btn-solid" title="Starting From £699" shape="round" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 194, 33)" text_color="rgb(4, 30, 66)" lh="text_small:1.15em" css=".vc_custom_1618676258114{padding-right: 1em !important;padding-left: 1em !important;}" link="url:https%3A%2F%2Fmarketplacepro.liquid-themes.com%2Fproduct-category%2Fcomputers%2Fhome-theather%2F|||"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1601018636769-5de63bf6-d606"][vc_row_inner bg_position="right top" css=".vc_custom_1601017893679{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 25vh !important;padding-left: 15px !important;background-image: url(https://marketplacepro.liquid-themes.com/wp-content/uploads/2020/09/macbook@2x.jpg?id=337) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:60px|padding_right_medium:60px|padding_bottom_medium:52.5vh|padding_left_medium:60px"][vc_column_inner][ld_fancy_heading]13-inch MacBook Air Touch ID[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Subscribe and get 20% off your first purchase.[/ld_fancy_heading][ld_button style="btn-solid" title="Starting From £699" shape="round" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 194, 33)" text_color="rgb(4, 30, 66)" lh="text_small:1.15em" css=".vc_custom_1618676266205{padding-right: 1em !important;padding-left: 1em !important;}" link="url:https%3A%2F%2Fmarketplacepro.liquid-themes.com%2Fproduct-category%2Fcomputers%2Fhome-theather%2F|||"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1601018637759-e8157fc6-7bb1"][vc_row_inner bg_position="right top" css=".vc_custom_1601017908263{padding-top: 110px !important;padding-right: 15px !important;padding-bottom: 25vh !important;padding-left: 15px !important;background-image: url(https://marketplacepro.liquid-themes.com/wp-content/uploads/2020/09/macbook@2x.jpg?id=337) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:60px|padding_right_medium:60px|padding_bottom_medium:52.5vh|padding_left_medium:60px"][vc_column_inner][ld_fancy_heading]Samsung
Galaxy Z Flip[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Subscribe and get 20% off your first purchase.[/ld_fancy_heading][ld_button style="btn-solid" title="Starting From £699" shape="round" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(255, 194, 33)" text_color="rgb(4, 30, 66)" lh="1.15em" css=".vc_custom_1599563765727{padding-right: 1em !important;padding-left: 1em !important;}"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column offset="vc_col-md-4"][vc_row_inner equal_height="yes" content_placement="bottom" gap="0"][vc_column_inner row_scale_bg_onhover="yes" enable_link="enable_column_link" width="1/2" enable_overlay="yes" bg_position="left center" link="url:%23|||" css=".vc_custom_1611238611716{padding-top: 10vh !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;background-image: url(https://marketplacepro.liquid-themes.com/wp-content/uploads/2020/05/bg-2@2x.jpg?id=127) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" hover_overlay_bg="rgba(0, 0, 0, 0.1)" offset="vc_col-md-12 vc_col-xs-6" responsive_css="padding_top_small:28.725vh|padding_right_small:35px|padding_left_small:35px"][ld_fancy_heading tag="h2" margin="bottom_small:0px" color="rgb(255, 255, 255)"]AirPods Pro 3[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" margin="bottom_small:0px" fs="text_small:28px" lh="text_small:1em" ls="text_small:-0.01em"]On sale[/ld_fancy_heading][/vc_column_inner][vc_column_inner row_scale_bg_onhover="yes" enable_link="enable_column_link" width="1/2" enable_overlay="yes" bg_position="left center" css=".vc_custom_1611238616182{padding-top: 10vh !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;background-image: url(https://marketplacepro.liquid-themes.com/wp-content/uploads/2020/05/bg-3@2x.jpg?id=126) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" link="url:%23|||" hover_overlay_bg="rgba(0, 0, 0, 0.1)" offset="vc_col-md-12 vc_col-xs-6" responsive_css="padding_top_small:28.725vh|padding_right_small:35px|padding_left_small:35px"][ld_fancy_heading tag="h2" margin="bottom_small:0px"]PS5 Virtual
Reality[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 47 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 47', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-47.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="middle" bg_position="custom" enable_overlay="yes" css=".vc_custom_1622118022498{background-image: url(http://multipurpose.liquid-themes.com/wp-content/uploads/2021/05/mp-banner@2x.jpg?id=165) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="linear-gradient(65deg, rgb(35, 42, 59) 0%, rgba(35, 42, 59, 0) 100%)" bg_pos_h="80%" bg_pos_v="50%"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10" responsive_align="text-center" ca_duration="1600" ca_delay="160" ca_init_translate_y="70"][ld_fancy_heading transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_medium:74px|text_small:14vw" lh="text_small:1.125em" ls="text_small:-0.005em" margin="bottom_small:0.35em"]Business In the Digital Age.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.8)" fs="text_medium:21px|text_small:19px" lh="text_small:1.38em" padding="right_all:12%25|left_all:12%25" margin="bottom_small:2em"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives careful[/ld_fancy_heading][ld_button style="btn-solid" title="See Case Studies" link_type="scroll_to_section" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-switch-change btn-hover-txt-switch btn-hover-txt-switch-y" title_secondary="Explore Portfolio" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_size="18px" i_shape_custom_size="41px" i_margin_left="11px" color="rgb(255, 255, 255)" i_color="rgb(15, 64, 100)" i_fill_color="rgba(15, 64, 100, 0.12)" text_color="rgb(0, 0, 0)" fs="text_small:18px" i_hcolor="rgb(255, 255, 255)" i_fill_hcolor="rgba(255, 255, 255, 0.15)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 48 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 48', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-48.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="middle" parallax="enable_parallax" enable_overlay="yes" css=".vc_custom_1622025734482{background-image: url(https://staging.liquid-themes.com/lawyer/wp-content/uploads/2021/05/bg-1@2x.jpg?id=24) !important;background-position: center;background-repeat: no-repeat;background-size:cover;}" overlay_bg="linear-gradient(56deg, rgb(11, 16, 44) 7%, rgba(11, 16, 44, 0) 88.21656050955414%)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10" responsive_align="text-center" ca_duration="1600" ca_delay="160" ca_init_translate_y="65" ca_init_rotate_y="50" responsive_css="padding_top_medium:90px"][ld_fancy_heading use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:80px|text_small:15vw" lh="text_small:1em" margin="bottom_small:0.35em"]Citizenship[ld_br]and immigration.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.85)" fs="text_small:18px" lh="text_small:1.33em" padding="right_all:15%25|left_all:15%25|right_large:0px|left_large:0px|right_medium:12%25|left_medium:12%25" margin="bottom_small:1.75em"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives careful[/ld_fancy_heading][ld_button style="btn-solid" title="Schedule Consultation" link_type="scroll_to_section" size="btn-xlg" border="border-none" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" color="rgb(255, 255, 255)" text_color="rgba(0, 0, 0, 0.85)" css=".vc_custom_1622201211149{padding-top: 0.5em !important;padding-right: 0.5em !important;padding-bottom: 0.5em !important;padding-left: 0.5em !important;}" ls="text_small:0.28em"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:15px" fw="text_small:500" margin="top_small:1.15em"]Or call us at 0123 567 8901[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 49 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 49', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-49.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" columns_placement="middle" content_placement="middle" bg_position="custom" enable_overlay="yes" enable_row_dividers="yes" css=".vc_custom_1621940353482{background-image: url(https://staging.liquid-themes.com/kids/wp-content/uploads/2021/05/bg-1@2x.jpg?id=32) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bg_pos_h="60%" bg_pos_v="50%" overlay_bg="linear-gradient(38deg, rgb(66,186,177) 0%, rgba(95,54,234,0.22) 21.337579617834397%, rgba(95,54,234,0) 44.90445859872611%)" row_svg_divider="bottom_shape_type:7|bottom_shape_color:%23ffffff|bottom_shape_height:16"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="120%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-80px" ca_an_opacity="1" offset="vc_col-lg-7 vc_col-md-8" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1621955825986{margin-bottom: 30px !important;}" ca_duration="1600" ca_delay="160" ca_init_translate_y="100" ca_init_rotate_y="-54" ca_init_rotate_z="12"][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22creativity.%22%7D%2C%7B%22word%22%3A%22personality.%22%7D%2C%7B%22word%22%3A%22education.%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:66px" lh="text_small:1em" margin="bottom_small:0.35em"]Helping kids unleash their[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:21px" lh="text_small:1.38em" margin="bottom_small:1.25em" padding="right_all:15%25"]Join us in the 100 campaign, a year-long journey to bring 100 children home to 100 families.[/ld_fancy_heading][ld_button style="btn-solid" title="Join the Program" link_type="scroll_to_section" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-switch-change btn-hover-txt-switch btn-hover-txt-switch-y" title_secondary="See the terms" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_shape_custom_size="33px" i_margin_left="10px" color="rgb(255, 255, 255)" i_color="rgb(45, 65, 98)" i_fill_color="rgba(45, 65, 98, 0.05)" text_color="rgb(45, 65, 98)" i_fill_hcolor="rgba(255, 255, 255, 0.2)" i_hcolor="rgb(255, 255, 255)"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1.15" ca_init_scale_y="1.15" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-4" responsive_align="text-md-center" ca_duration="1600" ca_delay="160" ca_start_delay="450" ca_init_translate_y="29"][ld_button style="btn-naked" title="Play Video" link_type="lightbox" hover_txt_effect="btn-hover-txt-liquid-y" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWaSvMAl4zPw||target:%20_blank|" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="85px" i_margin_bottom="15px" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 50 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 50', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-50.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" css=".vc_custom_1611767767518{padding-top: 60px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:35px"][vc_column][ld_particles as_bg="yes" color_type="multi_color" shape_type="circle,edge,triangle,polygon" opacity="1" enable_random_opacity="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1611230331606-91ba8f6f-a5f8" number="5" multi_color_values="%5B%7B%22scolor%22%3A%22%23fdc14c%22%7D%2C%7B%22scolor%22%3A%22%23fd5c4c%22%7D%2C%7B%22scolor%22%3A%22%2348bb0f%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%5D" size="5"][ld_images_group_container parallax="yes" move_to_parent_row="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" position="top_small:20%25|left_small:0px" translate_from_y="114" translate_to_y="-122"][ld_images_group_element img_size="50%" image="889"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_init_rotate_y="25" ca_init_rotate_x="10" responsive_align="text-center" responsive_css="padding_right_large:15%25|padding_left_large:15%25|padding_right_medium:10%25|padding_left_medium:10%25"][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:69px|text_small:12vw" fw="text_small:600" ls="text_small:-0.02em" lh="text_small:1em" margin="bottom_small:0.35em"]Track your daily work <span class="gradient-word">activity</span>[/ld_fancy_heading][ld_fancy_heading tag="p" duration="" delay="" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_medium:18px|text_small:16px" lh="text_small:30px" color="rgb(64, 64, 70)"]No more complex codes or boring designs. Creating an attractive and functional site has never been easier.[/ld_fancy_heading][ld_spacer height="20px"][ld_button style="btn-solid" title="Sign up free" link_type="scroll_to_section" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="17px" lh="1.5em" css=".vc_custom_1614348590399{margin-right: 10px !important;margin-bottom: 10px !important;margin-left: 10px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(0, 0, 0)"][ld_button style="btn-default" title="Watch Demo" link_type="lightbox" shape="circle" border="border-thick" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" fs="17px" lh="1.5em" css=".vc_custom_1614348229733{margin-right: 10px !important;margin-bottom: 10px !important;margin-left: 10px !important;padding-right: 0.5em !important;padding-left: 0.5em !important;}" hover_color="rgb(0, 0, 0)" color="rgb(237, 237, 237)" text_color="rgb(0, 0, 0)" i_color="rgb(66, 91, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-lg-8 vc_col-md-offset-1 vc_col-md-10 vc_col-xs-12" css=".vc_custom_1611341441659{padding-top: 35px !important;padding-bottom: 15px !important;}" responsive_css="padding_top_small:50px" responsive_align="text-center"][vc_row_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1800" ca_start_delay="850" ca_delay="180" ca_init_translate_y="35"][vc_column_inner width="1/3" responsive_align="text-center"][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-inline" items_alignment="align-items-center" title="Huge Template Library" title_mb="1" custom_heading_size="14px" link="url:%23|||" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" i_color="rgb(0, 108, 227)" shape_color="rgb(246, 245, 255)" icon_size="16px" custom_i_size="30px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/3" responsive_align="text-center"][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-inline" items_alignment="align-items-center" title="Live Customizer" title_mb="1" custom_heading_size="14px" link="url:%23|||" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" i_color="rgb(0, 108, 227)" shape_color="rgb(246, 245, 255)" icon_size="14px" custom_i_size="30px"][/ld_icon_box][/vc_column_inner][vc_column_inner width="1/3" responsive_align="text-center"][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-inline" items_alignment="align-items-center" title="On Demand Live Support" title_mb="1" custom_heading_size="14px" link="url:%23|||" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" i_color="rgb(0, 108, 227)" shape_color="rgb(246, 245, 255)" icon_size="14px" custom_i_size="30px"][/ld_icon_box][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" offset="vc_col-lg-offset-1 vc_col-lg-10" responsive_align="text-center"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="0.85" pf_init_scale_y="0.85" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1800" pf_delay="180" pf_init_rotate_y="0" pf_init_translate_y="80" pf_start_delay="1450" pf_init_rotate_x="0"][ld_images_group_element absolute_pos="yes" image="928" position="right_small:-100px|bottom_small:-230px|left_small:-100px"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_roudness="yes" image_roudness="8" image="934"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_roudness="yes" image_roudness="8" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="931" position="top_small:10%25|left_small:-5%25" translate_from_y="-11" rotate_from_z="-1" translate_to_y="185" rotate_to_z="15"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_roudness="yes" image_roudness="8" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="932" position="top_small:70%25|right_small:-5%25" translate_from_y="99" rotate_from_z="-1" translate_to_y="-165" rotate_to_z="15"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 51 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 51', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-51.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" equal_height="yes" content_placement="middle" bg_position="custom" css=".vc_custom_1613498682007{padding-top: 120px !important;padding-bottom: 80px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50vw" bg_pos_v="120%" responsive_css="padding_top_medium:80px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" ca_start_delay="700" ca_delay="170" ca_duration="1800" ca_init_translate_y="64" ca_init_rotate_y="64"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:12px" margin="bottom_small:2em" fw="text_small:700" ls="text_small:0.13em" color="rgb(36, 36, 36)"]CREATIVE SOLUTIONS FOR EVERYONE[/ld_fancy_heading][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22marketing%22%7D%2C%7B%22word%22%3A%22design%22%7D%2C%7B%22word%22%3A%22mobile%20apps%22%7D%5D" use_custom_fonts_title="true" fs="text_all:72px|text_large:64px|text_medium:11vw|text_small:11vw" lh="text_small:1.06em" ls="text_small:0" margin="right_large:0px|right_medium:12%25|bottom_small:0.35em"]Digital age adventure in[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="20px" lh="32px" margin="bottom_small:2em"]Passionate about solving problems through creative and digital products.[/ld_fancy_heading][vc_row_inner][vc_column_inner][ld_button style="btn-solid" title="Get a Quote" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" size="btn-xlg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" css=".vc_custom_1598369525565{margin-right: 30px !important;margin-bottom: 25px !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(255, 77, 84)" color="rgb(0, 127, 255)" color2="rgb(255, 77, 84)" hover_color2="rgb(0, 127, 255)"][ld_button style="btn-naked" title="Discover Hub" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(2, 33, 82)" css=".vc_custom_1579623428579{margin-bottom: 25px !important;margin-left: 10px !important;}" i_icon_linea="icon-ion-ios-arrow-round-down"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-7" responsive_css="margin_right_medium:-15%25"][ld_masked_image image="4341" bg_pos_x="50%" bg_pos_y="50%"][/vc_column][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_particles as_bg="yes" absolute_pos="yes" enable_density="yes" color_type="multi_color" opacity="1" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1579874781983-fb436513-72aa" height="100vh" position="right_small:0px|bottom_small:0px" number="14" multi_color_values="%5B%7B%22scolor%22%3A%22%23f27e3f%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%2C%7B%22scolor%22%3A%22%2348bb0f%22%7D%2C%7B%22scolor%22%3A%22%233ff292%22%7D%2C%7B%22scolor%22%3A%22%23899bff%22%7D%5D" size="6" anim_size_speed="1" anim_size_min="50" density="200"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 52 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 52', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-52.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" css=".vc_custom_1611479397932{padding-top: 60px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:150px|padding_bottom_medium:150px"][vc_column bg_position="right bottom" offset="vc_col-md-6" css=".vc_custom_1611479449153{background-image: url(https://modernagencypro.liquid-themes.com/wp-content/uploads/2020/08/asset-1.svg?id=4262) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][ld_particles as_bg="yes" color_type="multi_color" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1580387421529-fc2793d3-d4fc" number="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%23604cfd%22%7D%2C%7B%22scolor%22%3A%22%23f85976%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%5D" size="4"][ld_fancy_heading tag="h6" transform="text-lowercase" duration="1600" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_bg="yes" fh_border_radius="circle" enable_split="true" margin="bottom_small:0.75em" ca_init_translate_x="0" ca_init_rotate_y="0" ca_init_translate_y="35" color="rgb(255, 90, 61)" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(255, 234, 230)"]Digital Experience[/ld_fancy_heading][ld_fancy_heading highlight_offset="0.1em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-80px" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" compressor="0.75" minfontsize="44" ca_init_translate_x="0" ca_init_translate_y="30" ca_init_rotate_x="-75" start_delay="250" ca_init_translate_z="-130" ca_init_rotate_y="0" fs="text_medium:52px|text_small:10vw" ls="text_small:-0.02em" highlight_color="rgba(255, 185, 158, 0.5)"]Branding, digital [ld_highlight]marketing[/ld_highlight] and business solutions[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_medium:20px|text_small:18px" lh="text_small:1.5em" start_delay="850" ca_init_translate_y="65"]We merge imagination and technology to help thousands of brands grow in an age of digital transformation.[/ld_fancy_heading][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-50px" ca_an_opacity="1" css=".vc_custom_1580394487759{padding-top: 45px !important;}" ca_duration="1800" ca_start_delay="1350" ca_delay="180" ca_init_translate_y="5" ca_init_translate_z="-70" ca_init_rotate_x="-90"][vc_column_inner offset="vc_col-md-6"][ld_button style="btn-solid" title="See how we work" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-x" i_type="linea" i_hover_reveal="btn-hover-reveal" enable_row_shadowbox="yes" i_add_icon="true" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(248%2C85%2C78%2C0.15)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611478338953{margin-bottom: 35px !important;padding-right: 1em !important;padding-left: 1em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(51, 106, 234)"][/vc_column_inner][vc_column_inner offset="vc_col-md-6"][vc_column_text css=".vc_custom_1580292171884{margin-bottom: 35px !important;}"]<span style="color: #000000;">Hotline: <span style="color: var(--color-primary);">(733) 860-2906</span></span>[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" position="top_large:-40px|top_small:30px|right_small:0px"][ld_images_group_element img_size="35%" image="4301"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-xlg" i_ripple="btn-icon-ripple" i_add_icon="true" i_size="22px" color="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-ion-ios-play"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 53 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 53', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-53.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" bg_position="custom" enable_overlay="yes" enable_row_dividers="yes" css=".vc_custom_1607336739703{padding-top: 90px !important;padding-bottom: 90px !important;background-image: url(https://businessstartuppro.liquid-themes.com/wp-content/uploads/2019/11/bg-1@2x-scaled.jpg?id=36) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 0, 0, 0.25)" row_svg_divider="bottom_shape_type:12|bottom_shape_color:%23ffffff|bottom_shape_height:96" bg_pos_h="85%" bg_pos_v="50%"][vc_column width="3/4" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_align="text-center text-sm-left" responsive_css="margin_bottom_small:0px" css=".vc_custom_1603370852638{margin-bottom: 40px !important;}"][ld_fancy_heading use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:68px|text_medium:50px|text_small:46px" lh="text_large:1em" fw="text_large:700"]Consulting agency for your business.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:20px" lh="text_small:32px" margin="bottom_small:1.8em"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][ld_button style="btn-solid" title="Get Started Hub" link_type="scroll_to_section" shape="circle" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)"][/vc_column][vc_column width="1/4" enable_content_animation="yes" ca_init_scale_x="0.8" ca_init_scale_y="0.8" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_onmobile="yes" align="text-center" offset="vc_col-md-offset-2 vc_col-md-4" ca_duration="1800" ca_start_delay="950" responsive_align="text-center" responsive_css="margin_bottom_small:0px" css=".vc_custom_1607336221074{margin-bottom: 20px !important;}"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thickest" i_shape_size="btn-icon-custom-size" i_ripple="btn-icon-ripple" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_size="30px" i_shape_custom_size="87px" color="rgb(255, 255, 255)" i_color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_color2="rgb(255, 255, 255)" i_fill_hcolor2="rgb(255, 255, 255)" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 54 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 54', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-54.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" content_placement="middle" bg_position="left center" css=".vc_custom_1610914977012{background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column offset="vc_col-md-8" gradient_bg_color="linear-gradient(115deg, rgb(255,183,183) 1.2738853503184713%, rgb(195,214,250) 51.59235668789809%, rgb(175, 255, 242) 100%)" responsive_css="padding_top_medium:0px|padding_right_medium:0px|padding_bottom_medium:0px|padding_left_medium:12vw|padding_top_small:160px|padding_bottom_small:340px" css=".vc_custom_1611571884701{padding-top: 140px !important;padding-right: 15px !important;padding-bottom: 250px !important;padding-left: 15px !important;}"][vc_row_inner][vc_column_inner offset="vc_col-lg-8 vc_col-md-10"][ld_fancy_heading tag="h5" use_custom_fonts_title="true" color="rgb(224, 23, 101)" fs="text_small:13px" margin="top_small:1em"]— Building the £9Billion Market[/ld_fancy_heading][ld_fancy_heading enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22video%20calls.%22%7D%2C%7B%22word%22%3A%22group%20chats.%22%7D%5D" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_height="0.175em" highlight_offset="7px" use_custom_fonts_title="true" fs="text_large:5.5vw|text_medium:8.5vw|text_small:15vw" lh="text_small:1em" margin="bottom_small:0.2em" highlight_color="rgba(62, 196, 175, 0.35)" ls="text_small:-0.02em"]Make [ld_highlight]free[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.666em" ls="text_small:-0.01em" padding="right_large:6vw" margin="bottom_small:1.6em" fw="text_small:500"]Complete Toolkit – The only theme covers all aspects; beautiful layouts, super customizable.[/ld_fancy_heading][ld_button style="btn-solid" title="Get Started — It’s free" link_type="scroll_to_section" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" text_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ls="0.02em" fs="15px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:15px" margin="top_small:1em"]Try for free. No credit card required.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_col-md-4"][ld_images_group_container position="left_large:-27%25" margin="top_large:90px|top_medium:-250px|top_small:-180px|bottom_small:0px"][ld_images_group_element absolute_pos="yes" image="285" position="top_small:-20px|left_small:-20px"][/ld_images_group_element][ld_images_group_element absolute_pos="yes" image="44" position="top_small:18%25|right_small:0px|left_small:30%25"][/ld_images_group_element][ld_images_group_element img_size="60%" enable_hover3d="yes" image="274"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 55 - softwarehub
	$data = array();
	$data['name'] = esc_html__( 'Banner 55', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-55.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" bg_position="right center" enable_row_dividers="yes" css=".vc_custom_1621436916963{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #8fe8f2 !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" row_svg_divider="top_shape_color:%23ffffff|top_shape_height:0|bottom_shape_type:13|bottom_shape_color:%23ffffff|bottom_shape_height:440" responsive_css="padding_top_medium:110px|padding_bottom_medium:110px"][vc_column offset="vc_col-lg-6 vc_col-md-7"][ld_fancy_heading use_custom_fonts_title="true" enable_fit="true" compressor="0.8" minfontsize="48" fs="text_medium:66px|text_small:60px" ls="text_small:-0.04em" lh="text_small:1em" margin="bottom_small:0.2em"]Automate all your notifications.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(49, 63, 88)" fs="text_small:20px" lh="text_small:1.25em" margin="bottom_small:2em" padding="right_large:17%25"]Centralize email, Facebook, Twitter, message, web chat and 30+ apps in one place.[/ld_fancy_heading][ld_button style="btn-solid" title="Download hub" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" size="btn-lg" border="border-none" i_type="fontawesome" i_separator="btn-icon-sep" i_add_icon="true" i_size="22px" color="rgb(255, 255, 255)" hover_color="rgb(74, 33, 112)" fs="text_small:12px" i_separator_color="rgba(0, 0, 0, 0.1)" htext_color="rgb(255, 255, 255)" css=".vc_custom_1621245074221{margin-right: 20px !important;margin-bottom: 20px !important;}" i_color="rgb(74, 33, 112)" text_color="rgb(0, 0, 0)" i_icon_fontawesome="fab fa-apple" ls="text_small:0.09em" i_hcolor="rgb(255, 255, 255)" i_separator_hcolor="rgba(255, 255, 255, 0.15)" fw="text_small:700"][ld_button style="btn-naked" title="`{`ld_small font-size=``11px```}`Watch Demo`{`/ld_small`}`See how it works" link_type="lightbox" i_type="linea" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thick" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_size="18px" color="rgb(110, 35, 128)" fs="text_small:14px" lh="text_small:1.25em" css=".vc_custom_1621244998586{margin-bottom: 20px !important;}" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="48px" hover_color="rgb(0, 0, 0)" fw="text_small:500" i_hcolor="rgb(255, 255, 255)" i_fill_hcolor2="rgb(0, 0, 0)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWaSvMAl4zPw||target:%20_blank|"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.65)" fs="text_small:15px"]Free 30 days trial   ·   Exclusive Support   ·   No Fees[/ld_fancy_heading][/vc_column][vc_column width="5/6" column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-lg-6 vc_col-md-offset-0 vc_col-md-5 vc_col-sm-offset-1 vc_hidden-xs" responsive_align="text-md-right"][ld_images_group_container el_class="z-index-2"][ld_images_group_element img_size="60%" enable_float_effect="yes" image="153" margin="right_all:-10%25|top_large:-20%25|right_large:-45%25|top_small:-2vw|right_small:-20vw"][/ld_images_group_element][ld_images_group_element img_size="55%" enable_hover3d="yes" enable_float_effect="yes" absolute_pos="yes" image="154" position="bottom_all:-25%25|left_all:-20%25|bottom_large:-50%25|left_large:-25%25|bottom_small:-10vw|left_small:-12vw"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 56 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 56', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-56.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Banner 57 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 57', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-57.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;
	
	//Banner 58 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 58', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-58.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Banner 59 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 59', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-59.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" full_height="yes" enable_gradient="yes" enable_row_dividers="yes" responsive_css="padding_right_medium:8vw|padding_left_medium:8vw" gradient_bg="linear-gradient(90deg, rgb(141, 239, 255) 0.3184713375796178%, rgb(255, 175, 251) 97.13375796178345%)" row_svg_divider="bottom_shape_type:12|bottom_shape_color:%23ffffff|bottom_shape_height:113" css=".vc_custom_1611764336293{padding-top: 140px !important;padding-bottom: 100px !important;}"][vc_column offset="vc_col-lg-5 vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1603198065121{margin-bottom: 45px !important;}" responsive_align="text-center text-sm-left"][ld_fancy_heading tag="h6" margin="bottom_small:1.5em"]Global Experience[/ld_fancy_heading][ld_fancy_heading use_custom_fonts_title="true" gradient="linear-gradient(121deg, rgb(252, 0, 223) 0.9554140127388535%, rgb(59, 89, 255) 98%)" fs="text_all:7.5vw|text_large:110px|text_medium:12vw|text_small:25vw" margin="bottom_small:0.1em" lh="text_large:1em|text_medium:1.25em|text_small:1em"]Digital Studio[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:1.5em" color="rgb(49, 63, 88)" margin="bottom_small:2em"]Our design services starts and ends with a best in class experience strategy that builds brands.[/ld_fancy_heading][ld_button style="btn-solid" title="Let’s talk — Send a message" link_type="scroll_to_section" shape="circle" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-lqd-pen" fs="15px" lh="1.5em" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)"][/vc_column][vc_column offset="vc_col-lg-7 vc_col-md-6"][ld_images_group_container][ld_images_group_element absolute_pos="yes" image="43" position="top_small:12%25|right_small:12%25"][/ld_images_group_element][ld_images_group_element img_size="50%" image="41"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 60 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 60', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-60.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="bottom" enable_cc_circle="yes" bg_position="right center" bg_attachment="fixed" enable_overlay="yes" enable_loading_bg="yes" responsive_css="margin_left_medium:100px|padding_bottom_medium:6vw|padding_left_medium:8vw" css=".vc_custom_1611576840327{padding-bottom: 5vw !important;padding-left: 5vw !important;background-image: url() !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" cc_circle_color="rgb(197, 40, 40)" overlay_bg="rgba(0, 0, 0, 0.24)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_init_scale_z="1" ca_an_scale_z="1" offset="vc_col-md-7" ca_duration="1800" ca_delay="180" ca_init_translate_x="-40"][ld_fancy_heading tag="p" enable_bg="yes" fh_border_radius="round" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" lh="text_small:1em" padding="top_small:0.5em|right_small:1em|bottom_small:0.5em|left_small:1em" fh_bg="rgb(255, 255, 255)" margin="bottom_small:2em"]Investments[/ld_fancy_heading][ld_fancy_heading split_type="chars, words" highlight_type="lqd-highlight-custom-underline" duration="1200" delay="25" easing="expo.out" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" ca_init_scale_z="1" ca_an_scale_z="1" color="rgb(255, 255, 255)" fs="text_large:5vw|text_medium:11vw|text_small:18vw" ca_init_translate_y="-60" highlight_color_brush="rgba(255, 255, 255, 0.79)" ls="text_small:-0.02em"][ld_highlight]Investing[/ld_highlight] in digital platforms.[/ld_fancy_heading][ld_fancy_heading tag="p" tag_to_inherite="h4" use_inheritance="true" color="rgb(255, 255, 255)" margin="right_large:3vw|bottom_small:1.35em"]Hub is a digital design studio that develops strategic vision and products through cultural insight and emotion.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 61 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 61', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-61.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" css=".vc_custom_1603704684299{background-color: #ffc1c5 !important;}"][vc_column][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:1em"]Digital Designer based in Los Angeles[/ld_fancy_heading][ld_fancy_heading mask_bg_size="cover" mask_bg_repeat="no-repeat" mask_bg_position="center center" use_custom_fonts_title="true" use_bg_mask="true" fs="text_large:80px|text_medium:8vw|text_small:10vw" lh="text_small:1.1em" ls="text_small:-0.02em" gradient="linear-gradient(111deg, #0bccee 0%, rgb(235, 173, 105) 41.082802547770704%, rgb(194, 80, 80) 79.29936305732484%, #ac1de1 100%)"]Hi, I'm Alix. I work at <i class="fa fa-apple"></i>. I craft original effective brand experiences. My aim is to build your website so that it is functional and user friendly.[/ld_fancy_heading][ld_button style="btn-naked" title="— See my works" link_type="scroll_to_section" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(0, 0, 0)" hover_color="rgba(0, 0, 0, 0.75)" fs="19px" i_icon_linea="lqd-icn-ess icon-md-arrow-down"][ld_particles as_bg="yes" color_type="random_color" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1596101585154-567d0b79-a330" number="12" size="2px"][/vc_column][/vc_row][vc_row css=".vc_custom_1606205965159{padding-top: 40px !important;padding-bottom: 40px !important;background-color: #d5f5ff !important;}" responsive_css="padding_top_medium:10vh|padding_bottom_medium:10vh"][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_promo show_dynamic_shape="yes" show_button="yes" ib_style="btn-naked" ib_title="— view project" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_hover_reveal="btn-hover-reveal" use_custom_fonts_title="true" ib_i_add_icon="true" title="Anti Dote" image="307" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_color="rgb(0, 74, 199)" ib_hover_color="rgb(0, 0, 0)" ib_fs="text_small:13px" ib_ls="text_small:0.1em" color="rgb(0, 74, 199)" overlay_color="rgb(255, 255, 255)" dynamic_shape_bg="rgb(255, 255, 255)" fs="9vw" ib_fw="text_small:700" ib_link="url:http%3A%2F%2Fadaptivecolorspro.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|title:Starter%20Kit||" link="url:http%3A%2F%2Fadaptivecolorspro.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|||"]Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam[/ld_promo][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 62 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 62', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-62.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" css=".vc_custom_1608296878382{padding-top: 70px !important;padding-bottom: 70px !important;background-color: #ffaac7 !important;}" responsive_css="padding_top_medium:120px"][vc_column responsive_align="text-center"][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_reveal="yes" reveal_direction="bt" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="238" reveal_color="rgb(185, 223, 255)" position="top_all:-15%25|top_large:-25%25|top_medium:-50%25|left_medium:50%25|top_small:-60%25|left_small:0px" margin="left_medium:-290px|left_small:0px" translate_from_y="130" translate_to_y="-130"][/ld_images_group_element][ld_fancy_heading split_type="chars, words" duration="1600" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="150%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(185, 223, 255)" fs="text_large:300px|text_medium:32vw|text_small:30vw" lh="text_small:0.9em" ls="text_small:-0.05em" margin="bottom_small:0px" ca_init_translate_y="200" ca_init_rotate_x="125" start_delay="350"]Hi, I’m Paul.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Banner 63 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Banner 63', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-63.jpg' );
	$data['sort_name'] = 'Banner';
	$data['custom_class'] = 'general banner';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1606205965159{padding-top: 40px !important;padding-bottom: 40px !important;background-color: #d5f5ff !important;}" responsive_css="padding_top_medium:10vh|padding_bottom_medium:10vh"][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_promo show_dynamic_shape="yes" show_button="yes" ib_style="btn-naked" ib_title="— view project" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_hover_reveal="btn-hover-reveal" use_custom_fonts_title="true" ib_i_add_icon="true" title="Anti Dote" image="307" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_color="rgb(0, 74, 199)" ib_hover_color="rgb(0, 0, 0)" ib_fs="text_small:13px" ib_ls="text_small:0.1em" color="rgb(0, 74, 199)" overlay_color="rgb(255, 255, 255)" dynamic_shape_bg="rgb(255, 255, 255)" fs="9vw" ib_fw="text_small:700" ib_link="url:http%3A%2F%2Fadaptivecolorspro.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|title:Starter%20Kit||" link="url:http%3A%2F%2Fadaptivecolorspro.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|||"]Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<br />
Ut enim ad minim veniam[/ld_promo][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category CTA
	//CTA 1 - newsletterhub
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-1.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1610920943854{padding-top: 130px !important;padding-bottom: 100px !important;background-color: #edf7f8 !important;}" el_id="installation"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-80px" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1600" ca_delay="160" ca_init_translate_y="40" ca_init_rotate_x="-90"][ld_particles as_bg="yes" shape_type="image" opacity="1" enable_random_opacity="yes" enable_random_size="yes" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" particle_id="lqd-1608817134008-f5183198-5a24" number="10" image="282" image_width="74" image_height="45" size="50" color="#ffffff" move_speed="1"][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(17, 36, 70)" fs="text_medium:55px" lh="text_small:1.1em" margin="bottom_small:0.35em"]Our Data-Driven Unique Features.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:19px" lh="text_small:1.3em" color="rgb(0, 27, 56)" margin="bottom_small:1.65em"]No more complex codes. Creating an attractive and functional site has never been easier.[/ld_fancy_heading][ld_button style="btn-solid" title="Sign up — It’s Free" link_type="scroll_to_section" shape="circle" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.25em" css=".vc_custom_1611424185971{padding-right: 0.25em !important;padding-left: 0.25em !important;}" fs="16px" color="rgb(10, 98, 115)" fw="500" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(20, 20, 20)" htext_color="rgb(255, 255, 255)" ls="0.01em"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_ontablet="yes" column_top_onmobile="yes" responsive_align="text-md-right" offset="vc_col-md-7" ca_duration="1600" ca_start_delay="450" ca_delay="160" ca_init_translate_x="45" ca_init_translate_y="0"][ld_images_group_element image="280"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//CTA 2 - newsletterhub
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-2.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="center top" el_id="pricing" css=".vc_custom_1608821054922{padding-top: 70px !important;padding-bottom: 70px !important;background-image: url(https://softwarehub.liquid-themes.com/staging/wp-content/uploads/2020/12/bg-2.svg?id=250) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="160" ca_init_translate_x="-35" offset="vc_col-md-6"][ld_images_group_element image="280"][/ld_images_group_element][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" ca_duration="1600" ca_start_delay="250" ca_delay="160" ca_init_translate_y="30"][ld_fancy_heading tag="h2" highlight_height="0.3em" highlight_offset="5px" use_custom_fonts_title="true" color="rgb(17, 36, 70)" fs="text_small:38px" ls="text_small:-0.01em" margin="bottom_small:0.55em" highlight_color="rgba(57, 107, 255, 0.17)"]High Performance Servers.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(74, 98, 126)" lh="text_small:1.375em" margin="bottom_small:1.5em"]Choose a pre-built header or create a custom layout that perfectly suits your needs. It’s easy and fast. Your time is precious for us. Install any demo, plugin or template in a matter of seconds.[/ld_fancy_heading][ld_button style="btn-naked" title="See it in Action" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgb(27, 58, 90)" fs="15px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//CTA 3 - newsletterhub
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-3.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-80px" ca_an_opacity="1" ca_duration="1600" ca_delay="160" ca_init_translate_y="80" ca_init_rotate_x="-90" el_id="download" css=".vc_custom_1611417764708{padding-bottom: 10px !important;}"][vc_column css=".vc_custom_1610378810132{padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_medium:70px|padding_left_medium:70px|padding_right_small:20px|padding_left_small:20px"][vc_row_inner content_placement="middle"][vc_column_inner width="2/3" responsive_align="text-center" responsive_css="margin_bottom_small:0px" css=".vc_custom_1610378804362{margin-bottom: 20px !important;}" offset="vc_col-md-offset-2"][ld_fancy_heading tag="h2" highlight_height="0.3em" highlight_offset="5px" use_custom_fonts_title="true" fs="text_small:46px" margin="bottom_small:0.15em" highlight_color="rgba(57, 107, 255, 0.15)"]Join Hub and get limited [ld_highlight] discount[/ld_highlight][/ld_fancy_heading][ld_spacer height="18px"][ld_fancy_heading tag="p" use_custom_fonts_title="true"]We offer no questions asked refund policy for 14 days from the policy date.[/ld_fancy_heading][ld_spacer height="18px"][ld_button style="btn-solid" title="Sign up — It’s Free" shape="circle" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.25em" css=".vc_custom_1611417745568{padding-right: 0.75em !important;padding-left: 0.75em !important;}" fs="16px" color="rgb(232, 251, 255)" fw="500" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" text_color="rgb(10, 98, 115)" hover_color="rgb(37, 37, 37)" htext_color="rgb(255, 255, 255)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//CTA 4 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-4.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row row_scale_bg_onhover="yes" bg_position="custom" enable_overlay="yes" enable_row_shadowbox="yes" css=".vc_custom_1611924976884{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(https://classichub.liquid-themes.com/staging/wp-content/uploads/2020/03/bg-2@2x-scaled.jpg?id=69) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(43, 43, 43, 0.35)" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2222px%22%2C%22blur_radius%22%3A%2255px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.13)%22%7D%5D" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px|padding_top_small:60px|padding_bottom_small:60px" bg_pos_h="25%" bg_pos_v="50%"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_inheritance="true" enable_split="true" color="rgb(255, 255, 255)" padding="right_large:7%25|left_large:7%25"]We help people to build and expand their services.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" margin="bottom_small:2em" fs="text_small:17px" lh="text_small:28px" color="rgba(255, 255, 255, 0.8)" padding="right_large:15%25|left_large:15%25"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][ld_button style="btn-solid" title="Explore hub" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//CTA 5 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-5.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" row_scale_bg_onhover="yes" enable_overlay="yes" css=".vc_custom_1610893415509{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(https://classichub.liquid-themes.com/staging/wp-content/uploads/2020/03/bg-3@2x-scaled.jpg?id=77) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 0, 0, 0.22)" hover_overlay_bg="rgba(0, 0, 0, 0.4)" responsive_css="padding_top_medium:100px|padding_bottom_medium:80px|padding_top_small:60px|padding_bottom_small:60px"][vc_column align="text-center" offset="vc_col-md-7" responsive_align="text-md-left" css=".vc_custom_1595400834749{margin-bottom: 45px !important;}"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_medium:45px|text_small:35px" ls="text_small:-0.01em" margin="bottom_small:0px" ca_init_translate_y="90"]Schedule a meeting to take your business to the next level.[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-3" ca_init_translate_y="39" responsive_align="text-md-right"][ld_button style="btn-solid" title="Get in Touch" transformation="text-uppercase" link_type="scroll_to_section" shape="round" size="btn-xlg" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 6 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-6.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" row_scale_bg_onhover="yes" enable_cc_circle="yes" enable_overlay="yes" css=".vc_custom_1611576458077{padding-top: 60px !important;padding-bottom: 60px !important;background-image: url(https://asymmetric-businesspro.liquid-themes.com/wp-content/uploads/2020/10/asy-business-banner@2x.jpg?id=4375) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(0, 0, 0, 0.1)" responsive_css="margin_left_medium:100px|padding_top_medium:110px|padding_right_medium:7vw|padding_bottom_medium:110px|padding_left_medium:7vw" hover_overlay_bg="rgba(29, 30, 60, 0.13)"][vc_column offset="vc_col-lg-4 vc_col-md-5"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" use_inheritance="true" color="rgb(255, 255, 255)" fs="text_large:55px|text_small:45px" lh="text_small:1em" margin="bottom_small:0.65em"]Looking for a collaboration?[/ld_fancy_heading][ld_button style="btn-solid" title="Send message" shape="round" size="btn-sm" border="border-none" hover_txt_effect="btn-hover-txt-liquid-y" hover_bg_effect="btn-hover-bg-liquid" hover_bg_color="rgb(0, 0, 0)" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" css=".vc_custom_1610691148684{padding-right: 0.5em !important;padding-left: 0.5em !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 7 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-7.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="custom" css=".vc_custom_1587035098972{margin-bottom: 70px !important;padding-top: 80px !important;padding-bottom: 90px !important;background: #c10909 url(https://asymmetric-businesspro.liquid-themes.com/wp-content/uploads/2020/04/bg-2.svg?id=45) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="35%" bg_pos_v="-110px" responsive_css="margin_left_medium:100px"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h4" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]Our Story[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="p" tag_to_inherite="h4" use_inheritance="true" color="rgb(255, 255, 255)" margin="bottom_small:1.35em"]Hub is a digital design studio that develops <span style="text-decoration: underline;">strategic vision</span> and products through cultural insight and emotion.[/ld_fancy_heading][ld_button style="btn-solid" title="Send message" shape="round" size="btn-sm" border="border-none" hover_txt_effect="btn-hover-txt-liquid-y" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" css=".vc_custom_1596372112707{padding-right: 0.5em !important;padding-left: 0.5em !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(37, 37, 37)" htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 8 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-8.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1572002552033{padding-top: 35px !important;}"][vc_column enable_overlay="yes" enable_column_shadowbox="yes" css=".vc_custom_1572002832942{margin-bottom: -180px !important;padding-top: 75px !important;padding-right: 30px !important;padding-bottom: 75px !important;padding-left: 30px !important;background-image: url(https://servicepro.liquid-themes.com/wp-content/uploads/2019/10/bg-5.jpg?id=4318) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 10px !important;}" overlay_bg="rgba(1, 82, 197, 0.85)" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2230px%22%2C%22blur_radius%22%3A%2280px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.1)%22%7D%5D" responsive_css="padding_right_medium:100px|padding_left_medium:100px|padding_right_small:50px|padding_left_small:50px"][vc_row_inner content_placement="bottom"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-7" ca_duration="1800" ca_delay="200" ca_init_translate_y="80"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 227, 209)" fs="text_small:49px" lh="text_small:1.15em" margin="bottom_large:70px|bottom_small:40px" ca_init_translate_y="0"]La solution à vos mobile online payments[/ld_fancy_heading][/vc_column_inner][vc_column_inner][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1800" ca_init_translate_y="30"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.5)" fs="14px" margin="bottom_large:15px|bottom_small:35px"]Unpredictable rates may apply for $59[/ld_fancy_heading][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1.25" ca_init_scale_y="1.25" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-8" ca_duration="1800" ca_start_delay="200" ca_delay="200" responsive_align="text-md-right"][ld_button style="btn-solid" title="Become a Retailer" shape="round" size="btn-lg" border="border-none" color="rgb(255, 255, 255)" text_color="rgb(0, 36, 88)" fs="16px" lh="1.5em" hover_color="rgb(255, 227, 209)" htext_color="rgb(0, 36, 88)" css=".vc_custom_1605985793367{margin-right: 20px !important;margin-bottom: 15px !important;}"][ld_button style="btn-solid" title="Send money" shape="round" size="btn-lg" border="border-none" color="rgb(0, 203, 153)" text_color="rgb(255, 255, 255)" fs="16px" lh="1.5em" hover_color="rgb(255, 227, 209)" htext_color="rgb(0, 36, 88)" css=".vc_custom_1572002497948{margin-bottom: 15px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 9 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-9.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row enable_overlay="yes" css=".vc_custom_1615189193861{padding-top: 50px !important;padding-bottom: 10px !important;}" overlay_bg="linear-gradient(0deg, rgb(255, 255, 255) 0%, rgba(255, 255, 255, 0) 100%)" responsive_css="padding_top_medium:90px|padding_top_small:70px" el_id="contact"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1600" ca_delay="160" ca_init_translate_y="50" css=".vc_custom_1572354204050{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h2" highlight_offset="5px" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" highlight_color="rgb(211, 255, 248)" fs="text_small:42px" lh="text_small:1.333em"][ld_highlight]Any questions à [/ld_highlight] [ld_highlight]Projects?[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(0, 35, 82)"]Digital experiences, and print materials that communicate marketing goals.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs" el_class="z-index-2"][ld_images_group_element img_size="150%" enable_hover3d="yes" enable_float_effect="yes" absolute_pos="yes" image="4415" position="top_large:0px|right_large:0px|left_large:0px"][/ld_images_group_element][/vc_column][vc_column enable_column_shadowbox="yes" offset="vc_col-md-6" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2216px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgb(238%2C%20241%2C%20246)%22%7D%5D" css=".vc_custom_1572354237830{background-color: #ffffff !important;}"][vc_row_inner enable_content_animation="yes" equal_height="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="160" ca_init_translate_y="40"][vc_column_inner width="1/2" css=".vc_custom_1602650745639{border-right-width: 1px !important;padding-top: 33px !important;padding-right: 20px !important;padding-bottom: 15px !important;padding-left: 20px !important;border-right-color: #ebebeb !important;border-right-style: solid !important;}" responsive_css="padding_right_large:40px|padding_left_large:40px|border_right_medium:1px|padding_top_medium:33px|padding_right_medium:20px|padding_bottom_medium:33px|padding_left_medium:20px"][ld_fancy_heading tag="p" color="rgba(0, 35, 82, 0.6)" margin="bottom_small:0.25em"]Project Offers[/ld_fancy_heading][ld_fancy_heading tag="h4" color="rgb(0, 35, 82)" margin="bottom_small:0px"]info.liquid.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_css="padding_right_large:40px|padding_left_large:40px" css=".vc_custom_1588598769887{padding-top: 33px !important;padding-right: 20px !important;padding-bottom: 33px !important;padding-left: 20px !important;}"][ld_fancy_heading tag="p" color="rgba(0, 35, 82, 0.6)" margin="bottom_small:0.25em"]Consultation[/ld_fancy_heading][ld_fancy_heading tag="h4" color="rgb(0, 35, 82)" margin="bottom_small:0px"]+ 1 223 38 87[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 10 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-10.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:40px|padding_bottom_medium:40px" css=".vc_custom_1621614035928{padding-top: 30px !important;padding-bottom: 30px !important;}" el_id="vehicle-insurance"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:47px" margin="bottom_small:0.75em"]Covering your family’s needs.[/ld_fancy_heading][ld_fancy_heading tag="h3"]Protectec Insurance Policy[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:2.65em"]Mobile insurance packages made easy, forget about worrying for your mobile and live your life.[/ld_fancy_heading][ld_fancy_heading tag="h3"]Competitive Packages[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:2.65em"]We embrace holistic development and support for employees the aim of being a first-choice employer[/ld_fancy_heading][ld_button style="btn-solid" title="Request a Quote" shape="circle" border="border-none" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_add_icon="true" link="url:%23|||" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_shape_custom_size="30px" hover_color="rgb(15, 90, 100)" text_color="rgb(15, 90, 100)" color="rgba(7, 124, 88, 0.11)" htext_color="rgb(255, 255, 255)" i_hcolor="rgb(15, 90, 100)" i_fill_hcolor="rgb(255, 255, 255)" i_color="rgb(15, 90, 100)" fs="text_small:14px" lh="text_small:2em" i_margin_left="12px" fw="text_small:500"][/vc_column][vc_column column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-1 vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1621616442735{margin-bottom: 30px !important;}"][vc_single_image image="3532" css=".vc_custom_1621606897777{margin-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 11 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-11.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row enable_gradient="yes" gradient_bg="linear-gradient(179deg, #eef7fa 0.6369426751592356%, rgb(255, 255, 255) 100%)" css=".vc_custom_1605833651153{padding-top: 70px !important;padding-bottom: 50px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="65"][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" margin="bottom_small:0.3em" highlight_color="rgba(157, 95, 255, 0.1)"]Start your [ld_highlight]free trial.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="h4" color="rgba(21, 86, 108, 0.45)" margin="bottom_small:1.5em"]Ready to get started?[/ld_fancy_heading][ld_newsletter style="solid" inputs_size="ld-sf--size-xl" inputs_radius="ld-sf--round" inputs_shadow="ld-sf--input-shadow" btn_style="naked" btn_display="label_icon" btn_label="GET STARTED" btn_position="ld-sf--button-inside" i_type="linea" use_custom_fonts_input="true" use_custom_fonts_label="true" i_add_icon="true" placeholder_text="Your email address" fs="18px" label_fs="15px" label_ls="0.01em" txt_color="rgb(128, 129, 171)" txt_f_color="rgb(0, 0, 0)" margin="bottom_small:15px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][vc_column_text]<a href="https://startup.liquid-themes.com/wp-content/uploads/2019/10/shapes-1.svg"><img class="alignnone size-full wp-image-640" src="https://startup.liquid-themes.com/wp-content/uploads/2019/10/shapes-1.svg" alt="" /></a>    <span style="color: #000000; font-size: 12px;">Try for free. No credit card required.</span>[/vc_column_text][/vc_column][vc_column offset="vc_col-lg-4 vc_col-md-offset-1 vc_col-md-5 vc_hidden-sm vc_hidden-xs"][ld_images_group_container margin="top_large:-50%25"][ld_images_group_element enable_hover3d="yes" enable_float_effect="yes" image="766"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 12 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-12.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row parallax="enable_parallax" enable_content_animation="yes" ca_init_scale_x="1.2" ca_init_scale_y="1.2" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="center center" css=".vc_custom_1620300872542{padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(https://itbusinesspro.liquid-themes.com/wp-content/uploads/2020/01/bg-2@2x-scaled.jpg?id=47) !important;background-position: center;background-repeat: no-repeat !important;background-size: cover !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_x="100" ca_init_rotate_x="0" ca_init_rotate_y="60"][vc_column row_scale_bg_onhover="yes" enable_backdrop_filter="yes" enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" backfilter_blur="0" backfilter_saturation="1" backfilter_brightness="1" backfilter_contrast="1" backfilter_grayscale="0" backfilter_hue="0" backfilter_sepia="1" backfilter_opacity="1" offset="vc_col-md-offset-7 vc_col-md-5" css=".vc_custom_1609183980636{padding-top: 55px !important;padding-right: 40px !important;padding-bottom: 70px !important;padding-left: 40px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.1)%22%7D%5D" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_start_delay="500" responsive_css="padding_right_medium:70px|padding_left_medium:70px|padding_right_small:30px|padding_left_small:30px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="40px" margin="bottom_small:0.85em"]Key benefits[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="IT Solutions for your business" title_mb="1" icon_mb="7" custom_heading_size="17px" icon_size="18px" css=".vc_custom_1607346409497{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Complete API Integration" title_mb="1" icon_mb="7" custom_heading_size="17px" icon_size="18px" css=".vc_custom_1607346422524{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Simple registration system" title_mb="1" icon_mb="7" custom_heading_size="17px" icon_size="18px" css=".vc_custom_1607346433700{margin-bottom: 40px !important;}"][/ld_icon_box][ld_button style="btn-solid" title="See how we work" transformation="text-uppercase" shape="round" border="border-none" hover_txt_effect="btn-hover-txt-liquid-y" hover_bg_effect="btn-hover-bg-liquid" hover_bg_color="rgb(0, 0, 0)" fs="14px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 13 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-13.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row row_scale_bg_onhover="yes" bg_position="center center" enable_loading_bg="yes" css=".vc_custom_1620300997589{padding-top: 60px !important;padding-bottom: 70px !important;background-image: url(https://itbusinesspro.liquid-themes.com/wp-content/uploads/2020/01/bg-4@2x-1-scaled.jpg?id=66) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:110px|padding_bottom_medium:120px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" responsive_align="text-left text-md-center"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" color="rgb(255, 255, 255)" minfontsize="52" fs="text_medium:62px|text_small:13vw" lh="text_small:1.161em"]Contact us to secure your IT needs.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="24px" lh="1.25em" margin="bottom_small:1.75em"]Let’s collaborate and make an impact with our cross-discipline approach to design and deveopment.[/ld_fancy_heading][ld_button style="btn-solid" title="Let’s work together" transformation="text-uppercase" shape="round" border="border-none" hover_txt_effect="btn-hover-txt-liquid-y" hover_bg_effect="btn-hover-bg-liquid" hover_bg_color="rgb(0, 0, 0)" fs="14px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 14 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-14.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row row_scale_bg_onhover="yes" enable_overlay="yes" css=".vc_custom_1614671578707{padding-top: 120px !important;padding-bottom: 120px !important;background-image: url(https://itbusinesspro.liquid-themes.com/wp-content/uploads/2021/01/opus-two-background.jpg?id=8852) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(22, 22, 22, 0.15)" hover_overlay_bg="rgba(22, 22, 22, 0.45)"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1200" ca_delay="180" ca_init_translate_y="40" ca_init_translate_z="-161" ca_init_rotate_x="-80" css=".vc_custom_1545130653593{padding-top: 5% !important;padding-right: 5% !important;padding-bottom: 5% !important;padding-left: 5% !important;background-color: #ffffff !important;border-radius: 4px !important;}" responsive_align="text-center"][ld_spacer height="18px"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="36px" lh="1.111em"]Get in Touch[/ld_fancy_heading][ld_spacer height="12px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:25px" color="rgba(24, 27, 49, 0.502)"]Top-notch support, free lifetime updates, and bonus plugins included in the package![/ld_fancy_heading][ld_spacer height="22px"][ld_button style="btn-solid" title="Join to download" shape="round" width="btn-block" fs="15px" lh="1.5em" ls="0.02em" css=".vc_custom_1609858528105{padding-right: 2em !important;padding-left: 2em !important;}" hover_color="rgb(37, 37, 37)"][ld_spacer height="22px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 15 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-15.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="0.85" ca_init_scale_y="0.85" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1614344011038{padding-top: 15px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="65" ca_init_rotate_x="-35" el_id="download"][vc_column parallax="yes" scale_from_x="1.2" scale_from_y="1.2" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_column_shadowbox="yes" bg_position="center center" responsive_css="padding_right_medium:90px|padding_left_medium:90px" css=".vc_custom_1614345414070{margin-bottom: -100px !important;padding-top: 55px !important;padding-right: 15px !important;padding-bottom: 55px !important;padding-left: 15px !important;background-color: #030343 !important;background-position: 0 0 !important;background-repeat: no-repeat !important;border-radius: 10px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.19)%22%7D%5D" translate_from_y="100" parallax_duration="-=650"][vc_row_inner content_placement="middle"][vc_column_inner align="text-center" offset="vc_col-md-8" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:46px|text_small:10vw" margin="bottom_large:0px" lh="text_small:1em" fw="text_small:700"]Join Hub and increase your productivity.[/ld_fancy_heading][/vc_column_inner][vc_column_inner align="text-center" responsive_align="text-center text-md-right" offset="vc_col-md-4"][ld_button style="btn-solid" title="Get Started" shape="circle" size="btn-lg" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="linea" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(18, 18, 18)" htext_color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 16 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-16.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" enable_row_dividers="yes" css=".vc_custom_1605613246476{padding-bottom: 60px !important;background-color: #f8f9ff !important;}" row_svg_divider="bottom_shape_type:1|bottom_shape_color:%23ffffff|bottom_shape_height:80" el_id="contact" responsive_css="padding_top_medium:100px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-4" ca_duration="1600" ca_delay="160" ca_init_translate_y="50" css=".vc_custom_1572354204050{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="5px" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" highlight_color="rgb(211, 255, 248)" fs="text_medium:47px|text_small:10.5vw"][ld_highlight]Any questions à [/ld_highlight] [ld_highlight]Projects?[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(0, 35, 82)"]Digital experiences, and print materials that communicate marketing goals.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs" el_class="z-index-2"][ld_images_group_element enable_hover3d="yes" enable_float_effect="yes" image="4802" margin="right_large:-2.3vw|bottom_large:-1.25vw"][/ld_images_group_element][/vc_column][vc_column enable_column_shadowbox="yes" offset="vc_col-md-6" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2216px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgb(238%2C%20241%2C%20246)%22%7D%5D" css=".vc_custom_1572354237830{background-color: #ffffff !important;}"][vc_row_inner enable_content_animation="yes" equal_height="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="160" ca_init_translate_y="40"][vc_column_inner width="1/2" css=".vc_custom_1607327900056{border-right-width: 0px !important;padding-top: 33px !important;padding-right: 20px !important;padding-bottom: 33px !important;padding-left: 20px !important;border-right-color: #ebebeb !important;border-right-style: solid !important;}" responsive_css="padding_right_large:60px|padding_left_large:60px|border_right_small:1px"][ld_fancy_heading tag="p" color="rgba(0, 35, 82, 0.6)" margin="bottom_small:0.25em"]Project Offers[/ld_fancy_heading][ld_fancy_heading tag="h4" color="rgb(0, 35, 82)" margin="bottom_small:0px"]info.liquid.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_css="padding_right_large:60px|padding_left_large:60px" css=".vc_custom_1572354352529{padding-top: 33px !important;padding-right: 20px !important;padding-bottom: 33px !important;padding-left: 20px !important;}"][ld_fancy_heading tag="p" color="rgba(0, 35, 82, 0.6)" margin="bottom_small:0.25em"]Consultation[/ld_fancy_heading][ld_fancy_heading tag="h4" color="rgb(0, 35, 82)" margin="bottom_small:0px"]+ 1 223 38 87[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 17 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-17.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" enable_gradient="yes" css=".vc_custom_1606472875637{padding-top: 120px !important;padding-bottom: 80px !important;}" gradient_bg="linear-gradient(180deg, #f0f4f5 0%, rgb(255, 255, 255) 100%)" responsive_css="padding_top_medium:150px|padding_bottom_medium:120px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="55"][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" compressor="0.7" minfontsize="42" fs="text_medium:53px|text_small:42px" margin="bottom_small:0.35em" lh="text_small:1.2em" color="rgb(0, 49, 121)"]Looking for a job? Join the band.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:21px" lh="text_small:34px" margin="bottom_small:1.7em"] We provide digital experience services to startups and small businesses to looking for a partner of their digital media.[/ld_fancy_heading][ld_button style="btn-solid" title="See Available Jobs" link_type="scroll_to_section" shape="circle" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" fs="16px" color="rgb(91, 123, 251)" i_icon_linea="lqd-icn-ess icon-md-arrow-down"][/vc_column][vc_column offset="vc_col-md-6"][ld_images_group_container parallax="yes" enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" translate_from_y="-70" translate_to_y="110" margin="right_large:-20%25|bottom_small:0px" pf_duration="1800" pf_start_delay="350" pf_delay="180" pf_init_translate_x="50"][ld_images_group_element img_size="50%" image="4897"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1573545920395-493fe50f-7472" number="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23fdc14c%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%234cfd89%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%5D" size="4.5" move_speed="1.75"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 18 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-18.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-80px" ca_an_opacity="1" bg_position="right bottom" css=".vc_custom_1605615318044{padding-top: 35px !important;padding-bottom: 60px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="100" ca_init_rotate_x="-65" ca_init_translate_z="100" responsive_css="padding_bottom_medium:100px"][vc_column parallax="yes" scale_from_x="1.2" scale_from_y="1.2" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_column_shadowbox="yes" bg_position="custom" css=".vc_custom_1613479277468{padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;background: #ffffff url(https://modernagencypro.liquid-themes.com/wp-content/uploads/2020/08/asset-1.svg?id=4262) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;border-radius: 15px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.08)%22%7D%5D" responsive_css="padding_right_medium:65px|padding_left_medium:65px|padding_right_small:30px|padding_left_small:30px" bg_pos_h="92%" bg_pos_v="60%" translate_from_y="100"][vc_row_inner equal_height="yes" content_placement="middle"][vc_column_inner align="text-center" offset="vc_col-md-8" responsive_align="text-md-left" responsive_css="padding_right_medium:0px|padding_left_medium:0px" css=".vc_custom_1605986763153{padding-right: 15px !important;padding-left: 15px !important;}"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" enable_fit="true" fs="48px" lh="1.2em" margin="bottom_small:0.65em" minfontsize="36"]Ready to get started?[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="20px" lh="1.5em" margin="bottom_large:0px|bottom_small:30px"]As an award-winning agency, we are consistently and challenging ourseleves for the betterment. We are your authentic brand.[/ld_fancy_heading][/vc_column_inner][vc_column_inner align="text-center" offset="vc_col-md-4" responsive_align="text-md-right"][ld_button style="btn-solid" title="Get started now" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" hover_txt_effect="btn-hover-txt-liquid-y" enable_row_shadowbox="yes" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(248%2C85%2C78%2C0.21)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611478449356{padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(51, 106, 234)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 19 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-19.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="0.9" ca_init_scale_y="0.9" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1575031485016{padding-top: 30px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="80" ca_init_rotate_y="0" ca_init_rotate_x="-35"][vc_column enable_column_shadowbox="yes" bg_position="custom" responsive_css="padding_right_medium:90px|padding_left_medium:90px" css=".vc_custom_1610110069400{padding-top: 55px !important;padding-right: 25px !important;padding-bottom: 55px !important;padding-left: 25px !important;background-image: url(https://businessstartuppro.liquid-themes.com/wp-content/uploads/2021/01/bg-6.svg?id=347) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 10px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2230px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.1)%22%7D%5D" responsive_align="text-center" gradient_bg_color="linear-gradient(35deg, rgb(46, 52, 67) 0%, rgb(50, 51, 74) 50%, #3b4157 100%)" bg_pos_h="65%" bg_pos_v="50%"][vc_row_inner content_placement="middle"][vc_column_inner align="text-center" offset="vc_col-lg-6 vc_col-md-7" responsive_align="text-md-left" css=".vc_custom_1610701192756{padding-bottom: 20px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:46px|text_small:36px" margin="bottom_large:0px" fw="text_small:700" lh="text_small:1em" ls="text_small:-0.01em"]Convert more visitors into customers.[/ld_fancy_heading][/vc_column_inner][vc_column_inner align="text-center" responsive_align="text-center text-md-right" offset="vc_col-lg-6 vc_col-md-5"][ld_button style="btn-solid" title="Get Started Today" shape="circle" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" hover_color="rgb(18, 18, 18)" htext_color="rgb(255, 255, 255)" lh="1.25em" i_icon_linea="icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 20 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 20', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-20.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1614769150109{padding-top: 60px !important;padding-bottom: 60px !important;}" el_id="features"][vc_column offset="vc_col-md-6"][ld_images_group_element enable_float_effect="yes" image="244"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-md-offset-1 vc_col-md-5"][ld_images_group_element image="64" margin="bottom_small:15px"][/ld_images_group_element][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" use_custom_fonts_title="true" fs="text_small:45px" lh="text_small:1.1em" margin="bottom_small:0.35em" highlight_color="rgba(62, 196, 175, 0.47)"]Add calling [ld_highlight]credits[/ld_highlight].[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][ld_button style="btn-solid" title="Sign up — It’s Free" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="icon-md-arrow-round-forward" color="rgb(240, 242, 255)" text_color="rgb(67, 32, 145)" hover_color="rgb(67, 32, 145)" htext_color="rgb(255, 255, 255)" fs="16px" css=".vc_custom_1587623501253{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(111, 120, 128)" fs="text_small:13px" lh="text_small:1.53em" margin="bottom_small:1em"]Choose a pre-built header or create a custom layout that perfectly suits your needs. It’s easy and fast. Your time is precious for us.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" margin="top_small:1em"]John Doe, Founder of Liquid[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 21 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 21', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-21.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1614769212157{margin-bottom: 40px !important;}" el_id="download"][vc_column parallax="yes" scale_from_x="1.2" scale_from_y="1.2" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" gradient_bg_color="linear-gradient(115deg, rgb(247, 245, 255) 0%, #ebf9ff 100%)" translate_from_y="100" parallax_duration="-=750"][vc_row_inner content_placement="middle"][vc_column_inner css=".vc_custom_1605956339665{padding-top: 55px !important;padding-right: 30px !important;padding-bottom: 40px !important;padding-left: 30px !important;}" offset="vc_col-lg-offset-1 vc_col-lg-4 vc_col-md-5" responsive_css="padding_right_medium:0px|padding_bottom_medium:0px|padding_left_medium:0px"][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="7px" use_custom_fonts_title="true" fs="text_large:81px|text_small:45px" lh="text_small:0.9em" margin="bottom_small:0.75em" highlight_color="rgba(62, 196, 175, 0.35)"][ld_highlight]Join[/ld_highlight] the Hub.[/ld_fancy_heading][vc_single_image image="336" alignment="center" css=".vc_custom_1615483890427{margin-right: 12% !important;margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner offset="vc_col-lg-offset-1 vc_col-lg-4 vc_col-md-5" responsive_css="padding_right_medium:0px|padding_left_medium:0px" css=".vc_custom_1605956349538{padding-right: 30px !important;padding-left: 30px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:2em" color="rgb(0, 0, 0)"]Make a Website You’ll be proud of AI Powered Support Experience – Our support team will get assistance from AI-powered suggestions, making it quicker than ever to handle support requests.[/ld_fancy_heading][ld_button style="btn-solid" title="Sign up — It’s Free" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 6, 69)" text_color="rgb(255, 255, 255)" hover_color="rgb(67, 32, 145)" fs="16px" css=".vc_custom_1599123659344{margin-bottom: 25px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" margin="bottom_small:0px" position="bottom_small:-200px|left_small:0px"][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="86" translate_from_y="276" translate_to_y="-250"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 22 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 22', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-22.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle"][vc_column offset="vc_col-lg-offset-1 vc_col-md-6"][ld_images_group_container parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" translate_from_y="90" translate_to_y="-80"][ld_images_group_element img_size="50%" image="234"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_x="35"][ld_fancy_heading tag="p" transform="text-uppercase" tag_to_inherite="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" use_inheritance="true" fs="text_small:13px" ls="text_small:0.05em" margin="bottom_small:2em" fw="text_small:700" fh_bg="rgba(118, 53, 238, 0.09)" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px"]NOTIFICATION CENTER[/ld_fancy_heading][ld_fancy_heading tag="h2"]Deliver a personal experience at scale.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.35em" margin="bottom_small:1.75em"]<strong>Complete Design Toolkit </strong>– huge collection of elements, rich customization options, flexible layouts, and instant results![/ld_fancy_heading][ld_button style="btn-solid" title="Get started" shape="circle" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" i_margin_left="18px" color="rgba(17, 36, 70, 0.04)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" fs="16px" lh="1.35em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 23 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 23', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-23.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1609753743087{padding-top: 50px !important;}"][vc_column parallax="yes" scale_from_x="1.2" scale_from_y="1.2" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" responsive_css="padding_right_medium:12%25|padding_left_medium:12%25" css=".vc_custom_1613479127639{margin-bottom: 65px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" responsive_align="text-center" translate_from_y="100"][ld_fancy_heading tag="h2" highlight_height="0.375em" highlight_offset="6px" highlight_color="rgba(55, 220, 116, 0.25)"]Ready to get started? Start your [ld_highlight]free trial.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="17px" color="rgba(17, 36, 70, 0.5)"]Free 30 days trial   |   Exclusive Support   |   No Fees[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-3 vc_col-md-6" el_class="pull-down" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_init_rotate_x="-40" css=".vc_custom_1573513016155{border-radius: 5px !important;}"][ld_cf7 id="51" size="lqd-contact-form-inputs-lg" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="17px" lh="1.5em" submit_fs="20px" submit_lh="1.5em" lqd_bg_color="rgb(255, 255, 255)" color="rgb(154, 152, 160)" h_color="rgb(0, 0, 0)" border_color="rgb(229, 229, 229)" css=".vc_custom_1613478460338{margin-bottom: 0px !important;}" bm="0px" submit_bg_color="rgb(231, 108, 108)" submit_border_color="rgb(231, 108, 108)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 24 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 24', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-24.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_z="-80px" ca_an_opacity="1" ca_duration="1600" ca_delay="160" ca_init_translate_y="80" ca_init_rotate_x="-90" el_id="download" css=".vc_custom_1611417764708{padding-bottom: 10px !important;}"][vc_column css=".vc_custom_1620648190473{padding-top: 30px !important;padding-bottom: 80px !important;border-radius: 5px !important;}" responsive_css="padding_right_medium:70px|padding_bottom_medium:60px|padding_left_medium:70px|padding_right_small:20px|padding_left_small:20px" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-md-center"][ld_fancy_heading tag="h2" highlight_height="0.3em" highlight_offset="5px" use_custom_fonts_title="true" fs="text_small:46px" margin="bottom_small:0.15em" highlight_color="rgba(57, 107, 255, 0.15)"]Join Hub and get limited [ld_highlight] discount[/ld_highlight][/ld_fancy_heading][ld_spacer height="18px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px"]We offer no questions asked refund policy for 14 days from the policy date.[/ld_fancy_heading][ld_spacer height="18px"][ld_button style="btn-solid" title="Sign up — It’s Free" shape="circle" size="btn-lg" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.25em" css=".vc_custom_1611417745568{padding-right: 0.75em !important;padding-left: 0.75em !important;}" fs="16px" color="rgb(232, 251, 255)" fw="500" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" text_color="rgb(10, 98, 115)" hover_color="rgb(37, 37, 37)" htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 25 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 25', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-25.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" equal_height="yes" content_placement="middle"][vc_column responsive_css="padding_top_large:85px|padding_right_large:20%25|padding_bottom_large:85px|padding_left_large:15%25|padding_top_medium:70px|padding_right_medium:10%25|padding_bottom_medium:70px|padding_left_medium:10%25" css=".vc_custom_1621610935691{padding-top: 45px !important;padding-right: 20px !important;padding-bottom: 45px !important;padding-left: 20px !important;background: #e7f2ee url(https://insurance.liquid-themes.com/wp-content/uploads/2021/05/lines-3.svg?id=3542) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" offset="vc_col-md-7"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:51px" lh="text_small:1.07em"]Request an Insurance policy.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.35em" margin="bottom_small:2em" color="rgba(16, 58, 64, 0.75)"]Embrace holistic development and support for employees the aim of being a first-choice[/ld_fancy_heading][ld_button style="btn-solid" title="Request a Quote" shape="circle" border="border-none" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_add_icon="true" link="url:%23|||" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_shape_custom_size="30px" hover_color="rgb(15, 90, 100)" text_color="rgb(255, 255, 255)" color="rgb(15, 90, 100)" htext_color="rgb(255, 255, 255)" i_hcolor="rgb(15, 90, 100)" i_fill_hcolor="rgb(255, 255, 255)" i_color="rgb(15, 90, 100)" fs="text_small:14px" lh="text_small:2em" i_margin_left="12px" fw="text_small:500" i_fill_color="rgb(255, 255, 255)"][/vc_column][vc_column offset="vc_col-md-5" css=".vc_custom_1621610800097{background-image: url(https://insurance.liquid-themes.com/wp-content/uploads/2021/05/img-4@2x.jpg?id=3543) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_single_image image="3543" invisible="yes" css=".vc_custom_1621610857704{margin-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 26 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 26', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-26.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="0.85" ca_init_scale_y="0.85" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1613747209958{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #292e33 !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="65" ca_init_rotate_x="-35"][vc_column enable_column_shadowbox="yes" responsive_css="padding_right_medium:90px|padding_left_medium:90px" css=".vc_custom_1605397142557{margin-bottom: -100px !important;padding-top: 55px !important;padding-right: 15px !important;padding-bottom: 55px !important;padding-left: 15px !important;background-color: #4354fa !important;border-radius: 10px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2215px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.19)%22%7D%5D" responsive_align="text-center text-md-left"][vc_row_inner content_placement="middle"][vc_column_inner align="text-center" offset="vc_col-md-6" responsive_align="text-md-left"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="39px" margin="bottom_large:0px"]Create and edit tasks online. For free.[/ld_fancy_heading][/vc_column_inner][vc_column_inner align="text-center" responsive_align="text-md-right" offset="vc_col-md-6"][ld_button style="btn-solid" title="Get Started Today" shape="round" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" color="rgb(255, 255, 255)" hover_color="rgb(18, 18, 18)" htext_color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 27 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 27', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-27.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="custom" enable_overlay="yes" enable_row_dividers="yes" responsive_css="padding_top_medium:130px|padding_bottom_medium:110px" css=".vc_custom_1622131575715{padding-top: 90px !important;padding-bottom: 70px !important;background-image: url(https://staging.liquid-themes.com/kids/wp-content/uploads/2021/05/img-foot@2x.jpg?id=4460) !important;}" overlay_bg="rgba(0, 0, 0, 0.2)" row_svg_divider="top_shape_type:7|top_shape_color:%23ffffff|top_shape_height:16" el_id="contact" bg_pos_h="20%" bg_pos_v="50%"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" color="rgb(255, 126, 106)" padding="top_small:0.625em|right_small:1em|bottom_small:0.625em|left_small:1em" fh_bg="rgb(255, 239, 237)" margin="bottom_small:1em"]Enroll 2022[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_small:0.65em" color="rgb(255, 255, 255)" fs="text_medium:60px|text_small:52px" lh="text_small:1em"]Let your child explore and learn.[/ld_fancy_heading][ld_cf7 id=""][ld_button style="btn-solid" title="Join the Program" link_type="modal_window" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-marquee btn-hover-txt-marquee-x" hover_color="rgb(255, 255, 255)" htext_color="rgb(40, 59, 63)" anchor_id="#contact-modal"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//CTA 28 - classic
	$data = array();
	$data['name'] = esc_html__( 'Call To Action 28', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'cta-28.jpg' );
	$data['sort_name'] = 'Call to action';
	$data['custom_class'] = 'general cta call-to-action';
	$data['content'] = <<<CONTENT
	[vc_row row_scale_bg_onhover="yes" enable_overlay="yes" css=".vc_custom_1622019532938{padding-top: 95px !important;padding-bottom: 95px !important;background-image: url(http://multipurpose.liquid-themes.com/wp-content/uploads/2021/05/cta-bg@2x.jpg?id=9142) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" el_id="contact" hover_overlay_bg="rgba(0, 0, 0, 0.3)"][vc_column enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" enable_column_hover_shadowbox="yes" offset="vc_col-lg-5 vc_col-md-6" responsive_css="padding_right_medium:40px|padding_left_medium:40px" css=".vc_custom_1622015869369{padding-top: 40px !important;padding-right: 20px !important;padding-bottom: 45px !important;padding-left: 20px !important;background-color: #ffffff !important;}" custom_border_radius="15px" responsive_align="text-center" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22spread_radius%22%3A%22-5px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.15)%22%7D%5D"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:38px"]Contact Us[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(134, 147, 158)" fs="text_small:16px" lh="text_small:1.62em" margin="bottom_small:1.5em"]Great things in business are never done one. They're done by a team of people.[/ld_fancy_heading][ld_button style="btn-solid" title="Request a Quote" link_type="modal_window" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-switch-change btn-hover-txt-switch btn-hover-txt-switch-y" title_secondary="+123 874 238 90" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgba(21, 81, 83, 0.1)" text_color="rgb(21, 81, 83)" fs="text_small:16px" i_size="15px" i_margin_left="13px" i_shape_custom_size="35px" i_color="rgb(21, 81, 83)" i_fill_color="rgba(21, 81, 83, 0.18)" i_hcolor="rgb(255, 255, 255)" i_fill_hcolor="rgba(255, 255, 255, 0.15)" anchor_id="#contact-modal"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Carousel
	//Carousel 1
	$data = array();
	$data['name'] = esc_html__( 'Carousel 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-1.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1605623393505{padding-bottom: 90px !important;}" responsive_css="padding_top_medium:60px|padding_bottom_medium:60px|padding_bottom_small:90px"][vc_column align="text-center" responsive_align="text-md-left"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" cellalign="center" pagenationdots="yes" dots_bottom_offset="0px" dots_style="carousel-dots-style4"][ld_carousel_section title="Tab" tab_id="lqd-1595577691001-32470bc4-46d4"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-6" responsive_css="margin_top_medium:-10%25|padding_right_medium:7%25|padding_bottom_medium:0px" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" responsive_align="text-left" css=".vc_custom_1612274960212{padding-bottom: 30px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(58, 82, 116)" fs="12px" ls="0.1em" margin="bottom_small:1.8em"] Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:40px|text_small:32px"]Target mobile consumers and grow your brand.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:29px" margin="bottom_small:2.15em"]We provide digital experience services to startups and small businesses to looking for a partner of their digital media.[/ld_fancy_heading][ld_button style="btn-solid" title="Get Started" shape="circle" size="btn-sm" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1595578841603{padding-right: 0.75em !important;padding-left: 0.75em !important;}" color="rgb(0, 127, 255)" color2="rgb(255, 77, 84)" hover_color="rgb(255, 77, 84)" fs="18px" hover_color2="rgb(0, 127, 255)" i_margin_left="10px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_start_delay="500" ca_delay="180" css=".vc_custom_1606976246263{background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/Memphis-1-1.svg?id=5947) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_single_image image="6144" alignment="center"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595582162820-2fc3c6f6-ec7d"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-0 vc_col-md-6" responsive_css="margin_top_medium:-10%25|padding_right_medium:7%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="30" responsive_align="text-center text-md-left" css=".vc_custom_1606977438759{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(58, 82, 116)" fs="12px" ls="0.1em" margin="bottom_small:1.8em"] Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2"]Let your audience know about your brand.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:29px" margin="bottom_small:2.15em"]We provide digital experience services to startups and small businesses to looking for a partner of their digital media.[/ld_fancy_heading][ld_button style="btn-solid" title="Get Started" shape="circle" size="btn-sm" border="border-none" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" css=".vc_custom_1595578841603{padding-right: 0.75em !important;padding-left: 0.75em !important;}" color="rgb(0, 127, 255)" color2="rgb(255, 77, 84)" hover_color="rgb(255, 77, 84)" fs="18px" hover_color2="rgb(0, 127, 255)" i_margin_left="10px" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][vc_column_inner enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" ca_duration="1800" ca_start_delay="500" ca_delay="180" css=".vc_custom_1606976267414{background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2020/05/Memphis-1-1.svg?id=5947) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_single_image image="6057" alignment="center"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_move="yes" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1573301198431-6ff8827c-fef3" number="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23fd5c4c%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%234c7cfd%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%5D" size="4" move_speed="2"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 2 - classic
	$data = array();
	$data['name'] = esc_html__( 'Carousel 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-2.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel misc';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1606896214665{padding-top: 60px !important;padding-bottom: 40px !important;}" responsive_css="padding_top_medium:90px|padding_bottom_medium:90px"][vc_column][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" pagenationdots="yes" wraparound="yes" dots_bottom_offset="-15px" size_dots="carousel-dots-sm" mobile_dots_position="carousel-dots-mobile-inside" dots_bg_color="rgb(239, 239, 239)" dots_bg_hcolor="rgb(62, 173, 60)"][ld_carousel_section title="Tab" tab_id="lqd-1595436733469-64c80d59-5a3f"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1583837552785{margin-bottom: 35px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_x="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:12px" fw="text_small:600" margin="bottom_small:1em"]Landing Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Personal data protection for tech businesses.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Business Consultation" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check" css=".vc_custom_1595434733716{margin-bottom: 0.5em !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Corporate Financial Advisory" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check"][/ld_icon_box][ld_button style="btn-solid" title="Learn more" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][ld_spacer height="40px" lg_hide="vc_hidden-lg"][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1595348848944{margin-bottom: 35px !important;border-radius: 5px !important;}"][vc_single_image image="162" css=".vc_custom_1595434255206{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436734697-36414a0e-7dc0"][vc_row_inner content_placement="middle"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1583837552785{margin-bottom: 35px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_x="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:12px" fw="text_small:600" margin="bottom_small:1em"]Landing Hub Pro[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Personal data protection for tech businesses.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Business Consultation" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check" css=".vc_custom_1595434733716{margin-bottom: 0.5em !important;}"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-semibold" i_size="xs" position="iconbox-side" title="Corporate Financial Advisory" custom_heading_size="17px" icon_size="23px" i_icon_linea="lqd-icn-ess icon-lqd-check"][/ld_icon_box][ld_button style="btn-solid" title="Explore hub" transformation="text-uppercase" link_type="scroll_to_section" shape="round" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" lh="1.5em" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" hover_color="rgb(59, 59, 59)"][ld_spacer height="70px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg" md_height="0px" lg_height="0px"][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-6" css=".vc_custom_1595348848944{margin-bottom: 35px !important;border-radius: 5px !important;}"][vc_single_image image="145" css=".vc_custom_1595435228458{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 3 - classic
	$data = array();
	$data['name'] = esc_html__( 'Carousel 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-3.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel misc';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1606896290931{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f9f9f9 !important;}" responsive_css="padding_top_medium:90px|padding_bottom_medium:100px|padding_top_small:60px|padding_bottom_small:60px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1606208905051{margin-bottom: 60px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22Solutions%22%7D%2C%7B%22word%22%3A%22Advisory%22%7D%2C%7B%22word%22%3A%22Platforms%22%7D%5D" margin="bottom_small:0.4em"]Smart Business[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:30px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][/vc_column][vc_column][ld_carousel_tab columns="md:3|xs:1|spacing_md:23px|spacing_xs:15px" inactiv_opacity="1" pagenationdots="yes" wraparound="yes" dots_bottom_offset="-15px" size_dots="carousel-dots-sm" dots_bg_color="rgba(0, 0, 0, 0.1)" dots_bg_hcolor="rgb(62, 173, 60)"][ld_carousel_section title="Tab" tab_id="lqd-1595436846536-a4b426d5-3199"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="183" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501903417{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Business Consultation[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436847701-7a20ddd5-8d28"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="184" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501911919{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Financial Advisory[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347659412-b71932b0-5394"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="182" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501925705{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Platform Investments[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436845811-0c08bbc1-d269"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-center"][vc_single_image image="187" style="vc_box_rounded" onclick="custom_link" img_link_target="_blank" css=".vc_custom_1595501919777{border-radius: 5px !important;}"][ld_fancy_heading tag="h3" tag_to_inherite="h5" use_custom_fonts_title="true" use_inheritance="true" margin="bottom_small:0.6em"]Business Consultation[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub IT allows your business and technology computers to store, transmit and analyze. [/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 4 - classic
	$data = array();
	$data['name'] = esc_html__( 'Carousel 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-4.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1608208821057{padding-top: 55px !important;padding-bottom: 30px !important;}"][vc_column][ld_carousel_tab columns="xs:1|spacing_xs:0px" inactiv_opacity="1" cellalign="center" prevnextbuttons="yes" wraparound="yes" adaptiveheight="yes" fadeeffect="yes" autoplay="yes" navarrow="4" navsize="carousel-nav-lg" navfill="carousel-nav-solid" navshape="carousel-nav-square" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" mobile_dots_position="carousel-dots-mobile-inside" nav_arrow_color="rgb(0, 0, 0)" nav_bg_color="rgb(255, 255, 255)" autoplaytime="3000" mobile_dots_bg_color="rgba(255, 255, 255, 0.4)" mobile_dots_bg_hcolor="rgb(255, 255, 255)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1608208615375-86b0277c-bc6b"][vc_single_image image="3476" css=".vc_custom_1608208750206{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608208796091-c88e5950-eb37"][vc_single_image image="3453" css=".vc_custom_1611324461165{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608208793192-7fcdfd6f-89b2"][vc_single_image image="261" css=".vc_custom_1611324666304{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 5 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-5.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1610714622209{padding-top: 80px !important;padding-bottom: 20px !important;background-color: #23261b !important;}"][vc_column align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" fadeeffect="yes" navarrow="6" navsize="carousel-nav-lg" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" nav_arrow_color="rgb(255, 255, 255)" nav_arrow_color_hover="rgba(255, 255, 255, 0.6)" prevoffset="-12%" nextoffset="-12%" mobile_dots_bg_color="rgba(255, 255, 255, 0.6)" mobile_dots_bg_hcolor="rgb(255, 255, 255)"][ld_carousel_section title="Tab" tab_id="lqd-1595925595009-fe57db21-b7e8"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(250, 242, 220)" fs="text_small:18px" lh="text_small:1.22em"]"Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition. It's simply the best product i've ever used!"[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1612365055707-c5511143-aaaa"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(250, 242, 220)" fs="text_small:18px" lh="text_small:1.22em"]"Hub offers a range of skincare products that are feminine, delicate and ltricies eget, tempor sit amet, ante. Pellentesque habitant morbi tristique senectus et netus et malesuada.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1612365055168-b39b35bf-548c"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(250, 242, 220)" fs="text_small:18px" lh="text_small:1.22em"]"Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition. It's simply the best product i've ever used!"[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column][ld_spacer height="60px"][/vc_column][vc_column width="1/3" align="text-center" responsive_align="text-md-left" css=".vc_custom_1603288732328{margin-bottom: 35px !important;}" offset="vc_col-xs-4"][vc_single_image image="31" image_max_width="131px"][/vc_column][vc_column width="1/3" align="text-center" css=".vc_custom_1603288740656{margin-bottom: 35px !important;}" responsive_align="text-center" offset="vc_col-xs-4"][vc_single_image image="32" image_max_width="131px"][/vc_column][vc_column width="1/3" align="text-center" responsive_align="text-md-right" css=".vc_custom_1603288747454{margin-bottom: 35px !important;}" offset="vc_col-xs-4"][vc_single_image image="33" image_max_width="131px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 6 - retailshop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-6.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1616594964840{padding-right: 5px !important;padding-bottom: 30px !important;padding-left: 5px !important;}" responsive_css="padding_top_medium:20px|padding_right_medium:0px|padding_left_medium:0px|padding_right_small:25px|padding_left_small:25px" el_id="carousel"][vc_column][ld_carousel_tab columns="md:3|sm:2|xs:1.25|spacing_md:18px|spacing_sm:10px|spacing_xs:5px" inactiv_opacity="1" cellalign="center" prevnextbuttons="yes" groupcells="no" wraparound="yes" equalheightcells="yes" autoplay="yes" navarrow="6" navsize="carousel-nav-lg" navfill="carousel-nav-solid" navshape="carousel-nav-circle" navshadow="carousel-nav-shadowed-onhover" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" nav_arrow_color="rgb(0, 0, 0)" nav_arrow_color_hover="rgb(255, 255, 255)" nav_bg_color="rgb(255, 255, 255)" nav_bg_hcolor="rgb(0, 0, 0)" prevoffset="-10px" nextoffset="-10px"][ld_carousel_section title="Tab" tab_id="lqd-1594307211142-82b0190a-7598"][vc_row_inner row_scale_bg_onhover="yes" bg_position="center center" enable_overlay="yes" css=".vc_custom_1611133352531{padding-top: 35px !important;padding-bottom: 30px !important;background-image: url(https://retailpro.liquid-themes.com/wp-content/uploads/2020/05/bg-3@2x.jpg?id=116) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" hover_overlay_bg="rgba(0, 0, 0, 0.38)" responsive_css="padding_right_small:30px|padding_left_small:30px"][vc_column_inner enable_link="enable_column_link" width="3/4" link="url:https%3A%2F%2Fretailpro.liquid-themes.com%2Fproduct-category%2Fclothing%2F|||"][ld_fancy_heading tag="h2" tag_to_inherite="h4" use_inheritance="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]PlayStation 4 VR has arrived.[/ld_fancy_heading][ld_button style="btn-default" title="Shop Watches" shape="circle" size="btn-sm" border="border-thick" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="15px" lh="1.15em"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594307218857-88e81458-8e67"][vc_row_inner row_scale_bg_onhover="yes" bg_position="center center" enable_overlay="yes" css=".vc_custom_1611133307117{padding-top: 35px !important;padding-bottom: 30px !important;background-image: url(https://retailpro.liquid-themes.com/wp-content/uploads/2020/05/bg-4@2x.jpg?id=117) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" hover_overlay_bg="linear-gradient(295deg, rgba(101, 121, 155, 0.5) 0%, rgb(94, 37, 99) 99.36305732484077%)" responsive_css="padding_right_small:30px|padding_left_small:30px"][vc_column_inner enable_link="enable_column_link" width="2/3" offset="vc_col-lg-6 vc_col-md-7" link="url:https%3A%2F%2Fretailpro.liquid-themes.com%2Fproduct-category%2Fclothing%2F|||"][ld_fancy_heading tag="h2" tag_to_inherite="h4" use_inheritance="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]Galaxy S20 Series.[/ld_fancy_heading][ld_button style="btn-default" title="See Products" shape="circle" size="btn-sm" border="border-thick" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="15px" lh="1.15em"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594307114211-5cf2060a-9d6c"][vc_row_inner row_scale_bg_onhover="yes" bg_position="center center" enable_overlay="yes" css=".vc_custom_1611133324493{padding-top: 35px !important;padding-bottom: 30px !important;background-image: url(https://retailpro.liquid-themes.com/wp-content/uploads/2020/05/bg-2@2x.jpg?id=115) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" hover_overlay_bg="linear-gradient(65deg, rgb(245, 78, 162) 0%, rgba(255, 118, 118, 0.5) 100%)" responsive_css="padding_right_small:30px|padding_left_small:30px"][vc_column_inner enable_link="enable_column_link" width="3/4" offset="vc_col-lg-9 vc_col-md-10" link="url:https%3A%2F%2Fretailpro.liquid-themes.com%2Fproduct-category%2Fclothing%2F|||"][ld_fancy_heading tag="h2" tag_to_inherite="h4" use_inheritance="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]Chanel Gabriele Perfume.[/ld_fancy_heading][ld_button style="btn-default" title="See Products" shape="circle" size="btn-sm" border="border-thick" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="15px" lh="1.15em"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1596536460916-3f801a8d-2b98"][vc_row_inner row_scale_bg_onhover="yes" bg_position="center center" enable_overlay="yes" css=".vc_custom_1611133337170{padding-top: 35px !important;padding-bottom: 30px !important;background-image: url(https://retailpro.liquid-themes.com/wp-content/uploads/2020/09/shop-carousel-5@2x.jpg?id=369) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 5px !important;}" hover_overlay_bg="linear-gradient(295deg, rgba(101, 121, 155, 0.5) 0%, rgb(94, 37, 99) 99.36305732484077%)" responsive_css="padding_right_small:30px|padding_left_small:30px"][vc_column_inner enable_link="enable_column_link" width="2/3" offset="vc_col-md-6" link="url:https%3A%2F%2Fretailpro.liquid-themes.com%2Fproduct-category%2Fclothing%2F|||"][ld_fancy_heading tag="h2" tag_to_inherite="h4" use_inheritance="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]Women’s Lookbook[/ld_fancy_heading][ld_button style="btn-default" title="See Products" shape="circle" size="btn-sm" border="border-thick" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)" text_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" fs="15px" lh="1.15em"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 7 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-7.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1602665216151{margin-top: 60px !important;padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f0f1f7 !important;}" responsive_css="margin_top_medium:60px|margin_bottom_medium:60px|padding_top_medium:100px|padding_bottom_medium:100px"][vc_column][ld_carousel_gallery images="86,87,88,89,90,227,228,226"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 8 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-8.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1605616478180{padding-bottom: 60px !important;}"][vc_column][ld_carousel_marquee_tab columns="md:4.25|sm:2.9|xs:1.5|spacing_md:50px|spacing_xs:2%25" pause_on_hover="yes" randomveroffset="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434166403-376bd1f6-e3bd"][vc_single_image image="56" css=".vc_custom_1600434720760{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434294047-e8e3297a-ecf8"][vc_single_image image="58" css=".vc_custom_1600434728358{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434315298-8ffdba0e-bdb9"][vc_single_image image="59" css=".vc_custom_1600434737821{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434339502-e71d2cda-694b"][vc_single_image image="4313" css=".vc_custom_1600434747987{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434392281-5839817b-a5de"][vc_single_image image="57" css=".vc_custom_1600434759523{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434420928-b13c76de-d2ed"][vc_single_image image="56" css=".vc_custom_1600434767214{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434440973-4835951d-d1fa"][vc_single_image image="4314" css=".vc_custom_1600434775295{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434469640-f8476374-692b"][vc_single_image image="4311" css=".vc_custom_1600434783500{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 9 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-9.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" luminosity="dark" responsive_css="margin_right_large:16%25|margin_right_medium:8%25|margin_bottom_medium:80px"][vc_column][ld_slideshow_2 height="700px" overlay_bg="rgba(0, 0, 0, 0.3)"][ld_slideshow_section title="Interior Design" image="4306"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:81px|text_small:40px" lh="text_small:1.15em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][ld_slideshow_section title="Construction" image="4263"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:81px|text_small:40px" lh="text_small:0.96em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][ld_slideshow_section title="Residential" image="4445"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:80px|text_small:40px" lh="text_small:0.96em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][ld_slideshow_section title="City planning" image="4260"][ld_fancy_heading tag="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" color="rgb(255, 255, 255)" margin="bottom_small:1.5em"]— Latest projects[/ld_fancy_heading][ld_fancy_heading tag="h3" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:80px|text_small:40px" lh="text_small:0.96em"]Building the<br />
city marks[/ld_fancy_heading][/ld_slideshow_section][/ld_slideshow_2][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 10 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-10.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:50px|padding_bottom_medium:120px" css=".vc_custom_1622103240889{padding-top: 35px !important;padding-bottom: 70px !important;}" el_id="case-studies"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:47px" margin="bottom_large:0px"]Practice Areas[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.47em"]We embrace holistic development and support for the aim of being a first-choice employer within our sectors.[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1622034472426{padding-top: 50px !important;}"][ld_carousel_tab columns="md:3|sm:2|xs:1|spacing_xs:20px" inactiv_opacity="1" pagenationdots="yes" groupcells="no" wraparound="yes" dots_style="carousel-dots-style4" dots_bg_color="rgb(225, 225, 225)" dots_bg_hcolor="rgb(87, 87, 87)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034411038-85a52ec4-8a1d"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Immigration Issues" image="31" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034751456-c0483566-f77d"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Intellectual Property" image="93" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034782334-be933597-a3f9"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Citizenship" image="30" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034819526-4fd41faa-c7ab"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Intellectual Property" image="29" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 11 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-11.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1610005427022{padding-bottom: 60px !important;}" responsive_css="padding_bottom_medium:120px"][vc_column][ld_carousel_tab columns="md:3.75|sm:2|xs:1|spacing_xs:3%25" inactiv_opacity="1" pagenationdots="yes" groupcells="no" wraparound="yes" randomveroffset="yes" dots_type="numbers" number_style="line" align_dots="carousel-dots-center" dots_right_offset="0px" dots_bottom_offset="-90px" dots_left_offset="0px" mobile_dots_bottom_offset_outside="0px"][ld_carousel_section title="Carousel Item" tab_id="lqd-1609928485321-d1763d38-7178"][vc_single_image image="4393"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1609928485322-7a2f67e5-9e30"][vc_single_image image="4396"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1609928485322-4116baff-12d7"][vc_single_image image="4395"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1609928668158-0a01a229-5bed"][vc_single_image image="4394"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1609929187099-4bd71f45-1420"][vc_single_image image="4399"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 12 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-12.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="center center" responsive_css="padding_top_medium:100px|padding_bottom_medium:150px" css=".vc_custom_1605894339565{padding-bottom: 60px !important;background-image: url(https://multiusepro.liquid-themes.com/wp-content/uploads/2020/01/map.jpg?id=62) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_images_group_container enable_item_animation="yes" move_to_parent_row="yes" pf_init_scale_x="0.3" pf_init_scale_y="0.3" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" absolute_pos="yes" pf_duration="1800" pf_delay="180" pf_init_translate_y="36" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px"][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="50em" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="107" position="bottom_small:32vh|left_small:5vw" translate_from_y="90" translate_to_y="-140"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="50em" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="108" position="bottom_small:18vh|left_small:15vw" translate_from_y="60" translate_to_y="-85"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="50em" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="109" position="bottom_small:40vh|left_small:20vw" translate_from_y="90" translate_to_y="-200"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="50em" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="111" position="right_small:3vw|bottom_small:30vh" translate_from_y="90" translate_to_y="-140"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="50em" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="110" position="right_small:13vw|bottom_small:20vh" translate_from_y="40" translate_to_y="-50"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="50em" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="112" position="right_small:12vw|bottom_small:35vh" translate_from_y="40" translate_to_y="-120"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1607345746700{margin-bottom: 70px !important;}" responsive_align="text-md-center"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]What we achieved[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" duration="1000" delay="120" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" minfontsize="40" fs="text_large:48px|text_small:40px" ca_init_translate_y="70"]Don't just take our word for it[/ld_fancy_heading][/vc_column][vc_column align="text-center" offset="vc_col-md-offset-1 vc_col-md-10" responsive_align="text-md-center"][ld_images_group_element parallax="yes" scale_from_x="0.8" scale_from_y="0.8" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="64" position="top_small:-10%25|left_small:35%25" translate_from_y="20" translate_to_y="-190"][/ld_images_group_element][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" pagenationdots="yes" wraparound="yes" dots_right_offset="0" dots_bottom_offset="-20px" dots_left_offset="0" size_dots="carousel-dots-custom" dotscustomsize="30px" dotscustomsize_height="2px" dots_bg_color="rgba(6, 61, 174, 0.2)" dots_bg_hcolor="rgb(1, 209, 50)"][ld_carousel_section title="Tab" tab_id="lqd-1595668633656-4131b1cf-5a17"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-md-center"][vc_single_image image="63" img_size="95x95" alignment="center" style="vc_box_border_circle" border_color="white"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:1.53em" margin="bottom_small:1.5em"]“Greatest appreciation to you &amp; your team for the awesome and outstanding job you did for us. The website is just what we wanted, and we were thrilled with the speed your team exercised. We feel privileged to have Hub Coporation as our online marketing partner!”[/ld_fancy_heading][ld_fancy_heading tag="h4" tag_to_inherite="h6" use_inheritance="true" color="rgb(0, 0, 0)"]Rochus Sabah, CEO &amp; Co-Founder[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1599660131503-c223b229-c189"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-md-center"][vc_single_image image="110" img_size="95x95" alignment="center" style="vc_box_border_circle" border_color="white"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:1.53em" margin="bottom_small:1.5em"]“Greatest appreciation to you &amp; your team for the awesome and outstanding job you did for us. The website is just what we wanted, and we were thrilled with the speed your team exercised. We feel privileged to have Hub Coporation as our online marketing partner!”[/ld_fancy_heading][ld_fancy_heading tag="h4" tag_to_inherite="h6" use_inheritance="true" color="rgb(0, 0, 0)"]Rochus Sabah, CEO &amp; Co-Founder[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1599660130278-a39e322f-2278"][vc_row_inner][vc_column_inner align="text-center" responsive_align="text-md-center"][vc_single_image image="63" img_size="95x95" alignment="center" style="vc_box_border_circle" border_color="white"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:1.53em" margin="bottom_small:1.5em"]“Greatest appreciation to you &amp; your team for the awesome and outstanding job you did for us. The website is just what we wanted, and we were thrilled with the speed your team exercised. We feel privileged to have Hub Coporation as our online marketing partner!”[/ld_fancy_heading][ld_fancy_heading tag="h4" tag_to_inherite="h6" use_inheritance="true" color="rgb(0, 0, 0)"]Rochus Sabah, CEO &amp; Co-Founder[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 13 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-13.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" responsive_css="padding_bottom_medium:55px" css=".vc_custom_1610196192443{padding-top: 5px !important;padding-bottom: 30px !important;}"][vc_column][ld_slideshow columns="md:4|sm:3|xs:2|spacing_xs:0px" identities="%5B%7B%22title%22%3A%22Innovative%20Solutions%22%2C%22image%22%3A%228908%22%2C%22url%22%3A%22%23%22%2C%22btn_label%22%3A%22Learn%20more%22%7D%2C%7B%22title%22%3A%22Trusted%20Experience%22%2C%22image%22%3A%228907%22%2C%22url%22%3A%22%23%22%2C%22btn_label%22%3A%22Learn%20more%22%7D%2C%7B%22title%22%3A%22Digital%20Solutions%22%2C%22image%22%3A%228909%22%2C%22url%22%3A%22%23%22%2C%22btn_label%22%3A%22Learn%20more%22%7D%2C%7B%22title%22%3A%22Global%20Partners%22%2C%22image%22%3A%228910%22%2C%22url%22%3A%22%23%22%2C%22btn_label%22%3A%22Learn%20more%22%7D%2C%7B%22title%22%3A%22IT%20Consultancy%22%2C%22image%22%3A%228911%22%2C%22url%22%3A%22%23%22%2C%22btn_label%22%3A%22Learn%20more%22%7D%2C%7B%22title%22%3A%22Business%20Consultation%22%2C%22image%22%3A%228912%22%2C%22url%22%3A%22%23%22%2C%22btn_label%22%3A%22Learn%20more%22%7D%5D" overlay_bg="rgba(0, 0, 0, 0.3)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 14 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-14.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1611248305657{padding-top: 20px !important;padding-bottom: 20px !important;}"][vc_column offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" responsive_css="padding_right_large:6%25|padding_left_large:6%25" css=".vc_custom_1611248686536{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="0.15em" use_custom_fonts_title="true" fs="text_small:42px" highlight_color="rgba(177, 204, 255, 0.35)"]Available on [ld_highlight]iOS.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.5em" padding="right_all:10%25|left_all:10%25" color="rgb(121, 121, 121)"]Open a beautiful store, increase your conversion rates and boost your sales in minutes with object-oriented UX.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" el_id="overview"][vc_column][ld_carousel_tab columns="sm:1.5|xs:1.15|spacing_xs:2%25" inactiv_opacity="1" cellalign="center" wraparound="yes"][ld_carousel_section title="Carousel Item" tab_id="lqd-1611248400277-455c40be-4e57"][vc_single_image image="1070" alignment="center" css=".vc_custom_1615556810191{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1615556815059-da49c2ad-063d"][vc_single_image image="1070" alignment="center" css=".vc_custom_1615556810191{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1615556814640-3dd376e0-a3a7"][vc_single_image image="1070" alignment="center" css=".vc_custom_1615556810191{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1615556814270-260c5b02-04c1"][vc_single_image image="1070" alignment="center" css=".vc_custom_1615556810191{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row][vc_row equal_height="yes" content_placement="middle" responsive_css="padding_top_medium:120px|padding_top_small:80px|padding_bottom_small:30px" css=".vc_custom_1614342255674{padding-top: 60px !important;padding-bottom: 15px !important;}"][vc_column offset="vc_col-md-5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1611315213533{margin-bottom: 20px !important;}"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]<a href="https://saaspro.liquid-themes.com/wp-content/uploads/2021/01/Group-32402.svg"><img class="alignnone size-medium wp-image-964" src="https://saaspro.liquid-themes.com/wp-content/uploads/2021/01/Group-32402.svg" alt="" width="110" height="19" /></a>  Next Generation[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="0.15em" use_custom_fonts_title="true" fs="text_medium:51px|text_small:11vw" highlight_color="rgba(177, 204, 255, 0.35)" margin="bottom_small:0.35em"]Track your daily [ld_highlight]activity.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.47em"]The latest design trends meet hand-crafted templates in Hub Collection. Use pre-built sections to speed up your design process.[/ld_fancy_heading][/vc_column][vc_column responsive_css="padding_left_large:6%25" offset="vc_col-md-7"][ld_images_group_element enable_hover3d="yes" image="970"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 15 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-15.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="left center" css=".vc_custom_1615296732210{padding-top: 80px !important;padding-bottom: 60px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:190px|padding_bottom_medium:75px"][vc_column offset="vc_col-md-5"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" el_id="imagecarousel"][ld_carousel_section title="Carousel Item" tab_id="lqd-1600252282304-a8c70604-d900"][vc_single_image image="4768" css=".vc_custom_1610979853260{border-radius: 5px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1600252282452-a023f235-8281"][vc_single_image image="4354" css=".vc_custom_1600252738454{border-radius: 5px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1600252282579-796a9db6-b27b"][vc_single_image image="4768" css=".vc_custom_1614708765444{border-radius: 5px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" adaptiveheight="yes" navarrow="6" navsize="carousel-nav-lg" navfill="carousel-nav-solid" navshape="carousel-nav-circle" navshadow="carousel-nav-shadowed-onhover" nav_arrow_color="rgb(2, 33, 82)" nav_arrow_color_hover="rgb(255, 255, 255)" controllingcarousels="#imagecarousel"][ld_carousel_section title="Carousel Item" tab_id="lqd-1600252289383-2383b595-a791"][vc_row_inner css=".vc_custom_1572343240749{margin-bottom: 60px !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_init_translate_y="45"][ld_fancy_heading tag="h5" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" fs="text_small:12px" margin="bottom_small:2em" fw="text_small:700" ls="text_small:0.13em" color="rgb(230, 81, 46)" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(255, 239, 227)"]CREATIVE SOLUTIONS[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_animation="lqd-highlight-grow-bottom" highlight_offset="4px" duration="1600" delay="160" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" highlight_color="rgb(211, 255, 248)" fs="text_small:52px" lh="text_small:1.2em" padding="right_large:15%25" ca_init_translate_y="0"]Marketing at [ld_highlight]Facebook[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" duration="1600" delay="160" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:20px" lh="text_small:34px" start_delay="200" ca_init_translate_y="0"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore Advertising" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" color="rgb(14, 82, 74)" hover_color="rgb(0, 0, 0)" i_size="20px" css=".vc_custom_1611039414143{margin-top: 20px !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1600252289530-ea17f851-bd12"][vc_row_inner css=".vc_custom_1572343240749{margin-bottom: 60px !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_init_translate_y="45"][ld_fancy_heading tag="h2" highlight_offset="4px" duration="1600" delay="160" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" highlight_color="rgb(211, 255, 248)" fs="text_small:52px" lh="text_small:1.2em" padding="right_large:15%25" ca_init_translate_y="0"]Marketing at Facebook[/ld_fancy_heading][ld_fancy_heading tag="p" duration="1600" delay="160" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:20px" lh="text_small:34px" start_delay="200" ca_init_translate_y="0"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore Advertising" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" color="rgb(14, 82, 74)" hover_color="rgb(0, 0, 0)" i_size="20px" css=".vc_custom_1611039693450{margin-top: 20px !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1600252289665-a5c38731-fcd6"][vc_row_inner css=".vc_custom_1572343240749{margin-bottom: 60px !important;}"][vc_column_inner enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_init_translate_y="45"][ld_fancy_heading tag="h2" highlight_offset="4px" duration="1600" delay="160" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" highlight_color="rgb(211, 255, 248)" fs="text_small:52px" lh="text_small:1.2em" padding="right_large:15%25" ca_init_translate_y="0"]Marketing at Facebook[/ld_fancy_heading][ld_fancy_heading tag="p" duration="1600" delay="160" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:20px" lh="text_small:34px" start_delay="200" ca_init_translate_y="0"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore Advertising" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" color="rgb(14, 82, 74)" hover_color="rgb(0, 0, 0)" i_size="20px" css=".vc_custom_1611039719492{margin-top: 20px !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 16 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-16.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Carousel 17 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-17.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="bottom" enable_gradient="yes" enable_row_dividers="yes" css=".vc_custom_1615552552691{padding-top: 80px !important;padding-bottom: 40px !important;background-color: #122339 !important;}" responsive_css="margin_top_medium:50px|margin_bottom_medium:50px|padding_top_medium:110px|padding_bottom_medium:0px" gradient_bg="linear-gradient(295deg, rgb(59,65,87) 0.3184713375796178%, rgb(50,51,74) 51.366487733877385%, rgb(64, 74, 99) 99.36305732484077%)" el_id="explore" row_svg_divider="top_shape_type:14|top_shape_color:%23ffffff|top_shape_height:56|bottom_shape_type:12|bottom_shape_color:%23ffffff|bottom_shape_height:54"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-4" responsive_css="margin_bottom_medium:180px|padding_right_medium:15px|padding_left_medium:15px" css=".vc_custom_1605398444640{margin-bottom: 45px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" fs="text_small:13px" ls="text_small:0.05em" margin="bottom_small:1.75em" fh_bg="rgba(0, 0, 0, 0.11)" padding="top_small:6px|right_small:13px|bottom_small:6px|left_small:13px" color="rgb(255, 255, 255)"]Explore new places[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_small:0.3em" color="rgb(255, 255, 255)" padding="right_all:10%25" fs="text_large:39px|text_small:32px"]Travel and Discover[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:30px" margin="bottom_small:1.5em" padding="right_large:18%25" color="rgba(255, 255, 255, 0.9)"]WooCommerce. Hub provides all the tools you need to start selling online.[/ld_fancy_heading][ld_button style="btn-solid" title="Get started" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="16px" css=".vc_custom_1614328638081{padding-right: 0.75em !important;padding-left: 0.75em !important;}" color="rgba(0, 0, 0, 0.27)" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" i_margin_left="15px"][/vc_column][vc_column width="5/12" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-sm-offset-0 vc_col-xs-offset-2 vc_col-xs-8" responsive_css="margin_bottom_medium:-110px"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" el_id="mobile-carousel"][ld_carousel_section title="Carousel Item" tab_id="lqd-1610629144508-a3955598-06cb"][vc_single_image image="127"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1599141772807-23e2341c-40ef"][vc_single_image image="125"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1599141772942-cb894e74-f595"][vc_single_image image="49"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1610629149400-5a675e39-b2bb"][vc_single_image image="128"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1599141772651-89308042-67b8"][vc_single_image image="127"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1599141776504-c7c1b36a-6419"][vc_single_image image="49"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column width="7/12" offset="vc_col-md-4" responsive_css="margin_bottom_medium:200px|padding_right_medium:15px|padding_left_medium:15px" css=".vc_custom_1573390261312{margin-bottom: 45px !important;}"][vc_row_inner css=".vc_custom_1573118821882{margin-bottom: 50px !important;}"][vc_column_inner el_id="carousel-nav-container"][/vc_column_inner][/vc_row_inner][ld_carousel_tab columns="md:1|xs:1|spacing_xs:15px" inactiv_opacity="1" enable_item_animation="yes" prevnextbuttons="yes" fullwidthside="yes" groupcells="no" navarrow="6" navappend="custom_id" navsize="carousel-nav-xl" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" navappend_id="#carousel-nav-container" nav_arrow_color="rgb(255, 255, 255)" nav_bg_hcolor="rgb(255, 255, 255)" pf_duration="1800" pf_start_delay="600" pf_delay="80" pf_init_translate_x="35" pf_init_translate_y="0" controllingcarousels="#mobile-carousel" nav_border_color="rgba(255, 255, 255, 0.28)" nav_border_hcolor="rgb(255, 255, 255)" nav_arrow_color_hover="rgb(0, 0, 0)" mobile_dots_bg_color="rgba(255, 255, 255, 0.75)" mobile_dots_bg_hcolor="rgb(255, 255, 255)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1599141846603-9b344608-792a"][ld_fancy_heading tag="h5" margin="bottom_small:1.25em" color="rgb(255, 255, 255)"]One Click Installation[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:16px" lh="text_small:28px"]Hub is extremely light. A rock-solid structure and next-generation technologies deliver the maximum performance with minimum resources.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1599141846736-02ee7d70-6ae7"][ld_fancy_heading tag="h5" margin="bottom_small:1.25em" color="rgb(255, 255, 255)"]Mega Menu Builder[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:16px" lh="text_small:28px"]Hub is extremely light. A rock-solid structure and next-generation technologies deliver the maximum performance with minimum resources.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1599141846857-4f564418-d86c"][ld_fancy_heading tag="h5" margin="bottom_small:1.25em" color="rgb(255, 255, 255)"]WooCommerce[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:16px" lh="text_small:28px"]Hub is extremely light. A rock-solid structure and next-generation technologies deliver the maximum performance with minimum resources.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1610629137241-bcc9d59a-bdcf"][ld_fancy_heading tag="h5" margin="bottom_small:1.25em" color="rgb(255, 255, 255)"]Rock Solid Performance[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="16px" lh="28px"]All in one landing and startup solutions. Endless use-cases that make it highly flexible, adaptable, and scalable for everyone in the community.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1610629135751-206df3cc-5684"][ld_fancy_heading tag="h5" margin="bottom_small:1.25em" color="rgb(255, 255, 255)"]Popup Builder[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:16px" lh="text_small:28px"]Create beautiful pop ups in minutes. Start converting your website visitors into subscribers and customers.[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 18 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-18.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="center center" css=".vc_custom_1614328250330{padding-top: 60px !important;background-image: url(https://mobilepro.liquid-themes.com/wp-content/uploads/2019/11/circles.svg?id=51) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" responsive_css="padding_top_medium:80px|padding_bottom_medium:80px" el_id="testimonials"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_css="margin_bottom_medium:80px" responsive_align="text-center" css=".vc_custom_1605398055025{margin-bottom: 20px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" fs="text_small:13px" ls="text_small:0.05em" margin="bottom_small:1.75em" fh_bg="rgb(228, 230, 255)" padding="top_small:6px|right_small:13px|bottom_small:6px|left_small:13px"]Explore new places[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_type="lqd-highlight-custom-underline" use_custom_fonts_title="true" enable_fit="true" fs="text_large:39px|text_small:32px" compressor="0.7" minfontsize="38"]They enjoy HubApp[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10" css=".vc_custom_1573123868086{margin-bottom: 30px !important;}"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" enable_item_animation="yes" prevnextbuttons="yes" adaptiveheight="yes" navarrow="6" navsize="carousel-nav-xl" navhalign="carousel-nav-center" navfloated="carousel-nav-floated" navvalign="carousel-nav-middle" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" nav_arrow_color="rgb(29, 39, 78)" prevoffset="-10%" nextoffset="-10%" pf_duration="1800" pf_delay="100" pf_init_translate_y="35"][ld_carousel_section title="Carousel Item" tab_id="lqd-1599142005913-0c1d5ef6-5d8e"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-xs-offset-3 vc_col-xs-6" responsive_css="margin_right_medium:0px|margin_bottom_medium:0px|margin_left_medium:0px|margin_right_small:75px|margin_left_small:0px" css=".vc_custom_1573390562319{margin-bottom: -50px !important;margin-left: -70px !important;}"][vc_single_image image="54"][/vc_column_inner][vc_column_inner offset="vc_col-md-7" responsive_css="padding_left_medium:7%25" responsive_align="text-center text-md-left"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:33px" color="rgb(77, 85, 116)" margin="bottom_small:1em"]All in one landing and startup solutions. Endless use-cases that make it highly flexible, adaptable, and scalable for everyone in the community. Focused on providing smart, Route each conversation to the right recipient.[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="15px" color="rgb(29, 39, 78)"]Clarissa Dalloway, Hub CEO[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1599142006163-4945c6c7-ba1d"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-xs-offset-3 vc_col-xs-6" responsive_css="margin_right_medium:0px|margin_bottom_medium:0px|margin_left_medium:0px|margin_right_small:75px|margin_left_small:0px" css=".vc_custom_1573390562319{margin-bottom: -50px !important;margin-left: -70px !important;}"][vc_single_image image="54"][/vc_column_inner][vc_column_inner offset="vc_col-md-7" responsive_css="padding_left_medium:7%25"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:33px" color="rgb(77, 85, 116)" margin="bottom_small:1em"]All in one landing and startup solutions. Endless use-cases that make it highly flexible, adaptable, and scalable for everyone in the community. Focused on providing smart, Route each conversation to the right recipient.[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="15px" color="rgb(29, 39, 78)"]Clarissa Dalloway, Hub CEO[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1599142006327-bbc6db18-0c01"][vc_row_inner][vc_column_inner width="1/2" offset="vc_col-md-offset-0 vc_col-md-4 vc_col-xs-offset-3 vc_col-xs-6" responsive_css="margin_right_medium:0px|margin_bottom_medium:0px|margin_left_medium:0px|margin_right_small:75px|margin_left_small:0px" css=".vc_custom_1573390562319{margin-bottom: -50px !important;margin-left: -70px !important;}"][vc_single_image image="54"][/vc_column_inner][vc_column_inner offset="vc_col-md-7" responsive_css="padding_left_medium:7%25"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:22px" lh="text_small:33px" color="rgb(77, 85, 116)" margin="bottom_small:1em"]All in one landing and startup solutions. Endless use-cases that make it highly flexible, adaptable, and scalable for everyone in the community. Focused on providing smart, Route each conversation to the right recipient.[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="15px" color="rgb(29, 39, 78)"]Clarissa Dalloway, Hub CEO[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 19 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-19.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1614669893026{padding-bottom: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:150px" el_id="businesssolutions"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1614670742369{margin-bottom: 30px !important;}" responsive_align="text-left text-md-center" responsive_css="margin_bottom_medium:70px"][ld_fancy_heading tag="h2"]IT Business Solutions[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.6em" padding="bottom_large:0px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/vc_column][vc_column responsive_css="margin_top_medium:0px"][ld_carousel_tab columns="md:3|sm:2|xs:1.15|spacing_sm:22px|spacing_xs:15px" inactiv_opacity="1" cellalign="center" wraparound="yes"][ld_carousel_section title="Section 1" tab_id="1592381833921-56829c90-f38d"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="IT Security" image="45" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Section 2" tab_id="1592381834026-24319b72-5616"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="For companies" image="46" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="1592381906295-db133a42-c5d6"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="Mobile Data" image="44" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="1592381922832-36d419fc-b64a"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="Mobile Data" image="44" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Buyer through your marketing and sales funnels through the power of real-time conversations and forms.[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 20 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 20', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-20.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1620983472130{padding-top: 20px !important;padding-bottom: 20px !important;}" responsive_css="padding_right_large:12vw|padding_left_large:12vw|padding_top_medium:50px|padding_right_medium:7vw|padding_bottom_medium:50px|padding_left_medium:7vw"][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center text-md-left"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_inheritance="true" counter_mb_checkbox="true" enable_blur="true" count="1m+" fs="51px" lh="1.1em" color="rgb(0, 6, 69)" el_class="mb-0"][ld_images_group_element image="80" margin="bottom_small:10px"][/ld_images_group_element][ld_fancy_heading tag="p" color="rgb(29, 41, 63)" margin="bottom_small:0.25em"]Installations[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(37, 138, 255)" margin="bottom_small:0.25em"]Application Store[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center text-md-left"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_inheritance="true" counter_mb_checkbox="true" enable_blur="true" count="4.98" fs="51px" lh="1.1em" color="rgb(0, 6, 69)" el_class="mb-0"][ld_images_group_element image="80" margin="bottom_small:10px"][/ld_images_group_element][ld_fancy_heading tag="p" color="rgb(29, 41, 63)" margin="bottom_small:0.25em"]The Best Rated App[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(37, 138, 255)" margin="bottom_small:0.25em"]On Play Store[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" responsive_css="padding_top_medium:0px" css=".vc_custom_1607338010924{padding-top: 30px !important;}"][ld_carousel_tab columns="sm:3|xs:2|spacing_xs:6%25" inactiv_opacity="1" groupcells="no" wraparound="yes" autoplay="yes" mobile_dots_bottom_offset_outside="0.75em"][ld_carousel_section title="Tab" tab_id="lqd-1595515496470-f476a47f-849c"][vc_single_image image="252" css=".vc_custom_1610913064974{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516087526-77fd3c05-0c62"][vc_single_image image="250" css=".vc_custom_1610913084440{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516150566-e55e95d9-d8be"][vc_single_image image="251" css=".vc_custom_1610974291183{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516109864-40f2ee70-4236"][vc_single_image image="250" css=".vc_custom_1610974269734{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516118611-8b77e018-dc40"][vc_single_image image="249" css=".vc_custom_1610913025734{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516099239-3985f1b0-c8b7"][vc_single_image image="253" css=".vc_custom_1610913003035{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 21 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 21', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-21.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1605608047098{padding-bottom: 60px !important;}" responsive_css="padding_top_medium:80px|padding_bottom_medium:150px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1607336418520{margin-bottom: 40px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_css="margin_bottom_medium:55px|padding_right_medium:7%25|padding_left_medium:7%25" responsive_align="text-md-center"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22Startups.%22%7D%2C%7B%22word%22%3A%22Digital%20Platforms.%22%7D%2C%7B%22word%22%3A%22Technology%22%7D%5D" use_custom_fonts_title="true" margin="bottom_small:0.35em" fs="text_large:42px|text_small:40px"]Investing in[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:20px|text_small:17px" lh="text_large:34px|text_small:25px"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly.[/ld_fancy_heading][/vc_column][vc_column][ld_carousel_tab columns="md:3|sm:2|xs:1.15|spacing_md:30px|spacing_xs:15px" inactiv_opacity="1" enable_item_animation="yes" cellalign="center" pagenationdots="yes" wraparound="yes" dots_bottom_offset="-60px" dots_style="carousel-dots-style2" mobile_dots_bottom_offset_outside="-0.5em" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1800" pf_delay="180" pf_init_translate_y="45"][ld_carousel_section title="Tab" tab_id="lqd-1610529190454-ea1f16c5-b1b9"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="149" style="vc_box_rounded" css=".vc_custom_1596641224806{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Investing in Digital Companies[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="400"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595324695548-74e3fd47-dacf"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="148" style="vc_box_rounded" css=".vc_custom_1596641258953{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Securing Digital Payment[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="399"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1610529182300-5f911446-06c3"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="147" style="vc_box_rounded" css=".vc_custom_1596641348795{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="20px" margin="bottom_small:1em"]Building the idea of future[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="398"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1610529176041-5b3d9b87-c563"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="148" style="vc_box_rounded" css=".vc_custom_1596641258953{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Securing Digital Payment[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="397"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595253276998-204134b5-b96d"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="149" style="vc_box_rounded" css=".vc_custom_1596641224806{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Investing in Digital Companies[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="396"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595324697368-7ed8aa77-fb0d"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="147" style="vc_box_rounded" css=".vc_custom_1596641348795{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="20px" margin="bottom_small:1em"]Building the idea of future[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="398"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Carousel 22 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Carousel 22', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'carousel-22.jpg' );
	$data['sort_name'] = 'Carousel';
	$data['custom_class'] = 'general carousel client';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" enable_gradient="yes" responsive_css="padding_top_medium:85px|padding_bottom_medium:80px" css=".vc_custom_1622015708223{padding-top: 70px !important;padding-bottom: 70px !important;background-color: #f2f4f5 !important;}" el_id="case-studies" gradient_bg="linear-gradient(180deg, rgb(235, 239, 241) 0%, rgb(255, 255, 255) 100%)"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h2"]Business Insight and strategic vision..[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" responsive_css="padding_right_large:5%25"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(33, 41, 67, 0.8)" fs="text_small:18px" lh="text_small:1.44em"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives careful[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-1" el_id="business-carousel-nav"][/vc_column][vc_column css=".vc_custom_1621852652935{padding-top: 50px !important;}"][ld_carousel_tab columns="md:3|sm:2|xs:1|spacing_xs:10px" inactiv_opacity="1" prevnextbuttons="yes" fullwidthside="yes" groupcells="no" navarrow="custom" navappend="custom_id" navsize="carousel-nav-lg" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" navappend_id="#business-carousel-nav" shapesize="54px" prev="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIybHFkLWljbi1lc3MlMjBpY29uLWlvbi1pb3MtYXJyb3ctYmFjayU1QyUyMiUzRSUzQyUyRmklM0U=" next="#E-8_JTNDaSUyMGNsYXNzJTNEJTVDJTIybHFkLWljbi1lc3MlMjBpY29uLWlvbi1pb3MtYXJyb3ctZm9yd2FyZCU1QyUyMiUzRSUzQyUyRmklM0U="][ld_carousel_section title="Carousel Item" tab_id="lqd-1621852656776-bfb85b8c-3360"][ld_content_box template="s01" use_custom_fonts_title="true" title="Helping companies to build the future" label="Events" fs="24px" fw="700" img_link="url:http%3A%2F%2Fmultipurpose.liquid-themes.com%2Findex.php%2Fservices-2%2F|title:Services||" image="91"]Our process applies techniques from a variety of disciplines, values distinction in detail[/ld_content_box][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1621853132178-9e6d3619-7cbd"][ld_content_box template="s01" use_custom_fonts_title="true" title="Amazing Facilities inside the Building" label="Careers" fs="24px" fw="700" img_link="url:http%3A%2F%2Fmultipurpose.liquid-themes.com%2Findex.php%2Fservices-2%2F|title:Services||" image="92"]Our process applies techniques from a variety of disciplines, values distinction in detail[/ld_content_box][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1621853193746-52fedb4f-41e2"][ld_content_box template="s01" use_custom_fonts_title="true" title="Developing insights that drive impact" label="Events" fs="24px" fw="700" img_link="url:http%3A%2F%2Fmultipurpose.liquid-themes.com%2Findex.php%2Fservices-2%2F|title:Services||" image="93"]Our process applies techniques from a variety of disciplines, values distinction in detail[/ld_content_box][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1621853245199-3eacf8a9-e7d0"][ld_content_box template="s01" use_custom_fonts_title="true" title="Amazing Facilities inside the Campus" label="Careers" fs="24px" fw="700" img_link="url:http%3A%2F%2Fmultipurpose.liquid-themes.com%2Findex.php%2Fservices-2%2F|title:Services||" image="94"]Our process applies techniques from a variety of disciplines, values distinction in detail[/ld_content_box][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1621853372309-8fb88701-4e99"][ld_content_box template="s01" use_custom_fonts_title="true" title="Helping companies to build the future" label="Events" fs="24px" fw="700" img_link="url:http%3A%2F%2Fmultipurpose.liquid-themes.com%2Findex.php%2Fservices-2%2F|title:Services||" image="101"]Our process applies techniques from a variety of disciplines, values distinction in detail[/ld_content_box][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column css=".vc_custom_1621853740828{padding-top: 60px !important;}" responsive_align="text-center"][ld_button style="btn-solid" title="Develop Impactful Stories" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgba(21, 81, 83, 0.07)" text_color="rgb(21, 81, 83)" fs="text_small:16px" i_size="1.25em" i_margin_left="13px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Clients
	//Clients 1
	$data = array();
	$data['name'] = esc_html__( 'Clients 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-1.jpg' );
	$data['sort_name'] = 'Clients, Marquee';
	$data['custom_class'] = 'general clients marquee';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1595425808576{padding-top: 50px !important;padding-bottom: 20px !important;background-color: #fcfaf9 !important;}"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center"][ld_fancy_heading tag="p" color="rgba(29, 39, 78, 0.75)" margin="bottom_small:50px"]Join the 10.000+ companies trusting Hub[/ld_fancy_heading][/vc_column][vc_column align="text-center" responsive_align="text-center"][ld_carousel_marquee_tab columns="md:6|sm:4|xs:3|spacing_md:34px|spacing_xs:20px" fadesides="lqd-fade-sides" draggable="no" pause_on_hover="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600670099986-fda266dc-b13a"][vc_single_image image="8804"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670135306-ec00d2d2-6cd6"][vc_single_image image="8802"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670138255-ecb183c1-d7e6"][vc_single_image image="8801"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670142203-cffe373d-a535"][vc_single_image image="8799"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670145263-0552daf2-f1e0"][vc_single_image image="8800"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670147842-65cbe96c-b157"][vc_single_image image="8798"][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 2
	$data = array();
	$data['name'] = esc_html__( 'Clients 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-2.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1610731000077{border-top-width: 1px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-top-color: #efefef !important;border-top-style: solid !important;}"][vc_column css=".vc_custom_1610701116044{margin-bottom: 30px !important;}" offset="vc_col-md-3"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" ls="text_small:0.1em"]Trusted by global brands[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-8"][vc_row_inner][vc_column_inner width="1/5" css=".vc_custom_1610700678572{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9120" alignment="center" css=".vc_custom_1610730857045{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" css=".vc_custom_1610700690002{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9124" alignment="center" css=".vc_custom_1610730865485{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" css=".vc_custom_1610700701170{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9122" alignment="center" css=".vc_custom_1610730875086{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" responsive_css="margin_bottom_small:0px" css=".vc_custom_1610700458155{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9123" alignment="center" css=".vc_custom_1610730883006{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/5" css=".vc_custom_1610700720672{margin-bottom: 30px !important;}" offset="vc_col-md-1/5 vc_col-xs-6"][vc_single_image image="9121" alignment="center" css=".vc_custom_1610730894187{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 3 - gridportfolio
	$data = array();
	$data['name'] = esc_html__( 'Clients 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-3.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" equal_height="yes" el_id="about" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px" css=".vc_custom_1596327810853{padding-top: 20px !important;padding-bottom: 40px !important;}"][vc_column responsive_align="text-left text-md-center"][ld_fancy_heading tag="h6" alignment="text-center" margin="bottom_small:2.7em" color="rgb(0, 0, 0)"]— I’ve worked with global brands:[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" animation_preset="Fade In" ca_delay="180" css=".vc_custom_1588770973128{background-color: #f3f3f7 !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772265264{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 76px !important;padding-bottom: 77px !important;border-left-color: #dbdbdb !important;border-left-style: solid !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="4146" alignment="center" css=".vc_custom_1610891617674{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772270206{border-top-width: 1px !important;border-right-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="4145" alignment="center" css=".vc_custom_1610891639947{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772275415{border-top-width: 1px !important;border-right-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="3957" alignment="center" css=".vc_custom_1595497357906{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772281264{border-top-width: 1px !important;border-right-width: 1px !important;padding-top: 80px !important;padding-bottom: 72px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;}"][vc_single_image image="3953" alignment="center" css=".vc_custom_1595497361776{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1533036259034{margin-top: -10px !important;}"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" animation_preset="Fade In" ca_delay="180" css=".vc_custom_1588770977062{background-color: #f3f3f7 !important;}"][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772285903{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 82px !important;padding-bottom: 82px !important;border-left-color: #dbdbdb !important;border-left-style: solid !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="3952" alignment="center" css=".vc_custom_1595497379033{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772290644{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 80px !important;padding-bottom: 80px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="3955" alignment="center" css=".vc_custom_1595497375335{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772295464{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 78px !important;padding-bottom: 79px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="4038" alignment="center" css=".vc_custom_1595497370735{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1588772300083{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 76px !important;padding-bottom: 76px !important;border-right-color: #dbdbdb !important;border-right-style: solid !important;border-top-color: #dbdbdb !important;border-top-style: solid !important;border-bottom-color: #dbdbdb !important;border-bottom-style: solid !important;}"][vc_single_image image="3950" alignment="center" css=".vc_custom_1595497366539{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 4 - classic
	$data = array();
	$data['name'] = esc_html__( 'Clients 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-4.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1596326557783{padding-top: 55px !important;padding-bottom: 55px !important;}" row_hide="hidden-xs"][vc_column offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1596325944900{margin-bottom: 35px !important;}" responsive_align="text-xs-center"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="14px" fw="400" margin="bottom_small:1em"]GLOBAL EXPERTS[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-9"][ld_carousel_tab columns="md:5|sm:4|xs:3|spacing_sm:4%25|spacing_xs:3%25" inactiv_opacity="1" wraparound="yes" equalheightcells="yes" middlealigncontent="yes"][ld_carousel_section title="Tab" tab_id="lqd-1595348147795-a5d223c2-99cd"][vc_single_image image="170" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512753938{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595347985125-5118c773-7b5a"][vc_single_image image="3518" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512782879{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595436615090-f639f0f8-79da"][vc_single_image image="172" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512790551{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595502568530-1eb6e334-c01a"][vc_single_image image="3550" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512798013{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595348177750-4c0ed434-b4a4"][vc_single_image image="3519" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512805862{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595348137797-04705869-b534"][vc_single_image image="171" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512815723{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595348167153-50f0755f-ea71"][vc_single_image image="173" alignment="center" enable_opacity="yes" opacity="0.75" css=".vc_custom_1611512822828{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 5 - dark pf
	$data = array();
	$data['name'] = esc_html__( 'Clients 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-5.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1605844997940{padding-bottom: 70px !important;}" responsive_css="padding_top_medium:50px|padding_bottom_medium:220px"][vc_column offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1575033906022{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h5" margin="bottom_small:1em"]Clients[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-9"][ld_carousel_tab columns="md:5|sm:4|xs:3|spacing_sm:50px|spacing_xs:25px" inactiv_opacity="1" enable_item_animation="yes" wraparound="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1"][ld_carousel_section title="Tab" tab_id="lqd-1594635756583-9440a3c2-6d75"][vc_single_image image="4494" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332163643{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635786754-dbc6eed8-e2f1"][vc_single_image image="4492" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332175238{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635790230-f87f18e0-0be8"][vc_single_image image="4491" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332190199{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635793597-d67b304b-a8db"][vc_single_image image="4489" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332203086{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635797036-7a912cd2-511c"][vc_single_image image="4490" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332219968{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1594635800274-4eeddc9b-d34b"][vc_single_image image="4488" enable_opacity="yes" opacity="0.65" css=".vc_custom_1611332267594{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 6 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-6.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1608026193087{padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;}" responsive_css="padding_top_small:50px|padding_bottom_small:50px"][vc_column width="1/2" align="text-center" offset="vc_col-md-3" responsive_align="text-md-left"][ld_fancy_heading tag="h5" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="78" ca_init_rotate_z="7" margin="bottom_small:1em"]Clients[/ld_fancy_heading][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_small:90px|padding_bottom_small:90px" css=".vc_custom_1608025725377{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="225" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025168012{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1608025922593{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="218" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025209217{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_top_medium:1px|border_left_medium:1px|border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167238443{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="224" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025217984{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1606167249830{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_css="border_left_medium:0px|border_left_small:1px|padding_top_small:80px|padding_bottom_small:80px" responsive_align="text-center"][vc_single_image image="217" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025250001{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_small:0px|padding_top_small:90px|padding_bottom_small:90px" css=".vc_custom_1608025757964{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="215" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025242330{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167274508{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="211" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025261402{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167286802{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" fadeeffect="yes" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" mobile_dots_bottom_offset="0" autoplaytime="3800" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595920532443-74056658-209a"][vc_single_image image="212" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025783680{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595920532744-efdf2255-df73"][vc_single_image image="213" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025673969{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:1px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167298395{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="219" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025292406{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_top_medium:1px|border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1608025810148{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" fadeeffect="yes" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" mobile_dots_bottom_offset="0" autoplaytime="5500" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595920417812-eae19c99-abc8"][vc_single_image image="51" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025531321{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595920417962-2c67d1a8-3110"][vc_single_image image="50" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025664057{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 7 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-7.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
[vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle" bg_position="center bottom" css=".vc_custom_1620984793088{margin-bottom: 60px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;background-color: #1a1a21 !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" responsive_css="margin_top_medium:70px|margin_left_medium:100px|padding_top_medium:110px|padding_right_medium:5vw|padding_bottom_medium:110px|padding_left_medium:5vw"][vc_column css=".vc_custom_1587041477333{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:13px" margin="bottom_small:2em"]— Partners[/ld_fancy_heading][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1587041176561{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;}"][vc_single_image image="64" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1596455047070{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1587041967640{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 0px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;}"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" equalheightcells="yes" middlealigncontent="yes" fadeeffect="yes" draggable="no" custom_cursor="disable-cc" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595406386219-6632ecfe-2cae"][vc_single_image image="65" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1607081960588{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595406386340-67127d08-bd0f"][vc_single_image image="4895" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1610963123458{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_small:0px" css=".vc_custom_1587041233981{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;}"][vc_single_image image="4892" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1610963032126{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:0px|border_left_small:1px" css=".vc_custom_1587042222379{border-top-width: 1px !important;border-right-width: 1px !important;border-left-width: 0px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;}"][vc_single_image image="67" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1587041622777{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1587042156633{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 0px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.08) !important;border-bottom-style: solid !important;}" responsive_css="border_bottom_medium:1px|border_left_medium:1px|border_left_small:0px"][vc_single_image image="4893" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1610963041563{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1587042092748{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 0px !important;border-left-width: 0px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.08) !important;border-bottom-style: solid !important;}" responsive_css="border_bottom_small:1px"][vc_single_image image="63" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1587041652709{margin-bottom: 0px !important;}"][/vc_column][vc_column css=".vc_custom_1606157997504{padding-top: 60px !important;}" responsive_css="padding_top_medium:100px"][vc_row_inner][vc_column_inner offset="vc_col-md-5"][/vc_column_inner][vc_column_inner offset="vc_col-md-offset-1 vc_col-md-6"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1587042106062{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.08) !important;border-bottom-style: solid !important;}" responsive_css="border_left_medium:0px"][vc_single_image image="4894" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1610963008678{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:0px" css=".vc_custom_1587041941945{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 0px !important;padding-top: 40px !important;padding-right: 40px !important;padding-bottom: 40px !important;padding-left: 40px !important;border-left-color: rgba(255,255,255,0.08) !important;border-left-style: solid !important;border-right-color: rgba(255,255,255,0.08) !important;border-right-style: solid !important;border-top-color: rgba(255,255,255,0.08) !important;border-top-style: solid !important;border-bottom-color: rgba(255,255,255,0.08) !important;border-bottom-style: solid !important;}"][ld_carousel_tab columns="xs:1|spacing_xs:15px" inactiv_opacity="1" equalheightcells="yes" middlealigncontent="yes" fadeeffect="yes" custom_cursor="disable-cc" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" autoplaytime="3500" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595406357998-54b01fed-07a7"][vc_single_image image="63" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1587041695342{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595406358107-e67fbf03-cb2f"][vc_single_image image="69" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1587041705371{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]CONTENT;
CONTENT;
	$templates[] = $data;

	//Clients 8 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-8.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1621000759678{padding-top: 40px !important;padding-bottom: 30px !important;}" responsive_css="padding_top_medium:100px|padding_right_medium:12vw|padding_bottom_medium:100px|padding_left_medium:12vw"][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341529275{margin-bottom: 15px !important;}"][vc_single_image image="53" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1596795189745{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341519612{margin-bottom: 15px !important;}"][vc_single_image image="50" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405494382{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341541786{margin-bottom: 15px !important;}"][vc_single_image image="54" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405512606{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341548479{margin-bottom: 15px !important;}"][vc_single_image image="56" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405539697{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341555590{margin-bottom: 15px !important;}"][vc_single_image image="51" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1596795213357{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" offset="vc_col-md-2 vc_col-xs-6" css=".vc_custom_1607341562768{margin-bottom: 15px !important;}"][vc_single_image image="55" alignment="center" enable_opacity="yes" opacity="0.4" css=".vc_custom_1588405607034{margin-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 9 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-9.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1621000766613{padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;}" responsive_css="padding_top_small:50px|padding_bottom_small:50px"][vc_column width="1/2" align="text-center" offset="vc_col-md-3" responsive_align="text-md-left"][ld_fancy_heading tag="h5" duration="1600" delay="60" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" ca_init_translate_y="78" ca_init_rotate_z="7" margin="bottom_small:1em"]Clients[/ld_fancy_heading][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_small:90px|padding_bottom_small:90px" css=".vc_custom_1608025725377{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="225" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025168012{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1608025922593{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="218" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025209217{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_top_medium:1px|border_left_medium:1px|border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167238443{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="224" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025217984{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1606167249830{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_css="border_left_medium:0px|border_left_small:1px|padding_top_small:80px|padding_bottom_small:80px" responsive_align="text-center"][vc_single_image image="217" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025250001{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_small:0px|padding_top_small:90px|padding_bottom_small:90px" css=".vc_custom_1608025757964{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="215" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025242330{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167274508{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="211" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025261402{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167286802{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" fadeeffect="yes" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" mobile_dots_bottom_offset="0" autoplaytime="3800" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595920532443-74056658-209a"][vc_single_image image="212" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025783680{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595920532744-efdf2255-df73"][vc_single_image image="213" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025673969{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_left_medium:1px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1606167298395{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="219" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025292406{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" responsive_css="border_top_medium:1px|border_left_small:0px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1608025810148{border-top-width: 0px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-left-color: #262626 !important;border-left-style: solid !important;border-right-color: #262626 !important;border-right-style: solid !important;border-top-color: #262626 !important;border-top-style: solid !important;border-bottom-color: #262626 !important;border-bottom-style: solid !important;}" responsive_align="text-center"][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" fadeeffect="yes" autoplay="yes" mobile_dots_position="carousel-dots-mobile-inside" mobile_dots_bottom_offset="0" autoplaytime="5500" mobile_dots_bg_color="rgba(255, 255, 255, 0)" mobile_dots_bg_hcolor="rgba(255, 255, 255, 0)"][ld_carousel_section title="Tab" tab_id="lqd-1595920417812-eae19c99-abc8"][vc_single_image image="51" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025531321{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595920417962-2c67d1a8-3110"][vc_single_image image="50" enable_opacity="yes" opacity="0.4" css=".vc_custom_1608025664057{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 10 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-10.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1621001372195{border-top-width: 1px !important;padding-top: 40px !important;padding-bottom: 40px !important;border-top-color: #f0f0f0 !important;border-top-style: solid !important;}" responsive_css="margin_top_medium:60px"][vc_column][ld_carousel_marquee_tab columns="md:6|sm:4|xs:3|spacing_xs:5px" cellalign="center" fadesides="lqd-fade-sides" reverse="yes" marquee_speed="1"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869275969-2af5a83e-691d"][vc_single_image image="86" css=".vc_custom_1600869578540{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869581894-1df5449f-86ae"][vc_single_image image="89" css=".vc_custom_1600869594464{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869595467-ec50c9c5-a299"][vc_single_image image="88" css=".vc_custom_1600869608860{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869619216-960b0d0f-15ef"][vc_single_image image="87" css=".vc_custom_1600869646405{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869648981-0550ffa2-b53c"][vc_single_image image="90" css=".vc_custom_1600869662207{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869663953-167bf2b1-dbdf"][vc_single_image image="91" css=".vc_custom_1600869682676{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869684367-6a0c87f8-3df3"][vc_single_image image="88" css=".vc_custom_1600869805735{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 11 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-11.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1605894313726{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f6f9fe !important;}" responsive_css="padding_top_medium:130px|padding_bottom_medium:140px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1607345773487{margin-bottom: 45px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-md-center"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]Who our clients[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" duration="1000" delay="120" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" minfontsize="40" fs="text_large:48px|text_small:40px" ca_init_translate_y="70"]In partnership with top global business organizations.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="1.666em"]From bold start-ups to big names, Nesi Coporation is proud of our clients’s success and passionate about helping them accelerate growth through digital.[/ld_fancy_heading][/vc_column][vc_column][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="73" translate_from_y="90" translate_to_y="-70" position="bottom_small:-60px|left_small:15%25"][/ld_images_group_element][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_row_shadowbox="yes" css=".vc_custom_1579259765527{background-color: #ffffff !important;border-radius: 10px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.05)%22%7D%5D" ca_duration="1800" ca_delay="180"][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900742205{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="66" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872199241{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900752564{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="65" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872216074{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900762849{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="67" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872222914{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900772732{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="68" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872231616{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900782719{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="69" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872238922{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900791718{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="70" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872247250{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900800672{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="71" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872254080{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" align="text-center" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1605900810936{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" responsive_align="text-center"][vc_single_image image="72" enable_opacity="yes" opacity="0.5" css=".vc_custom_1612872261702{margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" css=".vc_custom_1579259713191{margin-top: 65px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" responsive_align="text-center"][ld_button style="btn-solid" title="See more clients" transformation="text-uppercase" shape="circle" enable_row_shadowbox="yes" fs="14px" lh="1.5em" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C207%2C50%2C0.2)%22%7D%5D" hover_button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2225px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(12%2C0%2C0%2C0.1)%22%7D%5D" hover_color="rgb(27, 27, 27)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 12 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-12.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1621601049003{padding-top: 55px !important;padding-bottom: 40px !important;background-color: #f0f7f3 !important;}" responsive_css="padding_bottom_medium:65px"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" css=".vc_custom_1621602396781{margin-bottom: 65px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(9, 64, 72)" fs="text_small:40px" margin="bottom_small:0.35em"]Trusted by global companies[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(10, 37, 51, 0.75)" fs="text_small:18px" lh="text_small:1.27em"]We embrace holistic development and support for employees the aim of being a first-choice employer within our sectors.[/ld_fancy_heading][/vc_column][vc_column][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center"][vc_single_image image="3496" css=".vc_custom_1621600979537{margin-bottom: 25px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center"][vc_single_image image="3497" css=".vc_custom_1621600985509{margin-bottom: 25px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center"][vc_single_image image="3498" css=".vc_custom_1621600992674{margin-bottom: 25px !important;}"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center"][vc_single_image image="3500" css=".vc_custom_1621601001539{margin-bottom: 25px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 13 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-13.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1620986663815{margin-top: 80px !important;margin-bottom: 55px !important;}" responsive_css="margin_right_medium:8vw|margin_left_medium:8vw"][vc_column][ld_carousel_tab columns="md:7|sm:5|xs:3|spacing_sm:3%25|spacing_xs:5%25" inactiv_opacity="1" cellalign="center" equalheightcells="yes" middlealigncontent="yes"][ld_carousel_section title="Tab" tab_id="lqd-1596197780012-3142b785-dee5"][vc_single_image image="281" img_size="119x19"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1596198456212-5bd8b3a0-ac5a"][vc_single_image image="335" img_size="59x42" image_max_width="80%"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1596197780215-4bfc1506-91f4"][vc_single_image image="283" img_size="100x31"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1596198458270-522f721a-4909"][vc_single_image image="280" img_size="120x34"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1596198457566-aef2c34e-248e"][vc_single_image image="333" img_size="60x40" alignment="center" image_max_width="70px"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1596198456903-253a5228-5c6f"][vc_single_image image="285" img_size="85x20"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1596197780114-7d27b51b-4a9b"][vc_single_image image="282" img_size="125x27"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 14 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-14.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Clients 15 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-15.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1605615646869{padding-top: 40px !important;padding-bottom: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs"][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" position="top_small:0px|right_small:55vw|bottom_small:0px|left_small:0px"][ld_images_group_element img_size="50%" absolute_pos="yes" image="4149" position="top_small:-2%25|left_small:5vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4148" position="bottom_small:0px|left_small:4vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4144" position="top_small:35%25|left_small:10vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4146" position="bottom_small:-35px|left_small:15vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4142" position="top_small:0%25|left_small:13vw"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_float_effect="yes" absolute_pos="yes" image="4280" position="top_small:24%25|left_small:20vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4151" position="bottom_small:7%25|left_small:26vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4143" position="top_small:-9%25|left_small:34vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4145" position="top_small:35%25|right_small:2vw"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4147" position="right_small:1vw|bottom_small:-10%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-lowercase" duration="1600" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_bg="yes" fh_border_radius="circle" enable_split="true" margin="bottom_small:0.75em" ca_init_translate_x="0" ca_init_rotate_y="0" ca_init_translate_y="35" color="rgb(255, 90, 61)" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(255, 234, 230)"]Digital Experience[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_animation="lqd-highlight-grow-bottom" highlight_offset="0.1em" use_custom_fonts_title="true" enable_fit="true" fs="text_large:48px|text_small:35px" lh="text_small:1.2em" margin="bottom_small:0.65em" minfontsize="36" highlight_color="rgba(255, 185, 158, 0.53)"]Trusted by top [ld_highlight]global[/ld_highlight] companies And orginizations[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="20px" lh="1.5em" margin="bottom_small:2.5em"]From bold start-ups to big names, Blue Fountain Media is proud of our clients’ success and passionate about helping them accelerate growth through digital.[/ld_fancy_heading][ld_button style="btn-solid" title="Learn more" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" enable_row_shadowbox="yes" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(248%2C85%2C78%2C0.24)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611478747231{margin-bottom: 35px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(51, 106, 234)"][/vc_column][vc_column offset="vc_hidden-lg vc_hidden-md"][vc_single_image image="4187"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 16 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-16.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="center top" enable_row_dividers="yes" css=".vc_custom_1608729633610{padding-top: 120px !important;padding-bottom: 100px !important;background-image: url(https://businessstartuppro.liquid-themes.com/wp-content/uploads/2020/12/bg-1@2x.jpg?id=233) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:140px|padding_bottom_medium:140px" row_svg_divider="bottom_shape_type:8|bottom_shape_color:%23ffffff|bottom_shape_height:61"][vc_column width="1/2" offset="vc_col-md-5" css=".vc_custom_1608729930888{margin-bottom: 20px !important;}" responsive_css="margin_bottom_small:35px"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1600" pf_delay="160" pf_init_translate_x="-35" pf_init_translate_y="35" pf_init_rotate_y="0"][ld_images_group_element absolute_pos="yes" image="237" position="top_small:0px|left_small:0px"][/ld_images_group_element][ld_images_group_element img_size="50%" image="231" margin="top_small:25px|left_small:28px"][ld_button style="btn-solid" title="Play video" link_type="lightbox" shape="circle" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" hover_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" lh="1.1em"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-6 vc_col-md-7" css=".vc_custom_1608729911892{margin-bottom: 70px !important;}" responsive_css="margin_bottom_medium:65px|margin_bottom_small:35px" ca_delay="160" ca_init_translate_y="60" ca_duration="1600" ca_start_delay="450"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em" margin="bottom_small:3em"]Customer stories[/ld_fancy_heading][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_small:68px" lh="text_small:1.1em" fw="text_small:700" ls="text_small:-0.02em" highlight_color="rgba(126, 255, 195, 0.4)" margin="bottom_small:0.25em"]They [ld_highlight]trust[/ld_highlight] Hub. But why?[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:18px" lh="text_small:1.44em" fw="text_small:500" margin="right_large:22%25|bottom_small:2.75em"]Hub IT allows your business and technology computers to store and analyze.[/ld_fancy_heading][ld_button style="btn-naked" title="`{`ld_strong`}`DANIEL CHARLES`{`/ld_strong`}``{`ld_span`}`Netflix Chief Designer`{`/ld_span`}`" link_type="lightbox" i_type="linea" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thicker" i_shape_size="btn-icon-custom-size" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DFXI_-OesT3A%26ab_channel%3DApple|||" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="68px" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)"][/vc_column][vc_column][ld_carousel_tab columns="md:6|sm:4|xs:3|spacing_xs:15px" inactiv_opacity="1" enable_item_animation="yes" groupcells="no" wraparound="yes" equalheightcells="yes" middlealigncontent="yes" autoplay="yes" mobile_dots_bottom_offset_outside="1em" pf_init_scale_x="0.3" pf_init_scale_y="0.3" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1600" pf_start_delay="1000" pf_delay="160" mobile_dots_bg_color="rgba(255, 255, 255, 0.35)" mobile_dots_bg_hcolor="rgb(255, 255, 255)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722795312-3f978e43-4471"][vc_single_image image="240" alignment="center" css=".vc_custom_1608722911038{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608723029108-4269f2d2-09ef"][vc_single_image image="239" alignment="center" css=".vc_custom_1608723005040{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722795312-563e3a31-1736"][vc_single_image image="242" alignment="center" css=".vc_custom_1608722946839{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722795312-4b81f2ed-de44"][vc_single_image image="241" alignment="center" css=".vc_custom_1608722972969{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722993089-e220608a-0b0b"][vc_single_image image="239" alignment="center" css=".vc_custom_1608723005040{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722976821-3fc5d8ee-00fd"][vc_single_image image="243" alignment="center" css=".vc_custom_1608722989439{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608723009463-97570643-55f7"][vc_single_image image="238" alignment="center" css=".vc_custom_1608723023054{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 17 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-17.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1621002151380{padding-top: 15px !important;padding-bottom: 85px !important;}" responsive_css="padding_top_medium:45px|padding_bottom_medium:45px" el_id="testimonials"][vc_column enable_column_shadowbox="yes" css=".vc_custom_1614154485960{margin-top: 85px !important;background-color: #ffffff !important;border-radius: 4px !important;}" offset="vc_col-lg-4 vc_col-md-5" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2223px%22%2C%22blur_radius%22%3A%2255px%22%2C%22shadow_color%22%3A%22rgba(19%2C%2030%2C%2056%2C%200.05)%22%7D%5D"][vc_row_inner enable_content_animation="yes" equal_height="yes" content_placement="middle" gap="0" animation_preset="Fade In" ca_duration="1800" ca_delay="80"][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(254, 249, 246)" css=".vc_custom_1589206754553{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="416" alignment="center" image_max_width="95px" css=".vc_custom_1610970609510{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(246, 254, 247)" css=".vc_custom_1589206742447{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="421" alignment="center" image_max_width="80px" css=".vc_custom_1610970900464{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(243, 243, 248)" css=".vc_custom_1589359018360{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="418" alignment="center" image_max_width="105px" css=".vc_custom_1610970636157{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(246, 252, 254)" css=".vc_custom_1573385372520{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="419" alignment="center" image_max_width="115px" css=".vc_custom_1610970649432{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(250, 246, 254)" css=".vc_custom_1589206775026{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="427" alignment="center" image_max_width="95px" css=".vc_custom_1611581046810{margin-bottom: 0px !important;}"][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" hover_overlay_bg="rgb(252, 254, 246)" css=".vc_custom_1589206782722{padding-top: 60px !important;padding-right: 25px !important;padding-bottom: 60px !important;padding-left: 25px !important;}" overlay_bg="rgb(255, 255, 255)" offset="vc_col-xs-6" responsive_css="padding_right_medium:15px|padding_left_medium:15px"][vc_single_image image="426" alignment="center" css=".vc_custom_1611581061011{margin-bottom: 0px !important;}" image_max_width="105px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_ontablet="yes" column_top_onmobile="yes" bg_position="left top" offset="vc_col-lg-8 vc_col-md-7" responsive_css="padding_top_medium:80px|padding_left_medium:8.5%25" css=".vc_custom_1610105371336{padding-top: 15px !important;background-image: url(https://marketinghub.liquid-themes.com/staging/wp-content/uploads/2019/11/world.png?id=5822) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h2"]Hear from our happy clients<span style="font-family: Playfair Display, palatino, serif; font-weight: bold;"><em>.</em></span>[/ld_fancy_heading][ld_carousel_tab columns="xs:1" inactiv_opacity="1" cellalign="center" prevnextbuttons="yes" navarrow="6" navsize="carousel-nav-sm" navfill="carousel-nav-bordered" navshape="carousel-nav-circle" shapesize="47px" nav_border_color="rgb(223, 223, 223)" nav_bg_hcolor="rgb(42, 42, 42)" nav_arrow_color_hover="rgb(255, 255, 255)"][ld_carousel_section title="Tab" tab_id="lqd-1595577808765-230a4d56-128a"][ld_testimonial template="style13" title="Matt Sanchez" position="ThemeForest Exclusive" avatar="150"]<span style="font-size: 24px; line-height: 39px; color: #5d6371;">“I think Hub is the best theme I ever saw this year. Amazing design, easy to customize and a design quality superlative account on its cloud platform.</span><span style="font-size: 24px; color: #5d6371;">for the optimized performance”</span>[/ld_testimonial][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595577265551-a0a6c56a-225f"][ld_testimonial template="style13" title="Daniel Rock" position="ThemeForest Exclusive" avatar="151"]<span style="font-size: 24px; line-height: 39px; color: #5d6371;">“I think Hub is the best theme I ever saw this year. Amazing design, easy to customize and a design quality superlative account on its cloud platform.</span><span style="font-size: 24px; color: #5d6371;">for the optimized performance”</span>[/ld_testimonial][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595577809214-bbaa1329-bddd"][ld_testimonial template="style13" title="Daniel Rock" position="ThemeForest Exclusive" avatar="152"]<span style="font-size: 24px; line-height: 39px; color: #5d6371;">“I think Hub is the best theme I ever saw this year. Amazing design, easy to customize and a design quality superlative account on its cloud platform.</span><span style="font-size: 24px; color: #5d6371;">for the optimized performance”</span>[/ld_testimonial][/ld_carousel_section][/ld_carousel_tab][ld_particles as_bg="yes" absolute_pos="yes" enable_density="yes" opacity="1" enable_random_size="yes" enable_anim_size="yes" enable_move="yes" move_direction="top" enable_random_move="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1579874781983-fb436513-72aa" height="100vh" position="right_small:0px|bottom_small:0px" number="7" size="3" anim_size_speed="1" anim_size_min="50" density="200" color="#d5dfe2"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 18 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-18.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" equal_height="yes" content_placement="middle" css=".vc_custom_1620983472130{padding-top: 20px !important;padding-bottom: 20px !important;}" responsive_css="padding_right_large:12vw|padding_left_large:12vw|padding_top_medium:50px|padding_right_medium:7vw|padding_bottom_medium:50px|padding_left_medium:7vw"][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center text-md-left"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_inheritance="true" counter_mb_checkbox="true" enable_blur="true" count="1m+" fs="51px" lh="1.1em" color="rgb(0, 6, 69)" el_class="mb-0"][ld_images_group_element image="80" margin="bottom_small:10px"][/ld_images_group_element][ld_fancy_heading tag="p" color="rgb(29, 41, 63)" margin="bottom_small:0.25em"]Installations[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(37, 138, 255)" margin="bottom_small:0.25em"]Application Store[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center text-md-left"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_inheritance="true" counter_mb_checkbox="true" enable_blur="true" count="4.98" fs="51px" lh="1.1em" color="rgb(0, 6, 69)" el_class="mb-0"][ld_images_group_element image="80" margin="bottom_small:10px"][/ld_images_group_element][ld_fancy_heading tag="p" color="rgb(29, 41, 63)" margin="bottom_small:0.25em"]The Best Rated App[/ld_fancy_heading][ld_fancy_heading tag="p" color="rgb(37, 138, 255)" margin="bottom_small:0.25em"]On Play Store[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" responsive_css="padding_top_medium:0px" css=".vc_custom_1607338010924{padding-top: 30px !important;}"][ld_carousel_tab columns="sm:3|xs:2|spacing_xs:6%25" inactiv_opacity="1" groupcells="no" wraparound="yes" autoplay="yes" mobile_dots_bottom_offset_outside="0.75em"][ld_carousel_section title="Tab" tab_id="lqd-1595515496470-f476a47f-849c"][vc_single_image image="252" css=".vc_custom_1610913064974{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516087526-77fd3c05-0c62"][vc_single_image image="250" css=".vc_custom_1610913084440{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516150566-e55e95d9-d8be"][vc_single_image image="251" css=".vc_custom_1610974291183{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516109864-40f2ee70-4236"][vc_single_image image="250" css=".vc_custom_1610974269734{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516118611-8b77e018-dc40"][vc_single_image image="249" css=".vc_custom_1610913025734{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595516099239-3985f1b0-c8b7"][vc_single_image image="253" css=".vc_custom_1610913003035{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 19 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-19.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Clients 20 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 20', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-20.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" equal_height="yes" content_placement="middle" css=".vc_custom_1621864721992{border-top-width: 1px !important;border-top-color: rgba(112,112,112,0.2) !important;border-top-style: solid !important;}"][vc_column width="1/3" css=".vc_custom_1621861561550{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 42px !important;padding-right: 15px !important;padding-bottom: 42px !important;padding-left: 15px !important;border-right-color: rgba(112,112,112,0.1) !important;border-right-style: solid !important;border-bottom-color: rgba(112,112,112,0.1) !important;border-bottom-style: solid !important;}" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-center" responsive_css="border_bottom_medium:0px"][vc_single_image image="177" css=".vc_custom_1622019184755{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" css=".vc_custom_1621861561550{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 42px !important;padding-right: 15px !important;padding-bottom: 42px !important;padding-left: 15px !important;border-right-color: rgba(112,112,112,0.1) !important;border-right-style: solid !important;border-bottom-color: rgba(112,112,112,0.1) !important;border-bottom-style: solid !important;}" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-center" responsive_css="border_bottom_medium:0px"][vc_single_image image="180" css=".vc_custom_1622019222620{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" css=".vc_custom_1621861561550{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 42px !important;padding-right: 15px !important;padding-bottom: 42px !important;padding-left: 15px !important;border-right-color: rgba(112,112,112,0.1) !important;border-right-style: solid !important;border-bottom-color: rgba(112,112,112,0.1) !important;border-bottom-style: solid !important;}" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-center" responsive_css="border_bottom_medium:0px"][vc_single_image image="178" css=".vc_custom_1622019208066{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" css=".vc_custom_1621861561550{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 42px !important;padding-right: 15px !important;padding-bottom: 42px !important;padding-left: 15px !important;border-right-color: rgba(112,112,112,0.1) !important;border-right-style: solid !important;border-bottom-color: rgba(112,112,112,0.1) !important;border-bottom-style: solid !important;}" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-center" responsive_css="border_bottom_medium:0px"][vc_single_image image="175" css=".vc_custom_1622019215881{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" css=".vc_custom_1621861561550{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 42px !important;padding-right: 15px !important;padding-bottom: 42px !important;padding-left: 15px !important;border-right-color: rgba(112,112,112,0.1) !important;border-right-style: solid !important;border-bottom-color: rgba(112,112,112,0.1) !important;border-bottom-style: solid !important;}" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-center" responsive_css="border_bottom_medium:0px"][vc_single_image image="179" css=".vc_custom_1622019196744{margin-bottom: 0px !important;}"][/vc_column][vc_column width="1/3" css=".vc_custom_1621861561550{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 42px !important;padding-right: 15px !important;padding-bottom: 42px !important;padding-left: 15px !important;border-right-color: rgba(112,112,112,0.1) !important;border-right-style: solid !important;border-bottom-color: rgba(112,112,112,0.1) !important;border-bottom-style: solid !important;}" offset="vc_col-md-2 vc_col-xs-6" responsive_align="text-center" responsive_css="border_bottom_medium:0px"][vc_single_image image="114" css=".vc_custom_1622019226658{margin-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Clients 21 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Clients 21', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'clients-21.jpg' );
	$data['sort_name'] = 'Clients';
	$data['custom_class'] = 'general clients';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1621863858589{padding-top: 60px !important;padding-bottom: 80px !important;}" el_id="clients"][vc_column][ld_images_group_container move_to_parent_row="yes" absolute_pos="yes" position="top_small:-90px|right_small:-170px|bottom_small:0px" el_class="z-index-2" hide_el="hidden-xs"][ld_images_group_element image="9311"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" responsive_css="padding_right_large:5%25|padding_left_large:5%25" css=".vc_custom_1621847401544{margin-bottom: 35px !important;}"][ld_fancy_heading tag="h2"]Helping companies to build the future.[/ld_fancy_heading][/vc_column][vc_column][ld_carousel_tab columns="md:5|sm:3|xs:2|spacing_md:5px|spacing_xs:15px" inactiv_opacity="1" equalheightcells="yes" middlealigncontent="yes"][ld_carousel_section title="Carousel Item" tab_id="lqd-1622018967581-fa0385e3-231a"][vc_single_image image="177" alignment="center" css=".vc_custom_1622018941795{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622018987642-e70b2ba0-c0aa"][vc_single_image image="180" alignment="center" css=".vc_custom_1622018918951{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622018967735-23dfed12-f9af"][vc_single_image image="175" alignment="center" css=".vc_custom_1622018897591{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622018967877-0d21a86c-553f"][vc_single_image image="178" alignment="center" css=".vc_custom_1622019013076{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622018986892-8bd596cb-2fa3"][vc_single_image image="179" alignment="center" css=".vc_custom_1622019024682{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column responsive_align="text-center" css=".vc_custom_1621847580731{padding-top: 45px !important;}"][ld_button style="btn-solid" title="Develop Impactful Stories" shape="circle" border="border-none" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" color="rgba(21, 81, 83, 0.07)" text_color="rgb(21, 81, 83)" fs="text_small:16px" i_size="1.25em" i_margin_left="13px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Contact
	//Contact 1
	$data = array();
	$data['name'] = esc_html__( 'Contact 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-1.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1605625730804{padding-top: 80px !important;padding-bottom: 35px !important;}" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]about us[/ld_fancy_heading][ld_fancy_heading tag="h2" padding="right_large:14%25"]consulting agency for your business.[/ld_fancy_heading][ld_fancy_heading tag="p"]Hub has a full range of products for personal data analysis, business consultation, and strategic partnership. Hub allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][/vc_column][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-2 vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1612176801668{padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 40px !important;padding-left: 20px !important;background-color: #ffffff !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.07)%22%7D%5D" responsive_css="margin_top_medium:-65px|padding_bottom_medium:20px|padding_right_small:50px|padding_left_small:50px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]send a message[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" padding="right_large:14%25" margin="bottom_small:1.1em" fs="30px"]request a call back[/ld_fancy_heading][ld_cf7 id="8632" shape="lqd-contact-form-inputs-filled" size="lqd-contact-form-inputs-lg" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" fw="400" submit_fs="16px" submit_fw="700" lqd_bg_color="rgb(248, 245, 243)" color="rgb(0, 0, 0)" css=".vc_custom_1606897967487{margin-bottom: 0px !important;}" submit_color="rgb(24, 67, 65)" bm="20px" submit_hbg_color="rgb(24, 67, 65)" submit_h_color="rgb(255, 255, 255)" submit_bg_color="rgb(255, 205, 40)" submit_border_color="rgb(255, 205, 40)" submit_hover_border_color="rgb(24, 67, 65)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 2
	$data = array();
	$data['name'] = esc_html__( 'Contact 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-2.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0"][vc_column][ld_google_map style="assassinsCreedIV" map_marker="html_marker" si_style="" si_size="" si_border="" zoom="14" address="Manhattan" map_height="580px"][/vc_column][vc_column css=".vc_custom_1607955432920{margin-top: -250px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:16px" margin="bottom_small:0.25em"]home - contact[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:50px" ls="text_small:-0.04em" fw="text_small:900" margin="bottom_small:0px"]contact us[/ld_fancy_heading][/vc_column][/vc_row][vc_row content_placement="middle"][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" css=".vc_custom_1607954640145{padding-top: 35px !important;padding-right: 50px !important;padding-bottom: 40px !important;padding-left: 50px !important;background-color: #ffffff !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.07)%22%7D%5D" responsive_css="margin_top_medium:-70px|padding_bottom_medium:20px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:1.1em" fs="text_small:20px"]Send a message[/ld_fancy_heading][ld_cf7 id="8654" shape="lqd-contact-form-inputs-filled" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" fw="400" submit_fs="16px" submit_fw="700" lqd_bg_color="rgb(247, 248, 248)" color="rgb(59, 75, 83)" css=".vc_custom_1607956230465{margin-bottom: 0px !important;}" submit_color="rgb(24, 67, 65)" bm="20px" submit_hbg_color="rgb(24, 67, 65)" submit_h_color="rgb(255, 255, 255)" submit_bg_color="rgb(255, 205, 40)" submit_border_color="rgb(255, 205, 40)" submit_hover_border_color="rgb(24, 67, 65)"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_ontablet="yes" column_top_onmobile="yes" css=".vc_custom_1610101870866{padding-top: 80px !important;padding-bottom: 35px !important;}" offset="vc_col-lg-5 vc_col-md-offset-1 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" margin="bottom_small:0.75em"]Get in touch[/ld_fancy_heading][ld_fancy_heading tag="h2" padding="right_large:14%25"]We’d love to hear from you.[/ld_fancy_heading][ld_fancy_heading tag="p"]We are here to answer any question you may have. As a partner of corporates, Liquid has more than 9,000 offices of all sizes and all potential of session.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 3
	$data = array();
	$data['name'] = esc_html__( 'Contact 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-3.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1607955116165{padding-top: 65px !important;padding-bottom: 65px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1577271562832{margin-bottom: 60px !important;}" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_an_translate_y="0" responsive_align="text-center"][ld_fancy_heading tag="h2"]global offices[/ld_fancy_heading][ld_fancy_heading tag="p"]As a partner of corporates, Liquid has more than 9,000 offices of all sizes and all potential of session.[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" equal_height="yes" animation_preset="Fade In" ca_duration="1800" ca_delay="90"][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]Paris[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]290 Maryam Sprins 260,[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]Courbevoie, Paris, France[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+47 213 5941 295[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]Tokyo[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]37 Valentin Rapids Apt.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]Tokyo, Japan[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+17 113 6946 36[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]London[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]82 Bernie Greens Apt.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]London, UK[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+36 213 5941 295[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" enable_overlay="yes" offset="vc_col-md-3 vc_col-xs-6" css=".vc_custom_1607954944854{margin-bottom: 30px !important;padding-top: 30px !important;padding-right: 15px !important;padding-bottom: 30px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_small:30px|padding_left_small:30px" hover_overlay_bg="rgb(250, 213, 91)"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.5em" color="rgb(34, 34, 50)"]New York[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:0px"]21 Valentin Rapids Apt.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em" margin="bottom_small:1.25em"]New Jersey, NYC[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.6em"]+47 213 5941 295[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Contact 4
	$data = array();
	$data['name'] = esc_html__( 'Contact 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-4.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="right center" css=".vc_custom_1614770659924{padding-top: 150px !important;padding-bottom: 190px !important;background-image: url(https://newsletterhub.liquid-themes.com/staging/wp-content/uploads/2021/03/bg-1@2x.jpg?id=272) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}"][vc_column offset="vc_col-lg-5 vc_col-md-offset-1 vc_col-md-6"][ld_fancy_heading use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_medium:57px|text_small:48px" lh="text_small:0.9em"]We’d love to hear from you.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-lg-4 vc_col-md-5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:22px" lh="text_small:1.22em" margin="right_all:10%25"]We are here to answer any question you may have.[/ld_fancy_heading][/vc_column][/vc_row][vc_row][vc_column enable_column_shadowbox="yes" css=".vc_custom_1608814764226{margin-top: -128px !important;border-top-width: 10px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;background-color: #ffffff !important;border-top-color: #e66c6c !important;border-top-style: solid !important;border-radius: 10px !important;}" offset="vc_col-md-offset-1 vc_col-md-10" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2290px%22%2C%22shadow_color%22%3A%22rgba(30%2C%2089%2C%20157%2C%200.06)%22%7D%5D" responsive_css="padding_right_medium:80px|padding_left_medium:80px|padding_right_small:30px|padding_left_small:30px"][vc_row_inner content_placement="middle" css=".vc_custom_1608813658428{margin-bottom: 35px !important;}"][vc_column_inner width="1/2"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:28px" fw="text_small:700"]Send a message[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_align="text-sm-right"][ld_icon_box i_type="animated" hover_animation="yes" position="iconbox-side" i_icon_animated="animated-basic_paperplane" custom_size="60px" css=".vc_custom_1608813529459{margin-bottom: 0px !important;}" i_color="rgb(219, 223, 229)" h_i_color="rgb(0, 0, 0)"][/ld_icon_box][/vc_column_inner][/vc_row_inner][ld_cf7 id="286" size="lqd-contact-form-inputs-lg" roundness="lqd-contact-form-inputs-round" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="16px" submit_fs="18px" submit_fw="700" border_color="rgba(123, 131, 142, 0.15)" hover_border_color="rgba(123, 131, 142, 0.3)" color="rgb(57, 68, 90)" h_color="rgb(0, 0, 0)" bm="20px" submit_bg_color="rgb(16, 70, 98)" css=".vc_custom_1614770698277{margin-bottom: 0px !important;}" submit_border_color="rgb(16, 70, 98)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Contact 5 - classic
	$data = array();
	$data['name'] = esc_html__( 'Contact 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-5.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:80px|padding_bottom_medium:80px" css=".vc_custom_1608199084580{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" responsive_css="margin_bottom_medium:0px|padding_right_medium:60px|padding_left_medium:60px|padding_top_small:55px|padding_right_small:20px|padding_bottom_small:35px|padding_left_small:20px" css=".vc_custom_1608199163750{margin-bottom: 30px !important;border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 45px !important;padding-right: 20px !important;padding-bottom: 25px !important;padding-left: 20px !important;border-left-color: #dddddd !important;border-left-style: solid !important;border-right-color: #dddddd !important;border-right-style: solid !important;border-top-color: #dddddd !important;border-top-style: solid !important;border-bottom-color: #dddddd !important;border-bottom-style: solid !important;border-radius: 3px !important;}"][ld_fancy_heading use_custom_fonts_title="true" fs="text_small:34px" fw="text_small:500"]Get in touch[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2.5em"]We are here to answer any question you may have. Feel free to reach via contact form.[/ld_fancy_heading][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_fontawesome="fas fa-map-marker-alt" title="290 Maryam Springs 260,`{`ld_br`}`Courbevoie, Paris" custom_heading_size="15px" icon_size="16px" icon_mb="15" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1608198980988{margin-bottom: 10px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_fontawesome="fas fa-envelope" title="Email: hello@liquid-themes.com" custom_heading_size="15px" icon_size="16px" icon_mb="15" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1608198973172{margin-bottom: 10px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" i_icon_fontawesome="fas fa-mobile" title="Phone: +47 213 5941 295" custom_heading_size="15px" icon_size="16px" icon_mb="15" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1608198966267{margin-bottom: 10px !important;}"][/ld_icon_box][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_right_medium:12%25"][ld_cf7 id="259" shape="lqd-contact-form-inputs-filled" roundness="lqd-contact-form-inputs-round" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="13px" submit_fs="14px" lqd_bg_color="rgb(247, 248, 248)" color="rgb(123, 131, 142)" h_color="rgb(0, 0, 0)" css=".vc_custom_1608199148075{margin-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Contact 6 - dark pf
	$data = array();
	$data['name'] = esc_html__( 'Contact 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-6.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" equal_height="yes" content_placement="middle" enable_content_animation="yes" animation_preset="Fade In" responsive_css="padding_right_large:12vw|padding_left_large:12vw|padding_top_medium:200px|padding_right_medium:7vw|padding_bottom_medium:200px|padding_left_medium:7vw" css=".vc_custom_1614945804570{padding-top: 100px !important;padding-bottom: 100px !important;}" ca_delay="125"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.5em"]Looking for collaboration for your next project? Do not hesitate to contact us to say hello.[/ld_fancy_heading][/vc_column][vc_column][ld_spacer height="50px"][/vc_column][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22hello.%22%7D%2C%7B%22word%22%3A%22sallut.%22%7D%2C%7B%22word%22%3A%22%E4%BD%A0%E5%A5%BD%22%7D%2C%7B%22word%22%3A%22hallo.%20%22%7D%2C%7B%22word%22%3A%22merhaba.%22%7D%2C%7B%22word%22%3A%22%E3%82%82%E3%81%97%E3%82%82%E3%81%97.%22%7D%2C%7B%22word%22%3A%22hola.%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_large:3.5vw|text_small:50px" margin="bottom_large:0px" lh="text_small:1.2em"]Don't be shy. Say[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3"][vc_separator color="white" border_width="5" css=".vc_custom_1614943343984{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column][vc_column offset="vc_col-md-4"][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:35px" margin="bottom_large:0px"]info@hub.com[/ld_fancy_heading][/vc_column][vc_column][ld_spacer height="50px" md_height="80px"][/vc_column][vc_column offset="vc_col-md-7"][vc_row_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:15px" margin="bottom_small:0px"]Project Offers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0px" fw="text_small:700"]info@hub.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(255, 255, 255, 0.6)" fs="text_small:15px" margin="bottom_small:0px"]Say hello[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:21px" margin="bottom_small:0px" fw="text_small:700"]07388 252344[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_spacer height="50px" md_hide="vc_hidden-md" lg_hide="vc_hidden-lg"][/vc_column][vc_column offset="vc_col-md-5" responsive_align="text-md-right"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Li%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="45" fs="16px" color="rgb(255, 255, 255)" hcolor="rgba(255, 255, 255, 0.6)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Contact 7 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-7.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" video_bg="yes" video_bg_source="youtube" video_bg_url="https://www.youtube.com/watch?v=5bnc8AxRTFc" enable_overlay="yes" css=".vc_custom_1614944976163{padding-top: 70px !important;padding-right: 10px !important;padding-bottom: 70px !important;padding-left: 10px !important;}" overlay_bg="rgba(25, 25, 25, 0.74)"][vc_column offset="vc_col-md-6" css=".vc_custom_1573716825914{margin-bottom: 30px !important;}"][ld_fancy_heading transform="text-uppercase" use_custom_fonts_title="true" fs="text_large:106px|text_small:33px" margin="bottom_small:0px"]SAY HI[/ld_fancy_heading][ld_fancy_heading transform="text-uppercase" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:106px|text_small:33px" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.29)" hover_text_outline_width="1px"]AVAILABLE[/ld_fancy_heading][ld_fancy_heading transform="text-uppercase" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:106px|text_small:33px" margin="bottom_small:0px" hover_text_outline_color="rgba(255, 255, 255, 0.35)" hover_text_outline_width="1px"]IN 2021[/ld_fancy_heading][ld_spacer][ld_fancy_heading tag="h5" margin="bottom_small:0em"]Currently, I am not available for freelance work. But I always love to hear from you,[/ld_fancy_heading][ld_spacer height="42px"][vc_row_inner css=".vc_custom_1573716672018{margin-bottom: 40px !important;}"][vc_column_inner width="1/2" css=".vc_custom_1614943101023{padding-top: 6px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" ls="text_small:0px" fs="text_small:16px" fw="text_small:700"]Address[/ld_fancy_heading][ld_fancy_heading tag="p"]290 Maryam Springs 260, Courbevoie, Paris, France[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" ls="text_small:0px" fs="text_small:16px" fw="text_small:700"]Contact[/ld_fancy_heading][ld_fancy_heading tag="p"]+47 213 5941 295 hello@liquid.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner][ld_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="28px" primary_color="rgba(255, 255, 255, 0.47)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column align="text-center" css=".vc_custom_1614942993185{margin-bottom: 30px !important;padding-top: 45px !important;padding-right: 20px !important;padding-bottom: 15px !important;padding-left: 20px !important;border-radius: 2px !important;}" offset="vc_col-md-offset-1 vc_col-md-5" responsive_align="text-left"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:23px"]Send a message[/ld_fancy_heading][ld_fancy_heading tag="h6" margin="bottom_small:0em" color="rgba(255, 255, 255, 0.37)"]Currently, I am not available for freelance work. But I always love to hear from you.[/ld_fancy_heading][ld_spacer][ld_cf7 id="73" shape="lqd-contact-form-inputs-filled" size="lqd-contact-form-inputs-md" roundness="lqd-contact-form-inputs-circle" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-circle" use_custom_fonts_input="true" color="rgb(184, 184, 184)" border_color="rgba(255, 255, 255, 0.32)" submit_bg_color="rgb(29, 29, 29)" submit_border_color="rgb(29, 29, 29)" submit_hbg_color="rgb(46, 46, 46)" submit_hover_border_color="rgb(46, 46, 46)" lqd_bg_color="rgba(255, 255, 255, 0.07)" fs="16px" h_color="rgb(255, 255, 255)"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]— copy email: zack@hub.com[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 9 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-9.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" bg_position="center center" css=".vc_custom_1614937207357{background-image: url(https://gridportfolio.liquid-themes.com/staging/wp-content/uploads/2021/03/glow-figss.svg?id=4868) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1614944108586{padding-top: 80px !important;padding-bottom: 35px !important;}" offset="vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_align="text-left"][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_onclick="yes" onclick_mode="bubble" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1614867775326-30fedaf3-eca4" number="7" size="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23ea48d5%22%7D%2C%7B%22scolor%22%3A%22%23bde89d%22%7D%2C%7B%22scolor%22%3A%22%23a2eff2%22%7D%2C%7B%22scolor%22%3A%22%23fd6059%22%7D%5D"][ld_fancy_heading use_custom_fonts_title="true" fs="text_large:72px|text_small:40px"]Have a cool ✌️ project in mind?[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_large:2em|bottom_small:1em" fs="text_large:21px|text_small:18px" lh="text_small:1.5em" color="rgba(0, 0, 0, 0.66)"]Currently, I am not available for freelance work. But I always love to hear from you about interesting projects.[/ld_fancy_heading][vc_row_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p"]<span style="color: #000000;">Project Offers[ld_br]</span>info@hubcommerce.com[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p"]<span style="color: #000000;">Say Hello</span>[ld_br]Call me at +123 878 90 87[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1614947596144{padding-top: 30px !important;padding-right: 20px !important;padding-bottom: 40px !important;padding-left: 20px !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%7D%5D" responsive_css="margin_top_medium:-65px|padding_bottom_medium:20px|padding_right_small:50px|padding_left_small:50px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center text-md-left"][ld_icon_box i_type="linea" heading_size="custom" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-lqd-circle" title="Available for freelance" icon_size="28px" i_color="rgb(132, 245, 176)" custom_heading_size="14px"][/ld_icon_box][ld_button style="btn-solid" title="Say hello at `{`ld_span`}`contact.at.hub.com`{`/ld_span`}`" shape="circle" size="btn-lg" border="border-none" i_type="linea" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-lg" enable_icon_shadowbox="yes" enable_row_shadowbox="yes" i_add_icon="true" hover_color="rgba(251, 252, 255, 0.5)" color="rgb(255, 255, 255)" text_color="rgb(20, 20, 20)" i_size="22px" fs="text_all:25px|text_large:16px|text_medium:15px|text_small:13px" lh="text_small:1.3em" fw="text_small:700" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(73%2C76%2C137%2C0.12)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" ls="text_small:0.02em" icon_box_shadow="%5B%7B%22y_offset%22%3A%2213px%22%2C%22blur_radius%22%3A%2222px%22%2C%22shadow_color%22%3A%22rgba(10%2C10%2C10%2C0.17)%22%7D%5D" h_icon_box_shadow="%5B%7B%7D%5D" i_color="rgb(255, 255, 255)" i_fill_color="rgb(253, 96, 89)" i_icon_linea="lqd-icn-ess icon-lqd-pen" i_margin_left="70px" htext_color="rgb(0, 0, 0)" i_fill_hcolor="rgb(253, 96, 89)" i_hcolor="rgb(255, 255, 255)"][/vc_column][vc_column][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22In.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Li.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" fs="17px" color="rgb(0, 0, 0)" spacing="50"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 10 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-10.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1608814107092{padding-top: 85px !important;padding-bottom: 85px !important;}"][vc_column offset="vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1608814797851{margin-bottom: 20px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" color="rgb(16, 48, 98)" ls="text_small:0.1em" margin="bottom_small:1.25em"]Get in touch[/ld_fancy_heading][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:37px" fw="text_small:700" margin="bottom_small:0.3em"]Contact us[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(34, 36, 58)" fs="text_small:17px"]We are here to answer any question you may have.[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-offset-1 vc_col-md-1/5" css=".vc_custom_1608814811249{margin-bottom: 20px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" color="rgb(16, 48, 98)" ls="text_small:0.1em" margin="bottom_small:1em"]Careers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:14px" lh="text_small:1.21em"]Would you like to join our growing team?[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:14px" fw="text_small:700" color="rgb(230, 108, 108)" margin="bottom_small:1.25em"]careers@hub.com[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-2" css=".vc_custom_1608814818824{margin-bottom: 20px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" color="rgb(16, 48, 98)" ls="text_small:0.1em" margin="bottom_small:1em"]Feedbacks[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:14px" lh="text_small:1.21em"]Have a project in mind? Send a message.[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:14px" fw="text_small:700" color="rgb(230, 108, 108)" margin="bottom_small:1.25em"]info@hub.com[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 11 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-11.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1610102039754{padding-top: 30px !important;padding-bottom: 60px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-4 vc_col-md-5" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" css=".vc_custom_1610187602697{padding-top: 35px !important;padding-bottom: 35px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:13px" ls="text_small:0.1em" margin="bottom_small:1em"]Send a message[/ld_fancy_heading][ld_fancy_heading tag="h3" use_custom_fonts_title="true" padding="right_large:14%25" fs="text_medium:43px|text_small:34px" fw="text_small:500"]Contact Us[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:1.85em" fs="text_small:17px" lh="text_small:1.7em" color="rgb(0, 0, 0)"]We’re here to here answer any question you may have.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:1.35em" fs="text_small:15px" lh="text_small:1.6em" color="rgba(0, 0, 0, 0.6)"]290 Maryam Springs 260,[ld_br]<br />
Courbevoie, Paris[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:1.35em" fs="text_small:15px" lh="text_small:1.6em" color="rgba(0, 0, 0, 0.6)"]Email: hello@liquid-themes.com[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:1.35em" fs="text_small:15px" lh="text_small:1.6em" color="rgba(0, 0, 0, 0.6)"]Phone: +47 213 5941 295[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-md-7" css=".vc_custom_1611571066605{padding-top: 35px !important;padding-right: 15px !important;padding-bottom: 40px !important;padding-left: 15px !important;border-radius: 5px !important;}" responsive_css="padding_right_medium:50px|padding_bottom_medium:20px|padding_left_medium:50px|padding_right_small:20px|padding_left_small:20px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35"][ld_cf7 id="4596" shape="lqd-contact-form-inputs-underlined" thickness="lqd-contact-form-inputs-border-thick" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" fw="400" submit_fs="16px" submit_fw="700" color="rgb(0, 0, 0)" css=".vc_custom_1610188452628{margin-bottom: 0px !important;}" submit_color="rgb(255, 255, 255)" bm="30px" submit_hbg_color="rgb(0, 0, 0)" submit_h_color="rgb(255, 255, 255)" submit_bg_color="rgb(10, 15, 30)" submit_border_color="rgb(10, 15, 30)" submit_hover_border_color="rgb(0, 0, 0)" border_color="rgb(208, 215, 222)" hover_border_color="rgb(0, 0, 0)" h_color="rgb(0, 0, 0)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 12 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-12.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px|padding_top_small:80px|padding_bottom_small:80px" css=".vc_custom_1610102039754{padding-top: 30px !important;padding-bottom: 60px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-5 vc_col-md-6" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" css=".vc_custom_1610102029367{padding-top: 35px !important;padding-bottom: 35px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" padding="right_large:14%25" fs="text_small:34px"]Get in touch[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.85em"]We are here to answer any question you may have.<br />
Feel free to reach via contact form.[/ld_fancy_heading][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_fontawesome="fas fa-map-marker-alt" title="290 Maryam Springs 260,<br />
Courbevoie, Paris" custom_heading_size="15px" icon_size="18px" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" title_mb="0" css=".vc_custom_1610101703176{margin-bottom: 20px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_fontawesome="fas fa-envelope" title="Email: hello@liquid-themes.com" custom_heading_size="15px" icon_size="18px" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1610204401204{margin-bottom: 20px !important;margin-left: -4px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_fontawesome="fas fa-mobile" title="Phone: +47 213 5941 295" custom_heading_size="15px" icon_size="18px" i_color="rgb(204, 204, 204)" h_color="rgba(0, 0, 0, 0.6)" css=".vc_custom_1610101731372{margin-bottom: 20px !important;}"][/ld_icon_box][/vc_column][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" css=".vc_custom_1610101463920{padding-top: 35px !important;padding-right: 50px !important;padding-bottom: 40px !important;padding-left: 50px !important;background-color: #ffffff !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.07)%22%7D%5D" responsive_css="margin_left_large:50px|padding_bottom_medium:20px" ca_duration="1800" ca_start_delay="250" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:1.1em" fs="text_small:20px"]Send a message[/ld_fancy_heading][ld_cf7 id="298" shape="lqd-contact-form-inputs-filled" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" btn_roundness="lqd-contact-form-button-round" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" fw="400" submit_fs="16px" submit_fw="700" lqd_bg_color="rgb(247, 248, 248)" color="rgb(59, 75, 83)" css=".vc_custom_1610101489375{margin-bottom: 0px !important;}" submit_color="rgb(255, 255, 255)" bm="20px" submit_hbg_color="rgb(24, 67, 65)" submit_h_color="rgb(255, 255, 255)" submit_bg_color="rgb(40, 175, 96)" submit_border_color="rgb(40, 175, 96)" submit_hover_border_color="rgb(24, 67, 65)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 13 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-13.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" bg_position="center bottom" css=".vc_custom_1611756368112{padding-top: 120px !important;padding-bottom: 80px !important;background-image: url(https://classicsaaspro.liquid-themes.com/wp-content/uploads/2020/12/bg.svg?id=239) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:80px"][vc_column offset="vc_col-lg-5 vc_col-md-6"][ld_fancy_heading use_custom_fonts_title="true" fs="text_medium:60px" fw="text_small:700" margin="bottom_small:0.1em"]Contact us[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(34, 36, 58)" fs="text_small:17px"]We are here to answer any question you may have.[/ld_fancy_heading][vc_row_inner css=".vc_custom_1608560196551{padding-top: 45px !important;}"][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:14px" lh="text_small:1.2em" margin="bottom_small:1em"]We’re interested in[ld_br]working together[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 107, 255)" fs="text_small:14px" lh="text_small:1.2em" fw="text_small:700"]+1 827 48 89[/ld_fancy_heading][ld_spacer][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:14px" lh="text_small:1.2em" margin="bottom_small:1em"]Visit our headquarters[ld_br]around the world.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 107, 255)" fs="text_small:14px" lh="text_small:1.2em" fw="text_small:700"]290 Maryam Springs 260, Courbevoie, Paris[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:14px" lh="text_small:1.2em" margin="bottom_small:1em"]Have a project in mind?[ld_br]Send a message.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 107, 255)" fs="text_small:14px" lh="text_small:1.2em" fw="text_small:700"]info@hub.com[/ld_fancy_heading][ld_spacer][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:14px" lh="text_small:1.2em" margin="bottom_small:1em"]Would you like to join[ld_br]our growing team?[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 107, 255)" fs="text_small:14px" lh="text_small:1.2em" fw="text_small:700"]careers@hub.com[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_column_shadowbox="yes" offset="vc_col-md-offset-1 vc_col-md-6" responsive_css="padding_right_small:45px|padding_left_small:45px" css=".vc_custom_1608560451329{padding-top: 35px !important;padding-right: 20px !important;padding-bottom: 40px !important;padding-left: 20px !important;background-color: #ffffff !important;border-radius: 5px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2290px%22%2C%22shadow_color%22%3A%22rgba(30%2C%2089%2C%20157%2C%200.1)%22%7D%5D"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1.25em"]Send a message[/ld_fancy_heading][ld_cf7 id="240" btn_width="lqd-contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="13px" submit_fs="16px" color="rgb(90, 102, 126)" h_color="rgb(0, 0, 0)" border_color="rgba(123, 131, 142, 0.16)" hover_border_color="rgb(90, 102, 126)" bm="18px" css=".vc_custom_1608558737857{margin-bottom: 0px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 14 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-14.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:100px"][vc_column][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="77" position="top_small:-40px|left_small:-7%25" translate_from_y="25" translate_to_y="-80"][/ld_images_group_element][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_column_shadowbox="yes" css=".vc_custom_1599657780294{padding-top: 65px !important;padding-right: 15px !important;padding-bottom: 50px !important;padding-left: 15px !important;background-color: #ffffff !important;}" custom_border_radius="0 0 15px 15px" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.05)%22%7D%5D" responsive_css="padding_right_medium:65px|padding_left_medium:65px|padding_right_small:30px|padding_left_small:30px" el_class="z-index-2 pull-down-column" translate_from_y="-90" translate_to_y="35"][ld_fancy_heading tag="h4" split_type="words" duration="1000" delay="120" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_small:36px" ca_init_translate_y="70"]Ready to get started with us?[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(51, 51, 51)" fs="18px" margin="bottom_small:3em"]Get the right service, determine what you need contact us for the most suitable services.[/ld_fancy_heading][ld_cf7 id="75" shape="lqd-contact-form-inputs-filled" size="lqd-contact-form-inputs-md" roundness="lqd-contact-form-inputs-round" btn_size="lqd-contact-form-button-lg" btn_roundness="lqd-contact-form-button-circle" use_custom_fonts_input="true" fs="18px" css=".vc_custom_1599654723861{margin-bottom: 0px !important;}" color="rgb(170, 170, 170)" h_color="rgb(0, 0, 0)" lqd_bg_color="rgb(246, 246, 246)"][/vc_column][vc_column el_class="pull-down-column"][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="77" position="right_small:-55px|bottom_small:-25px" translate_from_y="90" translate_to_y="-50"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 15 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-15.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact fancytext';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Contact 16 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-16.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row enable_gradient="yes" enable_row_dividers="yes" css=".vc_custom_1605609631170{padding-top: 90px !important;padding-bottom: 120px !important;}" gradient_bg="linear-gradient(90deg, rgb(155, 82, 255) 0%, #130cb5 100%)" row_svg_divider="top_shape_type:8|top_shape_color:%23ffffff|top_shape_height:100|bottom_shape_type:12|bottom_shape_color:%23ffffff|bottom_shape_height:150" responsive_css="padding_top_medium:120px|padding_bottom_medium:170px"][vc_column offset="vc_col-md-6"][ld_images_group_container][ld_images_group_element image="5078"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22hello%22%7D%2C%7B%22word%22%3A%22Zdravo%22%7D%2C%7B%22word%22%3A%22Bonjour%22%7D%2C%7B%22word%22%3A%22Priv%C3%A9t%22%7D%5D" use_custom_fonts_title="true" color="rgb(255, 255, 255)" margin="bottom_small:0.35em" fs="text_large:43px|text_small:38px"]👋 Say[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="18px"]We are here to answer any question you may have.[/ld_fancy_heading][ld_cf7 id="49" shape="lqd-contact-form-inputs-underlined" thickness="lqd-contact-form-inputs-border-thick" btn_roundness="lqd-contact-form-button-circle" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="12px" submit_ls="0.09em" color="rgb(255, 255, 255)" border_color="rgba(255, 255, 255, 0.3)" hover_border_color="rgb(255, 255, 255)" css=".vc_custom_1607333483904{margin-top: 30px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 17 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-17.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	<p>[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1614778244718{padding-top: 60px !important;}"][vc_column][ld_google_map style="unsaturatedBrowns" map_marker="html_marker" si_style="" si_size="" si_border="" zoom="14" address="Palo Alto" map_height="690px"][/vc_column][/vc_row][vc_row][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_onmobile="yes" responsive_css="margin_top_medium:-550px|padding_right_small:45px|padding_left_small:45px" css=".vc_custom_1606394900060{margin-top: 35px !important;padding-top: 45px !important;padding-right: 30px !important;padding-bottom: 45px !important;padding-left: 30px !important;background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-offset-7 vc_col-lg-5 vc_col-md-offset-6 vc_col-md-6" column_box_shadow="%5B%7B%22x_offset%22%3A%2220px%22%2C%22y_offset%22%3A%2240px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.1)%22%7D%5D" ca_duration="1800" ca_delay="160" ca_init_translate_y="35"][ld_fancy_heading tag="h3" margin="bottom_small:1.5em"]Contact us[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-10"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" alignment="text-left" i_icon_fontawesome="fa fa-map-marker" title="290 Maryam Springs 260, Courbevoie, Paris, France" custom_heading_size="16px" i_color="rgba(0, 0, 0, 0.6)" h_color="rgba(0, 0, 0, 0.6)" icon_size="20px" css=".vc_custom_1573556959571{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" alignment="text-left" i_icon_fontawesome="fa fa-envelope" title="Email: hello@liquid-themes.com" custom_heading_size="16px" i_color="rgba(0, 0, 0, 0.6)" h_color="rgba(0, 0, 0, 0.6)" icon_size="18px" css=".vc_custom_1573557026365{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" alignment="text-left" i_icon_fontawesome="fa fa-phone" title="Phone: +47 213 5941 295" custom_heading_size="16px" i_color="rgba(0, 0, 0, 0.6)" h_color="rgba(0, 0, 0, 0.6)" icon_size="18px" css=".vc_custom_1573557037992{margin-bottom: 20px !important;}"][/ld_icon_box][/vc_column_inner][/vc_row_inner][ld_button style="btn-solid" title="Visit on Google Maps" shape="circle" size="btn-lg" border="border-none" width="btn-block" color="rgba(0, 0, 0, 0.04)" fs="15px" lh="1.25em" text_color="rgb(0, 0, 0)" hover_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row]</p>

CONTENT;
	$templates[] = $data;

	//Contact 18 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-18.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1614778244718{padding-top: 60px !important;}"][vc_column][ld_google_map style="unsaturatedBrowns" map_marker="html_marker" si_style="" si_size="" si_shape="" si_border="" si_orientation="" zoom="14" address="Palo Alto" map_height="690px" si_identities="" si_font_size="" si_custom_size="" si_hover_color="" si_bg_color="" si_hbg_color="" si_border_color="" si_hborder_color=""][/vc_column][/vc_row][vc_row][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_onmobile="yes" responsive_css="margin_top_medium:-550px|padding_right_small:45px|padding_left_small:45px" css=".vc_custom_1606394900060{margin-top: 35px !important;padding-top: 45px !important;padding-right: 30px !important;padding-bottom: 45px !important;padding-left: 30px !important;background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-offset-7 vc_col-lg-5 vc_col-md-offset-6 vc_col-md-6" column_box_shadow="%5B%7B%22x_offset%22%3A%2220px%22%2C%22y_offset%22%3A%2240px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.1)%22%7D%5D" ca_duration="1800" ca_delay="160" ca_init_translate_y="35"][ld_fancy_heading tag="h3" margin="bottom_small:1.5em"]Contact us[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-10"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" alignment="text-left" i_icon_fontawesome="fa fa-map-marker" title="290 Maryam Springs 260, Courbevoie, Paris, France" custom_heading_size="16px" i_color="rgba(0, 0, 0, 0.6)" h_color="rgba(0, 0, 0, 0.6)" icon_size="20px" css=".vc_custom_1573556959571{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" alignment="text-left" i_icon_fontawesome="fa fa-envelope" title="Email: hello@liquid-themes.com" custom_heading_size="16px" i_color="rgba(0, 0, 0, 0.6)" h_color="rgba(0, 0, 0, 0.6)" icon_size="18px" css=".vc_custom_1573557026365{margin-bottom: 15px !important;}"][/ld_icon_box][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-side" alignment="text-left" i_icon_fontawesome="fa fa-phone" title="Phone: +47 213 5941 295" custom_heading_size="16px" i_color="rgba(0, 0, 0, 0.6)" h_color="rgba(0, 0, 0, 0.6)" icon_size="18px" css=".vc_custom_1573557037992{margin-bottom: 20px !important;}"][/ld_icon_box][/vc_column_inner][/vc_row_inner][ld_button style="btn-solid" title="Visit on Google Maps" shape="circle" size="btn-lg" border="border-none" width="btn-block" color="rgba(0, 0, 0, 0.04)" fs="15px" lh="1.25em" text_color="rgb(0, 0, 0)" hover_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 19 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-19.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="0.75" ca_init_scale_y="0.75" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1573557054725{padding-bottom: 60px !important;}" ca_duration="1800" ca_start_delay="350" ca_delay="180" ca_init_translate_y="80" ca_init_rotate_x="-10"][vc_column enable_column_shadowbox="yes" css=".vc_custom_1573555788144{padding-top: 55px !important;padding-right: 30px !important;padding-bottom: 45px !important;padding-left: 30px !important;background-color: #ffffff !important;border-radius: 10px !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2240px%22%2C%22blur_radius%22%3A%2280px%22%2C%22shadow_color%22%3A%22rgba(83%2C%2094%2C%20132%2C%200.15)%22%7D%5D" responsive_css="padding_right_medium:50px|padding_left_medium:50px" offset="vc_col-md-offset-1 vc_col-md-10"][ld_particles as_bg="yes" shape_type="circle,image" opacity="1" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" particle_id="lqd-1573554048121-31dc6376-0c5b" number="6" color="#f7fbfc" image="4202" image_width="110" image_height="67" move_speed="2"][ld_particles as_bg="yes" color_type="multi_color" opacity="1" enable_move="yes" move_direction="right" enable_random_move="yes" modes_grab_opacity="1" particle_id="lqd-1573554253946-fc704951-b3d8" number="4" multi_color_values="%5B%7B%22scolor%22%3A%22%23fdc14c%22%7D%2C%7B%22scolor%22%3A%22%23fda44c%22%7D%2C%7B%22scolor%22%3A%22%230fbbb4%22%7D%2C%7B%22scolor%22%3A%22%234cfd89%22%7D%5D" size="4" move_speed="1.25"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:30px"]Send a message[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" responsive_align="text-sm-right"][vc_column_text css=".vc_custom_1573555271440{margin-bottom: 0.5em !important;}"]<span style="font-size: 12px; color: rgba(0,0,0,0.75);">or Call for Consultation</span><br />
<strong><span style="color: var(--color-primary); font-size: 15px;"><i class="fa fa-phone"></i>+ 1 223 38 87</span></strong>[/vc_column_text][/vc_column_inner][vc_column_inner css=".vc_custom_1573555750233{margin-top: 15px !important;}"][ld_cf7 id="4954" shape="lqd-contact-form-inputs-underlined" btn_roundness="lqd-contact-form-button-circle" color="rgb(54, 54, 59)"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 20 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 20', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-20.jpg' );
	$data['sort_name'] = 'Contact';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" full_height="yes" equal_height="yes" content_placement="middle" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="center center" bg_attachment="fixed" css=".vc_custom_1614940948061{background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="70"][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" responsive_css="padding_top_medium:150px|padding_right_medium:7vw|padding_bottom_medium:150px|padding_left_medium:8vw|padding_left_small:30px" css=".vc_custom_1614940706329{padding-top: 70px !important;padding-right: 15px !important;padding-bottom: 70px !important;padding-left: 15px !important;}" ca_duration="1600" ca_delay="100" ca_init_translate_y="55" ca_init_rotate_z="5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:13px" margin="bottom_large:15px|bottom_small:30px"]<i class="lqd-icn-ess icon-lqd-circle mr-2" style="color: #00cc76; font-size: 18px; vertical-align: text-top;"></i>Available for freelance[/ld_fancy_heading][ld_fancy_heading split_type="words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:6vw" lh="text_small:1em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" color="rgba(255, 255, 255, 0.11)" margin="bottom_small:0px"]Let's talk.[/ld_fancy_heading][ld_fancy_heading split_type="words" duration="1600" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:60px|text_medium:40px|text_small:30px" lh="text_small:1.2em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_small:0.15em"]info@zack.com[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="text_large:21px|text_small:16px" lh="text_small:1.5em" margin="right_large:5%25|bottom_small:1.5em"]Currently, I am not available for freelance work. But I always love to hear from you about interesting projects.[/ld_fancy_heading][ld_spacer height="30px" md_height="50px"][ld_fancy_heading tag="h3" margin="bottom_small:1em"]Say Hello[/ld_fancy_heading][vc_row_inner responsive_css="margin_left_small:0.1em"][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:18px|text_small:15px" lh="text_small:1.45em" margin="left_large:10px|bottom_small:1.75em"]290 Maryam Springs
Courbevoie, NYC [ld_br]
+1 827 48 89[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:18px|text_small:15px" lh="text_small:1.45em" margin="left_large:10px|bottom_small:1.75em"]290 Maryam Springs
Courbevoie, NYC [ld_br]
+1 827 48 89[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_social_icons style="" identities="%5B%7B%22network%22%3A%22fa-facebook-square%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-twitter%22%2C%22url%22%3A%22%23%22%7D%2C%7B%22network%22%3A%22fa-instagram%22%2C%22url%22%3A%22%23%22%7D%5D" font_size="28px"][/vc_column][vc_column row_scale_bg_onhover="yes" enable_pin="enable_pin" pin_offset="-80px" width="1/2" column_top_ontablet="yes" column_top_onmobile="yes" bg_position="center top" css=".vc_custom_1614943889033{padding-top: 25vh !important;padding-bottom: 25vh !important;background-image: url(https://split.liquid-themes.com/staging/wp-content/uploads/2021/01/bg@2x.jpg?id=4793) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_small:50vh|padding_bottom_small:50vh"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 21 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 21', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-21.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" enable_row_dividers="yes" row_svg_divider="top_shape_type:7|top_shape_color:%23ffffff|top_shape_height:149"][vc_column][ld_google_map style="blueEssence" map_marker="html_marker" si_style="" si_size="" si_border="" zoom="17" map_controls="fullscreenControl" address="Gateway Battery Park City Apartment" map_height="650px"][/vc_column][/vc_row][vc_row][vc_column enable_column_shadowbox="yes" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_onmobile="yes" responsive_css="margin_top_medium:-520px|padding_right_small:45px|padding_left_small:45px" css=".vc_custom_1610103240445{margin-top: 35px !important;padding-top: 45px !important;padding-right: 30px !important;padding-bottom: 45px !important;padding-left: 30px !important;background-color: #ffffff !important;border-radius: 10px !important;}" offset="vc_col-lg-4 vc_col-md-6" column_box_shadow="%5B%7B%22x_offset%22%3A%2220px%22%2C%22y_offset%22%3A%2240px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.1)%22%7D%5D" ca_duration="1800" ca_delay="160" ca_init_translate_y="35"][ld_fancy_heading tag="h5" margin="bottom_small:0.75em"]Find us[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-10"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:1.25em"]290 Maryam Springs 260, Courbevoie, Paris, France[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:1.25em"]Email: hello@liquid-themes.com[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:1.25em"]Phone: +47 213 5941 295[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][ld_fancy_heading tag="h5" margin="bottom_small:0.75em"]Business Hours[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-10"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0px"]Mon - Fri: 8am - 9pm[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" margin="bottom_small:0px"]Sat - Sun: Closed[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Contact 22 - shadow
	$data = array();
	$data['name'] = esc_html__( 'Contact 22', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'contact-22.jpg' );
	$data['sort_name'] = 'Contact, fancytext';
	$data['custom_class'] = 'general contact';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="bottom" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="center bottom" css=".vc_custom_1608106142494{padding-top: 120px !important;padding-bottom: 15px !important;background-image: url(https://adaptivecolorspro.liquid-themes.com/wp-content/uploads/2020/12/bg-11@2x.jpg?id=209) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" ca_duration="1600" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="60" responsive_css="padding_top_medium:140px"][vc_column width="3/4" offset="vc_col-md-8"][ld_fancy_heading split_type="chars, words" duration="1600" delay="80" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_randomize="true" color="rgb(224, 59, 55)" fs="text_large:270px|text_medium:210px|text_small:32vw" lh="text_small:0.73em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="0"]Con-tact[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="30" ca_init_rotate_z="5" ca_start_delay="650" offset="vc_col-md-4"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-22%25|bottom_small:1.25em"]Currently, I am not available for freelance work. But I always love to hear from you about interesting projects.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-22%25|bottom_small:0px"]Reach me at info@alix.com[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-22%25|bottom_small:0px"]Call me at +123 878 90 87[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1608106138247{padding-top: 45px !important;padding-bottom: 60px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-10" ca_duration="1800" ca_start_delay="1100" ca_delay="180" ca_init_translate_y="60"][ld_cf7 id="218" shape="lqd-contact-form-inputs-underlined" size="lqd-contact-form-inputs-md" thickness="lqd-contact-form-inputs-border-thick" btn_size="lqd-contact-form-button-lg" btn_width="lqd-contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="16px" submit_fs="17px" color="rgb(164, 25, 61)" h_color="rgb(0, 0, 0)" border_color="rgb(164, 25, 61)" submit_bg_color="rgb(255, 255, 255)" submit_color="rgb(164, 25, 61)" submit_border_color="rgb(255, 255, 255)" submit_hbg_color="rgb(164, 25, 61)" submit_h_color="rgb(255, 255, 255)" submit_hover_border_color="rgb(164, 25, 61)" hover_border_color="rgb(0, 0, 0)" bm="45px"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Countdown
	//Countdown 1
	$data = array();
	$data['name'] = esc_html__( 'Countdown 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'countdown-1.jpg' );
	$data['sort_name'] = 'Countdown';
	$data['custom_class'] = 'general countdown';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="top" css=".vc_custom_1579173155241{padding-top: 50px !important;padding-bottom: 70px !important;}"][vc_column align="text-center" offset="vc_col-md-5" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true"]Next Event In:[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" fs="18px"]Jan 3, 2020 in Cambridge, London[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-7" responsive_align="text-md-right"][ld_countdown month="5" day="18" year="2021" use_custom_typography="true" fs="48px" lh="1.65em" primary_color="rgb(149, 149, 149)" digits_color="rgb(255, 255, 255)" sep_color="rgba(255, 255, 255, 0)" ls="0"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Counters
	//Counters 1
	$data = array();
	$data['name'] = esc_html__( 'Counters 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-1.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="center bottom" css=".vc_custom_1602651674721{padding-bottom: 70px !important;background-image: url(https://digitalstudiopro.liquid-themes.com/wp-content/uploads/2020/05/BG.svg?id=4390) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:70px|padding_bottom_medium:70px"][vc_column align="text-center" offset="vc_col-lg-offset-2 vc_col-lg-8" css=".vc_custom_1588593855688{margin-bottom: 30px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:1.5em"]Selected Projects[/ld_fancy_heading][ld_fancy_heading tag="h2"]Digital Case Studies[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:1.5em" margin="bottom_small:2em" padding="right_all:22%25|left_all:22%25"]Passionate about solving problems through creative communications.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-5"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="1" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="4392"][/ld_images_group_element][ld_images_group_element absolute_pos="yes" image="4394" position="top_small:28%25|left_small:-30px"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="2" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="4391" margin="top_small:-15%25|left_small:35%25" shadow_delay="75"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="4393" margin="top_small:-13%25|left_small:10%25" shadow_delay="150"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-md-7"][vc_row_inner equal_height="yes" gap="0" enable_row_shadowbox="yes" css=".vc_custom_1588593784234{background-color: #ffffff !important;border-radius: 10px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.06)%22%7D%5D" responsive_css="margin_right_medium:-5%25"][vc_column_inner width="1/3" css=".vc_custom_1602651393431{border-right-width: 1px !important;padding-top: 15px !important;padding-right: 30px !important;padding-left: 30px !important;border-right-color: #eaeaea !important;border-right-style: solid !important;}" responsive_css="border_right_medium:1px|padding_top_medium:15px|padding_right_medium:30px|padding_bottom_medium:65px|padding_left_medium:30px"][ld_counter tag_to_inherite="h2" tag_to_inherite_label="h2" use_custom_fonts_title="true" use_inheritance="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" count="10+" fs="44px" color="rgb(110, 0, 150)" label="Years of Operation" counter_mb="1" text_fs="14px" label_color="rgb(0, 0, 0)"][ld_spacer height="" sm_height="10px" md_height="25px" lg_height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.6em"]Our team have been running well about 10 years and keep going.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1602651585542{border-right-width: 1px !important;padding-top: 15px !important;padding-right: 30px !important;padding-left: 30px !important;border-right-color: #eaeaea !important;border-right-style: solid !important;}" responsive_css="border_right_medium:1px|padding_top_medium:15px|padding_right_medium:30px|padding_left_medium:30px"][ld_counter tag_to_inherite="h2" tag_to_inherite_label="h2" use_custom_fonts_title="true" use_inheritance="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" count="98%" fs="44px" color="rgb(110, 0, 150)" label="Positive Feedback" counter_mb="1" text_fs="14px" label_color="rgb(0, 0, 0)" start_delay="250"][ld_spacer height="" sm_height="10px" md_height="25px" lg_height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.6em"]Based on our happy clients about the quality of our services.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1588593663575{border-right-width: 1px !important;padding-top: 15px !important;padding-right: 30px !important;padding-bottom: 65px !important;padding-left: 30px !important;border-right-color: #eaeaea !important;border-right-style: solid !important;}"][ld_counter tag_to_inherite="h2" tag_to_inherite_label="h2" use_custom_fonts_title="true" use_inheritance="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" count="2,664" fs="44px" color="rgb(110, 0, 150)" label="Projects Copmpleted" counter_mb="1" text_fs="14px" label_color="rgb(0, 0, 0)" start_delay="500"][ld_spacer height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.6em"]All projects competeled with an absolutely high quality.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 2
	$data = array();
	$data['name'] = esc_html__( 'Counters 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-2.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_right_medium:7vw|padding_left_medium:7vw" css=".vc_custom_1609935763251{padding-bottom: 30px !important;}"][vc_column width="1/3" responsive_css="padding_right_large:7%25"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" count="10+" label="Years of experience. Urban design draws together the many strands of place-making," fs="100px" text_fs="16px" text_lh="1.56em" color="rgb(0, 0, 0)" fw="600" label_color="rgb(72, 72, 72)"][/vc_column][vc_column width="1/3" responsive_css="padding_right_large:7%25"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" count="40%" label="Average. Urban design draws together the many strands of place-making, environmental" fs="100px" text_fs="16px" text_lh="1.56em" color="rgb(0, 0, 0)" fw="600" label_color="rgb(72, 72, 72)"][/vc_column][vc_column width="1/3" responsive_css="padding_right_large:7%25"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" count="100m" label="Investment. Urban design draws together the many strands of place-making, environmental" fs="100px" text_fs="16px" text_lh="1.56em" color="rgb(0, 0, 0)" fw="600" label_color="rgb(72, 72, 72)"][/vc_column][/vc_row][vc_row css=".vc_custom_1609936212535{padding-top: 30px !important;padding-bottom: 45px !important;}" responsive_css="padding_right_medium:7vw|padding_left_medium:7vw" el_id="awards"][vc_column][vc_separator color="custom" accent_color="#d1d1d1"][/vc_column][/vc_row][vc_row css=".vc_custom_1609933417198{padding-bottom: 60px !important;}"][vc_column offset="vc_col-md-3"][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" ls="text_small:0.1em"]International Awards[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3"][ld_list txt_color="rgb(0, 0, 0)" items_spacing="20"]Pritzker Architecture ,Architecture MasterPrize,AIA Gold Medal,RedDot Design,Ribba architecture[/ld_list][/vc_column][vc_column offset="vc_col-md-3"][ld_list txt_color="rgb(0, 0, 0)" items_spacing="20"]Pritzker Architecture ,Architecture MasterPrize,AIA Gold Medal,RedDot Design,Ribba architecture[/ld_list][/vc_column][vc_column offset="vc_col-md-3"][ld_list txt_color="rgb(0, 0, 0)" items_spacing="20"]Pritzker Architecture ,Architecture MasterPrize,AIA Gold Medal,RedDot Design,Ribba architecture[/ld_list][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 3
	$data = array();
	$data['name'] = esc_html__( 'Counters 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-3.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="margin_bottom_medium:90px|padding_top_medium:195px" css=".vc_custom_1605894380130{margin-bottom: 60px !important;padding-top: 60px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" responsive_css="padding_right_medium:2.5vw|padding_left_medium:2.5vw" offset="vc_col-md-offset-1 vc_col-md-10" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-md-center"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]What we achieved[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" duration="1000" delay="120" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" minfontsize="40" fs="text_large:48px|text_small:40px" ca_init_translate_y="70"]The thousands of completed works.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="1.666em" padding="right_large:2.5vw|left_large:2.5vw"]Through strategy, design, and planning we build brand identities that connect with your Nesi. We then fine-tune a marketing plan that allows us to laser focus and target your audience through the right channels.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" content_placement="middle" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" responsive_css="padding_right_large:7vw|padding_left_large:7vw|padding_right_medium:5vw|padding_bottom_medium:150px|padding_left_medium:5vw" css=".vc_custom_1605894357515{padding-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="45"][vc_column offset="vc_col-md-7" responsive_css="padding_bottom_medium:0px" css=".vc_custom_1605900653624{padding-bottom: 40px !important;}"][ld_carousel_tab columns="sm:2|xs:1.15|spacing_sm:25px|spacing_xs:15px" inactiv_opacity="1" groupcells="no" wraparound="yes" freescroll="yes" autoplay="yes"][ld_carousel_section title="Tab" tab_id="lqd-1595668610562-2ce347a8-5c26"][vc_single_image image="136" css=".vc_custom_1599653788634{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668614654-7b524ffd-5e98"][vc_single_image image="154" css=".vc_custom_1599658760650{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668489515-bff38c98-e89c"][vc_single_image image="136" css=".vc_custom_1599659930441{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668596537-af5fa149-8305"][vc_single_image image="153" css=".vc_custom_1599658826780{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1800" ca_delay="180" ca_init_translate_x="45" translate_from_y="120" translate_to_y="-120" el_class="z-index-2"][vc_row_inner equal_height="yes" gap="0" enable_row_shadowbox="yes" responsive_css="margin_right_medium:-3vw|margin_left_medium:-35%25" css=".vc_custom_1579181548740{background-color: #ffffff !important;border-radius: 10px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.06)%22%7D%5D"][vc_column_inner offset="vc_col-md-4" responsive_css="border_right_medium:1px|border_bottom_medium:0px|padding_top_medium:100px|padding_right_medium:5%25|padding_bottom_medium:100px|padding_left_medium:10%25|padding_right_small:30px|padding_left_small:30px" css=".vc_custom_1605900568089{border-bottom-width: 1px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;border-bottom-color: #eaeaea !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" enable_blur="true" count="10+" fs="52px" fw="700" color="rgb(0, 207, 50)" start_delay="250"][ld_fancy_heading tag="h5" margin="bottom_small:1.5em"]Years of Operation[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(102, 102, 102)" fs="18px" lh="1.666em"]Our team have been running well about 10 years and keep going.[/ld_fancy_heading][/vc_column_inner][vc_column_inner offset="vc_col-md-4" responsive_css="border_right_medium:1px|border_bottom_medium:0px|padding_top_medium:100px|padding_right_medium:5%25|padding_bottom_medium:100px|padding_left_medium:10%25|padding_right_small:30px|padding_left_small:30px" css=".vc_custom_1605900583205{border-bottom-width: 1px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;border-bottom-color: #eaeaea !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" enable_blur="true" count="98%" fs="52px" fw="700" color="rgb(0, 207, 50)" start_delay="500"][ld_fancy_heading tag="h5" margin="bottom_small:1.5em"]Positive Feedback[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(102, 102, 102)" fs="18px" lh="1.666em"]Based on our happy clients about the quality of our products &amp; services.[/ld_fancy_heading][/vc_column_inner][vc_column_inner offset="vc_col-md-4" responsive_css="border_right_medium:1px|border_bottom_medium:0px|padding_top_medium:100px|padding_right_medium:5%25|padding_bottom_medium:100px|padding_left_medium:10%25|padding_right_small:30px|padding_left_small:30px" css=".vc_custom_1605900599342{border-bottom-width: 1px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" enable_blur="true" count="2,664" fs="52px" fw="700" color="rgb(0, 207, 50)" start_delay="750"][ld_fancy_heading tag="h5" margin="bottom_small:1.5em"]Projects Copmpleted[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(102, 102, 102)" fs="18px" lh="1.666em"]All projects competeled with an absolutely high quality[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 4
	$data = array();
	$data['name'] = esc_html__( 'Counters 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-4.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1621601353698{border-bottom-width: 1px !important;padding-top: 45px !important;padding-bottom: 45px !important;border-bottom-color: #d1d1d1 !important;border-bottom-style: solid !important;}"][vc_column responsive_align="text-center" css=".vc_custom_1621602116570{margin-bottom: 25px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:12px" fw="text_small:700" ls="text_small:0.1em" color="rgb(15, 90, 100)"]GLOBAL CLIENTS AROUND THE WORLD[/ld_fancy_heading][/vc_column][vc_column width="1/2" css=".vc_custom_1621602033442{margin-bottom: 25px !important;}" offset="vc_col-md-3" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" use_inheritance="true" color="rgb(15, 90, 100)" fs="text_small:62px" margin="bottom_small:0px"]2.7x[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.4)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.1em"]Avarage growth[/ld_fancy_heading][/vc_column][vc_column width="1/2" css=".vc_custom_1621602033442{margin-bottom: 25px !important;}" offset="vc_col-md-3" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" use_inheritance="true" color="rgb(15, 90, 100)" fs="text_small:62px" margin="bottom_small:0px"]98.7+[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.4)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.1em"]Customer satisfaction[/ld_fancy_heading][/vc_column][vc_column width="1/2" css=".vc_custom_1621602033442{margin-bottom: 25px !important;}" offset="vc_col-md-3" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" use_inheritance="true" color="rgb(15, 90, 100)" fs="text_small:62px" margin="bottom_small:0px"]302m[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.4)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.1em"]Monthly Payment[/ld_fancy_heading][/vc_column][vc_column width="1/2" css=".vc_custom_1621602033442{margin-bottom: 25px !important;}" offset="vc_col-md-3" responsive_align="text-center"][ld_fancy_heading tag="p" use_custom_fonts_title="true" use_inheritance="true" color="rgb(15, 90, 100)" fs="text_small:62px" margin="bottom_small:0px"]287+[/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.4)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.1em"]Agents around the world[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 5
	$data = array();
	$data['name'] = esc_html__( 'Counters 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-5.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row gap="5" bg_position="center center" css=".vc_custom_1611654023273{padding-top: 45px !important;padding-bottom: 45px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:65px|padding_bottom_medium:65px"][vc_column responsive_align="text-center" css=".vc_custom_1608725453633{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" duration="1600" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em" ca_init_translate_y="30" ca_init_rotate_z="2"]Global clients around the world[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" use_mask="true" fs="text_medium:62px|text_small:52px" fw="text_small:700" margin="bottom_small:0px" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]3160[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Avarage growth[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="250"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" use_mask="true" fs="text_medium:62px|text_small:52px" fw="text_small:700" margin="bottom_small:0px" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]830[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Customer satisfaction[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="500"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" use_mask="true" fs="text_medium:62px|text_small:52px" fw="text_small:700" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em" margin="bottom_small:0px"][ld_highlight]127[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Daily data input[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="750"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" use_inheritance="true" enable_split="true" use_mask="true" fs="text_medium:62px|text_small:52px" fw="text_small:700" margin="bottom_small:0px" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]1134[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Hub it Employees[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 6
	$data = array();
	$data['name'] = esc_html__( 'Counters 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-6.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1605615466165{padding-bottom: 60px !important;}" responsive_css="margin_bottom_medium:70px|padding_top_medium:50px|padding_bottom_medium:100px"][vc_column offset="vc_col-md-5" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-lowercase" duration="1600" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_bg="yes" fh_border_radius="circle" enable_split="true" margin="bottom_small:0.75em" ca_init_translate_x="0" ca_init_rotate_y="0" ca_init_translate_y="35" color="rgb(255, 90, 61)" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(255, 234, 230)"]Digital Experience[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_offset="0.1em" use_custom_fonts_title="true" enable_fit="true" fs="text_large:48px|text_small:35px" lh="text_small:1.2em" margin="bottom_small:0.65em" minfontsize="36" highlight_color="rgba(255, 185, 158, 0.52)"]The hundred of completed works still [ld_highlight]counting[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="20px" lh="1.5em" margin="bottom_small:2.5em"]Through strategy, design, and planning we build brand identities that connect with your Nesi. We then fine-tune a marketing plan that allows us to laser focus and target your audience through the right channels.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-5"][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="58" translate_from_y="80" translate_to_y="-80" position="bottom_small:-25px|left_small:-50px"][/ld_images_group_element][vc_row_inner equal_height="yes" content_placement="middle" gap="0" enable_row_shadowbox="yes" css=".vc_custom_1611001202350{padding-top: 15px !important;background-color: #ffffff !important;border-radius: 15px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2250px%22%2C%22blur_radius%22%3A%2290px%22%2C%22shadow_color%22%3A%22rgba(22%2C17%2C147%2C0.1)%22%7D%5D" responsive_css="padding_top_medium:0px"][vc_column_inner width="1/2" responsive_css="border_right_medium:1px" css=".vc_custom_1605986896192{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" offset="vc_col-xs-6"][ld_counter content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="19+" label="Total Top Services" fs="48px" fw="700" label_color="rgb(153, 153, 153)" counter_mb="13" color="rgb(26, 55, 96)"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1605986910497{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" offset="vc_col-xs-6"][ld_counter content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="27+" label="Countries" fs="48px" fw="700" color="rgb(26, 55, 96)" label_color="rgb(153, 153, 153)" counter_mb="13"][/vc_column_inner][vc_column_inner width="1/2" responsive_css="border_right_medium:1px" css=".vc_custom_1605986926031{border-right-width: 0px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;}" offset="vc_col-xs-6"][ld_counter content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="98%" label="Positive Feedback" fs="48px" fw="700" color="rgb(26, 55, 96)" label_color="rgb(153, 153, 153)" counter_mb="13"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1605986941269{padding-top: 45px !important;padding-bottom: 15px !important;}" offset="vc_col-xs-6"][ld_counter content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="2,663" label="Usual Users" fs="48px" fw="700" color="rgb(26, 55, 96)" label_color="rgb(153, 153, 153)" counter_mb="13"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 7
	$data = array();
	$data['name'] = esc_html__( 'Counters 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-7.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" css=".vc_custom_1606294189034{padding-top: 10px !important;padding-bottom: 10px !important;}"][vc_column width="1/2" css=".vc_custom_1606293526721{margin-bottom: 35px !important;border-bottom-width: 3px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}" offset="vc_col-md-3 vc_col-xs-6"][ld_counter use_custom_fonts_title="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" label="Years of experience" count="70+" fs="49px" lh="1.5em" text_fs="20px" text_lh="1.25em" color="rgb(17, 36, 70)" counter_mb="10"][/vc_column][vc_column width="1/2" css=".vc_custom_1606293532850{margin-bottom: 35px !important;border-bottom-width: 3px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}" offset="vc_col-md-3 vc_col-xs-6"][ld_counter use_custom_fonts_title="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" label="People and Projects" count="860" fs="49px" lh="1.5em" text_fs="20px" text_lh="1.25em" color="rgb(17, 36, 70)" start_delay="250" counter_mb="10"][/vc_column][vc_column width="1/2" css=".vc_custom_1606293539759{margin-bottom: 35px !important;border-bottom-width: 3px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}" offset="vc_col-md-3 vc_col-xs-6"][ld_counter use_custom_fonts_title="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" label="Layer Count" count="900%" fs="49px" lh="1.5em" text_fs="20px" text_lh="1.25em" color="rgb(17, 36, 70)" start_delay="500" counter_mb="10"][/vc_column][vc_column width="1/2" css=".vc_custom_1606293548785{margin-bottom: 35px !important;border-bottom-width: 3px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}" offset="vc_col-md-3 vc_col-xs-6"][ld_counter use_custom_fonts_title="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" label="Successful Projects" count="3.7m" fs="49px" lh="1.5em" text_fs="20px" text_lh="1.25em" color="rgb(17, 36, 70)" start_delay="700" counter_mb="10"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 8
	$data = array();
	$data['name'] = esc_html__( 'Counters 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-8.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Counters 9
	$data = array();
	$data['name'] = esc_html__( 'Counters 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-9.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="center center" css=".vc_custom_1608725614361{padding-top: 45px !important;padding-bottom: 45px !important;background-image: url(https://businessstartuppro.liquid-themes.com/wp-content/uploads/2020/12/map.png?id=252) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:85px|padding_bottom_medium:85px"][vc_column responsive_align="text-center" css=".vc_custom_1608725453633{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" duration="1600" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em" ca_init_translate_y="30" ca_init_rotate_z="2"]Global clients around the world[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5"][ld_fancy_heading tag="h5" split_type="chars, words" highlight_height="13px" highlight_offset="0.25em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:52px" fw="text_small:700" margin="bottom_small:0.25em" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]2.6x[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Avarage growth[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="250"][ld_fancy_heading tag="h5" split_type="chars, words" highlight_height="13px" highlight_offset="0.25em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:52px" fw="text_small:700" margin="bottom_small:0.25em" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]88.5%[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Customer satisfaction[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="500"][ld_fancy_heading tag="h5" split_type="chars, words" highlight_height="13px" highlight_offset="0.25em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:52px" fw="text_small:700" margin="bottom_small:0.25em" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]302m[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Daily data input[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="750"][ld_fancy_heading tag="h5" split_type="chars, words" highlight_height="13px" highlight_offset="0.25em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:52px" fw="text_small:700" margin="bottom_small:0.25em" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]287+[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Hub it Employees[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 10
	$data = array();
	$data['name'] = esc_html__( 'Counters 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-10.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1610701078375{padding-top: 60px !important;padding-bottom: 30px !important;}" responsive_css="padding_top_medium:60px|padding_bottom_medium:60px|padding_top_small:90px"][vc_column offset="vc_col-md-5"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" margin="bottom_small:0.75em" color="rgb(86, 154, 204)" fs="text_small:16px"]What we achieved[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" enable_fit="true" fs="text_small:39px" lh="text_small:1.05em" margin="bottom_small:0.65em" minfontsize="36" color="rgb(31, 42, 88)"]Hub generated 2x more online sales in 2021.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.5em" margin="bottom_small:2.5em"]Through strategy, design, and planning we build brand identities that connect with your Nesi. We then fine-tune a marketing plan that allows us to laser focus.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-lg-5 vc_col-md-offset-1 vc_col-md-6"][ld_images_group_container absolute_pos="yes" position="right_small:-30px|bottom_small:-70px|left_small:-30px"][ld_images_group_element absolute_pos="yes" image="333" position="bottom_small:0px|left_small:0px"][/ld_images_group_element][ld_images_group_element absolute_pos="yes" image="382" position="right_small:-110px|bottom_small:-80px"][/ld_images_group_element][/ld_images_group_container][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="58" translate_from_y="80" translate_to_y="-80" position="bottom_small:-25px|left_small:-50px"][/ld_images_group_element][vc_row_inner equal_height="yes" content_placement="middle" gap="0" enable_row_shadowbox="yes" css=".vc_custom_1605987054627{padding-top: 15px !important;background-color: #ffffff !important;border-radius: 15px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2223px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.08)%22%7D%5D" responsive_css="padding_top_medium:0px"][vc_column_inner width="1/2" responsive_css="border_right_medium:1px" css=".vc_custom_1610701571587{border-right-width: 1px !important;border-bottom-width: 1px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" offset="vc_col-xs-6"][ld_counter template="`{`object Object`}`" content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="19+" label="Total Top Services" fs="48px" fw="700" color="rgb(0, 0, 0)" label_color="rgb(153, 153, 153)" counter_mb="13"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1605986910497{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;border-bottom-color: #eeeeee !important;border-bottom-style: solid !important;}" offset="vc_col-xs-6"][ld_counter template="`{`object Object`}`" content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="27+" label="Countries" fs="48px" fw="700" color="rgb(0, 0, 0)" label_color="rgb(153, 153, 153)" counter_mb="13"][/vc_column_inner][vc_column_inner width="1/2" responsive_css="border_right_medium:1px" css=".vc_custom_1610701577771{border-right-width: 1px !important;padding-top: 45px !important;padding-bottom: 15px !important;border-right-color: #eeeeee !important;border-right-style: solid !important;}" offset="vc_col-xs-6"][ld_counter template="`{`object Object`}`" content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="98%" label="Positive Feedback" fs="48px" fw="700" color="rgb(0, 0, 0)" label_color="rgb(153, 153, 153)" counter_mb="13"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1605986941269{padding-top: 45px !important;padding-bottom: 15px !important;}" offset="vc_col-xs-6"][ld_counter template="`{`object Object`}`" content_align="text-center" use_custom_fonts_title="true" counter_mb_checkbox="true" enable_blur="true" count="2,664" label="Usual Users" fs="48px" fw="700" color="rgb(0, 0, 0)" label_color="rgb(153, 153, 153)" counter_mb="13"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_images_group_container move_to_parent_row="yes" position="top_small:35%25|left_small:26%25"][ld_images_group_element image="257"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 11
	$data = array();
	$data['name'] = esc_html__( 'Counters 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-11.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row gap="30" css=".vc_custom_1597155298077{padding-top: 45px !important;padding-bottom: 15px !important;}"][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1573513024104{margin-bottom: 30px !important;border-bottom-width: 2px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" label="Years of experience" count="16+" fs="42px" text_fs="20px" color="rgb(17, 36, 70)"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1573513029203{margin-bottom: 30px !important;border-bottom-width: 2px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" label="Employees" count="80" fs="42px" text_fs="20px" color="rgb(17, 36, 70)" start_delay="150"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1573513033690{margin-bottom: 30px !important;border-bottom-width: 2px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" label="Daily Notifications" count="320k+" fs="42px" text_fs="20px" color="rgb(17, 36, 70)" start_delay="300"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1573513037704{margin-bottom: 30px !important;border-bottom-width: 2px !important;border-bottom-color: #f4f4f7 !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" label="Successful Transactions" count="9.6m" fs="42px" text_fs="20px" color="rgb(17, 36, 70)" start_delay="450"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 12
	$data = array();
	$data['name'] = esc_html__( 'Counters 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-12.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="center center" css=".vc_custom_1609180432662{padding-top: 45px !important;padding-bottom: 45px !important;background-image: url(https://softwarepro.liquid-themes.com/wp-content/uploads/2020/12/map.png?id=273) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:55px|padding_bottom_medium:55px"][vc_column offset="vc_hidden-xs"][ld_images_group_container parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" position="right_all:0px|left_all:15%25|top_large:-25vh|left_large:10%25|top_small:-10vh|right_small:15%25|left_small:15%25" translate_from_y="90" translate_to_y="-90"][ld_images_group_element image="274"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column responsive_align="text-center" css=".vc_custom_1608725453633{margin-bottom: 15px !important;}"][ld_fancy_heading tag="p" transform="text-uppercase" duration="1600" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em" ca_init_translate_y="30" ca_init_rotate_z="2"]Global clients around the world[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:47px" fw="text_small:700" margin="bottom_small:0px" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]2.6x[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Avarage growth[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="250"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:47px" fw="text_small:700" margin="bottom_small:0px" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]99.6%[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Customer satisfaction[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="500"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:47px" fw="text_small:700" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em" margin="bottom_small:0px"][ld_highlight]302m[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Daily data input[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3 vc_col-xs-6" responsive_align="text-center" ca_duration="1600" ca_delay="80" ca_init_translate_y="60" ca_init_translate_x="0" ca_init_rotate_z="5" ca_start_delay="750"][ld_fancy_heading tag="p" split_type="chars, words" highlight_height="13px" highlight_offset="0.15em" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_medium:62px|text_small:47px" fw="text_small:700" margin="bottom_small:0px" highlight_color="rgba(113, 252, 188, 0.65)" lh="text_small:1em"][ld_highlight]287+[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(30, 47, 105)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em"]Hub it Employees[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 13
	$data = array();
	$data['name'] = esc_html__( 'Counters 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-13.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row enable_row_dividers="yes" responsive_css="padding_top_medium:130px|padding_bottom_medium:130px" css=".vc_custom_1621949257015{padding-top: 100px !important;padding-bottom: 100px !important;background-color: #f2f5f8 !important;}" row_svg_divider="top_shape_type:9|top_shape_color:%23ffffff|top_shape_height:31|bottom_shape_type:9|bottom_shape_color:%23ffffff|bottom_shape_height:32"][vc_column offset="vc_col-md-6" responsive_css="padding_right_large:10%25"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" color="rgb(42, 195, 177)" padding="top_small:0.625em|right_small:1em|bottom_small:0.625em|left_small:1em" fh_bg="rgba(42, 195, 177, 0.1)" margin="bottom_small:1em"]Testimonials[/ld_fancy_heading][ld_fancy_heading tag="h2" margin="bottom_small:0.35em"]So that one day, like magic, children will no longer need us.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.52em" margin="bottom_small:0.35em"]There’s even magic in our motivation: our unblinking belief that we can eradicae childhood disease — so that one day, like magic, children will no longer need us.[/ld_fancy_heading][/vc_column][/vc_row][vc_row css=".vc_custom_1621949959063{padding-top: 25px !important;padding-bottom: 25px !important;}"][vc_column width="1/3" offset="vc_col-md-2"][ld_counter use_custom_fonts_title="true" use_custom_fonts_text="true" counter_mb_checkbox="true" count="66K" label="STUDENTS LEANING" fs="50px" text_fs="10px" text_ls="0.1em" text_fw="700" counter_mb="5"][/vc_column][vc_column width="1/3" offset="vc_col-md-2"][ld_counter use_custom_fonts_title="true" use_custom_fonts_text="true" counter_mb_checkbox="true" count="90+" label="LOCAL SCHOOLS" fs="50px" text_fs="10px" text_ls="0.1em" text_fw="700" counter_mb="5" start_delay="250"][/vc_column][vc_column width="1/3" offset="vc_col-md-2"][ld_counter use_custom_fonts_title="true" use_custom_fonts_text="true" counter_mb_checkbox="true" count="11m" label="ENGLISH TEACHERS" fs="50px" text_fs="10px" text_ls="0.1em" text_fw="700" counter_mb="5" start_delay="500"][/vc_column][vc_column offset="vc_col-md-6" responsive_css="margin_top_medium:-388px|margin_right_medium:6%25|margin_left_medium:6%25|padding_right_medium:45px|padding_left_medium:45px" css=".vc_custom_1621952551902{margin-top: 25px !important;padding-top: 55px !important;padding-right: 20px !important;padding-bottom: 55px !important;padding-left: 20px !important;background: #32494c url(https://staging.liquid-themes.com/kids/wp-content/uploads/2021/05/overlay@2x.png?id=105) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 10px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:26px" lh="text_small:1.3em" margin="bottom_small:1.75em"]By enrolling in the Four Bear Program, Hub guarantees you will graduate in four years with a bachelor’s degree. Discover the global city—filled with inspiration, opportunities to explore.[/ld_fancy_heading][vc_separator color="custom" style="dashed" accent_color="rgba(255, 255, 255, 0.2)" css=".vc_custom_1621950334338{margin-bottom: 45px !important;}"][ld_images_group_element absolute_pos="yes" image="106" position="bottom_small:-95px|left_small:-40px"][/ld_images_group_element][ld_fancy_heading tag="h4" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:19px" margin="bottom_small:0.25em"]Marrion Miller[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(255, 255, 255)" fs="text_small:14px" margin="bottom_small:0.25em"]Maputo, Africa[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 14
	$data = array();
	$data['name'] = esc_html__( 'Counters 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-14.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:75px|padding_bottom_medium:65px" css=".vc_custom_1621856127454{padding-top: 35px !important;padding-bottom: 30px !important;}"][vc_column enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" enable_overlay="yes" enable_column_hover_shadowbox="yes" offset="vc_col-md-4" css=".vc_custom_1622018829240{margin-bottom: 30px !important;padding-top: 20px !important;padding-bottom: 35px !important;border-radius: 10px !important;}" responsive_css="margin_bottom_medium:0px" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22spread_radius%22%3A%22-4px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.08)%22%7D%5D" overlay_bg="rgb(244, 246, 247)" hover_overlay_bg="rgb(255, 255, 255)"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:49px" padding="right_all:50px|left_all:50px|right_small:20px|left_small:20px" margin="bottom_small:0.25em"]2.3x[/ld_fancy_heading][vc_separator color="custom" accent_color="rgb(255, 255, 255)" css=".vc_custom_1621858582603{margin-top: 0px !important;margin-bottom: 30px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(15, 64, 100, 0.85)" fs="text_small:17px" padding="right_large:50px|left_large:50px|right_small:20px|left_small:20px" margin="bottom_small:0px"]Average yearly growth[/ld_fancy_heading][/vc_column][vc_column enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" enable_overlay="yes" enable_column_hover_shadowbox="yes" offset="vc_col-md-4" css=".vc_custom_1622017094844{margin-bottom: 30px !important;padding-top: 20px !important;padding-bottom: 35px !important;border-radius: 10px !important;}" responsive_css="margin_bottom_medium:0px" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22spread_radius%22%3A%22-4px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.06)%22%7D%5D" overlay_bg="rgb(244, 246, 247)" hover_overlay_bg="rgb(255, 255, 255)"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:49px" padding="right_all:50px|left_all:50px|right_small:20px|left_small:20px" margin="bottom_small:0.25em"]98%[/ld_fancy_heading][vc_separator color="custom" accent_color="rgb(255, 255, 255)" css=".vc_custom_1621858582603{margin-top: 0px !important;margin-bottom: 30px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(15, 64, 100, 0.85)" fs="text_small:17px" padding="right_large:50px|left_large:50px|right_small:20px|left_small:20px" margin="bottom_small:0px"]Avarage customer satisfaction[/ld_fancy_heading][/vc_column][vc_column enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" enable_overlay="yes" enable_column_hover_shadowbox="yes" offset="vc_col-md-4" css=".vc_custom_1622018848241{margin-bottom: 30px !important;padding-top: 20px !important;padding-bottom: 35px !important;background-color: #f4f6f7 !important;border-radius: 10px !important;}" responsive_css="margin_bottom_medium:0px" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22spread_radius%22%3A%22-4px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.08)%22%7D%5D" overlay_bg="rgb(244, 246, 247)" hover_overlay_bg="rgb(255, 255, 255)"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:49px" padding="right_all:50px|left_all:50px|right_small:20px|left_small:20px" margin="bottom_small:0.25em"]168m[/ld_fancy_heading][vc_separator color="custom" accent_color="rgb(255, 255, 255)" css=".vc_custom_1621858582603{margin-top: 0px !important;margin-bottom: 30px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(15, 64, 100, 0.85)" fs="text_small:17px" padding="right_large:50px|left_large:50px|right_small:20px|left_small:20px" margin="bottom_small:0px"]Trusted Dealer and Clients[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 15
	$data = array();
	$data['name'] = esc_html__( 'Counters 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-15.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" responsive_css="padding_top_medium:50px|padding_bottom_medium:50px" css=".vc_custom_1622033178527{padding-top: 35px !important;padding-bottom: 35px !important;}"][vc_column width="1/2" offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px|padding_right_medium:20%25|border_right_small:1px" css=".vc_custom_1622100548152{margin-bottom: 30px !important;border-right-width: 0px !important;border-right-color: rgba(112,112,112,0.15) !important;border-right-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" count="10+" label="Years of experience. The many strands of place-" fs="66px" lh="1em" ls="-0.01em" color="rgb(177, 120, 86)" label_color="rgb(35, 42, 59)" el_class="mb-0" fw="500"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px|border_right_medium:1px|padding_right_medium:10%25|padding_left_medium:10%25" css=".vc_custom_1622100324416{margin-bottom: 30px !important;border-right-width: 0px !important;border-right-color: rgba(112,112,112,0.15) !important;border-right-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" count="88%" label="Years of experience. The many strands of place-" fs="66px" lh="1em" ls="-0.01em" color="rgb(177, 120, 86)" label_color="rgb(35, 42, 59)" el_class="mb-0" start_delay="200" fw="500"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px|padding_right_medium:10%25|padding_left_medium:10%25|border_right_small:1px" css=".vc_custom_1622100673222{margin-bottom: 30px !important;border-right-width: 0px !important;border-right-color: rgba(112,112,112,0.15) !important;border-right-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" count="160+" label="Years of experience. The many strands of place-" fs="66px" lh="1em" ls="-0.01em" color="rgb(177, 120, 86)" label_color="rgb(35, 42, 59)" el_class="mb-0" start_delay="400" fw="500"][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_css="margin_bottom_medium:0px|padding_right_medium:10%25|padding_left_medium:10%25" css=".vc_custom_1622030881033{margin-bottom: 30px !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" use_custom_fonts_text="true" count="13m" label="Years of experience. The many strands of place-" fs="66px" lh="1em" ls="-0.01em" color="rgb(177, 120, 86)" label_color="rgb(35, 42, 59)" el_class="mb-0" start_delay="600" fw="500"][/vc_column][vc_column css=".vc_custom_1622031163999{border-bottom-width: 23px !important;padding-top: 30px !important;border-bottom-color: #f7f7f7 !important;border-bottom-style: solid !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Counters 16
	$data = array();
	$data['name'] = esc_html__( 'Counters 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'counters-16.jpg' );
	$data['sort_name'] = 'Counters, Icon';
	$data['custom_class'] = 'general counters';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" parallax="enable_parallax" enable_overlay="yes" enable_row_dividers="yes" responsive_css="padding_top_medium:125px|padding_bottom_medium:125px" css=".vc_custom_1622009655669{padding-top: 70px !important;padding-bottom: 70px !important;background-image: url(https://staging.liquid-themes.com/kids/wp-content/uploads/2021/05/bg-2@2x.jpg?id=82) !important;background-position: center;background-repeat: no-repeat;background-size:cover;}" overlay_bg="rgba(47, 40, 40, 0.5)" row_svg_divider="bottom_shape_type:7|bottom_shape_color:%23ffffff|bottom_shape_height:16" el_id="events"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1621947681326{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" color="rgb(255, 126, 106)" padding="top_small:0.625em|right_small:1em|bottom_small:0.625em|left_small:1em" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]Spread Love[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_small:0.35em" color="rgb(255, 255, 255)" fs="text_medium:50px"]Take advantage of many education programs.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.52em" margin="bottom_small:0.35em" color="rgba(255, 255, 255, 0.88)" padding="right_all:25%25|right_large:15%25"]Join us in the 100 campaign, a year-long journey to bring 100 children home to 100 families.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-4" responsive_align="text-md-center"][ld_images_group_element absolute_pos="yes" image="84" position="top_small:-50px|left_small:-100px" hide_el="hidden-xs hidden-sm"][/ld_images_group_element][ld_counter tag_to_inherite_label="h4" use_custom_fonts_title="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" count="98%" fs="79px" color="rgb(255, 255, 255)" label="Success Rate" text_fs="23px" label_color="rgb(255, 255, 255)" counter_mb="13"][ld_button style="btn-underlined" title="Become Volunteer" link="url:%23|||" color="rgb(255, 255, 255)" lh="text_small:1em" fw="text_small:400"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Fancy Box
	//Fancy Box 1
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-1.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row gap="25" css=".vc_custom_1611248257778{padding-top: 80px !important;padding-bottom: 50px !important;}"][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" css=".vc_custom_1611049825683{margin-bottom: 45px !important;background-color: #ffffff !important;}" offset="vc_col-md-4" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:About||"][vc_single_image image="8738" css=".vc_custom_1607933290308{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Research and Development[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" css=".vc_custom_1611049834512{margin-bottom: 30px !important;background-color: #ffffff !important;}" offset="vc_col-md-4" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Course||"][vc_single_image image="8739" css=".vc_custom_1607933233844{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Science[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Startup Investment[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" css=".vc_custom_1611049844140{margin-bottom: 30px !important;background-color: #ffffff !important;}" offset="vc_col-md-4" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Course||"][vc_single_image image="8740" css=".vc_custom_1607933270102{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Leading Experience[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" offset="vc_col-md-4" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Service%20Detail||" css=".vc_custom_1611049851061{margin-bottom: 30px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D"][vc_single_image image="8740" css=".vc_custom_1607933282804{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Zero Commision[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" offset="vc_col-md-4" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Service%20Detail||" css=".vc_custom_1611049861827{margin-bottom: 30px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D"][vc_single_image image="8738" css=".vc_custom_1607933290308{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Science[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Leading Experience[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column enable_link="enable_column_link" width="1/2" enable_column_shadowbox="yes" offset="vc_col-md-4" link="url:https%3A%2F%2Fcompanyhub.liquid-themes.com%2Fstaging%2Findex.php%2Fservice-detail%2F|title:Service%20Detail||" css=".vc_custom_1611049869937{margin-bottom: 30px !important;background-color: #ffffff !important;}" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%22120px%22%2C%22shadow_color%22%3A%22rgba(149%2C%20146%2C%20157%2C%200.15)%22%7D%5D"][vc_single_image image="8739" css=".vc_custom_1607933309038{margin-bottom: 20px !important;}"][vc_row_inner css=".vc_custom_1575467932417{padding-right: 22px !important;padding-bottom: 35px !important;padding-left: 22px !important;}"][vc_column_inner][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(137, 32, 32)" fs="12px" padding="top_small:4px|right_small:10px|bottom_small:4px|left_small:10px" fh_bg="rgba(137, 32, 32, 0.07)" margin="bottom_small:1em"]Language[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:24px" margin="bottom_small:0.35em"]Big Data Analysis[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(112, 112, 112)" fs="14px" lh="22px" margin="bottom_small:0.75em"]Discover the global city—filled inspiration, opportunities to explore.[/ld_fancy_heading][ld_button style="btn-naked" title="Explore diversity at Chicago" i_type="linea" i_add_icon="true" i_icon_linea="icon-ion-ios-arrow-forward" fs="14px"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Fancy Box 2 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-2.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:80px|padding_bottom_medium:80px" css=".vc_custom_1608550148416{padding-top: 60px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Global Data Analysis" image="183" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Research and Development" image="182" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Startup Investment" image="184" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="RD Service Plan" image="184" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Growth Plan" image="183" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][vc_column width="1/2" offset="vc_col-md-4"][ld_content_box template="s04" show_button="yes" ib_style="btn-naked" ib_title="Discover Hub" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_add_icon="true" title="Business Consultation" image="182" border_color="rgb(62, 173, 60)" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-round-forward" ib_lh="1.5em" ib_ls="0.05em" ib_i_margin_left="10px"]Highly flexible, adaptable, and scalable projects for your startups.[/ld_content_box][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 3 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-3.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px" css=".vc_custom_1621613980008{padding-top: 70px !important;padding-bottom: 70px !important;}" el_id="packages"][vc_column offset="vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:47px"]Insurance Packages.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-md-5"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(80, 80, 80)" fs="text_small:18px" lh="text_small:1.55em"]Being a first-choice employer within our sectors. Our process applies techniques from a variety of disciplines.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-1" responsive_align="text-md-right" el_id="package-carousel-nav"][/vc_column][vc_column css=".vc_custom_1621600519269{padding-top: 30px !important;}"][ld_carousel_tab columns="md:3|sm:2.5|xs:1|spacing_sm:25px|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" groupcells="no" wraparound="yes" equalheightcells="yes" navarrow="4" navappend="custom_id" navsize="carousel-nav-sm" navshape="carousel-nav-square" navline="carousel-nav-dot-between" mobile_dots_position="carousel-dots-mobile-inside" navappend_id="#package-carousel-nav" shapesize="16px"][ld_carousel_section title="Carousel Item" tab_id="lqd-1621598718655-80c80356-1fee"][vc_row_inner css=".vc_custom_1621599561629{margin-bottom: 45px !important;}"][vc_column_inner enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1621599326460{padding-top: 22px !important;padding-bottom: 25px !important;background-color: #f8f8f8 !important;border-radius: 10px !important;}" hover_overlay_bg="rgb(255, 255, 255)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(65%2C%2094%2C%20148%2C%200.09)%22%7D%5D"][ld_fancy_heading tag="h6" alignment="text-right" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(51, 51, 51)" fs="text_small:10px" lh="text_small:1em" fw="text_small:700" ls="text_small:0.1em" padding="top_small:7px|right_small:10px|bottom_small:7px|left_small:10px" fh_bg="rgb(255, 255, 255)" margin="right_small:35px"]New[/ld_fancy_heading][ld_icon_box i_type="image" heading_size="custom" alignment="text-left" i_icon_image="3477" title="Protected Insurance" custom_heading_size="23px" css=".vc_custom_1621600093542{margin-bottom: 35px !important;padding-right: 35px !important;padding-left: 35px !important;}" custom_size="58px" icon_mb="30" title_mb="15"]<span style="font-size: 17px; line-height: 1.47em;">Adjust global theme options and see design changes in real-time.</span>[/ld_icon_box][vc_separator color="custom" accent_color="#e6e6e6" css=".vc_custom_1621599381041{margin-top: 0px !important;margin-bottom: 0px !important;}"][ld_button style="btn-naked" title="Learn more" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" css=".vc_custom_1621599449886{margin-top: 20px !important;margin-right: 35px !important;margin-left: 35px !important;}" color="rgb(15, 90, 100)" hover_color="rgb(0, 0, 0)" fs="text_small:15px"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1621599795422-fd00bb79-f296"][vc_row_inner css=".vc_custom_1621599561629{margin-bottom: 45px !important;}"][vc_column_inner enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1621599326460{padding-top: 22px !important;padding-bottom: 25px !important;background-color: #f8f8f8 !important;border-radius: 10px !important;}" hover_overlay_bg="rgb(255, 255, 255)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(65%2C%2094%2C%20148%2C%200.09)%22%7D%5D"][ld_fancy_heading tag="h6" alignment="text-right" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(51, 51, 51)" fs="text_small:10px" lh="text_small:1em" fw="text_small:700" ls="text_small:0.1em" padding="top_small:7px|right_small:10px|bottom_small:7px|left_small:10px" fh_bg="rgb(255, 255, 255)" margin="right_small:35px"]Offer[/ld_fancy_heading][ld_icon_box i_type="image" heading_size="custom" alignment="text-left" i_icon_image="3478" title="Healthcare Policy" custom_heading_size="23px" css=".vc_custom_1621599811757{margin-bottom: 35px !important;padding-right: 35px !important;padding-left: 35px !important;}" custom_size="50px" icon_mb="30" title_mb="15"]<span style="font-size: 17px; line-height: 1.47em;">Adjust global theme options and see design changes in real-time.</span>[/ld_icon_box][vc_separator color="custom" accent_color="#e6e6e6" css=".vc_custom_1621599381041{margin-top: 0px !important;margin-bottom: 0px !important;}"][ld_button style="btn-naked" title="Learn more" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" css=".vc_custom_1621599449886{margin-top: 20px !important;margin-right: 35px !important;margin-left: 35px !important;}" color="rgb(15, 90, 100)" hover_color="rgb(0, 0, 0)" fs="text_small:15px"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1621599820576-00ce6812-07a4"][vc_row_inner css=".vc_custom_1621599561629{margin-bottom: 45px !important;}"][vc_column_inner enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1621599326460{padding-top: 22px !important;padding-bottom: 25px !important;background-color: #f8f8f8 !important;border-radius: 10px !important;}" hover_overlay_bg="rgb(255, 255, 255)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(65%2C%2094%2C%20148%2C%200.09)%22%7D%5D"][ld_fancy_heading tag="h6" alignment="text-right" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(51, 51, 51)" fs="text_small:10px" lh="text_small:1em" fw="text_small:700" ls="text_small:0.1em" padding="top_small:7px|right_small:10px|bottom_small:7px|left_small:10px" fh_bg="rgb(255, 255, 255)" margin="right_small:35px"]Hot[/ld_fancy_heading][ld_icon_box i_type="image" heading_size="custom" alignment="text-left" i_icon_image="3479" title="Car / Vehicle Insurance" custom_heading_size="23px" css=".vc_custom_1621599934303{margin-bottom: 35px !important;padding-right: 35px !important;padding-left: 35px !important;}" custom_size="65px" icon_mb="26" title_mb="15"]<span style="font-size: 17px; line-height: 1.47em;">Adjust global theme options and see design changes in real-time.</span>[/ld_icon_box][vc_separator color="custom" accent_color="#e6e6e6" css=".vc_custom_1621599381041{margin-top: 0px !important;margin-bottom: 0px !important;}"][ld_button style="btn-naked" title="Learn more" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" css=".vc_custom_1621599449886{margin-top: 20px !important;margin-right: 35px !important;margin-left: 35px !important;}" color="rgb(15, 90, 100)" hover_color="rgb(0, 0, 0)" fs="text_small:15px"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1621599987738-6e0435c7-e658"][vc_row_inner css=".vc_custom_1621599561629{margin-bottom: 45px !important;}"][vc_column_inner enable_overlay="yes" enable_column_hover_shadowbox="yes" css=".vc_custom_1621599326460{padding-top: 22px !important;padding-bottom: 25px !important;background-color: #f8f8f8 !important;border-radius: 10px !important;}" hover_overlay_bg="rgb(255, 255, 255)" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2250px%22%2C%22shadow_color%22%3A%22rgba(65%2C%2094%2C%20148%2C%200.09)%22%7D%5D"][ld_fancy_heading tag="h6" alignment="text-right" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(51, 51, 51)" fs="text_small:10px" lh="text_small:1em" fw="text_small:700" ls="text_small:0.1em" padding="top_small:7px|right_small:10px|bottom_small:7px|left_small:10px" fh_bg="rgb(255, 255, 255)" margin="right_small:35px"]Offer[/ld_fancy_heading][ld_icon_box i_type="image" heading_size="custom" alignment="text-left" i_icon_image="3478" title="Healthcare Policy" custom_heading_size="23px" css=".vc_custom_1621599811757{margin-bottom: 35px !important;padding-right: 35px !important;padding-left: 35px !important;}" custom_size="50px" icon_mb="30" title_mb="15"]<span style="font-size: 17px; line-height: 1.47em;">Adjust global theme options and see design changes in real-time.</span>[/ld_icon_box][vc_separator color="custom" accent_color="#e6e6e6" css=".vc_custom_1621599381041{margin-top: 0px !important;margin-bottom: 0px !important;}"][ld_button style="btn-naked" title="Learn more" i_type="linea" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" css=".vc_custom_1621599449886{margin-top: 20px !important;margin-right: 35px !important;margin-left: 35px !important;}" color="rgb(15, 90, 100)" hover_color="rgb(0, 0, 0)" fs="text_small:15px"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column responsive_align="text-center" responsive_css="padding_top_medium:0px" css=".vc_custom_1621616700255{padding-top: 30px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:15px"]Our nearly 8,000 committed <a href="#">staff members</a> are ready to help.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 4 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-4.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1614669893026{padding-bottom: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:150px" el_id="businesssolutions"][vc_column align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1614670742369{margin-bottom: 30px !important;}" responsive_align="text-left text-md-center" responsive_css="margin_bottom_medium:70px"][ld_fancy_heading tag="h2"]IT Business Solutions[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.6em" padding="bottom_large:0px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/vc_column][vc_column responsive_css="margin_top_medium:0px"][ld_carousel_tab columns="md:3|sm:2|xs:1.15|spacing_sm:22px|spacing_xs:15px" inactiv_opacity="1" cellalign="center" wraparound="yes"][ld_carousel_section title="Section 1" tab_id="1592381833921-56829c90-f38d"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="IT Security" image="45" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Section 2" tab_id="1592381834026-24319b72-5616"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="For companies" image="46" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="1592381906295-db133a42-c5d6"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="Mobile Data" image="44" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="1592381922832-36d419fc-b64a"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-80" i_type="linea" title="Mobile Data" image="44" content_bg="rgb(255, 255, 255)" i_icon_linea="icon-arrow-right-material" i_color="rgb(170, 161, 120)" heading_color="rgb(0, 0, 0)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.42em" padding="right_large:10.5%25|left_large:10.5%25" margin="top_small:10px"]Buyer through your marketing and sales funnels through the power of real-time conversations and forms.[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 5 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-5.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1609856819563{padding-top: 20px !important;padding-bottom: 50px !important;}"][vc_column responsive_align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1609857128979{margin-bottom: 40px !important;}"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(35, 46, 108)" fs="text_small:12px" ls="text_small:0.1em" margin="bottom_small:1.5em"]Our services[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(35, 46, 108)" fs="text_small:43px" margin="bottom_small:0.35em"]Digital Solutions[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_content_box template="s06" use_custom_fonts_title="true" title="Tailor-made digital solutions." fs="26px" lh="1.2em" image="8860" subtitle="Art Direction" fw="600"][/ld_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_content_box template="s06" use_custom_fonts_title="true" title="Online Financial Security" fs="26px" lh="1.2em" image="8862" subtitle="Art Direction" fw="600"][/ld_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_content_box template="s06" use_custom_fonts_title="true" title="Face ID Protection and Analyze" fs="26px" lh="1.2em" image="8863" subtitle="Art Direction" fw="600"][/ld_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][ld_content_box template="s06" use_custom_fonts_title="true" title="Online Privacy And Security" fs="26px" lh="1.2em" image="8861" subtitle="Art Direction" fw="600"][/ld_content_box][/vc_column][vc_column css=".vc_custom_1609857185047{margin-top: 45px !important;}" responsive_align="text-center"][ld_fancy_heading tag="p" color="rgb(0, 0, 0)"]Our nearly 8,000 committed <a href="#">staff members</a> are ready to help.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 6 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-6.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1605608047098{padding-bottom: 60px !important;}" responsive_css="padding_top_medium:80px|padding_bottom_medium:150px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-2 vc_col-md-8" css=".vc_custom_1607336418520{margin-bottom: 40px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="60" responsive_css="margin_bottom_medium:55px|padding_right_medium:7%25|padding_left_medium:7%25" responsive_align="text-md-center"][ld_fancy_heading tag="h2" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22Startups.%22%7D%2C%7B%22word%22%3A%22Digital%20Platforms.%22%7D%2C%7B%22word%22%3A%22Technology%22%7D%5D" use_custom_fonts_title="true" margin="bottom_small:0.35em" fs="text_large:42px|text_small:40px"]Investing in[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:20px|text_small:17px" lh="text_large:34px|text_small:25px"]We help our clients succeed by creating brand identities, digital experiences, and print materials that communicate clearly.[/ld_fancy_heading][/vc_column][vc_column][ld_carousel_tab columns="md:3|sm:2|xs:1.15|spacing_md:30px|spacing_xs:15px" inactiv_opacity="1" enable_item_animation="yes" cellalign="center" pagenationdots="yes" wraparound="yes" dots_bottom_offset="-60px" dots_style="carousel-dots-style2" mobile_dots_bottom_offset_outside="-0.5em" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1800" pf_delay="180" pf_init_translate_y="45"][ld_carousel_section title="Tab" tab_id="lqd-1610529190454-ea1f16c5-b1b9"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="149" style="vc_box_rounded" css=".vc_custom_1596641224806{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Investing in Digital Companies[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="400"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595324695548-74e3fd47-dacf"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="148" style="vc_box_rounded" css=".vc_custom_1596641258953{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Securing Digital Payment[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="399"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1610529182300-5f911446-06c3"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="147" style="vc_box_rounded" css=".vc_custom_1596641348795{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="20px" margin="bottom_small:1em"]Building the idea of future[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="398"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1610529176041-5b3d9b87-c563"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="148" style="vc_box_rounded" css=".vc_custom_1596641258953{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Securing Digital Payment[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="397"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595253276998-204134b5-b96d"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="149" style="vc_box_rounded" css=".vc_custom_1596641224806{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:20px" margin="bottom_small:1em"]Investing in Digital Companies[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="396"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595324697368-7ed8aa77-fb0d"][vc_row_inner][vc_column_inner enable_hover_move="lqd-column-move-onhover" align="text-center" responsive_align="text-center"][vc_single_image image="147" style="vc_box_rounded" css=".vc_custom_1596641348795{margin-bottom: 35px !important;border-radius: 5px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="20px" margin="bottom_small:1em"]Building the idea of future[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:22px"]Hub IT allows your business and technology computers to store, transmit and analyze.[/ld_fancy_heading][vc_single_image image="398"][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 7 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-7.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:40px|padding_bottom_medium:80px|padding_bottom_small:50px" css=".vc_custom_1610110873258{padding-bottom: 30px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1577271701433{margin-bottom: 60px !important;}" responsive_css="padding_right_medium:5%25|padding_left_medium:5%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-center"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(35, 46, 108)" fs="text_medium:43px" margin="bottom_small:0.25em"]Business Solutions[/ld_fancy_heading][ld_fancy_heading tag="p"]We unleash your business potential by maximising the innovation.[/ld_fancy_heading][/vc_column][vc_column][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1610110845951{margin-bottom: 30px !important;}"][ld_flipbox direction="ld-flipbox-tb" shadow="ld-flipbox-shadow-onhover" border_radius="round" bg_image="337" bg_color="linear-gradient(0deg, rgb(24, 27, 49) 0%, rgba(24, 27, 49, 0) 75%)" back_bg_color="rgb(30, 47, 105)"][ld_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1610110470275{margin-right: -50px !important;margin-left: -50px !important;}"][vc_column_inner responsive_css="padding_right_small:20px|padding_left_small:20px" css=".vc_custom_1610110609331{padding-top: 160px !important;padding-right: 15px !important;padding-left: 15px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="text_small:13px" fw="text_small:700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:2em"]finance[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:28px" lh="text_small:1em"]big data integration for startups[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_button style="btn-solid" title="Learn more" shape="round" size="btn-lg" color="rgb(255, 255, 255)" text_color="rgb(35, 46, 108)"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1610110834871{margin-bottom: 30px !important;}"][ld_flipbox direction="ld-flipbox-tb" shadow="ld-flipbox-shadow-onhover" border_radius="round" bg_image="336" bg_color="linear-gradient(0deg, rgb(24, 27, 49) 0%, rgba(24, 27, 49, 0) 75%)" back_bg_color="rgb(30, 47, 105)"][ld_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1610110470275{margin-right: -50px !important;margin-left: -50px !important;}"][vc_column_inner responsive_css="padding_right_small:20px|padding_left_small:20px" css=".vc_custom_1610110609331{padding-top: 160px !important;padding-right: 15px !important;padding-left: 15px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="text_small:13px" fw="text_small:700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:2em"]analytics[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:28px" lh="text_small:1em"]big data integration for startups[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_button style="btn-solid" title="Learn more" shape="round" size="btn-lg" color="rgb(255, 255, 255)" text_color="rgb(35, 46, 108)"][/ld_flipbox_section][/ld_flipbox][/vc_column][vc_column offset="vc_col-md-4" css=".vc_custom_1610110855792{margin-bottom: 30px !important;}"][ld_flipbox direction="ld-flipbox-tb" shadow="ld-flipbox-shadow-onhover" border_radius="round" bg_image="338" bg_color="linear-gradient(0deg, rgb(24, 27, 49) 0%, rgba(24, 27, 49, 0) 75%)" back_bg_color="rgb(30, 47, 105)"][ld_flipbox_section title="Front"][vc_row_inner css=".vc_custom_1610110470275{margin-right: -50px !important;margin-left: -50px !important;}"][vc_column_inner responsive_css="padding_right_small:20px|padding_left_small:20px" css=".vc_custom_1610110609331{padding-top: 160px !important;padding-right: 15px !important;padding-left: 15px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="semi-round" use_custom_fonts_title="true" color="rgb(24, 67, 65)" fs="text_small:13px" fw="text_small:700" padding="top_small:6px|right_small:15px|bottom_small:6px|left_small:15px" fh_bg="rgb(255, 255, 255)" margin="bottom_small:2em"]consulting[/ld_fancy_heading][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_small:28px" lh="text_small:1em"]big data integration for startups[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/ld_flipbox_section][ld_flipbox_section title="Back"][ld_button style="btn-solid" title="Learn more" shape="round" size="btn-lg" color="rgb(255, 255, 255)" text_color="rgb(35, 46, 108)"][/ld_flipbox_section][/ld_flipbox][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 8 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-8.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Fancy Box 9 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-9.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row gap="20" equal_height="yes" css=".vc_custom_1605940817178{padding-top: 60px !important;padding-bottom: 60px !important;}" responsive_css="padding_top_medium:90px|padding_bottom_medium:30px"][vc_column align="text-center" offset="vc_col-md-offset-3 vc_col-md-6" css=".vc_custom_1591020170979{margin-bottom: 55px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h2"]#stayhome[/ld_fancy_heading][ld_fancy_heading tag="p" padding="right_large:3vw|left_large:3vw"]Because we know just how hard it is to get the size, color and even the garment right in the fashion.[/ld_fancy_heading][/vc_column][vc_column row_scale_bg_onhover="yes" enable_link="enable_column_link" enable_overlay="yes" bg_position="center center" align="text-center" offset="vc_col-md-6" css=".vc_custom_1618676208011{margin-bottom: 20px !important;padding-top: 250px !important;padding-right: 35px !important;padding-bottom: 35px !important;padding-left: 35px !important;background-image: url(https://fashionstorepro.liquid-themes.com/wp-content/uploads/2021/02/category@2x.jpg?id=4809) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:420px" hover_overlay_bg="rgba(0, 0, 0, 0.15)" responsive_align="text-center" link="url:https%3A%2F%2Ffashionstorepro.liquid-themes.com%2Fproduct-category%2Fparty-collection%2F|||"][ld_button style="btn-solid" title="Casual wear" transformation="text-uppercase" size="btn-sm" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.2em" ls="0.1em"][/vc_column][vc_column width="1/2" offset="vc_col-md-3"][vc_row_inner][vc_column_inner row_scale_bg_onhover="yes" enable_link="enable_column_link" enable_overlay="yes" align="text-center" css=".vc_custom_1618676216767{margin-bottom: 20px !important;padding-top: 160px !important;padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;background-image: url(https://fashionstorepro.liquid-themes.com/wp-content/uploads/2020/08/shop-cat-2@2x.jpg?id=4439) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="margin_bottom_small:45px" hover_overlay_bg="rgba(0, 0, 0, 0.15)" responsive_align="text-center" link="url:https%3A%2F%2Ffashionstorepro.liquid-themes.com%2Fproduct-category%2Fparty-collection%2F|||"][ld_button style="btn-solid" title="Accessories" transformation="text-uppercase" size="btn-sm" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.2em" ls="0.1em"][/vc_column_inner][vc_column_inner row_scale_bg_onhover="yes" enable_link="enable_column_link" enable_overlay="yes" align="text-center" css=".vc_custom_1618676222933{margin-bottom: 20px !important;padding-top: 160px !important;padding-right: 25px !important;padding-bottom: 25px !important;padding-left: 25px !important;background-image: url(https://fashionstorepro.liquid-themes.com/wp-content/uploads/2020/08/shop-cat-3@2x.jpg?id=4440) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" hover_overlay_bg="rgba(0, 0, 0, 0.15)" responsive_align="text-center" link="url:https%3A%2F%2Ffashionstorepro.liquid-themes.com%2Fproduct-category%2Fparty-collection%2F|||"][ld_button style="btn-solid" title="Shop Shirts" transformation="text-uppercase" size="btn-sm" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.2em" ls="0.1em"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column row_scale_bg_onhover="yes" enable_link="enable_column_link" width="1/2" enable_overlay="yes" align="text-center" offset="vc_col-md-3" css=".vc_custom_1618676231115{margin-bottom: 20px !important;padding-top: 420px !important;padding-right: 35px !important;padding-bottom: 35px !important;padding-left: 35px !important;background-image: url(https://fashionstorepro.liquid-themes.com/wp-content/uploads/2020/06/Image-1@2x.jpg?id=103) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" hover_overlay_bg="rgba(0, 0, 0, 0.15)" responsive_align="text-center" link="url:https%3A%2F%2Ffashionstorepro.liquid-themes.com%2Fproduct-category%2Fparty-collection%2F|||"][ld_button style="btn-solid" title="Top Dresses" transformation="text-uppercase" size="btn-sm" color="rgb(255, 255, 255)" hover_color="rgb(0, 0, 0)" text_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" fs="12px" lh="1.2em" ls="0.1em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 10 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-10.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1614153879083{padding-top: 50px !important;padding-bottom: 50px !important;}" el_id="solutions" responsive_css="padding_bottom_medium:70px"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" ca_duration="1800" ca_delay="180" ca_init_translate_y="45" css=".vc_custom_1575034938481{margin-bottom: 45px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h2" use_inheritance="true"]Case Studies[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:31px" margin="bottom_large:2em"]Choose a pre-built header or create a custom layout that perfectly suits your needs. It’s easy, fast and mobile-friendly.[/ld_fancy_heading][/vc_column][vc_column][vc_row_inner enable_content_animation="yes" gap="30" animation_preset="Fade In" ca_duration="1800" ca_delay="180"][vc_column_inner width="1/2" offset="vc_col-md-4" css=".vc_custom_1574948048040{margin-bottom: 35px !important;}"][ld_content_box template="s09" use_custom_fonts_title="true" title="Product and Branding Strategy" image="37" fs="18px"][/ld_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4" css=".vc_custom_1574948048040{margin-bottom: 35px !important;}"][ld_content_box template="s09" use_custom_fonts_title="true" title="Special Data Science" image="36" fs="18px"][/ld_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4" css=".vc_custom_1574948048040{margin-bottom: 35px !important;}"][ld_content_box template="s09" use_custom_fonts_title="true" title="Promote your Social Posts" image="35" fs="18px"][/ld_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4" css=".vc_custom_1574948048040{margin-bottom: 35px !important;}"][ld_content_box template="s09" use_custom_fonts_title="true" title="Increase your engagement" image="34" fs="18px"][/ld_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4" css=".vc_custom_1574948048040{margin-bottom: 35px !important;}"][ld_content_box template="s09" use_custom_fonts_title="true" title="Get Instant Analytics" image="33" fs="18px"][/ld_content_box][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-4" css=".vc_custom_1574948048040{margin-bottom: 35px !important;}"][ld_content_box template="s09" use_custom_fonts_title="true" title="Augmented Reality" image="38" fs="18px"][/ld_content_box][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 11 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-11.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1605984996048{padding-top: 60px !important;padding-bottom: 60px !important;}" el_id="services" responsive_css="padding_top_medium:150px|padding_bottom_medium:100px"][vc_column offset="vc_col-md-6" responsive_css="margin_left_medium:25px"][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="13px" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" highlight_color="rgba(21, 118, 255, 0.2)" ca_init_translate_x="0" ca_init_translate_y="0" margin="bottom_small:0.25em"]La [ld_highlight]solution[/ld_highlight] à cos payment[/ld_fancy_heading][ld_fancy_heading tag="p" tag_to_inherite="h6" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_inheritance="true" enable_split="true" use_mask="true"]Les services de paiement sont disponibles via des applications mobiles et de bureau.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-6" el_id="fancy-box-carousel-nav" responsive_align="text-md-right" responsive_css="margin_right_medium:25px"][/vc_column][vc_column css=".vc_custom_1572335927203{margin-top: 60px !important;}"][ld_carousel_tab columns="xs:1|spacing_md:30px|spacing_xs:15px" inactiv_opacity="1" prevnextbuttons="yes" wraparound="yes" adaptiveheight="yes" navarrow="6" navappend="custom_id" navsize="carousel-nav-xl" navfill="carousel-nav-solid" navshape="carousel-nav-circle" navshadow="carousel-nav-shadowed-onhover" navhalign="carousel-nav-right" navappend_id="#fancy-box-carousel-nav" nav_arrow_color="rgb(0, 36, 88)" nav_arrow_color_hover="rgb(0, 36, 88)" nav_bg_color="rgb(255, 255, 255)" nav_bg_hcolor="rgb(246, 252, 254)"][ld_carousel_section title="Tab" tab_id="lqd-1595256704358-1ba85b49-d223"][vc_row_inner equal_height="yes"][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257176494{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Available for retailers and stores" image="4351" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257194496{margin-bottom: 30px !important;}" responsive_css="padding_left_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Highly Secure Online Shopping" image="4350" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257187010{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Online Payment Services for mobile" image="4349" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257200786{margin-bottom: 30px !important;}" responsive_css="padding_left_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Intelligent money Transfer" image="4348" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][/vc_row_inner][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595256704539-cff9b882-097d"][vc_row_inner equal_height="yes"][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257259135{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Highly Secure Online Shopping" image="4350" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257271979{margin-bottom: 30px !important;}" responsive_css="padding_left_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Intelligent money Transfer" image="4348" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257265477{margin-bottom: 30px !important;}" responsive_css="padding_right_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Available for retailers and stores" image="4351" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][vc_column_inner offset="vc_col-md-6" css=".vc_custom_1595257278511{margin-bottom: 30px !important;}" responsive_css="padding_left_medium:17px"][ld_content_box template="s08" i_type="fontawesome" title="Online Payment Services for mobile" image="4349" i_icon_fontawesome="fa fa-angle-right" hover_text_color="rgb(255, 227, 209)"][/ld_content_box][/vc_column_inner][/vc_row_inner][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 12 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-12.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:50px|padding_bottom_medium:120px" css=".vc_custom_1622103240889{padding-top: 35px !important;padding-bottom: 70px !important;}" el_id="case-studies"][vc_column offset="vc_col-md-6"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:47px" margin="bottom_large:0px"]Practice Areas[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.47em"]We embrace holistic development and support for the aim of being a first-choice employer within our sectors.[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1622034472426{padding-top: 50px !important;}"][ld_carousel_tab columns="md:3|sm:2|xs:1|spacing_xs:20px" inactiv_opacity="1" pagenationdots="yes" groupcells="no" wraparound="yes" dots_style="carousel-dots-style4" dots_bg_color="rgb(225, 225, 225)" dots_bg_hcolor="rgb(87, 87, 87)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034411038-85a52ec4-8a1d"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Immigration Issues" image="31" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034751456-c0483566-f77d"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Intellectual Property" image="93" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034782334-be933597-a3f9"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Citizenship" image="30" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1622034819526-4fd41faa-c7ab"][ld_content_box template="s08" content_alignment="lqd-fb-content-bc" ct_width="w-90" i_type="linea" title="Intellectual Property" image="29" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-forward" i_color="rgb(175, 123, 91)"][/ld_content_box][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.71em" padding="top_large:1.5em|right_large:32px|left_large:32px"]Our process applies techniques from a variety of disciplines distinction in detail and gives careful attention.[/ld_fancy_heading][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Box 13 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-13.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Fancy Box 14 - classic
	$data = array();
	$data['name'] = esc_html__( 'Fancy Box 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fancybox-14.jpg' );
	$data['sort_name'] = 'Fancy Box';
	$data['custom_class'] = 'general fancybox';
	$data['content'] = <<<CONTENT
	[vc_row gap="0" equal_height="yes" responsive_css="padding_top_medium:50px|padding_right_medium:0px|padding_bottom_medium:100px|padding_left_medium:0px" css=".vc_custom_1622013818717{padding-top: 35px !important;padding-right: 15px !important;padding-bottom: 70px !important;padding-left: 15px !important;}" el_id="programs"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" css=".vc_custom_1621945723059{margin-bottom: 50px !important;}" responsive_css="margin_bottom_medium:80px"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" color="rgb(120, 95, 255)" padding="top_small:0.625em|right_small:1em|bottom_small:0.625em|left_small:1em" fh_bg="rgba(120, 95, 255, 0.1)" margin="bottom_small:1em"]Programs[/ld_fancy_heading][ld_fancy_heading tag="h2" margin="bottom_small:0.35em"]Volunteer in the campaign.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.52em" margin="bottom_small:0.35em"]Our nearly 8,000 committed staff members are critical to the University of Chicago’s tradition of excellence.[/ld_fancy_heading][/vc_column][vc_column][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1621946297992{margin-bottom: 30px !important;border-right-width: 0px !important;padding-right: 15px !important;padding-left: 15px !important;border-right-color: #e8e8e8 !important;border-right-style: solid !important;}" responsive_css="padding_right_large:10%25|padding_left_large:10%25|margin_bottom_medium:0px|padding_right_medium:7%25|padding_left_medium:7%25|border_right_small:1px|padding_right_small:23px|padding_left_small:23px"][ld_content_box template="s11" title="Creative Thinking" image="71" img_link="url:%23|||" margin="top_large:-30px|bottom_large:30px|bottom_small:0px" heading_hcolor="rgb(120, 95, 255)"][/ld_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1621946306892{margin-bottom: 30px !important;border-right-width: 0px !important;padding-right: 15px !important;padding-left: 15px !important;border-right-color: #e8e8e8 !important;border-right-style: solid !important;}" responsive_css="padding_right_large:10%25|padding_left_large:10%25|margin_bottom_medium:0px|padding_right_medium:7%25|padding_left_medium:7%25|border_right_small:1px|padding_right_small:23px|padding_left_small:23px"][ld_content_box template="s11" title="Educational Programs" image="74" img_link="url:%23|||" margin="top_large:-30px|bottom_large:30px|bottom_small:0px" heading_hcolor="rgb(255, 126, 106)"][/ld_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1621946313941{margin-bottom: 30px !important;border-right-width: 0px !important;padding-right: 15px !important;padding-left: 15px !important;border-right-color: #e8e8e8 !important;border-right-style: solid !important;}" responsive_css="padding_right_large:10%25|padding_left_large:10%25|margin_bottom_medium:0px|padding_right_medium:7%25|padding_left_medium:7%25|border_right_small:1px|padding_right_small:23px|padding_left_small:23px"][ld_content_box template="s11" title="Fun Play Times" image="73" img_link="url:%23|||" margin="top_large:-30px|bottom_large:30px|bottom_small:0px" heading_hcolor="rgb(61, 166, 180)"][/ld_content_box][/vc_column][vc_column width="1/2" offset="vc_col-md-3" css=".vc_custom_1621946341312{margin-bottom: 30px !important;padding-right: 15px !important;padding-left: 15px !important;}" responsive_css="padding_right_large:10%25|padding_left_large:10%25|margin_bottom_medium:0px|padding_right_medium:7%25|padding_left_medium:7%25|padding_right_small:23px|padding_left_small:23px"][ld_content_box template="s11" title="Art And Culture" image="72" img_link="url:%23|||" margin="top_large:-30px|bottom_large:30px|bottom_small:0px" heading_hcolor="rgb(255, 95, 167)"][/ld_content_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;
	
	//Category Fancy Image
	//Fancy Image 1 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-1.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1605622148793{padding-top: 60px !important;padding-bottom: 80px !important;}" responsive_css="padding_top_medium:120px|padding_bottom_medium:140px"][vc_column offset="vc_col-md-4" responsive_css="padding_right_large:10%25|padding_bottom_medium:0px" css=".vc_custom_1605622117741{padding-bottom: 40px !important;}"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:2em"]Hub wired collection[/ld_fancy_heading][ld_fancy_heading tag="h2"]Easy skin care routine.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_fancy_heading][ld_button style="btn-naked" title="Shop collection" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)" fs="13px" ls="0.1em"][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-5"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_hover3d="yes" enable_roudness="yes" image_roudness="2" enable_shadow="yes" image="37"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_hover3d="yes" enable_roudness="yes" image_roudness="2" enable_shadow="yes" absolute_pos="yes" image="280" position="bottom_small:-10%25|left_small:45%25" shadow_delay="500"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 2 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-2.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" css=".vc_custom_1605622781017{padding-bottom: 40px !important;}" responsive_css="padding_top_medium:60px|padding_bottom_medium:60px" row_hide="hidden-xs hidden-sm"][vc_column align="text-center" css=".vc_custom_1590405292325{margin-bottom: 240px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h4"]<i class="fa fa-instagram mr-3"></i>Follow us on Instagram[/ld_fancy_heading][/vc_column][vc_column align="text-center" responsive_align="text-center"][ld_images_group_container][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="123" position="top_small:-32%25|left_small:63%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" image="121" margin="left_small:10%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="124" position="top_small:-40%25|left_small:36%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="127" position="top_small:-20%25|left_small:15%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="145" position="top_small:30%25|left_small:2%25"][/ld_images_group_element][ld_images_group_element img_size="65%" enable_lightbox="yes" lightbox_group_id="shop-lightbox" absolute_pos="yes" image="122" position="top_small:25%25|left_small:83%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]	
CONTENT;
	$templates[] = $data;

	//Fancy Image 3 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-3.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row css=".vc_custom_1606205965159{padding-top: 40px !important;padding-bottom: 40px !important;background-color: #d5f5ff !important;}" responsive_css="padding_top_medium:10vh|padding_bottom_medium:10vh"][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_promo show_dynamic_shape="yes" show_button="yes" ib_style="btn-naked" ib_title="— view project" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_hover_reveal="btn-hover-reveal" use_custom_fonts_title="true" ib_i_add_icon="true" title="Anti Dote" image="307" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_color="rgb(0, 74, 199)" ib_hover_color="rgb(0, 0, 0)" ib_fs="13px" ib_ls="0.1em" color="rgb(0, 74, 199)" overlay_color="rgb(255, 255, 255)" dynamic_shape_bg="rgb(255, 255, 255)" fs="9vw" ib_fw="700" ib_link="url:https%3A%2F%2Fadaptivecolors.liquid-themes.com%2Fstaging%2Fportfolio%2Fnexa-mobile%2F|title:Starter%20Kit||"]Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam[/ld_promo][/vc_column][/vc_row]	
CONTENT;
	$templates[] = $data;

	//Fancy Image 4 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-4.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" bg_position="custom" css=".vc_custom_1610879009876{padding-top: 60px !important;padding-bottom: 60px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="104%" bg_pos_v="10%" responsive_css="margin_left_medium:100px|padding_top_medium:70px|padding_bottom_medium:70px|padding_bottom_small:40px"][vc_column offset="vc_col-md-4" css=".vc_custom_1610836127832{margin-bottom: 20px !important;}" responsive_css="padding_top_medium:70px"][ld_images_group_container][ld_images_group_element img_size="55%" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" absolute_pos="yes" image="49" position="top_large:-15%25|left_large:-7vw|left_medium:10vw|top_small:-15%25|left_small:0px"][/ld_images_group_element][ld_images_group_element img_size="55%" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" absolute_pos="yes" image="48" position="right_large:-30%25|right_medium:9vw|top_small:-26%25|right_small:0px"][/ld_images_group_element][ld_images_group_element img_size="55%" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" image="47" margin="top_large:90px" position="left_large:0px|left_medium:25vw|left_small:18vw"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-offset-2 vc_col-lg-5 vc_col-md-offset-1 vc_col-md-6"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]La solution a vos mobile online payments[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:1.5em"]We create brand identities, digital experiences, and print materials look fantastic.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-bordered" border_round="accordion-title-round" heading_shadow="yes" show_icon="yes" i_add_icon="true" expander_size="accordion-expander-lg" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="25px" fs="18px" lh="1.75em" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(255, 255, 255)" active_bg_color="rgb(255, 255, 255)" heading_color="rgb(21, 21, 23)" active_heading_color="rgb(21, 21, 23)" exp_color="rgb(77, 102, 255)" active_exp_color="rgb(77, 102, 255)" border_color="rgb(255, 255, 255)" active_border_color="rgb(255, 255, 255)"][vc_accordion_tab title="increase your conversion rate" tab_id="lqd-1587034043819-84b84fd6-594f"][ld_fancy_heading tag="p"]Helping innovators and brands through cultural insight, strategic vision, and innovation.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="End-to-end encryption for messages" tab_id="lqd-1587034043874-e9d0bbcd-65a3"][ld_fancy_heading tag="p"]Helping innovators and brands through cultural insight, strategic vision, and innovation.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 5 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-5.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="center bottom" css=".vc_custom_1602651674721{padding-bottom: 70px !important;background-image: url(https://digitalstudiopro.liquid-themes.com/wp-content/uploads/2020/05/BG.svg?id=4390) !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" responsive_css="padding_top_medium:70px|padding_bottom_medium:70px"][vc_column align="text-center" offset="vc_col-lg-offset-2 vc_col-lg-8" css=".vc_custom_1588593855688{margin-bottom: 30px !important;}" responsive_align="text-center"][ld_fancy_heading tag="h6" margin="bottom_small:1.5em"]Selected Projects[/ld_fancy_heading][ld_fancy_heading tag="h2"]Digital Case Studies[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:19px" lh="text_small:1.5em" margin="bottom_small:2em" padding="right_all:22%25|left_all:22%25"]Passionate about solving problems through creative communications.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-5"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="1" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="4392"][/ld_images_group_element][ld_images_group_element absolute_pos="yes" image="4394" position="top_small:28%25|left_small:-30px"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="2" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="4391" margin="top_small:-15%25|left_small:35%25" shadow_delay="75"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="4393" margin="top_small:-13%25|left_small:10%25" shadow_delay="150"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-md-7"][vc_row_inner equal_height="yes" gap="0" enable_row_shadowbox="yes" css=".vc_custom_1588593784234{background-color: #ffffff !important;border-radius: 10px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.06)%22%7D%5D" responsive_css="margin_right_medium:-5%25"][vc_column_inner width="1/3" css=".vc_custom_1602651393431{border-right-width: 1px !important;padding-top: 15px !important;padding-right: 30px !important;padding-left: 30px !important;border-right-color: #eaeaea !important;border-right-style: solid !important;}" responsive_css="border_right_medium:1px|padding_top_medium:15px|padding_right_medium:30px|padding_bottom_medium:65px|padding_left_medium:30px"][ld_counter tag_to_inherite="h2" tag_to_inherite_label="h2" use_custom_fonts_title="true" use_inheritance="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" count="10+" fs="44px" color="rgb(110, 0, 150)" label="Years of Operation" counter_mb="1" text_fs="14px" label_color="rgb(0, 0, 0)"][ld_spacer height="" sm_height="10px" md_height="25px" lg_height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.6em"]Our team have been running well about 10 years and keep going.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1602651585542{border-right-width: 1px !important;padding-top: 15px !important;padding-right: 30px !important;padding-left: 30px !important;border-right-color: #eaeaea !important;border-right-style: solid !important;}" responsive_css="border_right_medium:1px|padding_top_medium:15px|padding_right_medium:30px|padding_left_medium:30px"][ld_counter tag_to_inherite="h2" tag_to_inherite_label="h2" use_custom_fonts_title="true" use_inheritance="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" count="98%" fs="44px" color="rgb(110, 0, 150)" label="Positive Feedback" counter_mb="1" text_fs="14px" label_color="rgb(0, 0, 0)" start_delay="250"][ld_spacer height="" sm_height="10px" md_height="25px" lg_height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.6em"]Based on our happy clients about the quality of our services.[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" css=".vc_custom_1588593663575{border-right-width: 1px !important;padding-top: 15px !important;padding-right: 30px !important;padding-bottom: 65px !important;padding-left: 30px !important;border-right-color: #eaeaea !important;border-right-style: solid !important;}"][ld_counter tag_to_inherite="h2" tag_to_inherite_label="h2" use_custom_fonts_title="true" use_inheritance="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" enable_blur="true" count="2,664" fs="44px" color="rgb(110, 0, 150)" label="Projects Copmpleted" counter_mb="1" text_fs="14px" label_color="rgb(0, 0, 0)" start_delay="500"][ld_spacer height="25px"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:1.6em"]All projects competeled with an absolutely high quality.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 6 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-6.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:110px|padding_bottom_medium:110px|padding_bottom_small:80px" css=".vc_custom_1610005371078{padding-top: 30px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" css=".vc_custom_1620642235658{margin-bottom: 60px !important;}" responsive_css="margin_bottom_medium:35px"][ld_images_group_element img_size="50%" image="4404" margin="left_medium:45px|bottom_small:15px"][/ld_images_group_element][ld_fancy_heading tag="p" whitespace="ws-nowrap" vertical_txt="text-sm-vertical" absolute_pos="yes" use_custom_fonts_title="true" fs="text_small:19px" color="rgb(0, 0, 0)" position="bottom_medium:15px|bottom_small:-1em|left_small:0px" margin="bottom_small:0px"]<span class="h3" style="font-size: inherit;">San Francisco</span> Headquarter[/ld_fancy_heading][/vc_column][vc_column width="1/2"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" fw="text_small:700" ls="text_small:0.1em" margin="bottom_small:1em"]— Arch Philosophy[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:42px" margin="bottom_small:0.75em" fw="text_small:500"]Multidisciplinary <em class="h3" style="font-size: inherit;">team</em>[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.88em" color="rgb(0, 0, 0)" margin="bottom_small:2em"]Through a unique combination of engineering, construction and design disciplines and expertise, Concor delivers world class infrastructure solutions to customers and stakeholders across a broad range of industry sectors.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.88em" color="rgb(0, 0, 0)" margin="bottom_small:2em"]Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 7 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-7.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1618505117021{padding-bottom: 60px !important;}" responsive_css="margin_bottom_large:20px|padding_bottom_large:110px|padding_top_medium:60px|padding_bottom_medium:90px"][vc_column offset="vc_col-md-offset-0 vc_col-md-5" responsive_align="text-center text-md-left" css=".vc_custom_1605941093420{padding-bottom: 30px !important;}" responsive_css="padding_bottom_medium:0px"][ld_icon_box i_type="fontawesome" heading_size="custom" heading_weight="font-weight-light" position="iconbox-side" items_alignment="align-items-center" i_icon_fontawesome="fab fa-instagram" title="Kate Austen #hublookbook" title_mb="1" custom_heading_size="12px" icon_mb="15" icon_size="24px" i_color="rgb(203, 122, 64)" css=".vc_custom_1591084247851{margin-bottom: 20px !important;}"][/ld_icon_box][ld_fancy_heading tag="h2"]S-20 Lookbook Editorial.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:2em"]Hub offers a range of skincare products that are feminine, delicate and long-lasting with vitamins and nutritions to improve your skin condition.[/ld_fancy_heading][ld_button style="btn-naked" title="Shop Collection" transformation="text-uppercase" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" color="rgb(0, 0, 0)" fs="11px" fw="700" ls="0.1em" i_size="1.5em"][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6"][ld_images_group_container][ld_images_group_element img_size="50%" image="4435" margin="left_small:-20px"][/ld_images_group_element][ld_images_group_element img_size="50%" absolute_pos="yes" image="4715" position="right_small:0px|bottom_small:-50px"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row][vc_row css=".vc_custom_1621001372195{border-top-width: 1px !important;padding-top: 40px !important;padding-bottom: 40px !important;border-top-color: #f0f0f0 !important;border-top-style: solid !important;}" responsive_css="margin_top_medium:60px"][vc_column][ld_carousel_marquee_tab columns="md:6|sm:4|xs:3|spacing_xs:5px" cellalign="center" fadesides="lqd-fade-sides" reverse="yes" marquee_speed="1"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869275969-2af5a83e-691d"][vc_single_image image="86" css=".vc_custom_1600869578540{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869581894-1df5449f-86ae"][vc_single_image image="89" css=".vc_custom_1600869594464{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869595467-ec50c9c5-a299"][vc_single_image image="88" css=".vc_custom_1600869608860{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869619216-960b0d0f-15ef"][vc_single_image image="87" css=".vc_custom_1600869646405{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869648981-0550ffa2-b53c"][vc_single_image image="90" css=".vc_custom_1600869662207{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869663953-167bf2b1-dbdf"][vc_single_image image="91" css=".vc_custom_1600869682676{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869684367-6a0c87f8-3df3"][vc_single_image image="88" css=".vc_custom_1600869805735{margin-bottom: 0px !important;}"][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 8 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-8.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" responsive_css="padding_top_medium:50px|padding_bottom_medium:165px" css=".vc_custom_1617787581517{padding-bottom: 60px !important;}"][vc_column align="text-center" offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs" responsive_align="text-center"][ld_images_group_container][ld_images_group_element img_size="65%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_reveal="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="137" translate_from_y="35" rotate_from_y="0" translate_to_y="-45" position="top_small:-15%25|left_small:0%25"][/ld_images_group_element][ld_images_group_element img_size="40%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="4" enable_shadow="yes" enable_reveal="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="136" translate_from_y="90" translate_to_y="-70" margin="top_large:100px"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" responsive_css="padding_left_medium:10%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]Who we are[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" duration="1000" delay="120" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" minfontsize="40" fs="text_large:48px|text_small:40px" ca_init_translate_y="70"]Hub connects creative people.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" margin="bottom_small:3.35em"]With over 25 years of experience, we have crafted thousands of strategic discovery process.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-bordered" border_round="accordion-title-circle" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" bottom_margin="25px" fs="17px" lh="1.35em" fw="700" i_icon_linea="lqd-icn-ess icon-ion-ios-arrow-down" active_icon_linea="lqd-icn-ess icon-ion-ios-arrow-up" bg_color="rgb(247, 248, 249)" heading_color="rgb(0, 0, 0)" active_heading_color="rgb(255, 255, 255)" border_color="rgb(247, 248, 249)"][vc_accordion_tab title="Global search engine optimization" tab_id="lqd-1579175585568-fabb85cc-3af9"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.73em" margin="bottom_small:0.25em"]A startup or start-up is started by individual founders or entrepreneurs to search for a repeatable and scalable business model.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Complete Social Media Integration" tab_id="ld-1579175796106-906f8cfc-cbda"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.73em" margin="bottom_small:0.25em"]A startup or start-up is started by individual founders or entrepreneurs to search for a repeatable and scalable business model. A startup or start-up is started by individual founders or[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Branding Strategy for startups" tab_id="ld-1579175803325-17b3ad82-140a"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="15px" lh="1.73em" margin="bottom_small:0.25em"]A startup or start-up is started by individual founders or entrepreneurs to search for a repeatable and scalable business model. A startup or start-up is started by individual founders or[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 9 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-9.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="margin_bottom_medium:90px|padding_top_medium:195px" css=".vc_custom_1605894380130{margin-bottom: 60px !important;padding-top: 60px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" align="text-center" responsive_css="padding_right_medium:2.5vw|padding_left_medium:2.5vw" offset="vc_col-md-offset-1 vc_col-md-10" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" responsive_align="text-md-center"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]What we achieved[/ld_fancy_heading][ld_fancy_heading tag="h2" split_type="words" duration="1000" delay="120" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" enable_fit="true" minfontsize="40" fs="text_large:48px|text_small:40px" ca_init_translate_y="70"]The thousands of completed works.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="18px" lh="1.666em" padding="right_large:2.5vw|left_large:2.5vw"]Through strategy, design, and planning we build brand identities that connect with your Nesi. We then fine-tune a marketing plan that allows us to laser focus and target your audience through the right channels.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" content_placement="middle" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" responsive_css="padding_right_large:7vw|padding_left_large:7vw|padding_right_medium:5vw|padding_bottom_medium:150px|padding_left_medium:5vw" css=".vc_custom_1605894357515{padding-bottom: 60px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_y="45"][vc_column offset="vc_col-md-7" responsive_css="padding_bottom_medium:0px" css=".vc_custom_1605900653624{padding-bottom: 40px !important;}"][ld_carousel_tab columns="sm:2|xs:1.15|spacing_sm:25px|spacing_xs:15px" inactiv_opacity="1" groupcells="no" wraparound="yes" freescroll="yes" autoplay="yes"][ld_carousel_section title="Tab" tab_id="lqd-1595668610562-2ce347a8-5c26"][vc_single_image image="136" css=".vc_custom_1599653788634{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668614654-7b524ffd-5e98"][vc_single_image image="154" css=".vc_custom_1599658760650{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668489515-bff38c98-e89c"][vc_single_image image="136" css=".vc_custom_1599659930441{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][ld_carousel_section title="Tab" tab_id="lqd-1595668596537-af5fa149-8305"][vc_single_image image="153" css=".vc_custom_1599658826780{margin-bottom: 0px !important;border-radius: 10px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][vc_column parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1800" ca_delay="180" ca_init_translate_x="45" translate_from_y="120" translate_to_y="-120" el_class="z-index-2"][vc_row_inner equal_height="yes" gap="0" enable_row_shadowbox="yes" responsive_css="margin_right_medium:-3vw|margin_left_medium:-35%25" css=".vc_custom_1579181548740{background-color: #ffffff !important;border-radius: 10px !important;}" row_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2210px%22%2C%22blur_radius%22%3A%2230px%22%2C%22shadow_color%22%3A%22rgba(0%2C0%2C0%2C0.06)%22%7D%5D"][vc_column_inner offset="vc_col-md-4" responsive_css="border_right_medium:1px|border_bottom_medium:0px|padding_top_medium:100px|padding_right_medium:5%25|padding_bottom_medium:100px|padding_left_medium:10%25|padding_right_small:30px|padding_left_small:30px" css=".vc_custom_1605900568089{border-bottom-width: 1px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;border-bottom-color: #eaeaea !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" enable_blur="true" count="10+" fs="52px" fw="700" color="rgb(0, 207, 50)" start_delay="250"][ld_fancy_heading tag="h5" margin="bottom_small:1.5em"]Years of Operation[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(102, 102, 102)" fs="18px" lh="1.666em"]Our team have been running well about 10 years and keep going.[/ld_fancy_heading][/vc_column_inner][vc_column_inner offset="vc_col-md-4" responsive_css="border_right_medium:1px|border_bottom_medium:0px|padding_top_medium:100px|padding_right_medium:5%25|padding_bottom_medium:100px|padding_left_medium:10%25|padding_right_small:30px|padding_left_small:30px" css=".vc_custom_1605900583205{border-bottom-width: 1px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;border-bottom-color: #eaeaea !important;border-bottom-style: solid !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" enable_blur="true" count="98%" fs="52px" fw="700" color="rgb(0, 207, 50)" start_delay="500"][ld_fancy_heading tag="h5" margin="bottom_small:1.5em"]Positive Feedback[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(102, 102, 102)" fs="18px" lh="1.666em"]Based on our happy clients about the quality of our products &amp; services.[/ld_fancy_heading][/vc_column_inner][vc_column_inner offset="vc_col-md-4" responsive_css="border_right_medium:1px|border_bottom_medium:0px|padding_top_medium:100px|padding_right_medium:5%25|padding_bottom_medium:100px|padding_left_medium:10%25|padding_right_small:30px|padding_left_small:30px" css=".vc_custom_1605900599342{border-bottom-width: 1px !important;padding-top: 60px !important;padding-right: 15px !important;padding-bottom: 60px !important;padding-left: 15px !important;}"][ld_counter template="`{`object Object`}`" use_custom_fonts_title="true" enable_blur="true" count="2,664" fs="52px" fw="700" color="rgb(0, 207, 50)" start_delay="750"][ld_fancy_heading tag="h5" margin="bottom_small:1.5em"]Projects Copmpleted[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(102, 102, 102)" fs="18px" lh="1.666em"]All projects competeled with an absolutely high quality[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 10 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-10.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" el_id="ourvision" responsive_css="padding_top_medium:50px" css=".vc_custom_1614669877344{padding-bottom: 50px !important;}"][vc_column offset="vc_col-md-6 vc_hidden-sm vc_hidden-xs"][ld_images_group_container][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="40" translate_from_y="35" rotate_from_y="0" translate_to_y="-45"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="41" margin="top_small:-10%25|left_small:20%25" translate_from_y="90" translate_to_y="-70"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="3" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="42" margin="top_small:-70%25|right_small:-20%25|left_small:50%25" translate_from_y="135" translate_to_y="-91"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_left_medium:14%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" margin="bottom_small:0.75em" fs="13px"]Company’s vision[/ld_fancy_heading][ld_fancy_heading tag="h2" padding="right_large:4%25"]IT solutions for your business.[/ld_fancy_heading][ld_fancy_heading tag="p" margin="bottom_small:1.5em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Request API Integration" title_mb="1" icon_mb="10" custom_heading_size="17px" css=".vc_custom_1607346394904{margin-bottom: 10px !important;}" i_color="rgb(24, 67, 65)" icon_size="18px"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-normal" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Simple Registration System" title_mb="1" icon_mb="7" custom_heading_size="17px" icon_size="18px" css=".vc_custom_1607346378529{margin-bottom: 10px !important;}" i_color="rgb(24, 67, 65)"][/ld_icon_box][vc_row_inner content_placement="middle" css=".vc_custom_1578906109013{padding-top: 35px !important;}"][vc_column_inner width="7/12"][ld_button style="btn-solid" title="See how we work" transformation="text-uppercase" shape="round" border="border-none" hover_txt_effect="btn-hover-txt-liquid-y" hover_bg_effect="btn-hover-bg-liquid" hover_bg_color="rgb(0, 0, 0)" fs="14px" css=".vc_custom_1578917815295{margin-bottom: 15px !important;}"][/vc_column_inner][vc_column_inner width="5/12"][ld_fancy_heading tag="p" color="rgb(37, 97, 239)" margin="bottom_small:15px"](733) 860-2906[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 11 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-11.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" bg_position="center center" el_id="business-consultation" responsive_css="padding_top_medium:100px|padding_bottom_medium:50px" css=".vc_custom_1610196384922{padding-top: 80px !important;padding-bottom: 30px !important;background-image: url(https://itbusinesspro.liquid-themes.com/wp-content/uploads/2021/01/bg-2@2x.jpg?id=8896) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}"][vc_column offset="vc_col-md-5" responsive_align="text-right text-sm-center text-md-right" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1610196406027{margin-bottom: 80px !important;}"][ld_images_group_container][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="8890" translate_from_y="75" rotate_from_y="0" translate_to_y="-75" position="top_small:0px|left_small:0px"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="8891" translate_from_y="35" rotate_from_y="0" translate_to_y="-45" margin="top_small:40px"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="8892" translate_from_y="43" rotate_from_y="0" translate_to_y="-54" position="bottom_small:-20%25|left_small:20%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_left_medium:14%25" ca_duration="1800" ca_delay="180" ca_init_translate_y="35"][vc_text_separator title="ABOUT US" title_align="separator_align_left" color="custom" accent_color="rgba(6,14,98,0.13)"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgb(6, 14, 98)" fs="text_medium:60px|text_small:15vw" lh="text_small:1em" margin="bottom_small:0px" fw="text_small:700"]Meet Hub.[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" color="rgba(6, 14, 98, 0.35)" fs="text_medium:60px|text_small:15vw" lh="text_small:1em" margin="bottom_small:0.35em" fw="text_small:700"]digital.
innovative.
creative.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:1em" color="rgba(14, 37, 87, 0.65)" fs="text_small:19px" lh="text_small:1.5em"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data.[/ld_fancy_heading][ld_button style="btn-naked" title="Learn more" hover_txt_effect="btn-hover-txt-liquid-y" i_type="linea" i_add_icon="true" hover_bg_effect="btn-hover-bg-liquid" hover_bg_color="rgb(0, 0, 0)" fs="18px" css=".vc_custom_1610193758606{margin-bottom: 15px !important;}" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fw="500"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 12 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-12.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_small:50px|padding_bottom_small:50px" css=".vc_custom_1607940095660{padding-top: 50px !important;padding-bottom: 50px !important;}"][vc_column offset="vc_col-md-offset-1 vc_col-md-4"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:45px" lh="text_small:1em"]Hand-crafted goodies[/ld_fancy_heading][/vc_column][vc_column][ld_spacer height="30px" md_height="40px"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_right_large:11%25" ca_duration="1600" ca_start_delay="400" ca_delay="120" ca_init_translate_y="35"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.46em"]The build-up of plastic waste on our planet is a matter of real concern for all of us. So, next time you feel like grabbing a bottle of spring water from some far-away and exotic well, don’t. Instead, bottle your own water.[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" ca_duration="1600" ca_start_delay="550" ca_delay="120" ca_init_translate_y="35"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:15px" lh="text_small:1.46em"]The planet and your conscience will thank you. [ld_br]<br />
To help stem the flow of plastic into the ocean, we have committed to eliminating single-use plastic from th product range and food outlets by 2020.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 13 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-13.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:75px|padding_bottom_medium:75px" css=".vc_custom_1622033294126{padding-top: 35px !important;padding-bottom: 35px !important;}"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px|margin_bottom_small:240px" css=".vc_custom_1622100886801{margin-bottom: 220px !important;}"][ld_images_group_container][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="27" translate_from_y="40" translate_to_y="-45"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="28" position="right_large:0px|right_medium:20%25|top_small:20px|right_small:0px" translate_from_y="50" translate_to_y="-55" shadow_delay="240"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="26" position="left_medium:90px|top_small:80px|right_small:8%25|left_small:10%25" translate_from_y="75" translate_to_y="-105" shadow_delay="120"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]Legal disciplines.[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:45px"]Legal <u>aid</u> from professionals.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="1" fs="19px" fw="500" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove"][vc_accordion_tab title="Anti-money Laundering" tab_id="lqd-1622033590191-308418da-a55b"][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:0px" fs="text_small:14px" lh="text_small:1.64em"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Immigration and Citizenship" tab_id="lqd-1622033689521-14822213-718e"][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:0px" fs="text_small:14px" lh="text_small:1.64em"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Private Property and Business" tab_id="lqd-1622033685660-808da547-f3b8"][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:0px" fs="text_small:14px" lh="text_small:1.64em"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 14 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-14.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:65px|padding_bottom_medium:65px" css=".vc_custom_1621858742456{padding-top: 35px !important;padding-bottom: 35px !important;}"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1621859472422{margin-bottom: 30px !important;}"][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_hover3d="yes" enable_roudness="yes" image_roudness="custom" image="104" custom_roundness="15px"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6" responsive_css="padding_left_large:9%25"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:12px" fw="text_small:700" padding="top_small:4px|right_small:11px|bottom_small:4px|left_small:11px" fh_bg="rgb(235, 239, 241)" margin="bottom_small:1.75em" ls="text_small:0.1em"]HOW IT WORKS[/ld_fancy_heading][ld_fancy_heading tag="h2" margin="bottom_small:0.3em"]Business Insight and strategic vision[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(15, 64, 100)" fs="text_small:18px" lh="text_small:1.44em" margin="bottom_small:2.5em"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives careful[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-medium" i_shape="circle" i_border="" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Strategic Vision And Insight" icon_size="16px" custom_i_size="32px" i_color="rgb(15, 64, 100)" shape_color="rgba(21, 81, 83, 0.08)" custom_heading_size="17px" css=".vc_custom_1622018437817{margin-bottom: 15px !important;}" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(21, 81, 83)"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-medium" i_shape="circle" i_border="" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Business Consultation" icon_size="16px" custom_i_size="32px" i_color="rgb(15, 64, 100)" shape_color="rgba(21, 81, 83, 0.07)" custom_heading_size="17px" css=".vc_custom_1622017464496{margin-bottom: 15px !important;}" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(21, 81, 83)"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-medium" i_shape="circle" i_border="" position="iconbox-inline" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Exceptional Execution" icon_size="16px" custom_i_size="32px" i_color="rgb(15, 64, 100)" shape_color="rgba(21, 81, 83, 0.09)" custom_heading_size="17px" css=".vc_custom_1622017506111{margin-bottom: 15px !important;}" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(21, 81, 83)"][/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 15 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-15.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1607092723607{padding-top: 80px !important;padding-bottom: 50px !important;}" responsive_css="padding_top_medium:100px|padding_top_small:50px"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1607091812048{margin-bottom: 30px !important;}" responsive_align="text-center"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1"][ld_images_group_element parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="58" position="right_small:1vw|bottom_small:55px" translate_from_y="50"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="4266" position="top_large:-13%25|right_large:0px|top_medium:0px|right_medium:10%25|top_small:-15%25|right_small:-12%25" translate_from_y="110" translate_to_y="-50"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="56" translate_from_y="150" translate_to_y="-120" position="left_large:-30%25|left_medium:-10%25|top_small:-10%25|left_small:-50%25"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" image="4245" translate_from_y="80" translate_to_y="-70" margin="top_large:30%25|top_small:15%25" position="right_medium:0px|right_small:-30%25"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-lowercase" duration="1600" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_bg="yes" fh_border_radius="circle" enable_split="true" margin="bottom_small:0.75em" ca_init_translate_x="0" ca_init_rotate_y="0" ca_init_translate_y="35" color="rgb(255, 90, 61)" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(255, 234, 230)"]Digital Experience[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_offset="0.1em" use_custom_fonts_title="true" enable_fit="true" fs="text_large:48px|text_small:35px" lh="text_small:1.2em" margin="bottom_small:0.65em" minfontsize="36" highlight_color="rgba(255, 185, 158, 0.51)"]Connect people in [ld_highlight]digital life[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:20px" lh="text_small:1.5em" fw="text_small:700" margin="bottom_small:1.5em"]More than just an ad agency, we harness the tools of traditional and digital.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="20px" lh="1.5em" margin="bottom_small:2.5em"]With over 25 years of experience, we have crafted thousands of strategic discovery process that enables us to peel back the layers which enable us to understand, connect, represent and dominate your market.[/ld_fancy_heading][ld_button style="btn-solid" title="More about us" transformation="text-uppercase" link_type="scroll_to_section" shape="circle" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-x" enable_row_shadowbox="yes" button_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2260px%22%2C%22shadow_color%22%3A%22rgba(248%2C85%2C78%2C0.19)%22%7D%5D" hover_button_box_shadow="%5B%7B%7D%5D" css=".vc_custom_1611478359296{margin-bottom: 35px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(51, 106, 234)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 16 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-16.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="bottom" bg_position="custom" css=".vc_custom_1614777054684{padding-top: 80px !important;padding-bottom: 80px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50%" bg_pos_v="80%" responsive_css="padding_bottom_medium:130px"][vc_column offset="vc_col-md-6 vc_hidden-xs" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1614778539117{margin-bottom: 60px !important;}"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="0.75" pf_init_scale_y="0.75" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1800" pf_delay="180" pf_init_translate_x="-100" pf_init_translate_y="0"][ld_images_group_element img_size="50%" enable_hover3d="yes" image="4888"][/ld_images_group_element][ld_images_group_element img_size="50%" parallax="yes" enable_hover3d="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="4889" position="right_large:-90px|top_small:-120px|right_small:10%25" translate_from_y="50" translate_to_y="-75"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" ca_duration="1800" ca_start_delay="350" ca_delay="180" ca_init_translate_y="35"][ld_fancy_heading tag="h6" transform="text-lowercase" duration="1600" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_bg="yes" fh_border_radius="circle" enable_split="true" margin="bottom_small:1em" ca_init_translate_x="0" ca_init_rotate_y="0" ca_init_translate_y="35" color="rgb(255, 90, 61)" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(255, 234, 230)"]Digital Experience[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_offset="5px" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_fit="true" compressor="0.7" minfontsize="32" margin="bottom_small:0.25em" fs="text_large:47px|text_medium:42px|text_small:40px" highlight_color="rgba(255, 144, 114, 0.12)"]All services for your [ld_highlight]online presence.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" fs="text_small:17px" lh="text_small:29px" padding="right_large:8%25" margin="bottom_small:1.75em"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_button style="btn-underlined" title="Start a project" color="rgb(0, 35, 82)" b_color="rgba(0, 35, 82, 0.2)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;


	//Fancy Image 17 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-17.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1605971144699{padding-top: 60px !important;padding-bottom: 60px !important;background-color: #f7f9fc !important;}" responsive_css="padding_top_medium:200px|padding_bottom_medium:190px"][vc_column offset="vc_col-md-6"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="1" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" margin="bottom_large:0px|bottom_small:120px"][ld_images_group_element img_size="50%" enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" image="50"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_effects="yes" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="6" enable_shadow="yes" absolute_pos="yes" image="153" position="right_large:14%25|top_medium:19%25|right_medium:25%25|top_small:25%25|right_small:0px" shadow_delay="1600"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-offset-1 vc_col-md-5" ca_duration="1800" ca_delay="180" ca_init_translate_y="35" ca_init_translate_x="15"][vc_single_image image="41" css=".vc_custom_1575040929631{margin-bottom: 25px !important;}"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_small:0.35em" fs="text_large:42px|text_small:36px"]Convert more visitors into customers.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:16px" lh="text_small:26px" margin="bottom_small:1.625em" padding="right_large:12%25"]Hub IT allows your business and technology computers to store, transmit, analyze, and manipulate big data in the digital world.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Simple Registration System" title_mb="1" custom_heading_size="17px" icon_size="14px" custom_i_size="24px" css=".vc_custom_1607335580086{margin-bottom: 12px !important;}" i_color="rgb(25, 128, 46)" shape_color="rgba(16, 255, 34, 0.13)"][/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" i_icon_linea="lqd-icn-ess icon-ion-ios-checkmark" title="Request API Integration" title_mb="1" custom_heading_size="17px" icon_size="14px" custom_i_size="24px" css=".vc_custom_1607335589856{margin-bottom: 35px !important;}" i_color="rgb(25, 128, 46)" shape_color="rgba(16, 255, 34, 0.13)"][/ld_icon_box][ld_button style="btn-solid" title="Get Started Hub" link_type="scroll_to_section" shape="round" size="btn-md" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" hover_color="rgb(255, 255, 255)" htext_color="rgb(0, 0, 0)" i_icon_linea="lqd-icn-ess icon-md-arrow-forward"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 18 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-18.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" bg_position="center top" enable_row_dividers="yes" css=".vc_custom_1608729633610{padding-top: 120px !important;padding-bottom: 100px !important;background-image: url(https://businessstartuppro.liquid-themes.com/wp-content/uploads/2020/12/bg-1@2x.jpg?id=233) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:140px|padding_bottom_medium:140px" row_svg_divider="bottom_shape_type:8|bottom_shape_color:%23ffffff|bottom_shape_height:61"][vc_column width="1/2" offset="vc_col-md-5" css=".vc_custom_1608729930888{margin-bottom: 20px !important;}" responsive_css="margin_bottom_small:35px"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1600" pf_delay="160" pf_init_translate_x="-35" pf_init_translate_y="35" pf_init_rotate_y="0"][ld_images_group_element absolute_pos="yes" image="237" position="top_small:0px|left_small:0px"][/ld_images_group_element][ld_images_group_element img_size="50%" image="231" margin="top_small:25px|left_small:28px"][ld_button style="btn-solid" title="Play video" link_type="lightbox" shape="circle" i_type="linea" i_position="left" i_hover_reveal="btn-hover-swp" i_add_icon="true" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" i_icon_linea="lqd-icn-ess icon-ion-ios-play" color="rgb(255, 255, 255)" text_color="rgb(0, 0, 0)" hover_color="rgb(0, 0, 0)" htext_color="rgb(255, 255, 255)" lh="1.1em"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-lg-offset-1 vc_col-lg-6 vc_col-md-7" css=".vc_custom_1608729911892{margin-bottom: 70px !important;}" responsive_css="margin_bottom_medium:65px|margin_bottom_small:35px" ca_delay="160" ca_init_translate_y="60" ca_duration="1600" ca_start_delay="450"][ld_fancy_heading tag="h6" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_small:12px" fw="text_small:700" ls="text_small:0.08em" margin="bottom_small:3em"]Customer stories[/ld_fancy_heading][ld_fancy_heading ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(255, 255, 255)" fs="text_small:68px" lh="text_small:1.1em" fw="text_small:700" ls="text_small:-0.02em" highlight_color="rgba(126, 255, 195, 0.4)" margin="bottom_small:0.25em"]They [ld_highlight]trust[/ld_highlight] Hub. But why?[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(255, 255, 255, 0.7)" fs="text_small:18px" lh="text_small:1.44em" fw="text_small:500" margin="right_large:22%25|bottom_small:2.75em"]Hub IT allows your business and technology computers to store and analyze.[/ld_fancy_heading][ld_button style="btn-naked" title="`{`ld_strong`}`DANIEL CHARLES`{`/ld_strong`}``{`ld_span`}`Netflix Chief Designer`{`/ld_span`}`" link_type="lightbox" i_type="linea" i_position="left" i_shape="btn-icon-circle" i_shape_style="btn-icon-bordered" i_shape_bw="btn-icon-border-thicker" i_shape_size="btn-icon-custom-size" i_add_icon="true" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DFXI_-OesT3A%26ab_channel%3DApple|||" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="68px" color="rgb(255, 255, 255)" i_hcolor="rgb(0, 0, 0)" i_fill_hcolor2="rgb(255, 255, 255)" hover_color="rgb(255, 255, 255)"][/vc_column][vc_column][ld_carousel_tab columns="md:6|sm:4|xs:3|spacing_xs:15px" inactiv_opacity="1" enable_item_animation="yes" groupcells="no" wraparound="yes" equalheightcells="yes" middlealigncontent="yes" autoplay="yes" mobile_dots_bottom_offset_outside="1em" pf_init_scale_x="0.3" pf_init_scale_y="0.3" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1600" pf_start_delay="1000" pf_delay="160" mobile_dots_bg_color="rgba(255, 255, 255, 0.35)" mobile_dots_bg_hcolor="rgb(255, 255, 255)"][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722795312-3f978e43-4471"][vc_single_image image="240" alignment="center" css=".vc_custom_1608722911038{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608723029108-4269f2d2-09ef"][vc_single_image image="239" alignment="center" css=".vc_custom_1608723005040{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722795312-563e3a31-1736"][vc_single_image image="242" alignment="center" css=".vc_custom_1608722946839{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722795312-4b81f2ed-de44"][vc_single_image image="241" alignment="center" css=".vc_custom_1608722972969{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722993089-e220608a-0b0b"][vc_single_image image="239" alignment="center" css=".vc_custom_1608723005040{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608722976821-3fc5d8ee-00fd"][vc_single_image image="243" alignment="center" css=".vc_custom_1608722989439{margin-bottom: 0px !important;}"][/ld_carousel_section][ld_carousel_section title="Carousel Item" tab_id="lqd-1608723009463-97570643-55f7"][vc_single_image image="238" alignment="center" css=".vc_custom_1608723023054{margin-bottom: 0px !important;}"][/ld_carousel_section][/ld_carousel_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 19 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-19.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:120px" css=".vc_custom_1608725586069{padding-top: 90px !important;padding-bottom: 30px !important;}"][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-5" ca_duration="1600" ca_delay="120" ca_init_translate_y="45" ca_init_rotate_z="3" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608729665449{margin-bottom: 55px !important;}"][vc_text_separator title="CLIENT: HUB IT" title_align="separator_align_left" color="custom" accent_color="rgba(112,112,112,0.2)" css=".vc_custom_1608723651822{margin-bottom: 25px !important;}"][ld_fancy_heading tag="h2" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" highlight_color="rgba(126, 255, 195, 0.4)" fs="text_small:36px" lh="text_small:1.13em" fw="text_small:700" color="rgb(30, 47, 105)"]Apper reduced their support time by [ld_highlight]80% using live chat.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgba(70, 77, 101, 0.8)" fs="text_small:18px" lh="text_small:1.44em" margin="bottom_small:2em"]Content-focused grid designs, unique social elements, post-sharing function, author exposure and much more![/ld_fancy_heading][ld_button style="btn-naked" title="Read the story" link_type="lightbox" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" link="url:https%3A%2F%2Fyoutu.be%2FJLE228ZuGGA|||" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="18px" color="rgb(30, 47, 105)"][vc_separator color="custom" accent_color="rgba(112,112,112,0.2)" css=".vc_custom_1608723736193{margin-top: 50px !important;margin-bottom: 35px !important;}"][ld_fancy_heading tag="h4" transform="text-uppercase" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(25, 28, 95)" fs="text_small:12px" ls="text_small:0.08em" fw="text_small:700"]Phoebe Nathalia[/ld_fancy_heading][ld_fancy_heading tag="h5" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(86, 104, 130)" fs="text_small:14px" fw="text_small:500"]Netflix Chief Designer[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-7" responsive_css="padding_left_medium:5%25"][ld_images_group_container enable_item_animation="yes" pf_init_scale_x="1" pf_init_scale_y="1" pf_init_opacity="0" pf_an_scale_x="1" pf_an_scale_y="1" pf_an_opacity="1" pf_duration="1600" pf_delay="160" pf_init_translate_x="35" pf_init_translate_y="35" pf_init_rotate_y="0" pf_start_delay="650"][ld_images_group_element enable_image_shadow="yes" shadow_style="4" image="246"][/ld_images_group_element][ld_images_group_element absolute_pos="yes" image="248" position="top_small:45px|left_small:45px"][/ld_images_group_element][ld_images_group_element absolute_pos="yes" image="247" position="bottom_small:30px|left_small:45px"][/ld_images_group_element][/ld_images_group_container][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 20 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 20', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-20.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:110px|padding_top_small:80px|padding_bottom_small:60px" css=".vc_custom_1610696800165{padding-top: 60px !important;padding-bottom: 30px !important;}"][vc_column width="1/2" offset="vc_col-md-5" responsive_css="margin_bottom_small:0px" css=".vc_custom_1610698221117{margin-bottom: 80px !important;}"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="4" image="379"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_roudness="yes" image_roudness="4" absolute_pos="yes" image="378" position="top_medium:90px|top_small:60px|right_small:0px"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column width="1/2" offset="vc_col-lg-5 vc_col-md-offset-1 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" margin="bottom_small:0.75em" color="rgb(86, 154, 204)" fs="text_small:16px"]What we achieved[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" enable_fit="true" fs="text_small:39px" lh="text_small:1.05em" margin="bottom_small:1.15em" minfontsize="36" highlight_color="rgba(0, 203, 153, 0.35)" color="rgb(31, 42, 88)"]Hub unleashes your business [ld_highlight]potential[/ld_highlight] by the innovation.[/ld_fancy_heading][vc_row_inner][vc_column_inner offset="vc_col-md-11" responsive_css="margin_bottom_medium:45px" css=".vc_custom_1614595440928{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:17px"]Company Benefits[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(60, 69, 85)" fs="text_large:16px|text_small:14px" lh="text_small:1.35em"]Based in Paris, we work closely with clients from around the world, getting to the heart of their business to develop successful digital ideas and[/ld_fancy_heading][/vc_column_inner][vc_column_inner offset="vc_col-md-11"][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:17px"]Competitive Salary[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(60, 69, 85)" fs="text_large:16px|text_small:14px" lh="text_small:1.35em"]As a leading digital company in Paris, we look to engage with our clients beyond the conventional relationship, becoming a partner to the people and[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 21 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 21', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-21.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
CONTENT;
	$templates[] = $data;

	//Fancy Image 22 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 22', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-22.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" css=".vc_custom_1608127572115{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="2%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" el_class="z-index-2" offset="vc_col-md-6" ca_duration="1600" ca_delay="160" ca_init_translate_y="30" ca_init_rotate_z="6"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" fs="text_small:13px" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(245, 245, 245)" margin="bottom_small:1em"]<i class="lqd-icn-ess icon-lqd-circle mr-2" style="color: #00cc76; font-size: 1.25em; vertical-align: text-bottom;"></i>Available for freelance[/ld_fancy_heading][ld_fancy_heading enable_txt_rotator="yes" rotator_type="basic" items="%5B%7B%22word%22%3A%22.id%C3%A9e%22%7D%2C%7B%22word%22%3A%22.grafik%22%7D%2C%7B%22word%22%3A%22.design%22%7D%5D" use_custom_fonts_title="true" fs="text_all:94px|text_large:80px|text_medium:10vw" margin="right_large:-50%25" lh="text_small:0.95em"].freelance .créatif[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" margin="bottom_small:1.5em"]My name is Jean-Paul. I’m a freelance Branding and Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" margin="bottom_small:1.5em"]I’m always interested in small or big freelance projects to take your business to the next level.[/ld_fancy_heading][vc_row_inner content_placement="middle" css=".vc_custom_1608127080432{margin-top: 20px !important;}"][vc_column_inner width="1/3" offset="vc_col-md-6"][ld_button style="btn-solid" title="Send a message" transformation="text-uppercase" link_type="modal_window" shape="circle" size="btn-xlg" hover_txt_effect="btn-hover-txt-liquid-x-alt" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-lqd-envelope" lh="1.25em" ls="0.1em" fs="13px" fw="700" color="rgb(23, 25, 26)" css=".vc_custom_1608127757537{padding-right: 0.5em !important;padding-left: 0.5em !important;}" anchor_id="#contact-modal"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1608127055486{padding-top: 10px !important;}"][ld_custom_menu source="custom" inline="inline-nav" items="%5B%7B%22label%22%3A%22Facebook.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Twitter.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Behance.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="5" color="rgb(0, 0, 0)" hcolor="rgba(0, 0, 0, 0.65)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-6" responsive_align="text-center" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1613900706378{margin-bottom: 35px !important;}"][ld_images_group_element img_size="50%" enable_effects="yes" enable_hover3d="yes" enable_reveal="yes" image="4726"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 23 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 23', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-23.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" css=".vc_custom_1605398700956{padding-bottom: 40px !important;}" responsive_css="padding_bottom_medium:90px"][vc_column align="text-center" offset="vc_col-md-offset-0 vc_col-md-6" responsive_align="text-center"][ld_images_group_container][ld_images_group_element img_size="50%" enable_effects="yes" enable_roudness="yes" image_roudness="4" image="126"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" column_top_onmobile="yes" offset="vc_col-md-6" responsive_css="padding_right_medium:7%25|padding_left_medium:12%25" ca_duration="1600" ca_delay="160" ca_init_translate_y="30" responsive_align="text-center text-md-left"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" fs="text_small:13px" ls="text_small:0.05em" margin="bottom_small:1.75em" fh_bg="rgb(228, 230, 255)" padding="top_small:6px|right_small:13px|bottom_small:6px|left_small:13px"]Explore new places[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_animation="lqd-highlight-grow-bottom" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="8px" use_custom_fonts_title="true" margin="bottom_small:0.75em" fs="text_large:39px|text_small:32px" highlight_color="rgba(71, 79, 199, 0.28)"]Practical tools make it [ld_highlight]easier[/ld_highlight] to manage.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_large:19px|text_small:17px" lh="text_small:1.5em" margin="bottom_small:2em"]The ultimate collection crafted by world-class designers. Import a pre-built section block with a single click or save your own custom block to re-use on other pages. Build different section blocks to jump start your design phase and create unique combinations with ease.[/ld_fancy_heading][ld_button style="btn-solid" title="Discover Hub" shape="circle" size="btn-md" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" link="url:%23|||" fs="text_small:15px" ls="text_small:0.02em" css=".vc_custom_1621493675311{margin-right: 8px !important;margin-bottom: 10px !important;padding-right: 0.75em !important;padding-left: 0.75em !important;}" hover_color="rgb(39, 39, 39)"][ld_button style="btn-default" title="Free Trial" shape="circle" size="btn-md" hover_txt_effect="btn-hover-txt-switch btn-hover-txt-switch-y" link="url:%23|||" color="rgb(228, 228, 228)" fs="text_small:15px" ls="text_small:0.02em" css=".vc_custom_1621493687100{margin-bottom: 10px !important;margin-left: 8px !important;padding-right: 1em !important;padding-left: 1em !important;}" hover_color="rgb(0, 0, 0)" text_color="rgb(26, 28, 38)" htext_color="rgb(255, 255, 255)"][ld_spacer][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 24 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 24', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-24.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1605616186759{padding-top: 40px !important;padding-bottom: 60px !important;}"][vc_column offset="vc_col-md-5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1605616127527{margin-bottom: 40px !important;}"][ld_images_group_element image="4310"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-6" responsive_css="padding_right_large:7%25|padding_right_medium:5%25|padding_left_medium:8%25"][ld_fancy_heading tag="h6" margin="bottom_small:1.25em"]— Arch Philosophy[/ld_fancy_heading][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_inheritance="true" margin="bottom_small:1.5em"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/ld_fancy_heading][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" fs="18px" lh="1.8em" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" heading_color="rgb(0, 0, 0)" active_heading_color="rgb(0, 0, 0)" fw="400" border_color="rgb(185, 185, 185)"][vc_accordion_tab title="01. Building the future cities" tab_id="lqd-1584631046124-4d7a24d6-c841"][vc_column_text css=".vc_custom_1584946903012{margin-bottom: 15px !important;}"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="02. Unique and influential design" tab_id="lqd-1584631246270-3f120044-72ac"][vc_column_text css=".vc_custom_1584946910333{margin-bottom: 15px !important;}"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/vc_column_text][/vc_accordion_tab][vc_accordion_tab title="03. Award-winning Architecture" tab_id="lqd-1584631247309-5c26887d-1aeb"][vc_column_text css=".vc_custom_1584946916841{margin-bottom: 15px !important;}"]As the complexity of buildings to increase, the field of architecture became multi-disciplinary with technological expertise.[/vc_column_text][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 25 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 25', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-25.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="custom" css=".vc_custom_1614343963165{padding-top: 35px !important;padding-bottom: 45px !important;background-image: url(http://saashubfree.liquid-themes.com/wp-content/uploads/2019/10/bg-4.svg?id=683) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" bg_pos_h="50%" bg_pos_v="-100%" el_id="features"][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center" css=".vc_custom_1611237222930{margin-bottom: 30px !important;}"][ld_images_group_element img_size="50%" image="950" margin="bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:18px" margin="bottom_small:1.25em"]Customizable UI[/ld_fancy_heading][ld_fancy_heading tag="p"]Ceating brand identities, digital experiences, and print materials that communicate clearly.[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center" css=".vc_custom_1611237222930{margin-bottom: 30px !important;}"][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_roudness="yes" image_roudness="4" image="946" margin="top_medium:30px|bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:18px" margin="bottom_small:1.25em"]Custom Task Views[/ld_fancy_heading][ld_fancy_heading tag="p"]Ceating brand identities, digital experiences, and print materials that communicate clearly.[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center" css=".vc_custom_1611237222930{margin-bottom: 30px !important;}"][ld_images_group_element img_size="30%" enable_roudness="yes" image_roudness="4" image="1030" margin="top_medium:15px|bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:18px" margin="bottom_small:1.25em"]Team Collaboration[/ld_fancy_heading][ld_fancy_heading tag="p"]Ceating brand identities, digital experiences, and print materials that communicate clearly.[/ld_fancy_heading][/vc_column][vc_column width="1/2" offset="vc_col-md-3" responsive_align="text-center" css=".vc_custom_1611237222930{margin-bottom: 30px !important;}"][ld_images_group_element img_size="50%" image="948" margin="top_medium:25px|bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h3" use_custom_fonts_title="true" fs="text_small:18px" margin="bottom_small:1.25em"]Task Assignment[/ld_fancy_heading][ld_fancy_heading tag="p"]Ceating brand identities, digital experiences, and print materials that communicate clearly.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 26 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 26', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-26.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" responsive_css="padding_top_medium:120px|padding_top_small:80px|padding_bottom_small:30px" css=".vc_custom_1614342255674{padding-top: 60px !important;padding-bottom: 15px !important;}"][vc_column offset="vc_col-md-5" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1611315213533{margin-bottom: 20px !important;}"][ld_fancy_heading tag="h6" margin="bottom_small:2em"]<a href="https://saaspro.liquid-themes.com/wp-content/uploads/2021/01/Group-32402.svg"><img class="alignnone size-medium wp-image-964" src="https://saaspro.liquid-themes.com/wp-content/uploads/2021/01/Group-32402.svg" alt="" width="110" height="19" /></a>  Next Generation[/ld_fancy_heading][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" highlight_offset="0.15em" use_custom_fonts_title="true" fs="text_medium:51px|text_small:11vw" highlight_color="rgba(177, 204, 255, 0.35)" margin="bottom_small:0.35em"]Track your daily [ld_highlight]activity.[/ld_highlight][/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.47em"]The latest design trends meet hand-crafted templates in Hub Collection. Use pre-built sections to speed up your design process.[/ld_fancy_heading][/vc_column][vc_column responsive_css="padding_left_large:6%25" offset="vc_col-md-7"][ld_images_group_element enable_hover3d="yes" image="970"][/ld_images_group_element][/vc_column][/vc_row][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" css=".vc_custom_1614342277074{padding-top: 50px !important;padding-bottom: 50px !important;}" ca_duration="1800" ca_delay="180" ca_init_translate_x="35" responsive_css="margin_bottom_medium:35px"][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" i_shape="circle" i_size="xs" i_border="1" position="iconbox-side" title="SCHEDULE APPOINTMENT" custom_heading_size="14px" custom_i_size="47px" shape_hcolor="rgb(0, 68, 235)" border_shape_color="rgb(220, 228, 235)" border_shape_hcolor="rgb(0, 68, 235)" shape_color="rgb(255, 255, 255)" icon_size="16px" h_i_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-num-1" i_color="rgb(0, 0, 0)"]Google makes it easier to run high performance shared hosting account on its cloud platform.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" i_shape="circle" i_size="xs" i_border="1" position="iconbox-side" title="BUSINESS CONSULTATION" custom_heading_size="14px" custom_i_size="47px" shape_hcolor="rgb(0, 68, 235)" border_shape_color="rgb(220, 228, 235)" border_shape_hcolor="rgb(0, 68, 235)" shape_color="rgb(255, 255, 255)" icon_size="16px" h_i_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-num-2" i_color="rgb(26, 26, 26)"]Google makes it easier to run high performance shared hosting account on its cloud platform.[/ld_icon_box][/vc_column][vc_column offset="vc_col-md-4"][ld_icon_box i_type="linea" heading_size="custom" heading_weight="font-weight-bold" i_shape="circle" i_size="xs" i_border="1" position="iconbox-side" title="LAUNCH YOUR BUSINESS" custom_heading_size="14px" custom_i_size="47px" shape_hcolor="rgb(0, 68, 235)" border_shape_color="rgb(220, 228, 235)" border_shape_hcolor="rgb(0, 68, 235)" shape_color="rgb(255, 255, 255)" icon_size="16px" h_i_color="rgb(255, 255, 255)" i_icon_linea="lqd-icn-ess icon-num-3" i_color="rgb(22, 22, 22)"]Google makes it easier to run high performance shared hosting account on its cloud platform.[/ld_icon_box][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 27 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 27', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-27.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" css=".vc_custom_1614769150109{padding-top: 60px !important;padding-bottom: 60px !important;}" el_id="features"][vc_column offset="vc_col-md-6"][ld_images_group_element enable_float_effect="yes" image="244"][/ld_images_group_element][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-md-offset-1 vc_col-md-5"][ld_images_group_element image="64" margin="bottom_small:15px"][/ld_images_group_element][ld_fancy_heading tag="h2" highlight_reset_onhover="lqd-highlight-reset-onhover" use_custom_fonts_title="true" fs="text_small:45px" lh="text_small:1.1em" margin="bottom_small:0.35em" highlight_color="rgba(62, 196, 175, 0.47)"]Add calling [ld_highlight]credits[/ld_highlight].[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" lh="text_small:1.666em" ls="text_small:-0.01em" margin="bottom_small:1.5em"]Install any demo or template with a single click. You can mix and match all the demos &amp; templates. Every demo can be turned into one or multi-page. You can also use the shop features for all demos.[/ld_fancy_heading][ld_button style="btn-solid" title="Sign up — It’s Free" size="btn-lg" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="icon-md-arrow-round-forward" color="rgb(240, 242, 255)" text_color="rgb(67, 32, 145)" hover_color="rgb(67, 32, 145)" htext_color="rgb(255, 255, 255)" fs="16px" css=".vc_custom_1587623501253{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(111, 120, 128)" fs="text_small:13px" lh="text_small:1.53em" margin="bottom_small:1em"]Choose a pre-built header or create a custom layout that perfectly suits your needs. It’s easy and fast. Your time is precious for us.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" margin="top_small:1em"]John Doe, Founder of Liquid[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 28 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 28', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-28.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" parallax="enable_parallax" enable_overlay="yes" enable_row_dividers="yes" responsive_css="padding_top_medium:125px|padding_bottom_medium:125px" css=".vc_custom_1622009655669{padding-top: 70px !important;padding-bottom: 70px !important;background-image: url(https://staging.liquid-themes.com/kids/wp-content/uploads/2021/05/bg-2@2x.jpg?id=82) !important;background-position: center;background-repeat: no-repeat;background-size:cover;}" overlay_bg="rgba(47, 40, 40, 0.5)" row_svg_divider="bottom_shape_type:7|bottom_shape_color:%23ffffff|bottom_shape_height:16" el_id="events"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1621947681326{margin-bottom: 30px !important;}"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" color="rgb(255, 126, 106)" padding="top_small:0.625em|right_small:1em|bottom_small:0.625em|left_small:1em" fh_bg="rgb(255, 255, 255)" margin="bottom_small:1em"]Spread Love[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" margin="bottom_small:0.35em" color="rgb(255, 255, 255)" fs="text_medium:50px"]Take advantage of many education programs.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.52em" margin="bottom_small:0.35em" color="rgba(255, 255, 255, 0.88)" padding="right_all:25%25|right_large:15%25"]Join us in the 100 campaign, a year-long journey to bring 100 children home to 100 families.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-2 vc_col-md-4" responsive_align="text-md-center"][ld_images_group_element absolute_pos="yes" image="84" position="top_small:-50px|left_small:-100px" hide_el="hidden-xs hidden-sm"][/ld_images_group_element][ld_counter tag_to_inherite_label="h4" use_custom_fonts_title="true" use_inheritance_label="true" use_custom_fonts_text="true" counter_mb_checkbox="true" count="98%" fs="79px" color="rgb(255, 255, 255)" label="Success Rate" text_fs="23px" label_color="rgb(255, 255, 255)" counter_mb="13"][ld_button style="btn-underlined" title="Become Volunteer" link="url:%23|||" color="rgb(255, 255, 255)" lh="text_small:1em" fw="text_small:400"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 29 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 29', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-29.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:110px|padding_bottom_medium:75px" css=".vc_custom_1622015720342{padding-top: 70px !important;padding-bottom: 35px !important;}" el_id="solutions"][vc_column offset="vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h6" transform="text-uppercase" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:12px" fw="text_small:700" padding="top_small:4px|right_small:11px|bottom_small:4px|left_small:11px" fh_bg="rgb(235, 239, 241)" margin="bottom_small:1.75em" ls="text_small:0.1em"]THE PROCESS[/ld_fancy_heading][ld_fancy_heading tag="h2" margin="bottom_small:0.85em"]Smart and effective business solutions.[/ld_fancy_heading][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" i_linked="iconbox-icon-linked" alignment="text-left" shadow="iconbox-icon-shadow" i_icon_linea="lqd-icn-ess icon-num-1" title="Initial Concept Phase" custom_heading_size="17px" icon_size="15px" custom_i_size="47px" i_color="rgb(21, 81, 83)" shape_color="rgb(255, 255, 255)" icon_mb="22" title_mb="15" css=".vc_custom_1622015551988{margin-bottom: 45px !important;}" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(21, 81, 83)"]<span style="font-size: 15px; line-height: 1.6em;">Google makes it easier to run high performance shared hosting account on its cloud platform.</span>[/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" i_linked="iconbox-icon-linked" alignment="text-left" shadow="iconbox-icon-shadow" i_icon_linea="lqd-icn-ess icon-num-2" title="Business Consultation" custom_heading_size="17px" icon_size="15px" custom_i_size="47px" i_color="rgb(21, 81, 83)" shape_color="rgb(255, 255, 255)" icon_mb="22" title_mb="15" css=".vc_custom_1622015541138{margin-bottom: 45px !important;}" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(21, 81, 83)"]<span style="font-size: 15px; line-height: 1.6em;">Google makes it easier to run high performance shared hosting account on its cloud platform.</span>[/ld_icon_box][ld_icon_box i_type="linea" heading_size="custom" i_shape="circle" i_border="" position="iconbox-side" alignment="text-left" shadow="iconbox-icon-shadow" i_icon_linea="lqd-icn-ess icon-num-3" title="Product Launch" custom_heading_size="17px" icon_size="15px" custom_i_size="47px" i_color="rgb(21, 81, 83)" shape_color="rgb(255, 255, 255)" icon_mb="22" title_mb="15" css=".vc_custom_1622015529637{margin-bottom: 45px !important;}" h_i_color="rgb(255, 255, 255)" shape_hcolor="rgb(21, 81, 83)"]<span style="font-size: 15px; line-height: 1.6em;">Google makes it easier to run high performance shared hosting account on its cloud platform.</span>[/ld_icon_box][/vc_column][vc_column column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-offset-1 vc_col-md-6" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1621859483629{margin-bottom: 30px !important;}"][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="3" enable_hover3d="yes" enable_roudness="yes" image_roudness="custom" image="101" custom_roundness="15px"][ld_button style="btn-naked" link_type="lightbox" i_type="linea" i_position="top" i_shape="btn-icon-circle" i_shape_style="btn-icon-solid" i_shape_size="btn-icon-custom-size" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" i_shape_custom_size="100px" i_margin_bottom="0px" i_size="18px" color="rgba(21, 81, 83, 0.93)" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWaSvMAl4zPw||target:%20_blank|" i_hcolor="rgb(21, 81, 83)" i_fill_hcolor="rgb(255, 255, 255)"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 30 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 30', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-30.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:130px|padding_bottom_medium:130px" css=".vc_custom_1621849312172{padding-top: 70px !important;padding-bottom: 70px !important;}"][vc_column offset="vc_col-md-6" responsive_css="margin_bottom_medium:0px|margin_bottom_small:160px" css=".vc_custom_1621864061246{margin-bottom: 70px !important;}"][ld_images_group_container][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_roudness="yes" image_roudness="8" enable_shadow="yes" image="83"][/ld_images_group_element][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_roudness="yes" image_roudness="8" enable_shadow="yes" absolute_pos="yes" image="84" position="top_small:25%25|left_small:25%25" shadow_delay="250"][/ld_images_group_element][/ld_images_group_container][/vc_column][vc_column offset="vc_col-lg-offset-1 vc_col-lg-5 vc_col-md-6"][ld_fancy_heading tag="h2" margin="bottom_small:0.35em"]Smart and effective business solutions.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:18px" margin="bottom_small:1.25em"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives[/ld_fancy_heading][ld_button style="btn-underlined" title="Learn more" link_type="scroll_to_section" border="border-thick" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-md-arrow-forward" fs="text_small:17px" css=".vc_custom_1621865280408{margin-right: 40px !important;}"][ld_button style="btn-naked" title="Play Video" link_type="lightbox" i_type="linea" i_hover_reveal="btn-hover-swp" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-ion-ios-play" fs="text_small:17px" i_size="14px" link="url:https%3A%2F%2Fwww.youtube.com%2Fwatch%3Fv%3DWaSvMAl4zPw||target:%20_blank|"][ld_spacer height="30px"][vc_accordion size="md" borders="accordion-title-underlined" show_icon="yes" i_add_icon="true" i_type="linea" active_add_icon="true" active_type="linea" use_custom_fonts_title="true" active_tab="1" fs="19px" i_icon_linea="lqd-icn-ess icon-ion-ios-add" active_icon_linea="lqd-icn-ess icon-ion-ios-remove" fw="500"][vc_accordion_tab title="Business Consultation" tab_id="lqd-1621849870257-a6c90671-f7f1"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Strategetic Vision and Insight" tab_id="lqd-1621850133313-fcc50966-e093"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][vc_accordion_tab title="Private Property and Business" tab_id="lqd-1621850376284-61924f49-73ec"][ld_fancy_heading tag="p" margin="bottom_small:0px"]Many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_accordion_tab][/vc_accordion][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 31 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 31', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-31.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" responsive_css="padding_top_medium:45px|padding_bottom_medium:50px" css=".vc_custom_1622027909060{padding-top: 35px !important;padding-bottom: 35px !important;}"][vc_column column_content_align="justify-content-end" row_scale_bg_onhover="yes" enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" enable_overlay="yes" enable_column_shadowbox="yes" enable_column_hover_shadowbox="yes" bg_position="center top" offset="vc_col-lg-5 vc_col-md-6" css=".vc_custom_1622100300872{margin-bottom: 30px !important;padding-top: 250px !important;padding-right: 20px !important;padding-bottom: 45px !important;padding-left: 20px !important;background-image: url(https://staging.liquid-themes.com/lawyer/wp-content/uploads/2021/05/img-1@2x.jpg?id=25) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;border-radius: 10px !important;}" overlay_bg="linear-gradient(0deg, rgb(46, 70, 85) 0%, rgba(46, 70, 85, 0) 40%)" column_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2220px%22%2C%22blur_radius%22%3A%2288px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" responsive_css="margin_bottom_medium:0px|padding_top_medium:300px|padding_right_medium:65px|padding_left_medium:65px" column_hover_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%2230px%22%2C%22blur_radius%22%3A%22100px%22%2C%22shadow_color%22%3A%22rgba(0%2C%200%2C%200%2C%200.2)%22%7D%5D" responsive_align="text-right"][ld_fancy_heading tag="p" use_custom_fonts_title="true" use_inheritance="true" color="rgb(255, 255, 255)" fs="text_small:150px" lh="text_small:1em" margin="bottom_small:0px"]<span class="d-flex align-items-end justify-content-end"><span style="margin-bottom: -0.15em;">11</span> <span class="d-flex flex-column" style="font-size: 18px; line-height: 18px; flex: 0;">Years of experience</span></span>[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-5" responsive_css="padding_right_large:15%25"][ld_fancy_heading tag="h6" margin="bottom_small:1em"]About us[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_medium:45px"]We provide legal aid and <u>advice.</u>[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_small:2.15em"]Our process applies techniques from a variety of disciplines, values distinction in detail and gives careful. <a href="#">Our process</a> applies techniques from a variety of disciplines, values distinction in detail and gives careful[/ld_fancy_heading][ld_button style="btn-underlined" title="Read the story" link_type="scroll_to_section" border="border-thick" border_width="btn-bw-30" color="rgb(35, 42, 59)" lh="text_small:2em"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Image 32 - product shop
	$data = array();
	$data['name'] = esc_html__( 'Fancy Image 32', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'fi-32.jpg' );
	$data['sort_name'] = 'Fancy Image';
	$data['custom_class'] = 'general fancyimage';
	$data['content'] = <<<CONTENT
	[vc_row gap="30" equal_height="yes" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px" css=".vc_custom_1622013828612{padding-top: 70px !important;padding-bottom: 70px !important;}" el_id="teachers"][vc_column offset="vc_col-lg-offset-3 vc_col-lg-6 vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" css=".vc_custom_1621948335611{margin-bottom: 20px !important;}" responsive_css="margin_bottom_medium:50px"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" color="rgb(95, 157, 255)" padding="top_small:0.625em|right_small:1em|bottom_small:0.625em|left_small:1em" fh_bg="rgba(95, 157, 255, 0.1)" margin="bottom_small:1em"]Our Teachers[/ld_fancy_heading][ld_fancy_heading tag="h2" margin="bottom_small:0.35em"]Experienced Teachers[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.52em" margin="bottom_small:0.35em"]Our nearly 8,000 committed staff members are critical to the University of Chicago’s tradition of excellence.[/ld_fancy_heading][/vc_column][vc_column][/vc_column][vc_column enable_link="enable_column_link" enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" width="1/2" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1622131874136{margin-bottom: 30px !important;}" offset="vc_col-md-3" responsive_align="text-center" link="url:https%3A%2F%2Fstaging.liquid-themes.com%2Fkids%2Fteam-member-alex-martinex%2F|title:Team%20member%20%E2%80%93%20Alex%20Martinex||"][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_border="yes" border_width="custom" enable_roudness="yes" image_roudness="50em" image="92" custom_border_width="11px" border_color="rgb(255, 255, 255)" margin="bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:19px"]Olivia Robert[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px"]Maputo, Africa[/ld_fancy_heading][/vc_column][vc_column enable_link="enable_column_link" enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" width="1/2" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1622131886600{margin-bottom: 30px !important;}" offset="vc_col-md-3" responsive_align="text-center" link="url:https%3A%2F%2Fstaging.liquid-themes.com%2Fkids%2Fteam-member-alex-martinex%2F|title:Team%20member%20%E2%80%93%20Alex%20Martinex||"][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_border="yes" border_width="custom" enable_roudness="yes" image_roudness="50em" image="94" custom_border_width="11px" border_color="rgb(255, 255, 255)" margin="bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:19px"]David Richards[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px"]Maputo, Africa[/ld_fancy_heading][/vc_column][vc_column enable_link="enable_column_link" enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" width="1/2" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1622131894747{margin-bottom: 30px !important;}" offset="vc_col-md-3" responsive_align="text-center" link="url:https%3A%2F%2Fstaging.liquid-themes.com%2Fkids%2Fteam-member-alex-martinex%2F|title:Team%20member%20%E2%80%93%20Alex%20Martinex||"][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_border="yes" border_width="custom" enable_roudness="yes" image_roudness="50em" image="95" custom_border_width="11px" border_color="rgb(255, 255, 255)" margin="bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:19px"]Marrion Miller[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px"]Maputo, Africa[/ld_fancy_heading][/vc_column][vc_column enable_link="enable_column_link" enable_hover_move="lqd-column-move-onhover" hover_move_value="-5px" width="1/2" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1622131904439{margin-bottom: 30px !important;}" offset="vc_col-md-3" responsive_align="text-center" link="url:https%3A%2F%2Fstaging.liquid-themes.com%2Fkids%2Fteam-member-alex-martinex%2F|title:Team%20member%20%E2%80%93%20Alex%20Martinex||"][ld_images_group_element img_size="50%" enable_image_shadow="yes" shadow_style="4" enable_hover3d="yes" enable_border="yes" border_width="custom" enable_roudness="yes" image_roudness="50em" image="93" custom_border_width="11px" border_color="rgb(255, 255, 255)" margin="bottom_small:30px"][/ld_images_group_element][ld_fancy_heading tag="h4" use_custom_fonts_title="true" fs="text_small:19px"]Gilbert Huges[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px"]Maputo, Africa[/ld_fancy_heading][/vc_column][vc_column responsive_align="text-center" responsive_css="padding_top_medium:65px" css=".vc_custom_1621948416860{padding-top: 30px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(36, 20, 13)" fs="text_small:14px"]We want to change the world. Why not join us? <a href="#">Become Volunteer</a>[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Category Fancy Text
	//Fancy Text 1
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 01', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-1.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row bg_attachment="fixed" enable_overlay="yes" css=".vc_custom_1595428168333{padding-top: 110px !important;padding-bottom: 110px !important;background-image: url(https://companyhub.liquid-themes.com/staging/wp-content/uploads/2019/12/bg-2@2x-scaled.jpg?id=8662) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" overlay_bg="rgba(13, 65, 63, 0.91)"][vc_column offset="vc_col-md-offset-1 vc_col-md-10" responsive_css="padding_right_medium:7%25"][ld_fancy_heading tag="h2" alignment="text-center" split_type="words" duration="800" delay="20" easing="linear" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(255, 255, 255)" fs="text_large:50px|text_small:40px" lh="text_small:1.5em"]unleashing our clients’ potential by maximising <span style="color: #ffcc23;">the innovation.</span>[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 2
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 02', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-2.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" bg_position="custom" css=".vc_custom_1618822535209{padding-top: 160px !important;padding-bottom: 50px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" bg_pos_h="50%" bg_pos_v="-145px" responsive_css="padding_top_medium:200px|padding_right_medium:7vw|padding_left_medium:7vw"][vc_column][ld_images_group_element img_size="50%" absolute_pos="yes" image="36" position="top_small:8%25|right_small:5vw" el_class="z-index-3"][/ld_images_group_element][vc_row_inner el_class="z-index-2"][vc_column_inner][ld_fancy_heading transform="text-uppercase" enable_txt_rotator="yes" items="%5B%7B%22word%22%3A%22UX%20Designer%22%7D%2C%7B%22word%22%3A%22Illustrator%22%7D%2C%7B%22word%22%3A%22Developer%22%7D%5D" use_custom_fonts_title="true" fs="text_large:11vw|text_small:13vw" lh="text_small:0.9em" margin="left_large:2vw|bottom_small:0px"][/ld_fancy_heading][ld_fancy_heading tag="h2" alignment="text-right" transform="text-uppercase" split_type="chars, words" delay="80" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" gradient="linear-gradient(180deg, rgba(19, 17, 23, 0.65) 0%, rgb(255, 255, 255) 100%)" fs="text_large:11vw|text_small:13vw" lh="text_small:0.9em" margin="bottom_small:0px"]In London[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_small:11vw" lh="text_small:0.9em" margin="bottom_small:0px" el_class="z-index-1" hover_text_outline_color="rgba(255, 255, 255, 0.33)" hover_text_outline_width="1px"]See my works[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 3
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 03', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-3.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="custom" css=".vc_custom_1610987278257{padding-top: 80px !important;padding-bottom: 80px !important;background-color: #beefe6 !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1600" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="60" responsive_css="padding_top_medium:110px" bg_pos_h="20vw" bg_pos_v="0%"][vc_column][vc_separator color="custom" accent_color="#e03b37"][/vc_column][vc_column width="3/4"][ld_fancy_heading tag="h2" split_type="chars, words" duration="1600" delay="80" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_randomize="true" color="rgb(159, 51, 125)" fs="text_all:370px|text_large:300px|text_medium:210px|text_small:35.5vw" lh="text_small:0.73em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="0" fw="text_small:500" ls="text_small:-0.05em"]Process[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="30" ca_init_rotate_z="5" ca_start_delay="650" offset="vc_col-md-3"][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="277" translate_from_y="46" rotate_from_z="53" translate_to_y="-46" rotate_to_z="-41" position="top_small:0px|right_small:0px|left_small:0px" hide_el="hidden-xs hidden-sm"][/ld_images_group_element][ld_spacer height="35px" md_height="250px" lg_height="330px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]My job is to build your website so that it is functional and user friendly but at the same time attractive. My aim is to bring across your message and identity in the most creative way.[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1608301428153{margin-top: 45px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-bottom-color: #ac37e0 !important;border-bottom-style: solid !important;}" responsive_css="margin_top_medium:70px|padding_top_medium:40px|padding_bottom_medium:40px"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:72px" fw="text_small:500" margin="bottom_small:0px"]01[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-5"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:26px" fw="text_small:500" margin="bottom_small:0.35em"]Make your business visible online.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em"]We craft premium digital work for web, mobile and experiential with creative agencies and global brands alike – putting passion.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1608301449110{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-bottom-color: #ac37e0 !important;border-bottom-style: solid !important;}" responsive_css="padding_top_medium:40px|padding_bottom_medium:40px"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:72px" fw="text_small:500" margin="bottom_small:0px"]02[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-5"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:26px" fw="text_small:500" margin="bottom_small:0.35em"]Make your business stand out.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em"]We craft premium digital work for web, mobile and experiential with creative agencies and global brands alike – putting passion.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1608301449110{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-bottom-color: #ac37e0 !important;border-bottom-style: solid !important;}" responsive_css="padding_top_medium:40px|padding_bottom_medium:40px"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:72px" fw="text_small:500" margin="bottom_small:0px"]03[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-5"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:26px" fw="text_small:500" margin="bottom_small:0.35em"]Grow with your audience.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em"]We craft premium digital work for web, mobile and experiential with creative agencies and global brands alike – putting passion.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 4
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 04', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-4.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="custom" css=".vc_custom_1610987278257{padding-top: 80px !important;padding-bottom: 80px !important;background-color: #beefe6 !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1600" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="60" responsive_css="padding_top_medium:110px" bg_pos_h="20vw" bg_pos_v="0%"][vc_column][vc_separator color="custom" accent_color="#e03b37"][/vc_column][vc_column width="3/4"][ld_fancy_heading tag="h2" split_type="chars, words" duration="1600" delay="80" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_randomize="true" color="rgb(159, 51, 125)" fs="text_all:370px|text_large:300px|text_medium:210px|text_small:35.5vw" lh="text_small:0.73em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="0" fw="text_small:500" ls="text_small:-0.05em"]Process[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="30" ca_init_rotate_z="5" ca_start_delay="650" offset="vc_col-md-3"][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="277" translate_from_y="46" rotate_from_z="53" translate_to_y="-46" rotate_to_z="-41" position="top_small:0px|right_small:0px|left_small:0px" hide_el="hidden-xs hidden-sm"][/ld_images_group_element][ld_spacer height="35px" md_height="250px" lg_height="330px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]My job is to build your website so that it is functional and user friendly but at the same time attractive. My aim is to bring across your message and identity in the most creative way.[/ld_fancy_heading][/vc_column][vc_column css=".vc_custom_1608301428153{margin-top: 45px !important;border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-bottom-color: #ac37e0 !important;border-bottom-style: solid !important;}" responsive_css="margin_top_medium:70px|padding_top_medium:40px|padding_bottom_medium:40px"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:72px" fw="text_small:500" margin="bottom_small:0px"]01[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-5"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:26px" fw="text_small:500" margin="bottom_small:0.35em"]Make your business visible online.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em"]We craft premium digital work for web, mobile and experiential with creative agencies and global brands alike – putting passion.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1608301449110{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-bottom-color: #ac37e0 !important;border-bottom-style: solid !important;}" responsive_css="padding_top_medium:40px|padding_bottom_medium:40px"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:72px" fw="text_small:500" margin="bottom_small:0px"]02[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-5"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:26px" fw="text_small:500" margin="bottom_small:0.35em"]Make your business stand out.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em"]We craft premium digital work for web, mobile and experiential with creative agencies and global brands alike – putting passion.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column css=".vc_custom_1608301449110{border-bottom-width: 1px !important;padding-top: 30px !important;padding-bottom: 30px !important;border-bottom-color: #ac37e0 !important;border-bottom-style: solid !important;}" responsive_css="padding_top_medium:40px|padding_bottom_medium:40px"][vc_row_inner content_placement="middle"][vc_column_inner width="1/2"][ld_fancy_heading tag="h6" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:72px" fw="text_small:500" margin="bottom_small:0px"]03[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-lg-5"][ld_fancy_heading tag="h3" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:26px" fw="text_small:500" margin="bottom_small:0.35em"]Grow with your audience.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(159, 51, 125)" fs="text_small:15px" lh="text_small:1.33em"]We craft premium digital work for web, mobile and experiential with creative agencies and global brands alike – putting passion.[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 5
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 05', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'marquee-2.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" css=".vc_custom_1605879890274{margin-top: 30px !important;margin-bottom: 40px !important;}" responsive_css="margin_top_medium:100px|margin_bottom_medium:100px"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" fadesides="lqd-fade-sides" draggable="no" pause_on_hover="yes" reverse="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600669953490-1d6432ae-31e3"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]UI Design.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670046727-6e3f70d6-9e29"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Branding.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670050127-af9486df-0052"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Development.[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][ld_carousel_marquee_tab columns_auto_width="yes" fadesides="lqd-fade-sides" draggable="no" pause_on_hover="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600669960959-c9e61543-b44e"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Motion Design.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670059663-52e16e4a-044c"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Art Direction.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1600670067403-b1936528-48cc"][ld_fancy_heading whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline" use_custom_fonts_title="true" fs="text_large:10vw|text_small:50px" color="rgb(0, 0, 0)" hover_text_outline_color="rgba(0, 0, 0, 0.2)" lh="text_small:1em" ls="text_small:-0.02em"]Marketing Strategy.[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 6
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 06', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'marquee-5.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" css=".vc_custom_1602671540471{padding-top: 25px !important;padding-bottom: 25px !important;background-color: #ffd78b !important;}"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288497441-8bf20fef-4083"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670644137-e38675d2-149a"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I feel amazing when I use Hub Cosmetics.[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288409283-989c28c2-d697"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288483752{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602671192095-46abc435-ec95"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670963432-11920b84-244e"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670954055-fa8296fb-8b7e"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288526674-65d262fc-eff4"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602670975168-2be5953e-7120"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]The best products I’ve ever tried! Simply amazing![/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603288521994-c8c46d08-1455"][ld_icon_box i_type="fontawesome" i_icon_fontawesome="fas fa-circle" title_mb="1" icon_size="8px" icon_mb="1" css=".vc_custom_1603288495552{margin-bottom: 0px !important;}"][/ld_icon_box][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1602671209218-19459e63-0fea"][ld_fancy_heading tag="h4" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:0px" fw="text_small:500"]I was super happy when I got the package! It’s the best skin care product I’ve ever used![/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 7
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 07', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'marquee-7.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" css=".vc_custom_1605606230955{padding-top: 60px !important;padding-bottom: 60px !important;}" responsive_css="padding_top_medium:100px|padding_bottom_medium:100px"][vc_column align="text-center" responsive_align="text-center"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center" fadesides="lqd-fade-sides" marquee_speed="2"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603433760082-6eae0819-1090"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Webgl[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433967213-165b3b46-9d5d"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Ruby[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433970644-39e52cac-75ce"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Java[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433973732-5dd9bbb5-1239"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" fs="text_small:12vw" margin="bottom_small:0px"]Dart[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][vc_row_inner responsive_css="padding_right_medium:8vw|padding_left_medium:8vw"][vc_column_inner][vc_separator color="white" border_width="2" css=".vc_custom_1588404151561{margin-top: 0px !important;margin-bottom: 0px !important;}"][/vc_column_inner][/vc_row_inner][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="2%" cellalign="center" fadesides="lqd-fade-sides" reverse="yes" marquee_speed="2"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1603433802208-9e944f5d-8ecd"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:12vw" margin="bottom_small:0px"]Social[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433867498-a43b9d62-800b"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:12vw" margin="bottom_small:0px"]Ecommerce[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Tab" tab_id="lqd-1603433871018-e034fb2c-ae87"][ld_fancy_heading tag="h2" transform="text-uppercase" whitespace="ws-nowrap" use_custom_fonts_title="true" fs="text_small:12vw" margin="bottom_small:0px"]UI Design[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 8
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 08', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'marquee-9.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row responsive_css="padding_top_medium:50px|padding_bottom_medium:50px" css=".vc_custom_1614256641431{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column offset="vc_hidden-sm vc_hidden-xs"][ld_particles as_bg="yes" shape_type="image" opacity="1" enable_move="yes" move_out_mode="bounce" enable_bounce_move="yes" modes_grab_opacity="1" particle_id="lqd-1614869946417-306a9263-8727" number="1" image="4907" size="45" el_class="hidden-xs hidden-sm"][ld_particles as_bg="yes" shape_type="image" opacity="1" enable_move="yes" move_out_mode="bounce" enable_bounce_move="yes" modes_grab_opacity="1" particle_id="lqd-1614870476008-6329acb8-f972" number="1" image="4906" size="40" el_class="hidden-xs hidden-sm"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="20%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_x="80%" ca_an_opacity="1" offset="vc_col-md-offset-2 vc_col-md-8" responsive_align="text-center" ca_duration="1600" ca_delay="160" ca_init_translate_y="65" ca_init_rotate_y="25"][ld_fancy_heading tag="p" absolute_pos="yes" use_custom_fonts_title="true" use_inheritance="true" gradient="linear-gradient(180deg, rgba(34, 43, 60, 0.1) 0%, rgba(255, 255, 255, 0.1) 100%)" fs="text_large:300px|text_small:39vw" position="bottom_medium:-350px|right_small:0px|bottom_small:-80px|left_small:0px" lh="text_small:0.8em" margin="bottom_small:0px" fw="text_small:700" ls="text_small:-0.025"]4.87[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" gradient="linear-gradient(90deg, rgb(181,201,212) 0%, rgb(242,171,53) 27.38853503184713%, rgb(247,135,75) 68.59872611464968%, #c6b5bd 100%)" fs="text_large:74px|text_medium:54px|text_small:14vw" lh="text_small:1em" margin="top_small:-0.15em|bottom_small:0px"]The best rated[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_large:74px|text_medium:54px|text_small:14vw" lh="text_small:1em" margin="bottom_small:0.2em" color="rgb(49, 49, 49)"]theme[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgba(0, 0, 0, 0.6)" fs="text_small:18px" lh="text_small:1.4em" margin="right_large:18%25|left_large:18%25|bottom_small:1em"]They enjoy Hub as much as we do. So, why don’t you join us and be a part of the fastest growing community?[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0"][vc_column][ld_carousel_marquee_tab columns="md:3.95|sm:2.5|xs:1|spacing_xs:15px" cellalign="center" inactiv_opacity="1" groupcells="no" wraparound="yes" mobile_dots_bottom_offset_outside="0px"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1614259738802-47276269-95c2"][ld_testimonial title="Alex De Sanchez" position="Freelancer Designer"]Great design templates which are quite easy to adapt. The customer support is very helpful.[/ld_testimonial][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1614261032484-7586d1ec-1e99"][ld_testimonial title="Alex De Sanchez" position="Freelancer Designer"]Great design templates which are quite easy to adapt. The customer support is very helpful.[/ld_testimonial][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1614259933121-93dd082b-2525"][ld_testimonial title="Alex De Sanchez" position="Freelancer Designer"]Great design templates which are quite easy to adapt. The customer support is very helpful.[/ld_testimonial][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1614259931722-01422873-c280"][ld_testimonial title="Alex De Sanchez" position="Freelancer Designer"]Great design templates which are quite easy to adapt. The customer support is very helpful.[/ld_testimonial][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1614259930032-54fb41d0-fa8b"][ld_testimonial title="Alex De Sanchez" position="Freelancer Designer"]Great design templates which are quite easy to adapt. The customer support is very helpful.[/ld_testimonial][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1614259928521-9c81606f-f5ae"][ld_testimonial title="Alex De Sanchez" position="Freelancer Designer"]Great design templates which are quite easy to adapt. The customer support is very helpful.[/ld_testimonial][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 9
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 09', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'marquee-8.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" bg_position="right center" css=".vc_custom_1611739774461{padding-top: 100px !important;padding-bottom: 100px !important;background-image: url(https://fashionstorepro.liquid-themes.com/wp-content/uploads/2021/01/fashion-banner@2x.jpg?id=4723) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: cover !important;}" responsive_css="padding_top_medium:180px|padding_bottom_medium:180px"][vc_column][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1%" cellalign="center" draggable="no" reverse="yes" marquee_speed="2.5"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869286436-59cf967c-a07e"][ld_fancy_heading tag="h6" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" hover_text_outline_width="1px" fs="text_small:10vmin" margin="bottom_small:0px"]New arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869818369-03acb2a4-846a"][ld_fancy_heading tag="h6" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" hover_text_outline_width="1px" fs="text_small:10vmin" margin="bottom_small:0px"]New arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869817802-3774fc9d-9692"][ld_fancy_heading tag="h6" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" hover_text_outline_width="1px" fs="text_small:10vmin" margin="bottom_small:0px"]New arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869817219-849901cc-8e60"][ld_fancy_heading tag="h6" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" hover_text_outline_width="1px" fs="text_small:10vmin" margin="bottom_small:0px"]New arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600869816524-0deef519-42a2"][ld_fancy_heading tag="h6" transform="text-uppercase" whitespace="ws-nowrap" hover_text_outline="ld-fh-outline" outline_appearance="ld-fh-outline-static" use_custom_fonts_title="true" hover_text_outline_color="rgb(255, 255, 255)" hover_text_outline_width="1px" fs="text_small:10vmin" margin="bottom_small:0px"]New arrivals[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 10
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 10', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'info-8.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" content_placement="middle" css=".vc_custom_1608127572115{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="2%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" el_class="z-index-2" offset="vc_col-md-6" ca_duration="1600" ca_delay="160" ca_init_translate_y="30" ca_init_rotate_z="6"][ld_fancy_heading tag="h6" enable_bg="yes" fh_border_radius="circle" use_custom_fonts_title="true" fs="text_small:13px" padding="top_small:10px|right_small:20px|bottom_small:10px|left_small:20px" fh_bg="rgb(245, 245, 245)" margin="bottom_small:1em"]<i class="lqd-icn-ess icon-lqd-circle mr-2" style="color: #00cc76; font-size: 1.25em; vertical-align: text-bottom;"></i>Available for freelance[/ld_fancy_heading][ld_fancy_heading enable_txt_rotator="yes" rotator_type="basic" items="%5B%7B%22word%22%3A%22.id%C3%A9e%22%7D%2C%7B%22word%22%3A%22.grafik%22%7D%2C%7B%22word%22%3A%22.design%22%7D%5D" use_custom_fonts_title="true" fs="text_all:94px|text_large:80px|text_medium:10vw" margin="right_large:-50%25" lh="text_small:0.95em"].freelance .créatif[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" margin="bottom_small:1.5em"]My name is Jean-Paul. I’m a freelance Branding and Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" enable_split="true" use_mask="true" color="rgb(0, 0, 0)" margin="bottom_small:1.5em"]I’m always interested in small or big freelance projects to take your business to the next level.[/ld_fancy_heading][vc_row_inner content_placement="middle" css=".vc_custom_1608127080432{margin-top: 20px !important;}"][vc_column_inner width="1/3" offset="vc_col-md-6"][ld_button style="btn-solid" title="Send a message" transformation="text-uppercase" link_type="modal_window" shape="circle" size="btn-xlg" hover_txt_effect="btn-hover-txt-liquid-x-alt" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-lqd-envelope" lh="1.25em" ls="0.1em" fs="13px" fw="700" color="rgb(23, 25, 26)" css=".vc_custom_1608127757537{padding-right: 0.5em !important;padding-left: 0.5em !important;}" anchor_id="#contact-modal"][/vc_column_inner][vc_column_inner width="1/2" css=".vc_custom_1608127055486{padding-top: 10px !important;}"][ld_custom_menu source="custom" inline="inline-nav" items="%5B%7B%22label%22%3A%22Facebook.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Twitter.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Behance.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="5" color="rgb(0, 0, 0)" hcolor="rgba(0, 0, 0, 0.65)"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column column_top_ontablet="yes" column_top_onmobile="yes" offset="vc_col-md-6" responsive_align="text-center" responsive_css="margin_bottom_medium:0px" css=".vc_custom_1613900706378{margin-bottom: 35px !important;}"][ld_images_group_element img_size="50%" enable_effects="yes" enable_hover3d="yes" enable_reveal="yes" image="4726"][/ld_images_group_element][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 11
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 11', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'info-13.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="custom" css=".vc_custom_1610005435756{padding-top: 80px !important;padding-bottom: 60px !important;background-image: url(https://architecturepro.liquid-themes.com/wp-content/uploads/2021/01/bg@2x.jpg?id=4417) !important;background-position: center !important;background-repeat: no-repeat !important;background-size: contain !important;}" responsive_css="padding_top_medium:120px|padding_bottom_medium:60px" bg_pos_h="-200px" bg_pos_v="50%" el_id="what-we-do"][vc_column width="1/3"][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:42px" margin="bottom_small:0.75em" fw="text_small:500"]Our <em class="h3" style="font-size: inherit;">story</em>[/ld_fancy_heading][/vc_column][vc_column width="7/12" offset="vc_col-sm-offset-1"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.88em" color="rgb(0, 0, 0)" margin="bottom_small:2em"]Hub Construction employs over 3 000 employees, the majority of whom are based on project sites. We embrace holistic development and support for employees with the aim of being a first-choice employer within our[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.88em" color="rgb(0, 0, 0)" margin="bottom_small:2em"]Through a unique combination of engineering, construction and design disciplines and expertise, Concor delivers world class infrastructure solutions to customers and stakeholders across a broad range of industry sectors.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.88em" color="rgb(0, 0, 0)" margin="bottom_small:2em"]Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 12
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 12', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'info-15.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" responsive_css="padding_top_medium:110px|padding_bottom_medium:110px|padding_bottom_small:80px" css=".vc_custom_1610005371078{padding-top: 30px !important;padding-bottom: 60px !important;}"][vc_column width="1/2" css=".vc_custom_1620642235658{margin-bottom: 60px !important;}" responsive_css="margin_bottom_medium:35px"][ld_images_group_element img_size="50%" image="4404" margin="left_medium:45px|bottom_small:15px"][/ld_images_group_element][ld_fancy_heading tag="p" whitespace="ws-nowrap" vertical_txt="text-sm-vertical" absolute_pos="yes" use_custom_fonts_title="true" fs="text_small:19px" color="rgb(0, 0, 0)" position="bottom_medium:15px|bottom_small:-1em|left_small:0px" margin="bottom_small:0px"]<span class="h3" style="font-size: inherit;">San Francisco</span> Headquarter[/ld_fancy_heading][/vc_column][vc_column width="1/2"][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" color="rgb(0, 0, 0)" fs="text_small:13px" fw="text_small:700" ls="text_small:0.1em" margin="bottom_small:1em"]— Arch Philosophy[/ld_fancy_heading][ld_fancy_heading tag="h2" use_custom_fonts_title="true" fs="text_small:42px" margin="bottom_small:0.75em" fw="text_small:500"]Multidisciplinary <em class="h3" style="font-size: inherit;">team</em>[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.88em" color="rgb(0, 0, 0)" margin="bottom_small:2em"]Through a unique combination of engineering, construction and design disciplines and expertise, Concor delivers world class infrastructure solutions to customers and stakeholders across a broad range of industry sectors.[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:17px" lh="text_small:1.88em" color="rgb(0, 0, 0)" margin="bottom_small:2em"]Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 13
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 13', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'info-20.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row equal_height="yes" content_placement="middle" responsive_css="padding_bottom_medium:100px|padding_top_small:50px" css=".vc_custom_1608025838088{padding-top: 30px !important;padding-bottom: 30px !important;}"][vc_column width="1/3" offset="vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024402921{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:11px" margin="bottom_small:0px"]Looking for collaboration?[/ld_fancy_heading][ld_fancy_heading tag="h6" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:18px"]Hub wire[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs"][vc_separator color="white" border_width="2"][/vc_column][vc_column width="1/3" offset="vc_col-md-offset-1 vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024409989{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em"]290 Maryam Springs Courbevoie, NYC[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:18px"]+1 827 48 89[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-2 vc_hidden-sm vc_hidden-xs"][vc_separator color="white" border_width="2"][/vc_column][vc_column width="1/3" offset="vc_col-md-offset-1 vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608024417804{margin-bottom: 25px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em"]Looking for a job?<br />
Send your resume[/ld_fancy_heading][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:18px"]info@hub.com[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 14
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 14', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'info-23.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	<p>[vc_row full_width="stretch_row" gap="0" full_height="yes" columns_placement="stretch" equal_height="yes" enable_content_animation="yes" enable_cc_circle="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" cc_circle_color="rgba(255, 157, 202, 0.44)" ca_duration="1800" ca_delay="180" responsive_css="padding_top_small:0px" css=".vc_custom_1614501395799{padding-top: 60px !important;}"][vc_column width="1/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-2/5" css=".vc_custom_1608035606145{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 9vh !important;padding-right: 15px !important;padding-bottom: 10vh !important;padding-left: 15px !important;border-right-color: #a3183c !important;border-right-style: solid !important;border-bottom-color: #a3183c !important;border-bottom-style: solid !important;}" responsive_css="padding_right_large:7vw|padding_left_large:7vw|padding_right_medium:5vw|padding_left_medium:5vw|border_right_small:1px|padding_top_small:10vh" ca_duration="1600" ca_delay="160" ca_init_translate_y="30" ca_init_rotate_z="5"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1608034385137-bf3434ef-384f" height="100%" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="30" color="#167cf9" size="4"][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:1em"]About me[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:18px|text_small:14px" lh="text_small:1.5em" margin="bottom_small:1.5em"]My name is Roberto, I’m a freelance Branding and Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic.[/ld_fancy_heading][ld_button style="btn-underlined" title="Available for freelance" link_type="modal_window" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" i_icon_linea="lqd-icn-ess icon-lqd-envelope" color="rgb(164, 25, 61)" fs="14px" lh="1em" hover_color="rgb(255, 255, 255)" anchor_id="#contact-modal"][ld_modal_window title="Contact me" el_id="contact-modal"][vc_row_inner][vc_column_inner width="1/2"][vc_column_text css=".vc_custom_1608199527374{margin-bottom: 40px !important;}"]<span style="font-size: 16px; color: #4666e3;">Address</span></p>
<hr />
<p><span style="font-size: 15px; color: #666666;">290 Maryam Springs 260,</span><br />
<span style="font-size: 15px; color: #666666;">Courbevoie, Paris, France</span>[/vc_column_text][ld_google_map style="unsaturatedBrowns" map_marker="html_marker" si_style="" si_size="" si_border="" zoom="16" map_controls="fullscreenControl" map_height="448px" address="7420 Shore Rd, Brooklyn, NY 11209, USA"][vc_separator color="custom" accent_color="#f7f9fb"][/vc_column_inner][vc_column_inner width="1/2" offset="vc_col-md-offset-1 vc_col-md-5" css=".vc_custom_1608035373180{border-top-width: 1px !important;border-right-width: 1px !important;border-bottom-width: 1px !important;border-left-width: 1px !important;padding-top: 40px !important;padding-right: 12% !important;padding-left: 12% !important;border-left-color: #e7e7e7 !important;border-left-style: solid !important;border-right-color: #e7e7e7 !important;border-right-style: solid !important;border-top-color: #e7e7e7 !important;border-top-style: solid !important;border-bottom-color: #e7e7e7 !important;border-bottom-style: solid !important;}"][ld_fancy_heading tag="h2" tag_to_inherite="h3" use_custom_fonts_title="true" use_inheritance="true" color="rgb(26, 28, 38)" margin="bottom_small:10px" fw="300"]Send a message[/ld_fancy_heading][ld_spacer height="10px"][vc_column_text]<span style="color: #73747f; font-size: 15px; line-height: 26px;">Feel free to reach us if you need any assistance.</span>[/vc_column_text][ld_spacer height="35px"][ld_cf7 id="132" btn_width="lqd-contact-form-button-block" use_custom_fonts_input="true" use_custom_fonts_submit="true" fs="14px" submit_fs="15px" submit_color="rgb(255, 255, 255)" h_color="rgb(94, 96, 98)" bg_color="rgb(247, 249, 251)" hbg_color="rgb(238, 243, 248)" color="rgb(111, 114, 116)" fw="400" submit_hbg_color="rgb(58, 58, 58)" submit_hover_border_color="rgb(58, 58, 58)" border_color="rgb(247, 249, 251)" hover_border_color="rgb(238, 243, 248)" lqd_bg_color="rgb(247, 249, 251)" css=".vc_custom_1608035319019{background-color: #f7f9fb !important;}"][/vc_column_inner][vc_column_inner][/vc_column_inner][/vc_row_inner][/ld_modal_window][/vc_column][vc_column width="1/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-1/5" css=".vc_custom_1608037023630{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 5vh !important;padding-right: 15px !important;padding-bottom: 5vh !important;padding-left: 15px !important;border-right-color: #a3183c !important;border-right-style: solid !important;border-bottom-color: #a3183c !important;border-bottom-style: solid !important;}" responsive_css="padding_right_medium:2.5vw|padding_left_medium:2.5vw|border_right_small:1px|padding_top_small:10vh|padding_bottom_small:10vh" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_init_rotate_z="5" ca_start_delay="650"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1608034333111-e5ef3cc6-0627" height="100%" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="30" color="#15f887" size="4"][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:1em"]Experience[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:18px|text_small:14px" lh="text_small:1.5em" margin="bottom_small:1.5em"]I worked with Vodafone, Apple, Google, Amazon and many more startups in San Francisco.[/ld_fancy_heading][/vc_column][vc_column width="1/3" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-2/5" css=".vc_custom_1608037050753{border-bottom-width: 1px !important;padding-top: 7vh !important;padding-right: 15px !important;padding-bottom: 7vh !important;padding-left: 15px !important;border-bottom-color: #a3183c !important;border-bottom-style: solid !important;}" responsive_css="padding_right_large:7vw|padding_left_large:7vw|padding_right_medium:5vw|padding_left_medium:5vw|padding_top_small:10vh|padding_bottom_small:10vh" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_init_rotate_z="5" ca_start_delay="900"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1608034123225-5dbb76e5-e96c" height="100%" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="30" color="#ff0a0a" size="4"][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:1em"]Career[/ld_fancy_heading][ld_custom_menu source="custom" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%222020%20%20%20%20%E2%80%94%20%20%20%20Senior%20Designer%20%20%E2%80%94%20Liquid%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%222019%20%20%20%20%E2%80%94%20%20%20%20Product%20Designer%20%20%E2%80%94%20Apple%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%222018%20%20%20%20%E2%80%94%20%20%20%20Junior%20Designer%20%20%E2%80%94%20Google%20%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%222015%20%20%20%20%E2%80%94%20%20%20%20Graduated%20from%20Yale%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%222011%20%20%20%20%E2%80%94%20%20%20%20%20Graduated%20from%20High%20School%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="7" fs="18px" color="rgb(164, 25, 61)" hcolor="rgb(255, 255, 255)" lh="1.5em"][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-6" css=".vc_custom_1608037458634{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 10vh !important;padding-right: 15px !important;padding-bottom: 10vh !important;padding-left: 15px !important;border-right-color: #a3183c !important;border-right-style: solid !important;border-bottom-color: #a3183c !important;border-bottom-style: solid !important;}" responsive_css="padding_right_large:7vw|padding_left_large:7vw|border_bottom_medium:0px|padding_right_medium:5vw|padding_left_medium:5vw|border_right_small:1px" ca_duration="1600" ca_delay="80" ca_init_translate_y="35" ca_init_rotate_z="5" ca_start_delay="1150"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1608034408420-1e477203-1f27" height="100%" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="30" color="#8402ff" size="4"][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:1em"]Skills[/ld_fancy_heading][vc_row_inner equal_height="yes"][vc_column_inner width="1/3" responsive_css="padding_left_small:25px" css=".vc_custom_1608033780195{border-left-width: 1px !important;padding-left: 10px !important;border-left-color: #a4193d !important;border-left-style: dashed !important;}" offset="vc_col-xs-6"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:18px|text_small:13px" lh="text_small:1.5em"]Brand Guid[ld_br]<br />
Flayer Design[ld_br]<br />
Video Production[ld_br]<br />
Web Advertising[ld_br]<br />
Illustrations[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" responsive_css="padding_left_small:25px" css=".vc_custom_1608033789290{border-left-width: 1px !important;padding-left: 10px !important;border-left-color: #a4193d !important;border-left-style: dashed !important;}" offset="vc_col-xs-6"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:18px|text_small:13px" lh="text_small:1.5em"]Art Direction[ld_br]<br />
Brand Strategy[ld_br]<br />
Communication[ld_br]<br />
Graphic Design[ld_br]<br />
Print Design[ld_br]<br />
Motion Graphics[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3" responsive_css="padding_left_small:25px" css=".vc_custom_1608033795285{border-left-width: 1px !important;padding-left: 10px !important;border-left-color: #a4193d !important;border-left-style: dashed !important;}" offset="vc_col-xs-6"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:18px|text_small:13px" lh="text_small:1.45em"]Graphic Design[ld_br]<br />
Print Design[ld_br]<br />
Motion Graphics[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3" css=".vc_custom_1608037234997{border-right-width: 0px !important;border-bottom-width: 1px !important;padding-top: 5vh !important;padding-right: 15px !important;padding-bottom: 5vh !important;padding-left: 15px !important;border-right-color: #a3183c !important;border-right-style: solid !important;border-bottom-color: #a3183c !important;border-bottom-style: solid !important;}" responsive_css="padding_right_medium:3vw|padding_left_medium:3vw|border_right_small:1px|border_bottom_small:0px|padding_top_small:10vh|padding_bottom_small:10vh" ca_duration="1600" ca_delay="120" ca_init_translate_y="35" ca_init_rotate_z="5" ca_start_delay="1450"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1608034397048-27e6de0e-3001" height="100%" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="30" color="#0205d6" size="4"][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:1em"]Awards[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:18px|text_small:13px" lh="text_small:1.45em"]<span class="mr-3">3x</span>AW Site of the Day[ld_br]<br />
<span class="mr-3">1x</span>FTA Best Interactivity[ld_br]<br />
<span class="mr-3">2x</span>CSS Design Awards[ld_br]<br />
<span class="mr-3">6x</span>AW Honorable Mention[ld_br]<br />
<span class="mr-3">2x</span>Red Dot Graphic[/ld_fancy_heading][/vc_column][vc_column width="1/2" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" offset="vc_col-md-3" css=".vc_custom_1608037243987{padding-top: 5vh !important;padding-right: 15px !important;padding-bottom: 5vh !important;padding-left: 15px !important;}" responsive_css="padding_right_medium:3vw|padding_left_medium:3vw|padding_top_small:10vh|padding_bottom_small:10vh" ca_duration="1600" ca_delay="160" ca_init_translate_y="35" ca_init_rotate_z="5" ca_start_delay="1600"][ld_particles visible_on_hover="yes" absolute_pos="yes" opacity="1" enable_random_size="yes" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1608034213121-6d30d3b3-0264" height="100%" position="top_small:0px|right_small:0px|bottom_small:0px|left_small:0px" number="30" color="#02ffdd" size="4"][ld_fancy_heading tag="h4" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" margin="bottom_small:1em"]Contact[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:20px|text_small:13px" lh="text_small:1.57em" margin="bottom_small:0.5em"]I’m interested in<br />
working together[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:20px|text_small:13px" lh="text_small:1.57em" margin="bottom_small:0.5em"]+1 827 48 89[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:20px|text_small:13px" lh="text_small:1.57em" margin="bottom_small:0.5em"]Have a project in mind?[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(164, 25, 61)" fs="text_large:20px|text_small:13px" lh="text_small:1.57em" margin="bottom_small:0.5em"]info@hub.com[/ld_fancy_heading][/vc_column][/vc_row]</p>
CONTENT;
	$templates[] = $data;

	//Fancy Text 15
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'misc-31.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row bg_position="left center" css=".vc_custom_1611568262746{padding-top: 50px !important;padding-bottom: 130px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}"][vc_column css=".vc_custom_1611088285482{margin-bottom: 2.15em !important;}" offset="vc_col-md-offset-1 vc_col-md-10"][ld_fancy_heading tag="h6" margin="bottom_large:3em|bottom_small:2em"]— Architecture Services[/ld_fancy_heading][ld_fancy_heading tag="p" tag_to_inherite="h3" use_inheritance="true" margin="bottom_large:1.5em|bottom_small:1em"]Since the 1980s, as the complexity of buildings began to increase, the field of architecture became multi-disciplinary with specializations for each project type, technological expertise.[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][vc_row_inner][vc_column_inner width="1/3"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Urban Codes[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Interior Design[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— City Planning[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Residential[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Construction[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Landspaces[/ld_fancy_heading][/vc_column_inner][vc_column_inner width="1/3"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Innovative Design[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Facility Optimization[/ld_fancy_heading][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="16px" lh="1.5em"]— Consulting[/ld_fancy_heading][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" css=".vc_custom_1605616478180{padding-bottom: 60px !important;}"][vc_column][ld_carousel_marquee_tab columns="md:4.25|sm:2.9|xs:1.5|spacing_md:50px|spacing_xs:2%25" pause_on_hover="yes" randomveroffset="yes"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434166403-376bd1f6-e3bd"][vc_single_image image="56" css=".vc_custom_1600434720760{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434294047-e8e3297a-ecf8"][vc_single_image image="58" css=".vc_custom_1600434728358{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434315298-8ffdba0e-bdb9"][vc_single_image image="59" css=".vc_custom_1600434737821{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434339502-e71d2cda-694b"][vc_single_image image="4313" css=".vc_custom_1600434747987{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434392281-5839817b-a5de"][vc_single_image image="57" css=".vc_custom_1600434759523{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434420928-b13c76de-d2ed"][vc_single_image image="56" css=".vc_custom_1600434767214{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434440973-4835951d-d1fa"][vc_single_image image="4314" css=".vc_custom_1600434775295{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1600434469640-f8476374-692b"][vc_single_image image="4311" css=".vc_custom_1600434783500{margin-bottom: 50px !important;}"][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 16
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 16', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-16.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_section css=".vc_custom_1608304980112{background-color: #ffd091 !important;}"][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="center top" css=".vc_custom_1608304995259{margin-bottom: 70px !important;padding-top: 70px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1600" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="60" responsive_css="margin_bottom_medium:110px|padding_top_medium:120px"][vc_column][vc_separator color="custom" accent_color="#e03b37"][/vc_column][vc_column width="3/4"][ld_fancy_heading tag="h2" split_type="chars, words" duration="1600" delay="80" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_randomize="true" color="rgb(224, 55, 101)" fs="text_all:370px|text_large:300px|text_medium:210px|text_small:35.5vw" lh="text_small:0.73em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="0" fw="text_small:500" ls="text_small:-0.02em"]Clie-nts[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="30" ca_init_rotate_z="5" ca_start_delay="650" offset="vc_col-md-3"][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="300" translate_from_y="79" rotate_from_x="-30" rotate_from_y="0" rotate_from_z="-24" translate_to_y="-52" rotate_to_x="10" rotate_to_y="0" rotate_to_z="25" position="top_small:0px|right_small:0px|left_small:0px" hide_el="hidden-xs hidden-sm"][/ld_images_group_element][ld_spacer height="35px" md_height="200px" lg_height="270px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]We create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic. Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" responsive_css="padding_bottom_medium:175px" css=".vc_custom_1608305028501{padding-bottom: 70px !important;}"][vc_column css=".vc_custom_1608298152523{margin-bottom: 15px !important;}"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1%" marquee_speed="0.75"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568553-aa13f322-b75e"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]American Airlines[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568555-e75290e0-372d"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Google[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568557-d0618f0b-2d21"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em" color="rgb(255, 223, 185)" fh_bg="rgb(229, 67, 63)" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%23e5433f%22%7D%5D"]Redbull[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568559-3d6819cb-01da"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Amazon[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568562-fc439d4c-2076"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Adidas[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][vc_column css=".vc_custom_1608117008361{margin-bottom: 15px !important;}"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1%" reverse="yes" marquee_speed="0.75"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568567-de7992cb-6982"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Vogue[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568572-823f1faf-960b"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Adidas[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568574-d72f4628-50ef"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Goldline[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301857017-33493957-3ba6"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Pied Piper[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568576-99cfa613-d682"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Kahre[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568578-92f32a61-92b1"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Microsoft[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][/vc_row][/vc_section]
CONTENT;
	$templates[] = $data;

	//Fancy Text 17
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 17', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-17.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row content_placement="middle" enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="custom" css=".vc_custom_1620719701014{padding-top: 80px !important;padding-bottom: 80px !important;background-color: #573452 !important;}" ca_duration="1600" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="60" responsive_css="padding_top_medium:120px|padding_bottom_medium:120px" bg_pos_h="20vw" bg_pos_v="0%"][vc_column width="3/4"][ld_fancy_heading tag="h2" split_type="chars, words" duration="1600" delay="80" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_randomize="true" color="rgb(234, 178, 93)" fs="text_all:370px|text_large:300px|text_medium:210px|text_small:35.5vw" lh="text_small:0.73em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="0" fw="text_small:500" ls="text_small:-0.05em"]Cont-act[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="30" ca_init_rotate_z="5" ca_start_delay="650" offset="vc_col-md-3"][ld_spacer height="35px" md_height="200px" lg_height="250px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(241, 214, 173)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-50%25|bottom_small:2em"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(241, 214, 173)" fs="text_small:25px" lh="text_small:1.16em" margin="left_large:-50%25|bottom_small:1em"]Have a project in mind?[ld_br]Send a message.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(241, 214, 173)" fs="text_small:25px" lh="text_small:1.16em" margin="left_large:-50%25|bottom_small:1.25em"]zack.hub.com[/ld_fancy_heading][/vc_column][vc_column][ld_spacer md_height="100px"][/vc_column][vc_column width="1/3" offset="vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608302849799{margin-bottom: 20px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" color="rgb(241, 214, 173)" fs="text_small:11px" lh="text_small:1.15em" margin="bottom_small:0.3em"]Looking for collaboration?[/ld_fancy_heading][ld_fancy_heading tag="h2" transform="text-uppercase" use_custom_fonts_title="true" fs="text_small:18px" color="rgb(241, 214, 173)"]Hub wire[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][vc_separator color="custom" border_width="2" css=".vc_custom_1608303302739{margin-top: 0px !important;margin-bottom: 0px !important;}" accent_color="#f1d6ad"][/vc_column][vc_column width="1/3" offset="vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608302863120{margin-bottom: 20px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em" margin="bottom_small:0.75em" color="rgb(241, 214, 173)"]290 Maryam Springs Courbevoie, NYC[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="text_small:14px" margin="bottom_small:0.3em" color="rgb(241, 214, 173)"]+1 827 48 89[/ld_fancy_heading][/vc_column][vc_column offset="vc_col-md-3 vc_hidden-sm vc_hidden-xs"][vc_separator color="custom" border_width="2" css=".vc_custom_1608304735367{margin-top: 0px !important;margin-bottom: 0px !important;}" accent_color="#f1d6ad"][/vc_column][vc_column width="1/3" offset="vc_col-md-2" responsive_css="margin_bottom_small:0px" css=".vc_custom_1608302877479{margin-bottom: 20px !important;}"][ld_fancy_heading tag="p" use_custom_fonts_title="true" fs="text_small:14px" lh="text_small:1.21em" margin="bottom_small:0.75em" color="rgb(241, 214, 173)"]Looking for a job? Send your resume[/ld_fancy_heading][ld_fancy_heading tag="h5" use_custom_fonts_title="true" fs="text_small:14px" margin="bottom_small:0.3em" color="rgb(241, 214, 173)"]info@hub.com[/ld_fancy_heading][/vc_column][vc_column][ld_spacer md_height="100px"][/vc_column][vc_column width="1/2"][ld_fancy_heading tag="p" use_custom_fonts_title="true" margin="bottom_large:0px|bottom_small:20px" fs="text_small:12px" color="rgb(255, 201, 119)"]Available for freelance in Aug 2020[/ld_fancy_heading][/vc_column][vc_column width="1/2" responsive_align="text-sm-right"][ld_custom_menu source="custom" inline="inline-nav" use_custom_fonts_menu="true" items="%5B%7B%22label%22%3A%22Fb.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Tw.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22In.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%2C%7B%22label%22%3A%22Lk.%22%2C%22url%22%3A%22%23%22%2C%22icon_alignment%22%3A%22left-icon%22%7D%5D" spacing="15" fs="15px" color="rgb(255, 201, 119)" hcolor="rgb(255, 255, 255)"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 18
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 18', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-18.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" css=".vc_custom_1608296878382{padding-top: 70px !important;padding-bottom: 70px !important;background-color: #ffaac7 !important;}" responsive_css="padding_top_medium:120px"][vc_column responsive_align="text-center"][ld_images_group_element img_size="50%" enable_effects="yes" parallax="yes" enable_reveal="yes" reveal_direction="bt" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="238" reveal_color="rgb(185, 223, 255)" position="top_all:-15%25|top_large:-25%25|top_medium:-50%25|left_medium:50%25|top_small:-60%25|left_small:0px" margin="left_medium:-290px|left_small:0px" translate_from_y="130" translate_to_y="-130"][/ld_images_group_element][ld_fancy_heading split_type="chars, words" duration="1600" delay="100" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="150%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" color="rgb(185, 223, 255)" fs="text_large:300px|text_medium:32vw|text_small:30vw" lh="text_small:0.9em" ls="text_small:-0.05em" margin="bottom_small:0px" ca_init_translate_y="200" ca_init_rotate_x="125" start_delay="350"]Hi, I’m Paul.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 19
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 19', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-19.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_height="yes" css=".vc_custom_1603704684299{background-color: #ffc1c5 !important;}"][vc_column][ld_fancy_heading tag="h6" use_custom_fonts_title="true" fs="text_small:17px" margin="bottom_small:1em"]Digital Designer based in Los Angeles[/ld_fancy_heading][ld_fancy_heading mask_bg_size="cover" mask_bg_repeat="no-repeat" mask_bg_position="center center" use_custom_fonts_title="true" use_bg_mask="true" fs="text_large:80px|text_medium:8vw|text_small:10vw" lh="text_small:1.1em" ls="text_small:-0.02em" gradient="linear-gradient(111deg, #0bccee 0%, rgb(235, 173, 105) 41.082802547770704%, rgb(194, 80, 80) 79.29936305732484%, #ac1de1 100%)"]Hi, I'm Alix. I work at <i class="fa fa-apple"></i>. I craft original effective brand experiences. My aim is to build your website so that it is functional and user friendly.[/ld_fancy_heading][ld_button style="btn-naked" title="— See my works" link_type="scroll_to_section" i_type="linea" i_hover_reveal="btn-hover-reveal" i_add_icon="true" color="rgb(0, 0, 0)" hover_color="rgba(0, 0, 0, 0.75)" fs="19px" i_icon_linea="lqd-icn-ess icon-md-arrow-down"][ld_particles as_bg="yes" color_type="random_color" opacity="1" modes_grab_opacity="1" retina_detect="yes" particle_id="lqd-1596101585154-567d0b79-a330" number="12" size="2px"][/vc_column][/vc_row][vc_row css=".vc_custom_1606205965159{padding-top: 40px !important;padding-bottom: 40px !important;background-color: #d5f5ff !important;}" responsive_css="padding_top_medium:10vh|padding_bottom_medium:10vh"][vc_column offset="vc_col-md-offset-1 vc_col-md-10"][ld_promo show_dynamic_shape="yes" show_button="yes" ib_style="btn-naked" ib_title="— view project" ib_transformation="text-uppercase" ib_i_type="linea" ib_i_hover_reveal="btn-hover-reveal" use_custom_fonts_title="true" ib_i_add_icon="true" title="Anti Dote" image="307" ib_i_icon_linea="lqd-icn-ess icon-md-arrow-forward" ib_color="rgb(0, 74, 199)" ib_hover_color="rgb(0, 0, 0)" ib_fs="text_small:13px" ib_ls="text_small:0.1em" color="rgb(0, 74, 199)" overlay_color="rgb(255, 255, 255)" dynamic_shape_bg="rgb(255, 255, 255)" fs="9vw" ib_fw="text_small:700" ib_link="url:http%3A%2F%2Fadaptivecolorspro.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|title:Starter%20Kit||" link="url:http%3A%2F%2Fadaptivecolorspro.liquid-themes.com%2Fportfolio%2Fnexa-mobile%2F|||"]Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam[/ld_promo][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 20
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-20.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="center top" css=".vc_custom_1608304939202{margin-bottom: 70px !important;padding-top: 50px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1600" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="60" responsive_css="margin_bottom_medium:110px|padding_top_medium:70px"][vc_column][vc_separator color="custom" accent_color="#e03b37"][/vc_column][vc_column width="3/4"][ld_fancy_heading tag="h2" split_type="chars, words" duration="1600" delay="80" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_randomize="true" color="rgb(224, 59, 55)" fs="text_all:370px|text_large:300px|text_medium:210px|text_small:35.5vw" lh="text_small:0.73em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="0" fw="text_small:500" ls="text_small:-0.02em"]Abo-ut[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="30" ca_init_rotate_z="5" ca_start_delay="650" offset="vc_col-md-3"][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="276" translate_from_y="70" rotate_from_z="29" translate_to_y="-85" rotate_to_z="-17" position="top_small:0px|right_small:0px|left_small:0px" hide_el="hidden-xs hidden-sm"][/ld_images_group_element][ld_spacer height="35px" md_height="250px" lg_height="330px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]My name is Roberto, I’m a freelance Branding Digital Designer based by the valley in New York. I currently work at Liquid. I create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic. beauty and technical performance. Our design starts and ends best-in-class experience strategy that builds brands.[/ld_fancy_heading][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 21
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 15', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'ft-21.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_row full_width="stretch_row" gap="0" responsive_css="padding_bottom_medium:170px" css=".vc_custom_1608305043948{padding-bottom: 60px !important;}"][vc_column css=".vc_custom_1608298152523{margin-bottom: 15px !important;}"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1%" marquee_speed="0.75"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116305863-05a26f49-3597"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Branding[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116305864-78c3d786-5fc8"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Graphic Design[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116305864-44b2fc22-3d1c"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em" color="rgb(255, 223, 185)" fh_bg="rgb(229, 67, 63)" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%23e5433f%22%7D%5D"]Designer[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116820776-fc435265-95e4"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Video Production[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116928670-0d3df418-03fb"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Graphic Design[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][vc_column css=".vc_custom_1608117008361{margin-bottom: 15px !important;}"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1%" reverse="yes" marquee_speed="0.6"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116982525-17f4dbe1-a927"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Motion[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116982528-a6c99b03-beb1"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%23e5433f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em" color="rgb(255, 223, 185)" fh_bg="rgb(229, 67, 63)"]Photoshoot[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116982531-1ceb4ae0-4633"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Strategy[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116982523-cf970267-5791"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]UI Design[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608116982534-4a218d87-43a3"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Retouch[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608117388298-1df713bb-5acf"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]UI Design[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][vc_column css=".vc_custom_1608117008361{margin-bottom: 15px !important;}"][/vc_column][/vc_row]
CONTENT;
	$templates[] = $data;

	//Fancy Text 22
	$data = array();
	$data['name'] = esc_html__( 'Fancy Text 22', 'hub' );
	$data['disabled'] = true; //disable it to not show in the default tab
	$data['image_path'] = preg_replace( '/\s/', '%20',  $sections_uri . 'banner-16.jpg' );
	$data['sort_name'] = 'Fancy Text';
	$data['custom_class'] = 'general fancytext';
	$data['content'] = <<<CONTENT
	[vc_section css=".vc_custom_1608304980112{background-color: #ffd091 !important;}"][vc_row enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" bg_position="center top" css=".vc_custom_1608304995259{margin-bottom: 70px !important;padding-top: 70px !important;background-position: 0 0 !important;background-repeat: no-repeat !important;}" ca_duration="1600" ca_delay="180" ca_init_translate_x="0" ca_init_translate_y="60" responsive_css="margin_bottom_medium:110px|padding_top_medium:120px"][vc_column][vc_separator color="custom" accent_color="#e03b37"][/vc_column][vc_column width="3/4"][ld_fancy_heading tag="h2" split_type="chars, words" duration="1600" delay="80" easing="bounce.inOut" direction="random" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_y="100%" ca_init_opacity="0" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_origin_y="100%" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" enable_randomize="true" color="rgb(224, 55, 101)" fs="text_all:370px|text_large:300px|text_medium:210px|text_small:35.5vw" lh="text_small:0.73em" ca_init_rotate_x="0" ca_init_rotate_y="0" ca_init_rotate_z="0" margin="bottom_large:0px|bottom_small:0.25em" ca_init_translate_y="0" fw="text_small:500" ls="text_small:-0.02em"]Clie-nts[/ld_fancy_heading][/vc_column][vc_column enable_content_animation="yes" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_origin_x="0%" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" ca_duration="1600" ca_delay="120" ca_init_translate_y="30" ca_init_rotate_z="5" ca_start_delay="650" offset="vc_col-md-3"][ld_images_group_element img_size="50%" parallax="yes" scale_from_x="1" scale_from_y="1" scale_from_z="1" from_opacity="1" scale_to_x="1" scale_to_y="1" scale_to_z="1" to_opacity="1" absolute_pos="yes" image="300" translate_from_y="79" rotate_from_x="-30" rotate_from_y="0" rotate_from_z="-24" translate_to_y="-52" rotate_to_x="10" rotate_to_y="0" rotate_to_z="25" position="top_small:0px|right_small:0px|left_small:0px" hide_el="hidden-xs hidden-sm"][/ld_images_group_element][ld_spacer height="35px" md_height="200px" lg_height="270px"][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]As a leading digital agency in Paris, we look to engage with our clients beyond the conventional design and development agency relationship, becoming a partner to the people and companies we work with.[/ld_fancy_heading][ld_fancy_heading tag="p" ca_init_scale_x="1" ca_init_scale_y="1" ca_init_opacity="1" ca_an_scale_x="1" ca_an_scale_y="1" ca_an_opacity="1" use_custom_fonts_title="true" enable_split="true" use_mask="true" color="rgb(229, 67, 63)" fs="text_small:15px" lh="text_small:1.33em" margin="left_large:-80%25|bottom_small:1.25em"]We create brand identities, digital experiences, and print materials that communicate clearly achieve marketing goals, and look fantastic. Urban design draws together the many strands of place-making, environmental stewardship, social equity and economic viability into the creation of places with distinct beauty and identity.[/ld_fancy_heading][/vc_column][/vc_row][vc_row full_width="stretch_row" gap="0" responsive_css="padding_bottom_medium:175px" css=".vc_custom_1608305028501{padding-bottom: 70px !important;}"][vc_column css=".vc_custom_1608298152523{margin-bottom: 15px !important;}"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1%" marquee_speed="0.75"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568553-aa13f322-b75e"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]American Airlines[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568555-e75290e0-372d"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Google[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568557-d0618f0b-2d21"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em" color="rgb(255, 223, 185)" fh_bg="rgb(229, 67, 63)" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%23e5433f%22%7D%5D"]Redbull[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568559-3d6819cb-01da"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Amazon[/ld_fancy_heading][/ld_carousel_marquee_section][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568562-fc439d4c-2076"][ld_fancy_heading tag="h3" transform="text-uppercase" whitespace="ws-nowrap" enable_bg="yes" fh_border_radius="circle" enable_fh_shadowbox="yes" use_custom_fonts_title="true" margin="top_small:2px|bottom_small:2px" ls="text_small:-0.02em" fs="text_large:4vw" lh="text_small:1em" fh_box_shadow="%5B%7B%22x_offset%22%3A%220%22%2C%22y_offset%22%3A%220%22%2C%22blur_radius%22%3A%220%22%2C%22spread_radius%22%3A%222px%22%2C%22shadow_color%22%3A%22%231f1f1f%22%7D%5D" padding="top_small:0.1em|right_small:0.5em|bottom_small:0.1em|left_small:0.5em"]Adidas[/ld_fancy_heading][/ld_carousel_marquee_section][/ld_carousel_marquee_tab][/vc_column][vc_column css=".vc_custom_1608117008361{margin-bottom: 15px !important;}"][ld_carousel_marquee_tab columns_auto_width="yes" auto_width_padding="1%" reverse="yes" marquee_speed="0.75"][ld_carousel_marquee_section title="Carousel Item" tab_id="lqd-1608301568567-de7992cb-6982"][l